@extends('layouts.factor-master')


@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.InventoryTransferBill')</h3>

    <table class="main-table">
        <tr>
            <td align="center">@lang('layout.Number'): {{$transfer->number}}</td>
            <td align="center">@lang('layout.Date'): {{convertDate($transfer->Date)}}</td>
        </tr>
    </table>

    <br>

    <table class="main-table">
        <thead>
        <tr>
            <th> @lang('layout.Number') </th>
            <th> @lang('layout.Item') </th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.OldQuantity')</th>
            <th>@lang('layout.RemainAmount')</th>
            {{-- <th>@lang('layout.Unit/M')</th>
            <th>@lang('layout.FromSite')</th>
            <th>@lang('layout.ToSite')</th> --}}
        </tr>
        </thead>
        <tbody>
            @php
                $count = 0;
                $total = 0;
            @endphp
        @foreach($transferDetail as $key )
        @php
            $total+=$key->quantity;
        @endphp
            <tr>
                <td class="center">
                    {{++$count}}
                </td>
                <td class="center">
                    {{$key->ItemName}}
                </td>
                <td class="center">
                    {{$key->quantity}}
                </td>
                <td class="center">
                    {{$key->oldOnHand}}
                </td> 
                <td class="center">
                    {{$key->onHund}}
                </td>
                {{-- <td class="center">
                    {{$key->Measure}}
                </td>
                <td class="center">
                    {{$key->from_site}}
                </td>
                <td class="center">
                    {{$key->to_site}}
                </td> --}}
            </tr>
        @endforeach
        <tr>
            <td class="center" colspan="2">
                @lang('layout.Total')

            </td>
            <td class="center">{{$total}}</td>
            <td class="center"></td>
            <td class="center"></td>
        </tr>

        </tbody>
    </table>
    <br>

    @if(company()['inventory_transfer_message'])
        <table width="100%">
            <tr>
                <td style="font-size: 14px;">{!!company()['inventory_transfer_message']!!}</td>
            </tr>

            <tr>
                <td></td>
                <td></td>
            </tr>


        </table>
    @endif
@endsection
