@extends('layouts.factor-master')


@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.InventoryTransferBill')</h3>
    <table class="main-table">

        <tr>
             <th> @lang('layout.WayBillNumber')</th> 
             <th> @lang('layout.PlateNumber')</th> 
             <th> @lang('layout.TotalQty')</th> 
             <th> @lang('layout.Driver')</th>
             
             <th>@lang('layout.Number')</th>
             <th>@lang('layout.Date')</th>
             @if($customer_name)
             <th> @lang('layout.CustomerName')</th> 
             @endif
            <th>@lang('layout.Accountant')</th>
        </tr>
        <tr>
             <td class="hidden-xs"> {{ $transfer->way_bill_number}}  </td>
             <td class="hidden-xs"> {{ $transfer->plate_number}}  </td>
             <td class="hidden-xs"> {{ $transfer->total_bori}}  </td>
             <td class="hidden-xs"> {{ $transfer->name}}  </td>
             <td align="center">{{$transfer->id}}</td>
             <td align="center">{{convertDate($transfer->Date)}}</td>
             @if($customer_name)
             <td class="hidden-xs"> {{ $customer_name}}  </td>
             @endif
            <td align="center">{{$user}}</td>
        </tr>

    </table>

    <br>

    <table class="main-table">
        <thead>
        <tr>
            <th> @lang('layout.Number') </th>
            <th> @lang('layout.Item') </th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.Unit/M')</th>
            <th>@lang('layout.FromSite')</th>
            <th>@lang('layout.ToSite')</th>
            @if(searchByCodeLocation()=="true")
            <th>@lang('layout.Location')</th>
            <th>@lang('layout.ToLocation')</th>
            @endif
        </tr>
        </thead>
        <tbody>
        @foreach($transferDetail as $key )
            <tr>
                <td>
                    {{$key->item_number}}
                </td>
                <td>
                    {{$key->ItemName}}
                </td>
                <td>
                    {{$key->quantity}}
                </td>
                <td>
                    {{$key->Measure}}
                </td>
                <td>
                    {{$key->from_site}}
                </td>
                <td>
                    {{$key->to_site}}
                </td>
                @if(searchByCodeLocation()=="true")
                <td>
                    {{$key->location}}
                </td>
                <td>
                    {{$key->to_location}}
                </td>
                @endif
            </tr>
        @endforeach

        </tbody>
    </table>
    <br>

    <table class="main-table">
        <thead>
        <tr>
            <th width="70%"> @lang('layout.Description') </th>
            <th>@lang('layout.MohrAndSignature')</th>


        </tr>
        </thead>
        <tbody>
        <tr>
            <td width="70%">{{$transfer->description}}</td>
            <td style="width: 30%;height: 50px"></td>
        </tr>


        </tbody>
    </table>

    @if($loan)
    <h4 style="margin-bottom: 20px; margin-top: 30px; margin-top: 15px"> @lang('layout.ReciveLoan') </h4>

    <table class="main-table">
        <thead>
        <tr>
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.Member')</th>
            <th>@lang('layout.Account')</th>
            <th>@lang('layout.Amount')</th>
            <th>@lang('layout.Currency')</th>
            <th>@lang('layout.Rate')</th>
            <th>@lang('layout.Type')</th>
            <th>@lang('layout.Category')</th>
            <th>@lang('layout.Description')</th>
            <th>@lang('layout.Date')</th>

        </tr>
        </thead>
        <tbody>
        <tr>
            <td class="hidden-xs"> {{ (!$loan)?null:$loan->number}}  </td>
            <td class="hidden-xs"> {{ (!$loan)?null:$loan->name}}  </td>
            <td class="hidden-xs"> {{ (!$loan)?null:$loan->Account}}  </td>
            <td class="hidden-xs"> {{ (!$loan)?null:$loan->amount}}  </td>
            <td class="hidden-xs"> {{ (!$loan)?null:$loan->currency}}  </td>
            <td class="hidden-xs"> {{ (!$loan)?null:$loan->loanRate}}  </td>
            <td class="hidden-xs"> {{__('layout.'.ucfirst($loan->type))}}  </td>
            <td class="hidden-xs"> {{__('layout.'.ucfirst($loan->category))}} </td>
            <td class="hidden-xs"> {{ (!$loan)?null:$loan->description}}  </td>
            <td class="hidden-xs"> {{ (!$loan)?null:convertDate($loan->Date)}}  </td>
        </tr>


        </tbody>
    </table>

    @endif



    @if(company()['inventory_transfer_message'])
        <table width="100%">
            <tr>
                <td style="font-size: 14px;">{!!company()['inventory_transfer_message']!!}</td>
            </tr>

            <tr>
                <td></td>
                <td></td>
            </tr>


        </table>
    @endif
@endsection
