@extends('layouts.factor-master')

@section('content')
    <?php
    // $report = customeReport('inventory_transfer');
    // $_item_name = in_array('item_name', $report);
    // $_measure = in_array('measure', $report);
    // $_quantity = in_array('quantity', $report);
    // $_from_site = in_array('from_site', $report);
    // $_to_site = in_array('to_site', $report);


    $report = customeReportNew('inventory_transfer_index');
      $_date= !in_array('date', $report);
    $_item_name= !in_array('item_name', $report);
    $_quantity= !in_array('quantity', $report);
    $_measure= !in_array('measure', $report);
    $_from_site= !in_array('from_site', $report);
    $_to_site= !in_array('to_site', $report);
    $_unit_cost= !in_array('unit_cost', $report);
    $_number= !in_array('number', $report);
    $_contract= !in_array('contract', $report);
    $_wagon_number= !in_array('wagon_number', $report);
 

    $report_percent = customeReportNewPercent('inventory_transfer_index');
     $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_item_name_percent= (array_key_exists('item_name___percent', $report_percent))?$report_percent['item_name___percent']:null;
    $_quantity_percent= (array_key_exists('quantity___percent', $report_percent))?$report_percent['quantity___percent']:null;
    $_measure_percent= (array_key_exists('measure___percent', $report_percent))?$report_percent['measure___percent']:null;
    $_from_site_percent= (array_key_exists('from_site___percent', $report_percent))?$report_percent['from_site___percent']:null;
    $_to_site_percent= (array_key_exists('to_site___percent', $report_percent))?$report_percent['to_site___percent']:null;
    $_unit_cost_percent= (array_key_exists('unit_cost___percent', $report_percent))?$report_percent['unit_cost___percent']:null;
    $_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
    $_contract_percent= (array_key_exists('contract___percent', $report_percent))?$report_percent['contract___percent']:null;
    $_wagon_number_percent= (array_key_exists('wagon_number___percent', $report_percent))?$report_percent['wagon_number___percent']:null;
 
    ?>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.InventoryTransferReport') </h3>
        <table class="main-table">
            @if($transferInfo)
            <tr>
                     <th><i class="fa fa-bars"></i> @lang('layout.ID')</th> 
                     <th><i class="fa fa-bars"></i> @lang('layout.Number')</th> 
                     <th><i class="fa fa-bars"></i> @lang('layout.WayBillNumber')</th> 
                    <th><i class="fa fa-bars"></i> @lang('layout.PlateNumber')</th> 
                    <th><i class="fa fa-bars"></i> @lang('layout.TotalQty')</th> 
                    <th><i class="icon-user"></i> @lang('layout.Driver')</th>
                    <th><i class="icon-user"></i> @lang('layout.Responsible')</th>
                    <th>
                        <i class="fa fa-clock-o"></i> @lang('layout.Date')
                    </th>
                    <th><i class="fa fa-signal"></i> @lang('layout.Description')</th>
                    <th><i class="fa fa-signal"></i> @lang('layout.User')</th>

            </tr>
                <tr>
                        <td class="hidden-xs"> {{ $transferInfo->id}}  </td>
                        <td class="hidden-xs"> {{ $transferInfo->number}}  </td>
                        <td class="hidden-xs"> {{ $transferInfo->way_bill_number}}  </td>
                        <td class="hidden-xs"> {{ $transferInfo->plate_number}}  </td>
                        <td class="hidden-xs"> {{ $transferInfo->total_bori}}  </td>
                        <td class="hidden-xs"> {{ $transferInfo->name}}  </td>
                        <td class="hidden-xs"> {{ $transferInfo->employee}}  </td>
                        <td class="hidden-xs"> <BDO DIR="LTR"> {{convertDate(date('Y-m-d'))}} </BDO> </td>
                        <td class="hidden-xs"> {{ $transferInfo->description}}  </td>
                        <td class="hidden-xs"> {{ $transferInfo->user}}  </td>
                </tr>
        @endif
        </table>


    <table class="main-table">
 
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif        {{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif        {{convertDate($to_date)}}</BDO>
                </td>
            @endif
            @if($contract_name)
            <td>
                <span>@lang('layout.Contract')</span>:
                <BDO DIR="LTR">{{$contract_name}}</BDO>
            </td>
        @endif
            
        </tr>
    </table>
    <br>
    <table class="main-table">

        <thead>
        <tr class="bg">
             <th>
                <div class="center"> @lang('layout.Record') </div>
            </th>  
                 <th>
                    <div class="center"> @lang('layout.Number') </div>
                </th>  
               @if($_date) 
                <th @if($_date_percent) width="{{$_date_percent}}%" @endif>
                    <div class="center"> @lang('layout.Date')</div>
                </th> @endif
            @if($_item_name)
                <th @if($_item_name_percent) width="{{$_item_name_percent}}%" @endif >
                    <div class="center"> @lang('layout.ItemName') </div>
                </th>  @endif
             @if($_quantity)
                <th @if($_quantity_percent) width="{{$_quantity_percent}}%" @endif >
                    <div class="center"> @lang('layout.Quantity')</div>
                </th> @endif
            @if($_measure)
                <th @if($_measure_percent) width="{{$_measure_percent}}%" @endif >
                    <div class="center"> @lang('layout.Measure')</div>
                </th>@endif
            @if($_from_site)
                <th @if($_from_site_percent) width="{{$_from_site_percent}}%" @endif >
                    <div class="center"> @lang('layout.FromSite')</div>
                </th> @endif
            @if($_to_site)
                <th @if($_to_site_percent) width="{{$_to_site_percent}}%" @endif >
                    <div class="center"> @lang('layout.ToSite')</div>
                </th>@endif
               
                @if(searchByCodeLocation()=="true")
                <th>@lang('layout.Location')</th>
                <th>@lang('layout.ToLocation')</th>
                @endif

                @if(getSaleDescription()=="true") 
                <th>@lang('layout.Model')</th>
                <th>@lang('layout.Color')</th>
                @endif


                @if(getShowPurchaseRate() != "false")
               @if($_unit_cost) <th @if($_unit_cost_percent) width="{{$_unit_cost_percent}}%" @endif  class="center">@lang('layout.Total') @lang('layout.UnitCost') </th>@endif
                @endif
               @if($_number) <th @if($_number_percent) width="{{$_number_percent}}%" @endif >
                    <div class="center"> @lang('layout.Number')</div>
                </th> @endif
             
                
               @if($_contract) <th @if($_contract_percent) width="{{$_contract_percent}}%" @endif  style=""><div class="center"> @lang('layout.Contract') </div></th> @endif
                
               @if($_wagon_number) <th @if($_wagon_number_percent) width="{{$_wagon_number_percent}}%" @endif  style=""><div class="center"> @lang('layout.WagonNumber') </div></th> @endif
                <th style=""><div class="center"> @lang('layout.User') </div></th>
        </tr>
        </thead>
        <?php
        $count = 0;
        $AssetValue = 0;
        ?>
        @foreach($data AS $record)
        <?php
        $AssetValue += $record->AssetValue;
        ?>
            <tr>

                <td class="center">{{++$count}}</td>
                 
                    <td class="center">{{$record->item_number}}</td>
                    @if($_date)<td class="center">{{convertDate($record->Date)}}</td> @endif
              
                    @if($_item_name)<td class="center">{{$record->ItemName}}</td> @endif
                
                    @if($_quantity)<td class="center">{{$record->quantity}}</td> @endif
                
                    @if($_measure)<td class="center">{{$record->Measure}}</td> @endif
                 
                    @if($_from_site)<td class="center">{{$record->from_site}}</td>  @endif
              
                    @if($_to_site)<td class="center">{{$record->to_site}}</td> @endif
                 
                @if(searchByCodeLocation()=="true")
                <td class="center">{{$record->location}}</td>
                <td class="center">{{$record->to_location}}</td>
                @endif
                @if(getSaleDescription()=="true") 
                <td class="center">{{$record->model}}</td>
                <td class="center">{{$record->color}}</td>
                @endif
                @if(getShowPurchaseRate() != "false")
                  @if($_unit_cost)  <td class="center">{{$record->AssetValue}}   {{getHomeCurrency()[getCurrencyType()]}}</td> @endif
                @endif
                @if($_number)<td  class="center">{{$record->number}}</td>@endif
                @if(!$contract_name)
               @if($_contract) <td  class="center">{{$record->company_name}}</td>@endif
                @endif
                @if($_wagon_number)<td  class="center">{{$record->wagon_number}}</td>@endif
                <td  class="center">{{$record->user}}</td>
            </tr>

        @endforeach
        @if(getShowPurchaseRate() != "false")
        <tr class="bg">
            <td colspan="2" class="center">@lang('layout.Total') @lang('layout.UnitCost') : </td>
            <td colspan="3" class="center">{{$AssetValue}}  {{getHomeCurrency()[getCurrencyType()]}}</td>
        </tr>
        @endif
    </table>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection