@extends('layouts.app')
@section('style')
<style>
    .modal-container {
        width: 60% !important;
    }
</style>
@endsection
@section('content')
    {{-- <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'inventory_transfer_detail'"
                      @closed="closeModal">
            <div slot=body>
                <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.SelectType')</label>
                                
                                    <select name="report_type" class="form-control">
                                        <option value="">@lang('layout.SelectType')</option>
                                        <option value="general">@lang('layout.General')</option>
                                    </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectItem') </label>
                            <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist"> </v-select>
                            <input type="hidden" name="item_id" v-model.number="(!selectedItem)?null:selectedItem.id">
                        </div>
                </div>     
                <div class="row">
                    <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                <label class="control-label">@lang('layout.ContractName')</label>
                                <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                        v-model="selectedContract" label="company_name"
                                        @input="contractWagon()" :options="{{$contract}}">
                                </v-select>
                                <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                    </div>

                    <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                <label class="control-label">@lang('layout.WagonNumber')</label>
                                <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                        v-model="selectedWagon" label="name"
                                        :options="wagon">
                                </v-select>
                                <input type="hidden" name="wagon_number" v-model.number="(!selectedWagon)?null:selectedWagon.name" />
                    </div>
                </div>     
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.Date')</label>
                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                <option value="Today">@lang('type.Today')</option>
                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                <option value="YearToDate">@lang('type.YearToDate')</option>
                            </select>
                        </div>
                        <div class="col-md-8" v-show="period == 'CustomDates'">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div> --}}


    <!-- BEGIN CONTENT -->
<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
    :value-type="'inventory_transfer_detail'"
    @closed="closeModal">

        <div slot="body">

            <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
            <div class="row" v-cloak>
                <div class="tabbable tabbable-tabdrop">

                    <ul class="nav nav-tabs">

                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                        </li>
                        @if(systemConfig()[2] != 0 )
                        @permission(['EmployeeRewards-list'])
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                        </li>
                        @endpermission
                        @endif
                    </ul>

                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                            <div class="portlet light bordered">
                                <div class="portlet-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.SelectType')</label>
                                                
                                                    <select name="report_type" class="form-control">
                                                        <option value="">@lang('layout.SelectType')</option>
                                                        <option value="general">@lang('layout.General')</option>
                                                    </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <label class="control-label ">@lang('layout.SelectItem') </label>
                                            <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist"> </v-select>
                                            <input type="hidden" name="item_id" v-model.number="(!selectedItem)?null:selectedItem.id">
                                        </div>

                                        <div class="col-md-4">
                                            <label class="control-label">@lang('layout.Customer') </label>
                                            <v-select class="vue-select2" v-model="selected_customer" label="name" @search="CustomerSearch" :options="customer"> </v-select>
                                            <input type="hidden" name="customer_id" :value="!selected_customer?null:selected_customer.id">
                                        </div>
                                
                                </div>     
                                <div class="row">
                                    <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                <label class="control-label">@lang('layout.ContractName')</label>
                                                <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                                        v-model="selectedContract" label="company_name"
                                                        @input="contractWagon()" :options="{{$contract}}">
                                                </v-select>
                                                <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                    </div>
                
                                    <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                <label class="control-label">@lang('layout.WagonNumber')</label>
                                                <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                                        v-model="selectedWagon" label="name"
                                                        :options="wagon">
                                                </v-select>
                                                <input type="hidden" name="wagon_number" v-model.number="(!selectedWagon)?null:selectedWagon.name" />
                                    </div>
                                </div>     
                                <div class="row">
                                    <div class="form-group">
                                        <div class="col-md-4">
                                            <label class="control-label ">@lang('layout.Date')</label>
                                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                                <option value="Today">@lang('type.Today')</option>
                                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                                <option value="YearToDate">@lang('type.YearToDate')</option>
                                            </select>
                                        </div>
                                        <div class="col-md-8" v-show="period == 'CustomDates'">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.Date')</label>
                                                <div class="input-group">
                                                    <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                                    <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane" id="tab2">
                            <div class="portlet light bordered">
                                <div class="portlet-body">

                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="inventory_transfer_index">


                                        <div class="col-md-12 col-sm-12 col-xs-12">

                                            <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="margiv-top-10">
                                            <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                            <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>


        </div>
    </report-modal>
</div>


    <!-- END PAGE HEADER-->

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.InventoryTransferslist')</span>
                </div>
                <div class="pull-right">
                    @permission('inventoryTransfer-export')
                    <span id="anchore-modal">
                                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                        <i class="fa fa-print"></i>
                                     </a>
                                </span>

                    @endpermission
                    @permission('inventoryTransfer-create')
                    <a href="{{route('inventoryTransfer.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template  v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="InventoryTransfer">
                    <thead>
                    <tr>
                        <th>@lang('layout.ID')</th>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.WayBillNumber')</th>
                        <th>@lang('layout.PlateNumber')</th>
                        <th>@lang('layout.TotalQty')</th>
                        <th>@lang('layout.Driver')</th>
                        <th>@lang('layout.Responsible')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.CostomerName')</th>
                        @if(systemConfig()[20] == 1)
                        <th>@lang('layout.Transfer') @lang('layout.Contract')</th>
                        @endif
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->

    <iframe id="transferFrames" style="display: none;"></iframe>
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
        @if (Session('transfer_id'))
        printTransferBill("{{Session('transfer_id')}}")
        @endif

        Vue.component('v-select', VueSelect.VueSelect);
        var cust_rep = {!!customeReportNewData('inventory_transfer_index')!!};

        function printTransferBill(id) {

            var a = document.createElement('a');
            a.href = "{{url('printTransferBill')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }

        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#InventoryTransfer').DataTable({
                ajax: '{{route("inventoryTransfer.index")}}',
                pageLength: '{{getPageRows()}}',
                // scrollY:        450,
                order: [["{{orderByColumn()=='number'?0:6}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'id', name: 'inventory_transfers.id'},
                    {data: 'number', name: 'inventory_transfers.number'},
                    {data: 'way_bill_number', name: 'inventory_transfers.way_bill_number'},
                    {data: 'plate_number', name: 'inventory_transfers.plate_number'},
                    {data: 'total_bori', name: 'inventory_transfers.total_bori'},
                    {data: 'name', name: 'members.name'},
                    {data: 'employee', name: 'emp.name'},
                    {data: 'Date', name: 'inventory_transfers.date'},
                    {data: 'cus_name', name: 'customer.name'},
                    @if(systemConfig()[20] == 1)
                    {data: 'contract_type', name: 'contract_type', orderable: false, searchable: false},
                    @endif
                    {data: 'user_name', name: 'users.name'},
                    {data: 'description', name: 'inventory_transfers.description'},
                    {data: 'action', name: 'action', orderable: false, searchable: false},

                ]
            });
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if(typeof data_table =='object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }

                }
            }
        });

        var wagon= {!! $wagon !!};

        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                selectedItem: null,
                itemlist: [],
                wagon: wagon,
                wagonAll: wagon,
                customer: [],
                selected_customer: null,
                selectedContract: null,
                selectedWagon: null,
                customReportData:
                [
  
                   {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(cust_rep.item_name)?'checked':'',column_percentage:(cust_rep.item_name___percent)?cust_rep.item_name___percent:''},
                 {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_rep.quantity)?'checked':'',column_percentage:(cust_rep.quantity___percent)?cust_rep.quantity___percent:''},
                 {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_rep.measure)?'checked':'',column_percentage:(cust_rep.measure___percent)?cust_rep.measure___percent:''},
                 {Name: '@lang("layout.FromSite")', column_name: 'from_site',checkedColumn:(cust_rep.from_site)?'checked':'',column_percentage:(cust_rep.from_site___percent)?cust_rep.from_site___percent:''},
                 {Name: '@lang("layout.ToSite")', column_name: 'to_site',checkedColumn:(cust_rep.to_site)?'checked':'',column_percentage:(cust_rep.to_site___percent)?cust_rep.to_site___percent:''},
                 {Name: '@lang("layout.UnitCost")', column_name: 'unit_cost',checkedColumn:(cust_rep.unit_cost)?'checked':'',column_percentage:(cust_rep.unit_cost___percent)?cust_rep.unit_cost___percent:''},
                 {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                 {Name: '@lang("layout.Contract")', column_name: 'contract',checkedColumn:(cust_rep.contract)?'checked':'',column_percentage:(cust_rep.contract___percent)?cust_rep.contract___percent:''},
                 {Name: '@lang("layout.WagonNumber")', column_name: 'wagon_number',checkedColumn:(cust_rep.wagon_number)?'checked':'',column_percentage:(cust_rep.wagon_number___percent)?cust_rep.wagon_number___percent:''},
 
                  ],
                  cust_rep:cust_rep

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

                CustomerSearch: _.debounce((search, loading) => {
                loading(true);
                let class_id = (vm.selected_class != undefined) ? vm.selected_class.id : null;
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        class_id: class_id,
                        type: 'Customer'
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        vm.customer = [];
                        vm.customer = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),

                //ajax call to get items
                onItemSearch(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'itemesSearchSale',
                            keyword: search
                        }
                    })
                    .then(function(response) {
                        this.itemlist = [];
                        if (response.data.length > 0) {
                        vm.itemlist = response.data;
                        // console.log('data', vm.itemlist);
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                },
                contractWagon() {
                    this.wagon = this.wagonAll;
                    if (this.selectedContract) {
                        this.wagon = this.wagonAll.filter((wagon) => {
                            return this.selectedContract.id == wagon.contract_id;
                        });

                    }
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },

            }
        });


        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });
    </script>


@endpush

