@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

    <style>
        .required {
            padding-left: 0px !important;
            color: red;
        }
    </style>
@stop
@section('content')
    <div class="row">
        <div class="portlet light bordered">
            <!-- BEGIN TAB PORTLET-->
            <div class="portlet light bordered sale">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-anchor font-green-sharp"></i>&nbsp;
                        <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.EditInventoryTransfer')</span>
                    </div>
                    <div class="actions">
                    </div>
                </div>
                <div id="app" class="portlet-body">

                    <div class="tabbable tabbable-tabdrop">

                        <div>
                            {{Form::open(['route'=>['inventoryTransfer.update',$transfer->id],'method'=>'PATCH','class'=>'form-horizontal','id'=>'transfer-form'])}}
                            {{ csrf_field() }}
                            <div class="tab-content">
                                <div class="tab-pane active" id="tab1">
                                    <div v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                        <!-- BEGIN FORM-->


                                        <div class="form-body">
                                                <!-- begin inputs -->
                                                <div class="row">
                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Number')</label>
                                                                <input type="text" name="number" value="{{$transfer->number}}" class="form-control" autocomplete="off">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Date')</label>

                                                                <input type="text" name="date"
                                                                       value="{{$transfer->Date}}"
                                                                       class="form-control date now" autocomplete="off">
                                                            </div>
                                                        </div>
                                                    </div>
                                                @if(systemConfig()[20] == 1)   
                                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                    <label class="control-label"> <span class="fa fa-truck" style="color:green;"></span> @lang('layout.Transfer') @lang('layout.Contract') </label>
                                                    <div class="col-md-12 mt-checkbox">
                                                        <label class="mt-checkbox mt-checkbox-outline">
                                                            <input type="checkbox"  name="contract_transfer" v-model="contract_transfer"  />
                                                            <span></span>
                                                        </label>
                                                    </div>
                                                </div> 
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.ContractName')</label>
                                                            <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                                                    v-model="selectedContract" label="company_name"
                                                                    @input="contractWagon()" :options="{{$contract}}">
                                                            </v-select>
                                                            <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.WagonNumber')</label>
                                                            <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                                                    v-model="selectedWagon" label="name"
                                                                    :options="wagon">
                                                            </v-select>
                                                            <input type="hidden" name="wagon_number" v-model.number="(!selectedWagon)?null:selectedWagon.name" />
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif

                                                </div>
                                                <div class="row">
                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Responsible')</label>
                                                                <v-select label="name" :options="employees" @search="MemberSearch" v-model="selected_employee"></v-select>
                                                                <input type="hidden" name="employee_id" :value="!selected_employee?null:selected_employee.id">
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
    
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Customer') </label>
                                                                <div class="input-group">
                                                                    <v-select label="name" @search="CustomerSearch" :options="customer" v-model="selected_customer"></v-select>
                                                                    <input type="hidden" name="customer_id"  data-vv-as="@lang('layout.Customer')" :value="!selected_customer?null:selected_customer.id">
                                                                    
                                                                </div>
                                                            </div>
                                                        </div>
    
                                                    </div>


                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Description')</label>
                                                                <textarea name="description" class="form-control" rows="1">{{$transfer->description}}</textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>  
                                                <!-- end inputs -->

                                        <!-- begin Driver And Other Info -->


                                                <div class="row">
                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Driver')</label>
                                                                 <v-select label="name"  v-model="selected_driver"
                                                                      :options="driver">
                                                                  </v-select>
                                                                  <input type="hidden" name="driver_id" :value="(!selected_driver)?null:selected_driver.id">
                                                           
                                                            </div>
                                                        </div>
                                                    </div>  
                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.TotalQty')</label>
                                                                 <input type="text" name="total_bori" value="{{$transfer->total_bori}}" class="form-control" placeholder="@lang('layout.TotalQty')">
                                                           
                                                            </div>
                                                        </div>
                                                    </div>    
                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.WayBillNumber')</label>
                                                                 <input type="text" name="way_bill_number" value="{{$transfer->way_bill_number}}" class="form-control" placeholder="@lang('layout.WayBillNumber')">
                                                           
                                                            </div>
                                                        </div>
                                                    </div>
                                                 <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.PlateNumber')</label>
                                                                 <input type="text" name="plate_number"  value="{{$transfer->plate_number}}" class="form-control" placeholder="@lang('layout.PlateNumber')">
                                                           
                                                            </div>
                                                        </div>
                                                    </div>

                                                    

                                                </div>
                                             <!-- End Driver And Other Info -->

                                             <input type="hidden" name="edit_sale" value="{{$edit_sale}}">

                                            <div class="row" style="overflow-x: scroll;">
                                                <table id="table_content" class="table table-bordered table-advance">
                                                    <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        @if(systemConfig()[20] == 1)
                                                        <th style="min-width: 130px">@lang('layout.Contract') </th>
                                                        <th style="min-width: 130px">@lang('layout.WagonNumber') </th>
                                                        @endif
                                                        <th v-show="showWhat('sale_category')=='yes'" style="min-width: 130px">@lang('layout.Category') </th>
                                                        <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                                        @if(searchByCodeLocation()=="true")
                                                        <th style="min-width: 110px;">@lang('layout.Location')</th>
                                                        <th style="min-width: 100px;">@lang('layout.ToLocation')</th>
                                                        @endif
                                                        @if(getSerailNumber() =="true")
                                                        <th style="min-width: 100px">@lang('layout.SerialNum') </th>
                                                        @endif
                                                        <th style="min-width: 100px">@lang('layout.FromSite') </th>
                                                        <th style="min-width: 100px">@lang('layout.ToSite') </th>
                                                        <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                                        <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                        <th v-show="showWhat('other_measure')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue1') </th>
                                                        <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue2') </th>
                                                        <th></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr v-for="(item,index) in inventories">
                                                        <td>@{{index+1}}</td>
                                                        @if(systemConfig()[20] == 1)
                                                        <td>
                                                            <v-select label="company_name" v-model="item.contract" :options="contracts"  @keyup.native="contractChange(index), contractWagon1(index)" @Click.native="contractChange(index), contractWagon1(index)" ></v-select>
                                                            <input type="hidden" name="inv_contract_id[]" :value="(!item.contract)?null:item.contract.id">
                                                        </td>
                                                        <td>
                                                            <v-select label="name" v-model="item.select_wagon" :options="wagon" @keyup.native="contractChange(index)" @Click.native="contractChange(index)" ></v-select>
                                                            <input type="hidden" name="inv_wagon_number[]" :value="(!item.select_wagon)?null:item.select_wagon.name">
                                                        </td>
                                                        @else
                                                        <input type="hidden" name="inv_contract_id[]" >
                                                        <input type="hidden" name="inv_wagon_number[]" >
                                                        @endif
                                                        <td v-show="showWhat('sale_category')=='yes'">
                                                            <v-select label="name" v-model="item.item_category"
                                                                      :options="inventory_category"
                                                                      @input="itemCategoryChange(index)"></v-select>
                                                            <input type="hidden" name="inventory_category_id[]" :value="(!item.item_category)?null:item.item_category.id">
                                                        </td>
                                                        <td class="highlight">
                                                            <v-select label="name"
                                                            @input="(editKey)?onItemload(index):''" 
                                                            @keyup.native="editKey = true" 
                                                            @Click.native="addNew('inventory',index), editKey = true"
                                                            v-model="item.inventory" :options="temp_items"
                                                            @search="onItemSearch" :disabled = "item.update_data != 'yes' && edit_sale == 'yes'" ></v-select>
                                                            <input type="hidden" :name="'inventory_id['+index+']'"
                                                                   v-validate="''" data-vv-as="@lang('layout.ItemName')"
                                                                   :value="(!item.item)?null:item.item.id">
                                                            <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>
                                                            
                                                            <input type="hidden" :name="'update_data['+index+']'" :value="item.update_data">
                                                            <input type="hidden" :name="'transfer_info_id['+index+']'" :value="item.transfer_info_id">
                                                        </td>
                                                        @if(searchByCodeLocation()=="true")
                                                        <td class="highlight">
                                                            <v-select label="name" @input="(editKey)?locationItemload(index):''" 
                                                            @keyup.native="editKey = true" 
                                                            @Click.native="setIndex(index), editKey = true"
                                                            v-model="item.location" :options="(item.item==null)?[]:item.item.locationList" @search="locationSearch" ></v-select>
                                                            <input type="hidden" :name="'location['+index+']'" v-validate="''" data-vv-as="@lang('layout.Location')" :value="(!item.location)?null:item.location.name">
                                                        </td>
                                                        <td>
                                                            <input type="text" :name="'to_location['+index+']'" v-model="item.to_location" class="form-control input-style" placeholder="@lang('layout.ToLocation')">
                                                        </td>
                                                        @endif
                                                        @if(getSerailNumber() =="true")
                                                        <td>
                                                            @{{(!item.item)?null:item.item.number}}
                                                        </td>
                                                        @endif
                                                        <td class="highlight">
                                                        <div class="input-group">
                                                            <select v-model="(item.item==null)?null:item.item.site"
                                                                    class="form-control" :disabled = "item.update_data != 'yes' && edit_sale == 'yes'" >
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item != null)">
                                                                <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                                        :value="site">
                                                                  @{{site.site_name}}
                                                                </option> 
                                                              </span>
                                                            </select>
                                                            <input type="hidden" name="from_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                                <span class="input-group-addon">@{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity,0))}}</span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <span v-if="(item.item !=null)">
                                                                <div class="input-group"  v-if="item.item.site">
                                                                    <select class="form-control input_style"
                                                                            placeholder="@lang('layout.ToSite')"
                                                                            :disabled = "item.update_data != 'yes' && edit_sale == 'yes'"
                                                                            required="required" v-model="!item.item?null:item.item.to_site" >
                                                                        <option v-if="item.item.site.site_id!=si.site_id || contract_transfer"
                                                                                v-for="si in (item.item==null)?null:item.item.site_list" :value="si">@{{si.name}}
                                                                        </option>
                                                                    </select>
                                                                    <span class="input-group-addon">@{{myRound((item.item==null)?null:ToSiteItemQuantity(item.item,item.item.quantity))}}</span>
                                                                </div>
                                                                <input type="hidden" name="to_site[]" :value="(!item.item)?null:(item.item.to_site)?item.item.to_site.site_id:null">
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <input type="number" :name="'inventory_quantity['+index+']'"
                                                                   v-validate="''" data-vv-as="@lang('layout.Quantity')"
                                                                   v-model.number="(item.item==null)?null:item.item.quantity"
                                                                   class="form-control input-style input-number"
                                                                   :readonly = "item.update_data != 'yes' && edit_sale == 'yes'"
                                                                   placeholder="@lang('layout.Quantity')">
                                                            <span class="required">@{{ errors.first('inventory_quantity['+index+']') }}</span>
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(item.item == null)?null:item.item.measure"
                                                                class="form-control">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                                            :value="measure">
                                                                    @{{measure.measure_name}}
                                                                  </option> 
                                                                </span>
                                                            </select>

                                                            <input type="hidden" name="inventory_measure[]"
                                                                   :value="(item.item==null)?null:item.item.measure.measure_id">
                                                        </td>
                                                        <td v-show="showWhat('other_measure')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="other_measure_amount[]" v-model.number="(item.item==null)?null:item.item.other_measure"
                                                                oninput = "autowidths(event)"
                                                                class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue1')">
                                                                <span class="input-group-addon">@{{myRound((item.item==null)?0:((item.item.site==null)?0:item.item.site.other_measure))}}</span> 
                                                            </div>
                                                        </td>
                                                        <td v-show="showWhat('other_measure2')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="other_measure_amount2[]" v-model.number="(item.item==null)?null:item.item.other_measure2"
                                                                oninput = "autowidths(event)"
                                                                class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue2')">
                                                                <span class="input-group-addon">@{{myRound((item.item==null)?0:((item.item.site==null)?0:item.item.site.other_measure2))}}</span> 
                                                            </div>
                                                        </td>
                                                        <td>
                                                            @if($edit_sale != 'yes')
                                                            <span v-on:click="deleteItem('inventory',index)"><i
                                                                        class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    <tr style="background-color: #ffffff;">
                                                        <td></td>
                                                        <td>
                                                            <center>
                                                            @if($edit_sale != 'yes')
                                                                <button type="button" @click="addNew('inventory',500)"
                                                                class="btn btn-success"><i class="fa fa-plus"></i></button>
                                                            @endif                
                                                            </center>
                                                        </td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                    </tr>
                                                    </tbody>
                                                </table>


                                            </div>

                                            <br>
                                            <br>
                                            <br>

                                       
                                            <div class="col-xl-12"> 
                                                <table id="table_content" class="table table-striped table-bordered table-hover">
                                                    <h3 style="margin-bottom: 25px;"> @lang('layout.ReciveLoan') </h3>
                                                    <thead>
                                                        <tr>
                                                            <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                                            <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                                            <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                                            <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                                            <th class="text-center" style="min-width: 120px;">@lang('layout.Description')</th>
    
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr> 
                                                            <input type="hidden" value="getLoan" name="type_account">
                                                            <input type="hidden" value="loan" name="category_account">
                                                            <input type="hidden" v-model="loan_id"  name="loan_id">
    
                                                            <td>
                                                                <v-select label="code" :options="currency" v-model="selected_currency" @keyup.native="editKey = true" @click.native="editKey = true" @input="(editKey)?setSize(selected_currency.code):''" 
                                                                ></v-select>
                                                                <input type="hidden" name="currency_account" :value="!selected_currency?null:selected_currency.code">
                                                            
                                                            </td>
                                                            <td>
                                                                <select class="form-control input-style" v-model="selectbank" name="bank_id_account" >
                                                                <option value="">@lang('layout.Select')</option>
                                                                    <option v-if="selected_banks" v-for="banks in selected_banks" :value="banks.id">
                                                                        @{{banks.name}}
                                                                    </option>
                                                                </select>
    
                                                            </td>
                                                            
                                                            <td>
                                                                <input type="text" v-model="exchange_rate"  name="rate_account"  class="form-control" id="">
                                                            </td> 
    
                                                            <td>
                                                               <input type="text" name="amount_account" class="form-control" id="" v-model="loan_amount">
                                                            </td>
    
                                                            <td>
                                                               <textarea name="description_account" class="form-control" id="" cols="30" rows="1"> @if($loan) {{$loan->description}} @endif</textarea>
                                                            </td>
                                                               
                                                        </tr>
                                                    </tbody>
    
                                                </table>
    
                                                
                                            </div>
                                           

                                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                            <button type="button" v-if="!isError" @click="handleSubmit($event)"
                                                    class="btn green">@lang('layout.Submit')</button>
                                        <!--   <button type="button" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button> -->

                                            <a href="{{route('inventoryTransfer.index')}}" class="btn default"><i
                                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                        </div>

                                        <cmodal :show='showModal' @close="showModal=false">

                                        </cmodal>
                                    </div>

                                </div>


                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                    <p> &nbsp; </p>
                    <p> &nbsp; </p>
                </div>
            </div>
            <!-- END TAB PORTLET-->
        </div>
    </div>
@endsection
@push('scripts')


    <script type="text/javascript">
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif



        Vue.component('v-select', VueSelect.VueSelect);


        var inventory_category = {!! $inventory_category !!};
        var site = {!! $site !!};
        var driver = {!! $driver !!};
        var selected_item ={!! $selectedItem !!};
        var wagon= {!! $wagon !!};
        var transfer= {!! $transfer !!};
        var contract= {!! $contract !!};

        var banks= {!! $banks !!};
        var currency= {!! $currency !!};
        var loan = {!! json_encode($loan) !!};

        var v = new Vue({
            el: '#app',
            data: {
                showModal: false,
                temp_items: [],
                inventory_category: inventory_category,
                selected_iventory_category: null,
                selected_index: 0,
                employees: [],
                selected_employee: {!! $selectedEmployee !!},
                site: site,
                driver: driver,
                selected_driver: {!!$selected_driver!!},
                inventories: [],
                edit_sale: "{{$edit_sale}}",
                selected_item: selected_item,
                contracts: contract,
                wagon: wagon,
                wagonAll: wagon,
                customer: [],
                selected_customer: {!!$selectedCustomer!!},
                selectedContract: null,
                selectedWagon: null,
                contract_transfer: false,
                editKey: false,
                banks: banks,
                selected_banks: banks,
                selectbank:  null,
                currency: currency,
                selected_currency: null,
                exchange_rate: 1,
                loan_id: '',
                loan_amount: '',
            },
           
            computed: {

                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;
                    /**for (var i = 0; i < this.inventories.length; i++)
                     {
                    
                    if (this.inventories[i].item)
                    {
                      flag=true;
                      if(((this.inventories[i]['item']['rate'] <=0) ))
                      {
                        rate=this.inventories[i]['item']['rate'];
                        new_rate=this.inventories[i]['item']['new_rate'];
                        if(rate <=0 && new_rate <=0)
                        {
                             isError = true;
                        }
                       
                      }
                    } 
                 } **/

                    return isError;
                },

            },
            methods:
                {
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                v.submitForm(e.target);
                            }
                        });
                    },

                    

              setSize(selected_currency) {
                this.exchange_rate = this.selected_currency.exchange_rate;
                var b = _.clone(banks)
                    var test = b.filter((account) => {
                        return (new RegExp(selected_currency)).test(account.code)
                    })   
                    this.selected_banks = test;
            },
          
            CustomerSearch: _.debounce((search, loading) => {
                loading(true);
                let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        class_id: class_id,
                        type: 'Customer'
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        v.customer = [];
                        v.customer = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),


                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                type: 'Employee'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                v.employees = [];
                                v.employees = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),

                    contractWagon() {
                        this.wagon = this.wagonAll;
                        if (this.selectedContract) {
                            this.temp_items = [];
                            this.wagon = this.wagonAll.filter((wagon) => {
                                return this.selectedContract.id == wagon.contract_id;
                            });

                        }
                    },

                    contractChange(index) {

                        v.selected_index = index;
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                        if (v.inventories[v.selected_index]['contract']) {
                        let contract_id = v.inventories[v.selected_index]['contract'].id;
                        let wagon_number = (v.inventories[v.selected_index]['select_wagon'])?v.inventories[v.selected_index]['select_wagon'].name:null;

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchSaleContract',
                                inventory_category_id: inventory_category_id,
                                wagon_number: wagon_number,
                                contract_id: contract_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.inventories[index]['item'] = null;
                                    v.temp_items = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },

                    contractWagon1(index) {
                        v.wagon = v.wagonAll;
                        if (v.inventories[index]['contract']) {
                            v.wagon = v.wagonAll.filter((wagon) => {
                                return v.inventories[index]['contract'].id == wagon.contract_id;
                            });
                        }
                    },

                    // begin item search


                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                        let contract_id = (v.selectedContract != undefined && !v.contract_transfer) ? v.selectedContract.id : '';
                        let wagon_number = (v.selectedWagon != undefined && !v.contract_transfer) ? v.selectedWagon.name : '';

                        contract_id = (v.inventories[v.selected_index]['contract'])?v.inventories[v.selected_index]['contract'].id:contract_id;
                        wagon_number = (v.inventories[v.selected_index]['select_wagon'])?v.inventories[v.selected_index]['select_wagon'].name:wagon_number;

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                keyword: search,
                                inventory_category_id: inventory_category_id,
                                contract_id: contract_id,
                                wagon_number: wagon_number
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),

                    onItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].inventory != null) {
                            // console.log('klk',v.inventories[index].inventory,v.inventories);
                            var inventory_id = v.inventories[index].inventory.id;
                            let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                            let contract_id = (v.selectedContract != undefined && !v.contract_transfer) ? v.selectedContract.id : '';
                            let wagon_number = (v.selectedWagon != undefined && !v.contract_transfer) ? v.selectedWagon.name : '';

                            contract_id = (v.inventories[v.selected_index]['contract'])?v.inventories[v.selected_index]['contract'].id:contract_id;
                            wagon_number = (v.inventories[v.selected_index]['select_wagon'])?v.inventories[v.selected_index]['select_wagon'].name:wagon_number;

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchSale',
                                    inventory_id: inventory_id,
                                    inventory_category_id: inventory_category_id,
                                    contract_id: contract_id,
                                    wagon_number: wagon_number
                                }
                            })
                                .then(function (response) {
                                    v.inventories[index].item = null;
                                    v.inventories[index].location = null;
                                    if (response.data.length > 0) {
                                        v.inventories[index].item = response.data[0];
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                })
                        }
                    },

                    
                    locationSearch: _.debounce((search, loading) => {
                        loading(true);
                        let inventory_id = (v.inventories[v.selected_index]['item'] != undefined) ? v.inventories[v.selected_index]['item'].id : '';
                        // console.log(3333, v.inventories, v.selected_index, inventory_id, search);
                        if (inventory_id) {
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemesSearchLocation',
                                    keyword: search,
                                    inventory_id: inventory_id
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    v.inventories[v.selected_index]['item']['locationList'] = response.data;
                                }
                                loading(false);
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        } else {
                            loading(false);
                        }
                    }, getDebounceTime()),

                    locationItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].item != null && v.inventories[index].location != null) {
                            var inventory_id = v.inventories[index].item.id;
                            var location = v.inventories[index].location.name;

                            axios.get("{{route('callMethod.search')}}", {
                                    params: {
                                        method_name: 'itemSiteByLocation',
                                        inventory_id: inventory_id,
                                        location: location
                                    }
                                })
                                .then(function(response) {
                                    // console.log(4444, response.data);
                                    if (response.data.item.length > 0) {
                                        v.inventories[index].item.site_list = response.data.item;
                                        v.inventories[index].item.site = response.data.selectItem;
                                    }
                                })
                                .catch(function(error) {
                                    console.log(error);
                                })
                        }
                    },

                    //ajax call to get items
                    setIndex(e) {
                        //v.temp_items=[];
                        this.selected_index = e;
                    },
                    itemCategoryChange(index) {
                        v.setIndex(index);
                        v.selected_iventory_category = this.inventories[this.selected_index]['item_category'];
                        if (this.inventories[this.selected_index]['item_category'] != null) {
                            let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                            let contract_id = (v.selectedContract != undefined && !v.contract_transfer) ? v.selectedContract.id : '';
                            let wagon_number = (v.selectedWagon != undefined && !v.contract_transfer) ? v.selectedWagon.name : '';

                            contract_id = (v.inventories[v.selected_index]['contract'])?v.inventories[v.selected_index]['contract'].id:contract_id;
                            wagon_number = (v.inventories[v.selected_index]['select_wagon'])?v.inventories[v.selected_index]['select_wagon'].name:wagon_number;

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemesSearchSale',
                                    inventory_category_id: inventory_category_id,
                                    contract_id: contract_id,
                                    wagon_number: wagon_number
                                }
                            })
                                .then(function (response) {
                                    v.temp_items = [];
                                    if (response.data.length > 0) {
                                        v.temp_items = response.data;
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });
                        }

                    },

                    // end item search

                    ToSiteItemQuantity(item = null, quantity = null, edit_quantity = null) {
                        if (item != null) {
                            var result = 0;
                            if (item.to_site) {
                                result = (item.to_site.OnHand * item.measure_unit) / (item.measure.measure_unit) + Number(quantity);


                            }
                            if (edit_quantity != null) {
                                result +=Number(edit_quantity);
                            }
                            return result;
                        }
                    },

                    // contract search


                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.temp_items = [];
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({
                                        inventory: null,
                                        item: null,
                                        location: null,
                                        to_location: null,
                                        update_data: null,
                                        transfer_info_id: null,
                                        item_category: this.selected_iventory_category
                                    });
                                }
                            }


                        }

                    },

                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }

                        }

                    },
                    // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("transfer-form").submit()

                            }
                            else {

                            }
                        });

                    },
                    defaultValue() {
                        this.selected_index = 0;

                        this.inventories = [
                            {item: null, item_category: this.selected_iventory_category},
                        ];

                        this.temp_items = [];

                    },
                    saveAndNew() {
                        this.$validator.validate()
                            .then(valid => {
                                if (valid) {

                                    var url = "{{route('inventoryTransfer.store')}}";
                                    form_id = 'transfer-form';
                                    var data = $('#' + form_id).serialize();

                                    axios.post(url, data)
                                        .then(function (response) {
                                            if (response.data.result == 1) {
                                                $('#' + form_id).trigger('reset');
                                                toastr.success('', response.data.message);

                                                v.defaultValue();
                                            }
                                            else {
                                                var message = "{{__('message.Warning')}}";
                                                //$('#error-sound')[0].play();
                                                toastr.warning('', message);
                                            }
                                        })
                                        .catch(function (error) {
                                            console.log(error);
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        });

                                }
                            })
                    },
                },
            mounted: function () {
                // this.exchange_rate = loan.loanRate;

                if (transfer) {
                    if (transfer.id) {
                        var vmc = this;
                        axios.get("{{url('inventoryTransfer')}}/" + transfer.id + "/edit")
                        .then(function(response) {
                            if (response.data) {
                                if (response.data.selectedItem) {
                                    vmc.selected_item = response.data.selectedItem;

                                    for (var i = 0; i < vmc.selected_item.length; i++) {

                                        var select_wagon = null;
                                        var select_contract = null;
                                        if(vmc.selected_item[i].wagon_number != null && vmc.selected_item[i].wagon_number != ''){
                                            select_wagon = _.find(vmc.wagonAll, (c) => c.name == vmc.selected_item[i].wagon_number);
                                        }

                                        if(vmc.selected_item[i].contract_id != null && vmc.selected_item[i].contract_id != ''){
                                            select_contract = _.find(vmc.contracts, (c) => c.id == vmc.selected_item[i].contract_id);
                                        }

                                        vmc.inventories.push({
                                            inventory: vmc.selected_item[i],
                                            item: vmc.selected_item[i],
                                            to_location: vmc.selected_item[i].to_location,
                                            location: vmc.selected_item[i].selectedLocation,
                                            item_category: vmc.selected_item[i].item_category,
                                            update_data: vmc.selected_item[i].update_data,
                                            transfer_info_id: vmc.selected_item[i].inventory_transfer_info_id,
                                            contract: select_contract,
                                            select_wagon: select_wagon
                                        });
                                    }

                                    @if($edit_sale != 'yes')
                                    for (var m = 4; m > vmc.selected_item.length; m--) {
                                        vmc.inventories.push({inventory: null, item: null, location: null, to_location: null, item_category: null, update_data: null, transfer_info_id: null});
                                    }
                                    @endif

                                }
                            }
                        })
                        .catch(function(error) {
                            @if($edit_sale != 'yes')
                            for (var m = 4; m > vmc.selected_item.length; m--) {
                                vmc.inventories.push({inventory: null, item: null, location: null, to_location: null, item_category: null, update_data: null, transfer_info_id: null});
                            }
                            @endif
                            console.log(error);
                        })
                    } 
                }
                 
            
                @if($loan)
                @if($loan->bank_rate)
                this.exchange_rate = {{$loan->bank_rate}};
                @endif

                @if($loan->currency)
                    this.selected_currency = _.find(this.currency, (c) => c.code == '{{$loan->currency}}');
                @endif

                @if($loan->account_id)
                this.selectbank = {{$loan->account_id}};
                @endif
                
                this.loan_id = {{$loan->id}};
                this.loan_amount = {{$loan->amount}};
              
               
                @endif
                if(transfer.contract_id !='' && transfer.contract_id !=null)
                {
                    this.selectedContract = _.find({!! $contract !!}, (a) => a.id == transfer.contract_id);
                }

                if(transfer.wagon_number !='' && transfer.wagon_number !=null)
                {
                    this.selectedWagon = _.find({!! $wagon !!}, (a) => a.name == transfer.wagon_number);
                }

                if(transfer.contract_type !='' && transfer.contract_type !=null)
                {
                    this.contract_transfer = true;
                }

            }

        });

    </script>


@endpush