@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

    <style>
        .required {
            padding-left: 0px !important;
            color: red;
        }
    </style>
@stop
@section('content')
    <div class="row">
        <div class="portlet light bordered">
            <!-- BEGIN TAB PORTLET-->
            <div class="portlet light bordered sale">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-anchor font-green-sharp"></i>&nbsp;
                        <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.NewInventoryTransfer')</span>
                    </div>
                    <div class="actions">
                    </div>
                </div>
                <div id="app" class="portlet-body">

                    <div class="tabbable tabbable-tabdrop">
                            <div class="tab-content">
                            {{Form::open(['route' => 'inventoryTransfer.store','method' => 'POST','class' => 'form-horizontal','id'=>'transfer-form'])}}
                            {{ csrf_field() }}
                                <div class="tab-pane active" id="tab1">
                                    <div v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                        <!-- BEGIN FORM--> 
                                        <div class="form-body">
                                            <div class="row">
                                                <!-- begin inputs --> 
                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Number')</label>
                                                                <input type="text" name="number" v-validate="'required'" data-vv-as="@lang('layout.Number')" v-model="number" class="form-control">
                                                                <span class="required">@{{ errors.first('number') }}</span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Date')</label>

                                                                <input type="text" name="date"
                                                                       class="form-control date now" autocomplete="off">
                                                            </div>
                                                        </div>
                                                    </div>
                                                @if(systemConfig()[20] == 1)
                                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                    <label class="control-label"> <span class="fa fa-truck" style="color:green;"></span> @lang('layout.Transfer') @lang('layout.Contract') </label>
                                                    <div class="col-md-12 mt-checkbox">
                                                        <label class="mt-checkbox mt-checkbox-outline">
                                                            <input type="checkbox"  name="contract_transfer" v-model="contract_transfer"  />
                                                            <span></span>
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.ContractName')</label>
                                                            <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                                                    v-model="selectedContract" label="company_name"
                                                                    @input="contractWagon()" :options="{{$contract}}">
                                                            </v-select>
                                                            <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.WagonNumber')</label>
                                                            <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                                                    v-model="selectedWagon" label="name"
                                                                    :options="wagon">
                                                            </v-select>
                                                            <input type="hidden" name="wagon_number" v-model.number="(!selectedWagon)?null:selectedWagon.name" />
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif

                                                <!-- end inputs -->
                                            </div>

                                            <div class="row">
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Responsible')</label>
                                                            <v-select label="name" :options="employees" @search="MemberSearch" v-model="selected_employee"></v-select>
                                                            <input type="hidden" name="employee_id" :value="!selected_employee?null:selected_employee.id">
                                                        </div>
                                                    </div>
                                                </div>


                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <div class="form-group">

                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Customer') </label>
                                                                <v-select label="name" @search="CustomerSearch" :options="customer" v-model="selected_customer"></v-select>
                                                                <input type="hidden" name="customer_id"  data-vv-as="@lang('layout.Customer')" :value="!selected_customer?null:selected_customer.id">                                                                
                                                            <span class="required">@{{ errors.first('customer') }}</span>
                                                        </div>
                                                    </div>

                                                </div>

                                                
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Description')</label>

                                                            <textarea name="description" class="form-control"
                                                                      rows="1"></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>                 

                                            <!-- begin Driver And Other Info -->
                                            <div class="row">

                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Driver')</label>
                                                                 <v-select label="name"  v-model="selected_driver"
                                                                      :options="driver">
                                                                  </v-select>
                                                                  <input type="hidden" name="driver_id" :value="(!selected_driver)?null:selected_driver.id">
                                                           
                                                            </div>
                                                        </div>
                                                    </div>  
                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.TotalQty')</label>
                                                                 <input type="text" name="total_bori" class="form-control" placeholder="@lang('layout.TotalQty')">
                                                           
                                                            </div>
                                                        </div>
                                                    </div>    
                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.WayBillNumber')</label>
                                                                 <input type="text" name="way_bill_number" class="form-control" placeholder="@lang('layout.WayBillNumber')">
                                                           
                                                            </div>
                                                        </div>
                                                    </div>
                                                 <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.PlateNumber')</label>
                                                                 <input type="text" name="plate_number" class="form-control" placeholder="@lang('layout.PlateNumber')">
                                                           
                                                            </div>
                                                        </div>
                                                    </div>
                                            </div>
                                                <!-- End Driver And Other Info -->

                                            <div class="row" style="overflow-x: scroll;">
                                                <table id="table_content" class="table table-bordered table-advance">
                                                    <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        @if(systemConfig()[20] == 1)
                                                        <th style="min-width: 130px">@lang('layout.Contract') </th>
                                                        <th style="min-width: 130px">@lang('layout.WagonNumber') </th>
                                                        @endif
                                                        <th v-show="showWhat('sale_category')=='yes'" style="min-width: 130px; text-align:center;">@lang('layout.Category') </th>
                                                        <th style="min-width: 130px; text-align:center;">@lang('layout.ItemName') </th>
                                                        @if(searchByCodeLocation()=="true")
                                                        <th style="min-width: 110px;">@lang('layout.Location')</th>
                                                        <th style="min-width: 100px;">@lang('layout.ToLocation')</th>
                                                        @endif
                                                        @if(getSerailNumber() =="true")
                                                        <th style="min-width: 100px">@lang('layout.SerialNum') </th>
                                                        @endif
                                                        <th style="min-width: 130px; text-align:center;" >@lang('layout.FromSite') </th>
                                                        <th style="min-width: 130px; text-align:center;" >@lang('layout.ToSite') </th>
                                                        <th style="min-width: 100px; text-align:center;">@lang('layout.Quantity') </th>
                                                        <th style="min-width: 100px; text-align:center;">@lang('layout.Measure') </th>
                                                        <th v-show="showWhat('other_measure')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue1') </th>
                                                        <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue2') </th>
                                                        <th></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr v-for="(item,index) in inventories">
                                                        <td>@{{index+1}}</td>
                                                        @if(systemConfig()[20] == 1)
                                                        <td>
                                                            <v-select label="company_name" v-model="item.contract" :options="contracts" @input="contractChange(index), contractWagon1(index)"></v-select>
                                                            <input type="hidden" name="inv_contract_id[]" :value="(!item.contract)?null:item.contract.id">
                                                        </td>
                                                        <td>
                                                            <v-select label="name" v-model="item.select_wagon" :options="wagon" @input="contractChange(index)"></v-select>
                                                            <input type="hidden" name="inv_wagon_number[]" :value="(!item.select_wagon)?null:item.select_wagon.name">
                                                        </td>
                                                        @else
                                                        <input type="hidden" name="inv_contract_id[]" >
                                                        <input type="hidden" name="inv_wagon_number[]" >
                                                        @endif
                                                        <td v-show="showWhat('sale_category')=='yes'">
                                                            <v-select label="name" v-model="item.item_category"
                                                                      :options="inventory_category"
                                                                      @input="itemCategoryChange(index)"></v-select>
                                                            <input type="hidden" name="inventory_category_id[]" :value="(!item.item_category)?null:item.item_category.id">
                                                        </td>
                                                        <td class="highlight">
                                                            <v-select label="name" @input="onItemload(index)"
                                                                      v-model="item.inventory" :options="temp_items"
                                                                      @search="onItemSearch"></v-select>
                                                            <input type="hidden" :name="'inventory_id['+index+']'"
                                                                   v-validate="''" data-vv-as="@lang('layout.ItemName')"
                                                                   :value="(!item.item)?null:item.item.id">
                                                            <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>
                                                        </td>
                                                        @if(searchByCodeLocation()=="true")
                                                        <td class="highlight">
                                                            <v-select label="name" @Click.native="setIndex(index)" @input="locationItemload(index)" v-model="item.location" :options="(item.item==null)?[]:item.item.locationList" @search="locationSearch" ></v-select>
                                                            <input type="hidden" :name="'location['+index+']'" v-validate="''" data-vv-as="@lang('layout.Location')" :value="(!item.location)?null:item.location.name">
                                                        </td>
                                                        <td>
                                                            <input type="text" :name="'to_location['+index+']'" class="form-control input-style" placeholder="@lang('layout.ToLocation')">
                                                        </td>
                                                        @endif
                                                        @if(getSerailNumber() =="true")
                                                        <td>
                                                            @{{(!item.item)?null:item.item.number}}
                                                        </td>
                                                        @endif
                                                        <td class="highlight">
                                                            <div class="input-group">
                                                            <select v-model="(item.item==null)?null:item.item.site"
                                                                    class="form-control">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item != null)">
                                                                <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                                  @{{site.site_name}}
                                                                </option> 
                                                              </span>
                                                            </select>

                                                            <input type="hidden" name="from_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                            <span class="input-group-addon">@{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}</span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                          <span v-if="(item.item !=null)">
                                                          <div class="input-group" v-if="item.item.site">
                                                            <select class="form-control input_style" placeholder="@lang('layout.ToSite')" required="required" v-model="!item.item?null:item.item.to_site" >
                                                                <option v-if="item.item.site.site_id!=si.site_id || contract_transfer"
                                                                        v-for="si in (item.item==null)?null:item.item.site_list" :value="si">@{{si.name}}
                                                                </option>
                                                            </select>
                                                            <span class="input-group-addon">@{{myRound((item.item==null)?null:ToSiteItemQuantity(item.item,item.item.quantity))}}</span> 
                                                         </div>
                                                        </span>
                                                            <input type="hidden" name="to_site[]" :value="(!item.item)?null:(item.item.to_site)?item.item.to_site.site_id:null">
                                                        </td>
                                                        <td>
                                                            <input type="number" :name="'inventory_quantity['+index+']'"
                                                                   v-validate="''" data-vv-as="@lang('layout.Quantity')"
                                                                   v-model.number="(item.item==null)?null:item.item.quantity"
                                                                   class="form-control input-style input-number"
                                                                   placeholder="@lang('layout.Quantity')">
                                                            <span class="required">@{{ errors.first('inventory_quantity['+index+']') }}</span>
                                                        </td>

                                                        <td class="highlight">
                                                            <select v-model="(item.item == null)?null:item.item.measure"
                                                                    class="form-control">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                                            :value="measure">
                                                                    @{{measure.measure_name}}
                                                                  </option> 
                                                                </span>
                                                            </select>
                                                            <input type="hidden" name="inventory_measure[]"
                                                                   :value="(item.item==null)?null:item.item.measure.measure_id">
                                                        </td>
                                                        <td v-show="showWhat('other_measure')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="other_measure_amount[]"
                                                                oninput = "autowidths(event)"
                                                                    class="form-control input-style input-number chan_length"
                                                                    placeholder="@lang('layout.OMeasureValue1')">
                                                                <span class="input-group-addon">@{{myRound((item.item==null)?0:((item.item.site==null)?0:item.item.site.other_measure))}}</span> 
                                                            </div>
                                                        </td>
                                                        <td v-show="showWhat('other_measure2')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="other_measure_amount2[]"
                                                                oninput = "autowidths(event)"
                                                                    class="form-control input-style input-number chan_length"
                                                                    placeholder="@lang('layout.OMeasureValue2')">
                                                                <span class="input-group-addon">@{{myRound((item.item==null)?0:((item.item.site==null)?0:item.item.site.other_measure2))}}</span> 
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <span v-on:click="deleteItem('inventory',index)"><i
                                                                        class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>
                                                    <tr style="background-color: #ffffff;">
                                                        <td></td>
                                                        <td>
                                                            <center>
                                                                <button type="button" @click="addNew('inventory',100)"
                                                                        class="btn btn-success"><i
                                                                            class="fa fa-plus"></i></button>
                                                            </center>
                                                        </td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                    </tr>
                                                    </tbody>
                                                </table>

                                                <br/>
                                                <br/>
 
                                            </div>


                                        </div>
                                        <div class="col-xl-12"> 
                                            <table id="table_content" class="table table-striped table-bordered table-hover">
                                                <h3 style="margin-bottom: 25px;"> @lang('layout.ReciveLoan') </h3>
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                                        <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                                        <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                                        <th class="text-center" style="min-width: 120px;">@lang('layout.Description')</th>

                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr> 
                                                        <input type="hidden" value="getLoan" name="type_account">
                                                        <input type="hidden" value="loan" name="category_account">

                                                        <td>
                                                            <v-select label="code" :options="currency" v-model="selected_currency"  @input="setSize(selected_currency.code)"
                                                            ></v-select>
                                                            <input type="hidden" name="currency_account" :value="!selected_currency?null:selected_currency.code">
                                                        
                                                        </td>
                                                        <td>
                                                            <select class="form-control input-style" v-model="banks"
                                                             name="bank_id_account" >
                                                            <option value="">@lang('layout.Select')</option>
                                                                <option v-if="selected_banks" v-for="banks in selected_banks" :value="banks.id">
                                                                    @{{banks.name}}
                                                                </option>
                                                            </select>

                                                        </td>
                                                        
                                                        <td>
                                                            <input type="text" name="rate_account" v-model="exchange_rate" class="form-control" id="">
                                                        </td> 

                                                        <td>
                                                           <input type="text" name="amount_account" class="form-control" id="">
                                                        </td>

                                                        <td>
                                                           <textarea name="description_account" class="form-control" id="" cols="30" rows="1"></textarea>
                                                        </td>
                                                           
                                                    </tr>
                                                </tbody>

                                            </table>

                                            
                                        </div>
                                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                            <button type="button" v-if="!isError" @click="handleSubmit($event)"
                                                    class="btn green">@lang('layout.Submit')</button>
                                            <button type="button" class="btn blue"
                                                    @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>

                                            <a href="{{route('inventoryTransfer.index')}}" class="btn default"><i
                                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                        </div>

                                        <cmodal :show='showModal' @close="showModal=false">

                                        </cmodal>
                                    </div>

                                </div>


                                {!! Form::close() !!}
                            </div>
                    </div>
                    <p> &nbsp; </p>
                    <p> &nbsp; </p>
                </div>
            </div>
            <!-- END TAB PORTLET-->
        </div>
    </div>
@endsection
@push('scripts')


    <script type="text/javascript">
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif



        Vue.component('v-select', VueSelect.VueSelect);

        var inventory_category = {!! $inventory_category !!};
        var contract = {!! $contract !!};
        var site = {!! $site !!};
        var driver = {!! $driver !!};
        var wagon= {!! $wagon !!};

        var banks= {!! $banks !!};
        var currency= {!! $currency !!};

        var v = new Vue({
            el: '#app',
            data: {
                number: "{{$number}}",
                old_number: "{{$number}}",
                showModal: false,
                exchange_rate: null,
                temp_items: [],
                contracts: contract,
                inventory_category: inventory_category,
                selected_iventory_category: null,
                selected_index: 0,
                wagon: wagon,
                customer: [],
                selected_customer: null,
                wagonAll: wagon,
                selectedContract: null,
                selectedWagon: null,
                contract_transfer: false,
                site: site,
                driver: driver,
                selected_driver:null,
                selected_employee:null,
                banks: banks,
                selected_banks: banks,
                currency: currency,
                selected_currency: null,
                employees:[],
                inventories: [
                    {inventory: null, item: null, location: null, item_category: null},
                ],
            },
            computed: {

                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;
                    /**for (var i = 0; i < this.inventories.length; i++)
                     {
                    
                    if (this.inventories[i].item)
                    {
                      flag=true;
                      if(((this.inventories[i]['item']['rate'] <=0) ))
                      {
                        rate=this.inventories[i]['item']['rate'];
                        new_rate=this.inventories[i]['item']['new_rate'];
                        if(rate <=0 && new_rate <=0)
                        {
                             isError = true;
                        }
                       
                      }
                    } 
                 } **/

                    return isError;
                },

            },
            methods:
                {
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                v.submitForm(e.target);
                            }
                        });
                    },



              setSize(selected_currency) {
                this.exchange_rate = this.selected_currency.exchange_rate;

                var b = _.clone(banks)
                    var test = b.filter((account) => {
                        return (new RegExp(selected_currency)).test(account.code)
                    })   
                    this.selected_banks = test;
            },


         

            CustomerSearch: _.debounce((search, loading) => {
                loading(true);
                let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        class_id: class_id,
                        type: 'Customer'
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        v.customer = [];
                        v.customer = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),


                    contractWagon() {
                        this.wagon = this.wagonAll;
                        if (this.selectedContract) {
                            if (!this.contract_transfer) {
                                this.inventories = [
                                    {inventory: null, item: null, item_category: null},
                                ];
                                this.temp_items = [];
                            }
                            this.wagon = this.wagonAll.filter((wagon) => {
                                return this.selectedContract.id == wagon.contract_id;
                            });

                        }
                    },


                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                type: 'Employee'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                v.employees = [];
                                v.employees = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),

                    contractChange(index) {

                        v.selected_index = index;
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                        if (v.inventories[v.selected_index]['contract']) {
                        let contract_id = v.inventories[v.selected_index]['contract'].id;
                        let wagon_number = (v.inventories[v.selected_index]['select_wagon'])?v.inventories[v.selected_index]['select_wagon'].name:null;

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchSaleContract',
                                inventory_category_id: inventory_category_id,
                                wagon_number: wagon_number,
                                contract_id: contract_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.inventories[index]['item'] = null;
                                    v.temp_items = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },

                    contractWagon1(index) {
                        v.wagon = v.wagonAll;
                        if (v.inventories[index]['contract']) {
                            v.wagon = v.wagonAll.filter((wagon) => {
                                return v.inventories[index]['contract'].id == wagon.contract_id;
                            });
                        }
                    },

                    // begin item search

                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                        let contract_id = (v.selectedContract != undefined && !v.contract_transfer) ? v.selectedContract.id : '';
                        let wagon_number = (v.selectedWagon != undefined && !v.contract_transfer) ? v.selectedWagon.name : '';
                        
                        contract_id = (v.inventories[v.selected_index]['contract'])?v.inventories[v.selected_index]['contract'].id:contract_id;
                        wagon_number = (v.inventories[v.selected_index]['select_wagon'])?v.inventories[v.selected_index]['select_wagon'].name:wagon_number;
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                keyword: search,
                                inventory_category_id: inventory_category_id,
                                contract_id: contract_id,
                                wagon_number: wagon_number
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),

                    onItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].inventory != null) {
                            // console.log('klk',v.inventories[index].inventory,v.inventories);
                            var inventory_id = v.inventories[index].inventory.id;
                            let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                            let contract_id = (v.selectedContract != undefined && !v.contract_transfer) ? v.selectedContract.id : '';
                            let wagon_number = (v.selectedWagon != undefined && !v.contract_transfer) ? v.selectedWagon.name : '';

                            contract_id = (v.inventories[v.selected_index]['contract'])?v.inventories[v.selected_index]['contract'].id:contract_id;
                            wagon_number = (v.inventories[v.selected_index]['select_wagon'])?v.inventories[v.selected_index]['select_wagon'].name:wagon_number;

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchTransfer',
                                    inventory_id: inventory_id,
                                    inventory_category_id: inventory_category_id,
                                    contract_id: contract_id,
                                    wagon_number: wagon_number

                                }
                            })
                                .then(function (response) {
                                    v.inventories[index].item = null;
                                    v.inventories[index].location = null;
                                    if (response.data.length > 0) {
                                        v.inventories[index].item = response.data[0];
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                })
                        }
                    },

                    
                    locationSearch: _.debounce((search, loading) => {
                        loading(true);
                        let inventory_id = (v.inventories[v.selected_index]['item'] != undefined) ? v.inventories[v.selected_index]['item'].id : '';
                        // console.log(3333, v.inventories, v.selected_index, inventory_id, search);
                        if (inventory_id) {
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemesSearchLocation',
                                    keyword: search,
                                    inventory_id: inventory_id
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    v.inventories[v.selected_index]['item']['locationList'] = response.data;
                                }
                                loading(false);
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        } else {
                            loading(false);
                        }
                    }, getDebounceTime()),

                    locationItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].item != null && v.inventories[index].location != null) {
                            var inventory_id = v.inventories[index].item.id;
                            var location = v.inventories[index].location.name;

                            axios.get("{{route('callMethod.search')}}", {
                                    params: {
                                        method_name: 'itemSiteByLocation',
                                        inventory_id: inventory_id,
                                        location: location
                                    }
                                })
                                .then(function(response) {
                                    // console.log(4444, response.data);
                                    if (response.data.item.length > 0) {
                                        v.inventories[index].item.site_list = response.data.item;
                                        v.inventories[index].item.site = response.data.selectItem;
                                    }
                                })
                                .catch(function(error) {
                                    console.log(error);
                                })
                        }
                    },

                    //ajax call to get items
                    setIndex(e) {
                        //v.temp_items=[];
                        this.selected_index = e;
                    },
                    itemCategoryChange(index) {
                        v.setIndex(index);
                        v.selected_iventory_category = this.inventories[this.selected_index]['item_category'];
                        let contract_id = (v.selectedContract != undefined && !v.contract_transfer) ? v.selectedContract.id : '';
                        let wagon_number = (v.selectedWagon != undefined && !v.contract_transfer) ? v.selectedWagon.name : '';

                        contract_id = (v.inventories[v.selected_index]['contract'])?v.inventories[v.selected_index]['contract'].id:contract_id;
                        wagon_number = (v.inventories[v.selected_index]['select_wagon'])?v.inventories[v.selected_index]['select_wagon'].name:wagon_number;

                        if (this.inventories[this.selected_index]['item_category'] != null) {
                            let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemesSearchSale',
                                    inventory_category_id: inventory_category_id,
                                    contract_id: contract_id,
                                    wagon_number: wagon_number
                                }
                            })
                                .then(function (response) {
                                    v.temp_items = [];
                                    if (response.data.length > 0) {
                                        v.temp_items = response.data;
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });
                        }

                    },

                    // end item search

                    //get item quantity
                    ToSiteItemQuantity(item = null, quantity = null, edit_quantity = null) {
                        if (item != null) {
                            var result = 0;
                            if (item.to_site) {
                                result = (item.to_site.OnHand * item.measure_unit) / (item.measure.measure_unit) + Number(quantity);


                            }
                            if (edit_quantity != null) {
                                result +=Number(edit_quantity);
                            }
                            return result;
                        }
                    },

                    // contract search


                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.temp_items = [];
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({
                                        inventory: null,
                                        item: null,
                                        location: null,
                                        item_category: this.selected_iventory_category
                                    });
                                }
                            }


                        }

                    },

                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }

                        }

                    },
                    // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("transfer-form").submit()

                            }
                            else {

                            }
                        });

                    },
                    defaultValue() {
                        this.selected_index = 0;

                        this.inventories = [
                            {item: null, item_category: this.selected_iventory_category},
                        ];

                        this.temp_items = [];

                    },
                    saveAndNew() {
                        this.$validator.validate()
                            .then(valid => {
                                if (valid) {

                                    var url = "{{route('inventoryTransfer.store')}}";
                                    form_id = 'transfer-form';
                                    var data = $('#' + form_id).serialize();
                                    toggleBlock(true);
                                    axios.post(url, data)
                                        .then(function (response) {
                                            toggleBlock(0);
                                            if (response.data.result == 1) {
                                                $('#' + form_id).trigger('reset');
                                                toastr.success('', response.data.message);

                                                v.number = Number(v.old_number) + 1;
                                                v.old_number = Number(v.old_number) + 1;
                                                v.defaultValue();
                                            }
                                            else {
                                                var message = "{{__('message.Warning')}}";
                                                //$('#error-sound')[0].play();
                                                toastr.warning('', message);
                                            }
                                        })
                                        .catch(function (error) {
                                            toggleBlock(0);
                                            console.log(error);
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        });

                                }
                            })
                    },
                },
            created: function () {

            }

        });

    </script>


@endpush