@extends('layouts.factor-master')


@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.InventoryTransferBill')</h3>
    <table class="main-table">

        <tr>
            <th> @lang('layout.Number')</th>
			<th> @lang('layout.WayBillNumber')</th> 
            <th> @lang('layout.PlateNumber')</th> 
            <th> @lang('layout.TotalQty')</th> 
            <th> @lang('layout.Driver')</th>
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.Time')</th>
            <th>@lang('layout.CustomerName')</th>
            <th>@lang('layout.Accountant')</th>
        </tr>
        <tr>
            <td align="center">{{$transfer->id}}</td>
			<td class="hidden-xs"> {{ $transfer->way_bill_number}}  </td>
            <td class="hidden-xs"> {{ $transfer->plate_number}}  </td>
            <td class="hidden-xs"> {{ $transfer->total_bori}}  </td>
            <td class="hidden-xs"> {{ $transfer->name}}  </td>
            <td align="center">{{convertDate($transfer->Date)}} / {{$transfer->Date}}</td>
            <td align="center"><?php echo Date('h:i A' , strtotime($transfer->DateTime)); ?></td>
            <td align="center">{{$transfer->cus_name}}</td>
            <td align="center">{{$user}}</td>
        </tr>

    </table>

    <br>





    <table class="main-table">
        <thead>
        <tr>
            <th> @lang('layout.Item') </th>
            <th>@lang('layout.Code')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.Unit/M')</th>
            <th>@lang('layout.Wing')</th>
            <th>@lang('layout.FromSite')</th>
            <th>@lang('layout.ToSite')</th>

        </tr>
        </thead>
        <tbody>
		<?php
			$type=[];
			$code=0;
			$khada=0;
		?>
        @foreach($transferDetail as $key )
		
		<?php
			$code++;
			$khada += $key->khada;
			if(array_key_exists($key->Measure, $type))
			{
				$type[$key->Measure]=$type[$key->Measure]+$key->quantity;
			}
			else
			{
				$type[$key->Measure]=$key->quantity;
			}
		  ?>
            <tr>
                <td>
                    {{$key->ItemName}}
                </td>
                <td>
                    {{$key->code}}
                </td>
                <td>
                    {{$key->quantity}}
                </td>
                <td>
                    {{$key->Measure}}
                </td>
                <td>
                    {{$key->khada}}
                </td>
                <td>
                    {{$key->from_site}}
                </td>
                <td>
                    {{$key->to_site}}
                </td>
            </tr>
			
        @endforeach

        </tbody>
    </table>
    <br/>
	
	<table class="main-table">

	<tr class="bg">
	  <td><div class="center"> #</div></td>
	  <td><div class="center"> @lang('layout.Unit/M') </div></td>
	  <td><div class="center"> @lang('layout.Total') </div></td>
	</tr>
	<?php
	$count=0;

	if(isset($type))
	{
	  foreach($type As $key=>$typee)
	{
	  ?>
	  <tr>
		<td><div class="center">{{++$count}}</div></td>
		<td><div class="center">{{$key}}</div></td>
		<td><div class="center">{{$typee}}</div></td>

	  </tr>
	  <?php
	}
	}

	  ?>
		<tr  class="bg">
		<td>#</td>
		<td><div class="center"> @lang('layout.Code') </div></td>
		<td><div class="center">{{$code}}</div></td>
		</tr>
		<tr  class="bg">
		<td>#</td>
		<td><div class="center"> @lang('layout.Wing') </div></td>
		<td><div class="center">{{$khada}}</div></td>
		</tr>
	</table>
	
	<br/>
    <table class="main-table">
        <thead>
        <tr>
            <th width="70%"> @lang('layout.Description') </th>
            <th>@lang('layout.MohrAndSignature')</th>


        </tr>
        </thead>
        <tbody>
        <tr>
            <td width="70%">{{$transfer->description}}</td>
            <td style="width: 30%;height: 50px"></td>
        </tr>


        </tbody>
    </table>




    @if(company()['inventory_transfer_message'])
        <table width="100%">
            <tr>
                <td style="font-size: 14px;">@lang('layout.Note'): {{company()['inventory_transfer_message']}}</td>
            </tr>

            <tr>
                <td></td>
                <td></td>
            </tr>


        </table>
    @endif
@endsection
