@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption"><i
                        class=""></i>@lang('layout.InventoryTransferDetail')

            </div>
            <div class="tools"><a
                        href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-
                   original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table
                        class="table table-striped table-bordered table-advance table-hover">
                    <thead>

                    <tr>
                        <th><i class="fa fa-bars"></i> @lang('layout.Number')</th> 
                        <th><i class="fa fa-bars"></i> @lang('layout.WayBillNumber')</th> 
                        <th><i class="fa fa-bars"></i> @lang('layout.PlateNumber')</th> 
                        <th><i class="fa fa-bars"></i> @lang('layout.TotalQty')</th> 
                        <th><i class="icon-user"></i> @lang('layout.Driver')</th>
                        <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.Date')
                        </th>
                        <th><i class="icon-user"></i> @lang('layout.CostomerName')</th>
                        <th><i class="fa fa-signal"></i> @lang('layout.Description')</th>


                    </tr>

                    </thead>
                    <tbody>

                    <tr>
						
						<td class=""> {{ (!$firstTransfer)?null:$firstTransfer->number}}  </td>
						<td class=""> {{ (!$firstTransfer)?null:$firstTransfer->way_bill_number}}  </td>
                        <td class=""> {{ (!$firstTransfer)?null:$firstTransfer->plate_number}}  </td>
                        <td class=""> {{ (!$firstTransfer)?null:$firstTransfer->total_bori}}  </td>
                        <td class=""> {{ (!$firstTransfer)?null:$firstTransfer->name}}  </td>
                        <td class=""> {{ (!$firstTransfer)?null:convertDate($firstTransfer->Date)}}  </td>
                        <td class=""> {{ (!$firstTransfer)?null:$firstTransfer->cus_name}}  </td>
                        <td class=""> {{ (!$firstTransfer)?null:$firstTransfer->description}}  </td>


                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>


    <div class="">


        <div class="tabbable tabbable-tabdrop">

            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.InventoryDetails')</a>
                </li>
                <li class="">
                    <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
                </li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="tab1">
                    <div class="row">
                        <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.InventoryDetails')</span>
                                    </div>
                                    <div class="tools"></div>
                                    <div class="actions">
                                        {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="inventory_transfer_detailRoll"/>
                                        <input type="hidden" name="inventory_transfer_id"
                                               value="{{(!$firstTransfer)?null:$firstTransfer->id}}"/>
                                        <button type="submit" class="btn btn-success"><i
                                                    class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                        {{Form::close()}}

                                        {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="inventory_transfer_detailRoll"/>
                                        <input type="hidden" name="inventory_transfer_id"
                                               value="{{(!$firstTransfer)?null:$firstTransfer->id}}"/>
                                        <button type="submit" class="btn btn-success"><i
                                                    class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                        {{Form::close()}}
                                    </div>
                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover"
                                           id="inventory_transfer_detail">
                                        <thead>
                                        <tr>
                                            <th>@lang('layout.ItemName')</th>
                                            <th>@lang('layout.Code')</th>
                                            @if(getOtherMeasure()=="true")
                                            <th>@lang('layout.OMeasureValue1')</th>
                                            @endif
                                            @if(getOtherMeasure2()=="true")
                                            <th>@lang('layout.OMeasureValue2')</th>
                                            @endif
                                            <th>@lang('layout.Measure')</th>
                                            <th>@lang('layout.Quantity')</th>
                                            <th>@lang('layout.FromSite')</th>
                                            <th>@lang('layout.ToSite')</th>

                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="tab2">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="portlet light bordered">
                                <div class="portlet-body">

                                    <form role="form" action="{{route('attachment.store')}}" method="post"
                                          enctype="multipart/form-data">

                                        @csrf
                                        <input type="hidden" name="redirect_route" value="inventoryTransfer.show">
                                        <input type="hidden" name="foreign_data_id" value="{{$firstTransfer->id}}">
                                        <input type="hidden" name="path" value="uploads/InventoryTransfer">
                                        <input type="hidden" name="table_name" value="inventory_transfers">

                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                    <input type="text" name="title" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea name="description" class="form-control"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-7">
                                                <div class="form-group">
                                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                                        <div class="fileinput-new thumbnail"
                                                             style="width: 200px; height: 150px;">
                                                            <img src="" alt=""></div>
                                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                                             style="max-width: 200px; max-height: 150px; line-height: 10px;"></div>
                                                        <div>
                                                                    <span class="btn default btn-file">
                                                                        <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                        <input type="hidden" value="" name=""><input
                                                                                type="file" name="photo"> </span>

                                                            <a href="javascript:;" class="btn default fileinput-exists"
                                                               data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="margiv-top-10">
                                            <button type="button" onclick="regForm(this)"
                                                    class="btn green"> @lang('layout.Submit') </button>
                                            <a href="{{route('inventoryTransfer.index')}}"
                                               class="btn default">@lang('layout.Cancel')</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <table class="table table-striped table-bordered table-hover" id="attachment">
                                <thead>
                                <tr>
                                    <th>@lang('layout.AttachmentTitle')</th>
                                    <th>@lang('layout.Description')</th>
                                    <th>@lang('layout.Action')</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection

@push('scripts')

    <script>

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#inventory_transfer_detail').DataTable({
                ajax: {

                    url: '{{route("InventoryTransferRoll.show",$id)}}',
                    data: {type: 'inventoryTransfer'}
                },
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'ItemName', name: 'ItemName'},
                    {data: 'code', name: 'code'},
                    @if(getOtherMeasure()=="true")
                    { data: 'other_measure_name', name: 'other_measure_name', orderable:false,searchable:false },
                    @endif
                    @if(getOtherMeasure2()=="true")
                    { data: 'other_measure_name2', name: 'other_measure_name2', orderable:false,searchable:false },
                    @endif
                    {data: 'Measure', name: 'Measure'},
                    {data: 'quantity', name: 'quantity'},
                    {data: 'from_site', name: 'from_site'},
                    {data: 'to_site', name: 'to_site'},
                ]

            });

            $('#attachment').DataTable({
                ajax: {
                    url: '{{route("InventoryTransferRoll.show",$id)}}',
                    data: {type: 'attachment'}
                },

                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [

                    {data: 'title', name: 'attachments.title'},
                    {data: 'description', name: 'attachments.description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });

        });

    </script>


@endpush

