@extends('layouts.factor-master')

@section('content')

<?php
$report = customeReport('build');
$_date=in_array('date', $report);
$_build_number=in_array('build_number=', $report);
$_item_name=in_array('item_name', $report);
$_measure=in_array('measure', $report);
$_quantity=in_array('quantity', $report);
$_purchase_rate=in_array('purchase_rate', $report);
$_TotalExpense=in_array('_TotalExpense', $report);
$_from_site = in_array('from_site', $report);
$_to_site = in_array('to_site', $report);

?>

    <h4></h4>
	<h4 class="table-caption" style="text-align: center;">@lang('layout.InventoryTransferReport')</h4>
    <table class="main-table">
        <tr>
          @if($from_date)
          <td>
          <span>@lang('layout.FromDate')</span>:
          <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
        </td>
        @endif
        @if($to_date)
        <td>
          <span>@lang('layout.ToDate')</span>:
          <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
        </td>
        @endif
        @if($member_name)
        <td>
          <span>@lang('layout.CustomerName')</span>:
          <BDO>  {{$member_name}}  </BDO>
        </td>
        @endif
      </tr>
      </table>
      <br>
<table class="main-table">
    <thead>
    <tr>
      <th style="height: 10px"><div class="center"><b> #</b></div></th>
      <th style="height: 40px"><div class="center"><b> @lang('layout.Number')</b></div></th>
      <th style="height: 40px"><div class="center"><b> @lang('layout.Date')</b></div></th>
      <th style="height: 40px"><div class="center"><b> @lang('layout.Description')</b></div></th>
      <th style="height: 40px"><div class="center"><b> @lang('layout.WayBillNumber')</b></div></th>
      <th style="height: 40px"><div class="center"><b> @lang('layout.PlateNumber')</b> </div></th>
      <th style="height: 40px" ><div class="center"><b> @lang('layout.TotalQty')</b></div></th>
      <th style="height: 40px" ><div class="center"><b> @lang('layout.Driver')</b></div></th>
      @if(!$member_name)
      <th style="height: 30px"><div class="center"><b> @lang('layout.CustomerName')</b></div></th>
      @endif
      <th style="height: 30px"><div class="center"><b> @lang('layout.User')</b></div></th>
      <th style="height: 40px" ><div class="center"><b> @lang('layout.Item')</b></div></th>
    </tr>
    </thead>



    <?php
      $count = 0;
  
    ?>
    <tbody>
    @foreach($data AS $record)
    <?php
      $Item = $record['Item'];
    ?>
    <tr>
      <td class="center">{{++$count}}</td>
      <td  class="center">{{$record['number']}}</td>
      <td class="center">{{convertDate($record['Date'])}}</td>
      <td  class="center">{{$record['description']}}</td>
      <td  class="center">{{$record['way_bill_number']}}</td>
      <td  class="center">{{$record['plate_number']}}</td>
      <td  class="center">{{$record['total_bori']}}</td>
      <td  class="center">{{$record['Driver']}}</td>
      @if(!$member_name)
      <td  class="center">{{$record['cus_name']}}</td>
      @endif
      <td  class="center">{{$record['user']}}</td>
      
	  <td >
      <table class="main-table" style="width:100%">
        <tr class="bg">
            @if($_item_name)
                <td>
                    <div class="center"> @lang('layout.ItemName') </div>
                </td>@endif
                <td>
                    <div class="center"> @lang('layout.Code')</div>
                </td>
                @if(getOtherMeasure()=="true")
                <th>@lang('layout.OMeasureValue') 1</th>
                <th>@lang('layout.OMeasureValue') 2</th>
                @endif
            @if($_measure)
                <td>
                    <div class="center"> @lang('layout.Measure')</div>
                </td>@endif
            @if($_quantity)
                <td>
                    <div class="center"> @lang('layout.Quantity')</div>
                </td>
				<td>
                    <div class="center"> @lang('layout.Wing')</div>
                </td>
				@endif
                <td><div class="center"> @lang('layout.FromSite')</div></td>
                <td><div class="center"> @lang('layout.ToSite')</div></td>
        </tr>


		<?php
		$totalOut = 0;
		?>
	  @foreach($Item AS $row)
	  
		<tr>
			@if($_item_name)
				<td class="center">{{$row->ItemName}}</td>@endif
				<td class="center">{{$row->code}}</td>
                @if(getOtherMeasure()=="true")
				<td class="center">{{$row->other_measure_name}}</td>
				<td class="center">{{$row->other_measure_name2}}</td>
                @endif
			@if($_measure)
				<td class="center">{{$row->Measure}}</td>@endif
			@if($_quantity)
				<td class="center">{{$row->quantity}}</td>
				<td class="center">{{$row->khada}}</td>@endif
                <td class="center">{{$row->from_site}}</td>
                <td class="center">{{$row->to_site}}</td>
		</tr>
		
	  @endforeach
	  </table>
	  </td>
	  

    </tr>
    @endforeach

  </tbody>
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection