@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

    <style>
        .required {
            padding-left: 0px !important;
            color: red;
        }
    </style>
@stop
@section('content')
    <div class="row">
        <div class="portlet light bordered">
            <!-- BEGIN TAB PORTLET-->
            <div class="portlet light bordered sale">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-anchor font-green-sharp"></i>&nbsp;
                        <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.EditInventoryTransfer')</span>
                    </div>
                    <div class="actions">
                    </div>
                </div>
                <div id="app" class="portlet-body">

                    <div class="tabbable tabbable-tabdrop">


                        <div>
                            {{Form::open(['route'=>['InventoryTransferRoll.update',$transfer->id],'method'=>'PATCH','class'=>'form-horizontal','id'=>'transfer-form'])}}
                            {{ csrf_field() }}
                            <div class="tab-content">
                                <div class="tab-pane active" id="tab1">
                                    <div v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                        <!-- BEGIN FORM-->


                                        <div class="form-body">
                                                <!-- begin inputs -->
                                                <div class="row">
                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Number')</label>
                                                                <input type="text" name="number" value="{{$transfer->number}}" class="form-control">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Date')</label>

                                                                <input type="text" name="date"
                                                                       value="{{$transfer->Date}}"
                                                                       class="form-control date now" autocomplete="off">
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Description')</label>

                                                                <textarea name="description" class="form-control" rows="1">{{$transfer->description}}</textarea>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>
                                                <!-- end inputs -->
												
												<div class="row">
                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Driver')</label>
                                                                 <v-select label="name"  v-model="selected_driver"
                                                                      :options="driver">
                                                                  </v-select>
                                                                  <input type="hidden" name="driver_id" :value="(!selected_driver)?null:selected_driver.id">
                                                           
                                                            </div>
                                                        </div>
                                                    </div>  
                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.TotalQty')</label>
                                                                 <input type="text" name="total_bori" :value="subtotal" class="form-control" placeholder="@lang('layout.TotalQty')">
                                                           
                                                            </div>
                                                        </div>
                                                    </div>    
                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.WayBillNumber')</label>
                                                                 <input type="text" name="way_bill_number" value="{{$transfer->way_bill_number}}" class="form-control" placeholder="@lang('layout.WayBillNumber')">
                                                           
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-3 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Customer') </label>
                                                                <div class="input-group">
                                                                    <v-select label="name" @search="CustomerSearch" :options="customer" v-model="selected_customer"></v-select>
                                                                    <input type="hidden" name="customer_id"  data-vv-as="@lang('layout.Customer')" :value="!selected_customer?null:selected_customer.id">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.PlateNumber')</label>
                                                                 <input type="text" name="plate_number"  value="{{$transfer->plate_number}}" class="form-control" placeholder="@lang('layout.PlateNumber')">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                             <!-- End Driver And Other Info -->
                                             <input type="hidden" name="edit_sale" value="{{$edit_sale}}">
                                            
                                            <div class="row" style="overflow-x: scroll;">
                                                <table id="table_content" class="table table-bordered table-advance">
                                                    <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        @if(searchByCodeLocation()=="true")
                                                        <th style="min-width: 100px">@lang('layout.PartNumber') </th>
                                                        <th style="min-width: 100px;">@lang('layout.Location')</th>
                                                        <th style="min-width: 100px;">@lang('layout.ToLocation')</th>
                                                        @endif
                                                        <th style="min-width: 100px">@lang('layout.ItemName') </th>
                                                        <th style="min-width: 100px">@lang('layout.FromSite') </th>
                                                        <th style="min-width: 100px">@lang('layout.ToSite') </th>
                                                        @if(searchByCodeLocation()!="true")
                                                        <th style="min-width: 100px">@lang('layout.Code') </th>
                                                        @endif
                                                        <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                                        <th style="min-width: 50px"> @lang('layout.OnHand') @lang('layout.Code') </th>
                                                        <th style="min-width: 50px">@lang('layout.OnHand') </th>
                                                        <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                        <th v-show="showWhat('other_measure')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue1')</th>
                                                        <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue2')</th>
                                                        @if(getShowWing()!="false")
                                                        <th style="min-width: 50px">@lang('layout.Wing') </th>
                                                        @endif
                                                        <th></th>
                                                    </tr>
                                                    </thead>
													<tbody>
                                                    <tr v-for="(item,index) in inventories">
                                                        <td>@{{index+1}}</td>
                                                        @if(searchByCodeLocation()=="true")
                                                        <td class="highlight">
                                                            <v-select label="name" @click.native="addIndex(index), addNew('inventory',index), editKey = true" @input="(editKey)?(onItemLoadByCode(index)):''" v-model="(item==null)?null:item.code" :options="codeList" @search="onSearchCode" placeholder="@lang('layout.PartNumber')" ></v-select>
                                                            <input type="hidden" :name="'m_stocks_in_id['+index+']'" :value="(item==null)?null:((item.code==null)?null:item.code.id)">
                                                            <input type="hidden" :name="'main_stock_id['+index+']'" :value="(item==null)?null:((item.code==null)?null:item.code.main_stock_id)">
                                                        </td>
                                                        <td class="highlight">
                                                            <v-select label="name" @click.native="addIndex(index), addNew('inventory',index), editKey = true" @input="(editKey)?(onItemSearchLocation(index)):''" v-model="(item==null)?null:item.selectedLocation" :options="locationList" @search="onSearchLocation" placeholder="@lang('layout.Location')" ></v-select>
                                                            <input type="hidden" :value="(item==null)?null:((item.selectedLocation==null)?null:item.selectedLocation.name)">
                                                        </td>
                                                        <td>
                                                            <input :name="'to_location['+index+']'" type="text" v-model="(item==null)?null:item.to_location" class="form-control" placeholder="@lang('layout.ToLocation')">
                                                        </td>
                                                        @endif
                                                        <td class="highlight">
                                                            <v-select label="name" v-model="item.inventory"
                                                                      :options="temp_items"  @search="onItemSearch"
																	  @keyup.native="onItemLoadCode(index)"
                                                                      @click.native="onItemLoadCode(index)" :disabled = "item.update_data != 'yes' && edit_sale == 'yes'" ></v-select>
                                                            <input type="hidden" id="item_id"
                                                                   :name="'inventory_id['+index+']'"
                                                                   :value="(!item.item)?null:item.item.id">
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(item.item==null)?null:item.item.site" @click="onItemSearchCodeSelect(index)"
                                                                    class="form-control" :disabled = "item.update_data != 'yes' && edit_sale == 'yes'" >
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item != null)">
																  <option v-for="site in (item.item==null)?null:item.item.site_list"
																		  :value="site">
																	@{{site.site_name}}
																  </option> 
																</span>
                                                            </select>

                                                            <input type="hidden" id="inventory_site"
                                                                   :name="'from_site['+index+']'"
                                                                   :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">

                                                            <input type="hidden" :name="'update_data['+index+']'" :value="item.update_data">       
                                                            <input type="hidden" :name="'transfer_info_id['+index+']'" :value="item.transfer_info_id">       
                                                        </td>
														<td>
                                                          <span v-if="(item.item !=null)">
                                                            <select class="form-control input_style"
                                                                    placeholder="@lang('layout.ToSite')" required="required"
                                                                    v-model="!item.item?null:item.item.to_site" :disabled = "item.update_data != 'yes' && edit_sale == 'yes'" >

                                                            <option v-if="((item.item.site==null)?null:item.item.site.site_id) != si.id"
                                                                    v-for="si in site"
                                                                    :value="si.id">@{{si.name}}
                                                            </option>
                                                        </select>
                                                        </span>
                                                            <input type="hidden" :name="'to_site['+index+']'" :value="(!item.item)?null:(item.item.to_site)?item.item.to_site:null">
                                                        </td>
                                                        @if(searchByCodeLocation()!="true")
                                                        <td class="highlight">
                                                            <v-select label="name" @click.native="addIndex(index)"
                                                                      v-model="(item.item==null)?null:item.item.code"
                                                                      :options="subItems" @search="onItemSearchCode"
                                                                      placeholder="@lang('layout.Code')"
                                                                      :disabled = "item.update_data != 'yes' && edit_sale == 'yes'" ></v-select>
                                                            <input type="hidden" :name="'m_stocks_in_id['+index+']'"
                                                                   :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.id)">
                                                            <input type="hidden" :name="'main_stock_id['+index+']'"
                                                                   :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.main_stock_id)">
                                                        </td>
                                                        @endif
                                                        <td>
                                                            <input type="number" :name="'inventory_quantity['+index+']'"
                                                                   ref="qut_temp" @input="setNewRate(index)"
                                                                   :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.qut_temp)"
                                                                   class="form-control input-style input-number"
                                                                   placeholder="@lang('layout.Quantity')" :readonly = "item.update_data != 'yes' && edit_sale == 'yes'" >

                                                        </td>
                                                        <td>
                                                            @{{myRound((item.item==null)?null:((item.item.code==null)?null:item.item.code.OnHand))}}
                                                        </td>

                                                        <td>
                                                            @{{myRound((item.item==null)?null:saleItemQuantity(item.item))}}
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(item.item == null)?null:item.item.measure"
                                                                    class="form-control" @change="measureChange(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
																	  <option v-for="measure in (item.item==null)?null:item.item.measure_list"
																			  :value="measure">
																	  @{{measure.measure_name}}
																	</option> 
																  </span>
                                                            </select>

                                                            <input type="hidden" :name="'inventory_measure['+index+']'"
                                                                   :value="(item.item==null)?null:item.item.measure.measure_id">
                                                        </td>
                                                        <td v-show="showWhat('other_measure')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" :name="'other_measure['+index+']'"
                                                                class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue1')" v-model.number="(item.item==null)?null:item.item.other_measure">
                                                                <span class="input-group-addon">
                                                                    @{{myRound((item.item==null)?null:((item.item.code==null)?null:item.item.code.other_measure))}}
                                                                </span>
                                                            </div>
                                                        </td>
                                                        <td v-show="showWhat('other_measure2')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" :name="'other_measure2['+index+']'"
                                                                class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue2')" v-model.number="(item.item==null)?null:item.item.other_measure2">
                                                                <span class="input-group-addon">
                                                                    @{{myRound((item.item==null)?null:((item.item.code==null)?null:item.item.code.other_measure2))}}
                                                                </span>
                                                            </div>
                                                        </td>
                                                        @if(getShowWing()!="false")
                                                        <td>
                                                            <input :name="'khada['+index+']'" type="number" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.khada)" ref="khada" @input="setNewRate(index)"
                                                            oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.Wing')">
                                                        </td>
                                                        @endif
                                                        <td>
                                                            @if($edit_sale != 'yes')
                                                            <span v-if="inventories.length>1"
                                                                  v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                            @endif      
                                                        </td>
                                                    </tr>
                                                    <tr style="background-color: #ffffff;">
                                                        <td></td>
                                                        <td>
                                                            <center>
                                                            @if($edit_sale != 'yes')
                                                                <button type="button" @click="addNew('inventory',500)"
                                                                class="btn btn-success"><i class="fa fa-plus"></i></button>
                                                            @endif                
                                                            </center>
                                                        </td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                    </tr>

                                                    </tbody>
                                                </table>


                                            </div>


                                        </div>
                                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                            <button type="button" v-if="!isError" @click="handleSubmit($event)"
                                                    class="btn green">@lang('layout.Submit')</button>
                                        <!--   <button type="button" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button> -->

                                            <a href="{{route('inventoryTransfer.index')}}" class="btn default"><i
                                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                        </div>

                                        <cmodal :show='showModal' @close="showModal=false">

                                        </cmodal>
                                    </div>

                                </div>


                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                    <p> &nbsp; </p>
                    <p> &nbsp; </p>
                </div>
            </div>
            <!-- END TAB PORTLET-->
        </div>
    </div>
@endsection
@push('scripts')


    <script type="text/javascript">
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif



        Vue.component('v-select', VueSelect.VueSelect);


        var inventory_category = {!! $inventory_category !!};
        var site = {!! $site !!};
        var selected_item ={!! $selectedItem !!};
        var driver = {!! $driver !!};
        var v = new Vue({
            el: '#app',
            data: {
                showModal: false,
                temp_items: [],
                inventory_category: inventory_category,
                selected_iventory_category: null,
                selected_index: 0,
                selectedIndex: 0,
				subItems: [],
                codeList: [],
                locationList: [],
                driver: driver,
                selected_driver: {!!$selected_driver!!},
                edit_sale: "{{$edit_sale}}",
                customer: [],
                selected_customer: {!!$selectedCustomer!!},
                site: site,
                inventories: [],
                selected_item: selected_item,
                editKey: false,

            },
            computed: {
				
				// calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {		
                        if (this.inventories[i].item.code && this.inventories[i].item.code != null) {		
                            var quantity = this.inventories[i]['item']['code']['qut_temp'];
                            // var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            // var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if ( quantity > 0) {
                                sum += Number.parseFloat(quantity);
                            }
                        }
                        }
                    }
                    
                    return sum;
                },

                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;
                   

                    return isError;
                },

            },
            methods:
                {
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                v.submitForm(e.target);
                            }
                        });
                    },


                    // begin item search


                    //ajax call to get items
                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);
                        axios.get("{{route('callMethod.search')}}",
                            {

                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchNameRoll',
                                    keyword: search,
                                },
                            })
                            .then(function (response) {
                                v.temp_items = [];
                                v.subItems = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                    // console.log('pp',response.data);
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            });

                    }, getDebounceTime()),
					
					//ajax call to get items code
                    onItemLoadCode(selectedIndex) {
						v.selectedIndex = selectedIndex;
						
						if (v.inventories[selectedIndex].inventory != null) {
                            // console.log('klk',v.inventories[selectedIndex].inventory,v.main_inventories);
                            var inventory_id = v.inventories[selectedIndex].inventory.id;
                            // let inventory_category_id = (v.inventories[selectedIndex]['item_category'] != undefined) ? v.inventories[selectedIndex]['item_category'].id : '';

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchSaleRoll',
                                    inventory_id: inventory_id,
                                    // inventory_category_id: inventory_category_id,
                                }
                            })
                                .then(function (response) {
                                    v.inventories[selectedIndex].item = null;
                                    if (response.data.length > 0) {
                                        v.inventories[selectedIndex].item = response.data[0];
                                    // console.log('gg');
									
									v.onItemSearchCodeSelect(selectedIndex);
									
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                })
                        }
						
						
						
                    },

                    CustomerSearch: _.debounce((search, loading) => {
                        loading(true);
                        let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
                        
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                class_id: class_id,
                                type: 'Customer'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.customer = [];
                                v.customer = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),


                    //ajax call to get items code
                    onSearchCode: _.debounce((search, loading) => {
                        loading(true);
                        var selectedIndex = v.selectedIndex;
                        let inventory_brand_id = (v.inventories[selectedIndex]['selectedBrand'] != undefined) ? v.inventories[selectedIndex]['selectedBrand'].id : '';
                        let location = (v.inventories[selectedIndex]['selectedLocation'] != undefined) ? v.inventories[selectedIndex]['selectedLocation'].name : '';
                        let inventory_category_id = (v.inventories[selectedIndex]['item_category'] != undefined) ? v.inventories[selectedIndex]['item_category'].id : '';
                        let inventory_site = (v.inventories[selectedIndex]['item'] != undefined) ? ((v.inventories[selectedIndex]['item'].site != undefined) ? v.inventories[selectedIndex]['item']['site'].site_id : '') : '';
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'getAssebmliesSubSite',
                                keyword: search,
                                inventory_category_id: inventory_category_id,
                                brand_id: inventory_brand_id,
                                location: location,
                                inventory_site: inventory_site,
                            }
                        })
                        .then(function(response) {
                            // v.subItems = [];
                            if (response.data.length > 0) {
                                v.subItems[v.selectedIndex] = response.data;
                                v.subItemes = response.data;
                                v.codeList = response.data;
                                // console.log('subItems', v.subItems);
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                    }, getDebounceTime()),

                    //ajax call to get items
                    onItemLoadByCode(index) {
                        if (v.inventories[index].code != null) {
                            v.inventories[index].code.qut_temp = 0;
                            var inventory_id = v.inventories[index].code.inventory_id;
                            var brand_id = v.inventories[index].code.brand_id;
                            var stocks_in_id = v.inventories[index].code.id;
                            // console.log(33, stocks_in_id);
                            if (brand_id>0) {
                                v.inventories[index].selectedBrand = _.find(inventoryBrand, (o) => o.id == brand_id);
                            }
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchSaleRoll',
                                    inventory_id: inventory_id,
                                    stocks_in_id: stocks_in_id,
                                }
                            })
                            .then(function(response) {
                                // console.log("dddd",response.data)
                                v.inventories[index].item = null;

                                if (response.data.length > 0) {
                                    // console.log(34,response.data[0]);
                                    v.inventories[index].item = response.data[0];
                                    v.inventories[index].inventory = response.data[0];
                                    v.inventories[index].item.code = v.inventories[index].code;
                                    v.inventories[index].item.cost = response.data[0].code.cost;
                                    
                                    var site_id = v.inventories[index].code.site_id;
                                    var sites = response.data[0]['site_list'];
                                    for (let a = 0; a < sites.length; a++) {
                                        if(sites[a].site_id == site_id){
                                        v.inventories[index].item.site = sites[a];
                                        }
                                    }
                                    v.inventories[index].selectedLocation = response.data[0].selectedLocation;
                                    v.locationList = response.data[0].locationList;

                                    @if(ShowQuantityByWing() == "true")
                                    v.inventories[index].item.code.price_of_khada = response.data[0].price_of_khada;
                                    @endif

                                    // console.log('gg989', response.data[0],site_id,v.inventories[index].item.site);
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            });
                        }
                    },
                    // end item search

                    //ajax call to get items Location
                    onItemSearchLocation(selectedIndex) {
                        v.selectedIndex = selectedIndex;

                        if (v.inventories[selectedIndex].selectedLocation != null) {
                            let inventory_brand_id = (v.inventories[selectedIndex]['selectedBrand'] != undefined) ? v.inventories[selectedIndex]['selectedBrand'].id : '';
                            let location = (v.inventories[selectedIndex]['selectedLocation'] != undefined) ? v.inventories[selectedIndex]['selectedLocation'].name : '';
                            let inventory_category_id = (v.inventories[selectedIndex]['item_category'] != undefined) ? v.inventories[selectedIndex]['item_category'].id : '';
                            let item_id = (v.inventories[selectedIndex]['item'] != undefined) ? v.inventories[selectedIndex]['item'].id : '';
                            let code = (v.inventories[selectedIndex]['code'] != undefined) ? v.inventories[selectedIndex]['code'].code : '';
                            // console.log(32, code, item_id, location);
                            axios.get("{{route('callMethod.search')}}", {
                                    params: {
                                        method_name: 'getAssebmliesSubSite',
                                        brand_id: inventory_brand_id,
                                        location: location,
                                        item_id: item_id,
                                        code: code,
                                        inventory_category_id: inventory_category_id,
                                    }
                                })
                                .then(function(response) {
                                if (response.data.length > 0) {
                                    v.codeList = response.data;
                                    let clear = 3;
                                    let dataCode = null;
                                    if (response.data.length > 0) {
                                        for (var i = 0; i < response.data.length; i++) {
                                            if (response.data[i] && v.inventories[selectedIndex].code && v.inventories[selectedIndex].code != null) {
                                                if (clear != 1) {
                                                    if (v.inventories[selectedIndex].code.id == response.data[i].id) {
                                                        clear = 1;
                                                    } else if (clear != 1 && clear != 2 && location == response.data[i].location && v.inventories[selectedIndex].code.inventory_id == response.data[i].inventory_id) {
                                                        clear = 2;
                                                        dataCode=response.data[i];
                                                    }
                                                }
                                            }
                                        }
                                        if (clear == 2) {
                                            v.inventories[selectedIndex].code=dataCode;
                                        }
                                        if (clear == 3) {
                                            v.inventories[selectedIndex].code=null;
                                            v.inventories[selectedIndex].item=null;
                                            v.inventories[selectedIndex].inventory=null;
                                        }
                                        // console.log('subItems', response.data);
                                    }
                                } else {
                                    v.codeList = [];
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            });
                        }

                    },

                    //ajax call to get items code
                    onSearchLocation: _.debounce((search, loading) => {
                        loading(true);
                        var selectedIndex = v.selectedIndex;
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'getLocationList',
                                keyword: search,
                            }
                        })
                        .then(function(response) {
                            // console.log(response);
                            if (response.data) {
                                if (response.data.data.length > 0) {
                                    v.locationList = [];
                                    v.locationList = response.data.data;
                                }
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                    }, getDebounceTime()),
            
	
                    //ajax call to get items code
                    onItemSearchCode: _.debounce((search, loading) => {

                        // console.log('selectedIndex',v.selectedIndex);
                        item_id = v.inventories[v.selectedIndex].item.id;
						if(v.inventories[v.selectedIndex].item.site != null){
                        inventory_site = v.inventories[v.selectedIndex].item.site.site_id;
                        loading(true);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'getAssebmliesSubSite',
                                keyword: search,
                                item_id: item_id,
                                inventory_site: inventory_site,
                            }
                        })
                            .then(function (response) {
                                if (response.data.length > 0) {
                                v.subItems = [];
                                    v.subItems = response.data;
                                    console.log('subItems', v.subItems);
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
						}
                    }, getDebounceTime()),
					
                    //ajax call to get items code
                    onItemSearchCodeSelect(selectedIndex) {
						setTimeout(function(){
						
                        item_id = v.inventories[selectedIndex].item.id;
						if(v.inventories[selectedIndex].item.site != null){
                        inventory_site = v.inventories[selectedIndex].item.site.site_id;
                        // console.log('selectedIndex',selectedIndex,item_id,inventory_site);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'getAssebmliesSubSite',
                                item_id: item_id,
                                inventory_site: inventory_site,
                            }
                        })
                        .then(function (response) {
                            v.codeList = [];
                            v.inventories[selectedIndex].item.code = null;
                            v.inventories[selectedIndex].code = null;
                            v.inventories[selectedIndex].selectedLocation=null;
                            if (response.data.length > 0) {
                                v.inventories[selectedIndex].item.code=null;
                                v.subItems = response.data;
                                v.codeList = response.data;
                                
                                // console.log('subItemss', v.subItems);
                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
						}
						}, 400);
                    },
					
					setNewRate(index)
					{
						for(var i=0;i<this.inventories.length;i++)
						{
							if (this.inventories[i].item && this.inventories[i].item != null) {		
                                if (this.inventories[i].item.code && this.inventories[i].item.code != null) {
							        this.inventories[i].item.code.qut_temp = this.$refs.qut_temp[i].value;
							    }
                            }
						}

                        // console.log(33,index, this.inventories, this.inventories[index]);

                        @if(getShowWing()!="false")
                        if (this.inventories[index].item && this.inventories[index].item != null) {
                            if (this.inventories[index].item.code && this.inventories[index].item.code != null) {
                                this.inventories[index].item.code.khada = this.$refs.khada[index].value;
                            }
                        }
                        @endif
					},

					// delete item from list
                    addIndex(index) {
                        // v.subItems = [];
                        v.selectedIndex = index;
                    },
					
					
					//ajax call to get items
                    setIndex(e) {
                        //v.temp_items=[];
                        this.selected_index = e;
                    },
                    itemCategoryChange(index) {
                        v.setIndex(index);
                        v.selected_iventory_category = this.inventories[this.selected_index]['item_category'];
                        if (this.inventories[this.selected_index]['item_category'] != null) {
                            let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemesSearchSale',
                                    inventory_category_id: inventory_category_id
                                }
                            })
                                .then(function (response) {
                                    v.temp_items = [];
                                    if (response.data.length > 0) {
                                        v.temp_items = response.data;
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });
                        }

                    },

                    // end item search

                    // contract search


                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.temp_items = [];
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({
                                        inventory: null,
                                        item: null,
                                        update_data: null,
                                        transfer_info_id: null,
                                        item_category: this.selected_iventory_category,
                                        code: null, to_location: null, selectedLocation: null
                                    });
                                }
                            }


                        }

                    },

                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }

                        }

                    },
                    // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("transfer-form").submit()

                            }
                            else {

                            }
                        });

                    },
                    defaultValue() {
                        this.selected_index = 0;

                        this.inventories = [
                            {item: null, item_category: this.selected_iventory_category},
                        ];

                        this.temp_items = [];

                    },
                    saveAndNew() {
                        this.$validator.validate()
                            .then(valid => {
                                if (valid) {

                                    var url = "{{route('inventoryTransfer.store')}}";
                                    form_id = 'transfer-form';
                                    var data = $('#' + form_id).serialize();

                                    axios.post(url, data)
                                        .then(function (response) {
                                            if (response.data.result == 1) {
                                                $('#' + form_id).trigger('reset');
                                                toastr.success('', response.data.message);

                                                v.defaultValue();
                                            }
                                            else {
                                                var message = "{{__('message.Warning')}}";
                                                //$('#error-sound')[0].play();
                                                toastr.warning('', message);
                                            }
                                        })
                                        .catch(function (error) {
                                            console.log(error);
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        });

                                }
                            })
                    },
                },
            mounted: function () {
                for (var i = 0; i < this.selected_item.length; i++) {
                    
                    this.inventories.push({
                        inventory: this.selected_item[i],
                        item: this.selected_item[i],
                        update_data: this.selected_item[i].update_data,
                        transfer_info_id: this.selected_item[i].inventory_transfer_info_id,
                        item_category: this.selected_item[i].item_category,
                        code: this.selected_item[i].code, to_location: this.selected_item[i].to_location, 
                        locationList: this.selected_item[i].locationList, selectedLocation: this.selected_item[i].selectedLocation
                    });
                }
                @if($edit_sale != 'yes')
                this.inventories.push({inventory: null, item: null, item_category: null, update_data: null, transfer_info_id: null, code: null, to_location: null, selectedLocation: null});
                @endif    
                
            }

        });

    </script>


@endpush