@extends('layouts.app')
@section('content')


    <!-- END PAGE HEADER-->

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.InventoryTransferslist')</span>
                </div>
                <div class="tools"></div>
                <div class="btn-group pull-right">
                    <a href="{{route('inventoryTransfer.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="InventoryTransfer">
                    <thead>
                    <tr>
                      {{--  <th>@lang('layout.ID')</th>--}}
                        <th>@lang('layout.FromSite')</th>
                        <th>@lang('layout.ToSite')</th>
                        <th>@lang('layout.Item')</th>
                        <th>@lang('layout.Quantity')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>

    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->

@stop

@push('scripts')

    <script>
        $(document).ready(function () {
            $('#InventoryTransfer').DataTable({
                ajax: '{{route("inventoryTransfer.index")}}',
                pageLength: '{{getPageRows()}}',
                // scrollY:        450,
                scrollCollapse: true,
                // serverSide: true,
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                   /* {data: 'id', name: 'id'},*/
                    {data: 'from_site', name: 'from_site'},
                    {data: 'to_site', name: 'to_site'},
                    {data: 'Item', name: 'Item'},
                    {data: 'quantity', name: 'quantity'},
                    {data: 'Date', name: 'Date'},
                    {data: 'action', name: 'action'},
                ]
            });
        });

    </script>


@endpush
