@extends('layouts.app')
@section('content')
@section('style')
    <link rel="stylesheet" href="{{url('/vue/v-autocomplete.css')}}">
    <link rel="stylesheet" href="{{url('/vue/style.css')}}">
    <style>
        .dashboard-stat2 {
            padding: 0;
        }

        .totals tr td {
            padding: 6px;
        }

        .table {
            margin-bottom: 0px;
        }

        .table tbody tr td {
            padding: 0px;
            vertical-align: middle;
        }

        table {
            border-collapse: collapse;
            border-spacing: 0;
            width: 100%;
            border: 1px solid #ddd;
        }

        th, td {
            text-align: left;
            padding-bottom: 0px;
        }

        tr {
            border-bottom: 1px solid #ddd;
        }

        tr:nth-child(even) {

            background-color: #f2f2f2
        }

        [v-cloak] {
            display: none;
        }

        .row-height {
            height: 55px;
        }

        .v-autocomplete .v-autocomplete-input-group .v-autocomplete-input {
            padding: 5px 15px;
        }

        .v-autocomplete-list {
            z-index: 200;
        }

        .v-autocomplete .v-autocomplete-list {
            position: absolute;

            width: 200px;
        }

        .dashboard-stat2 {
            padding-bottom: 0;
        }

        .dashboard-tabel td {
            padding: 0 4px;

        }

        .badge3 {
            font-size: 18px !important;
            height: 30px;
            color: #fff;
            padding: 3px 6px;
        }

        .paddint-both {
            padding: 5px;
        }

        .paddint-both:hover {
            color: red;
        }

        #InventoryTransfers tr th {
            text-align: center;
            padding: 10px;
            background-color: #36c6d3;
            color: white;
        }
    </style>
@stop
<style type="text/css">


</style>
<div class="row">

    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>
                <span class="caption-subject font-green-haze bold uppercase"> @lang('layout.NewInventoryTransfer') </span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">
                <a href="" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                <a href="" class="reload" data-original-title="" title=""> </a>
                <a href="" class="remove" data-original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;">
            <!-- BEGIN FORM-->
            {!! Form::open(array('route' => 'inventoryTransfer.store','method'=>'POST','class'=>'horizontal-form')) !!}
            {{ csrf_field() }}
            <div class="form-body">
                <div class="row" id="newrow" v-cloak>
                    <table class="table table-hover" id="InventoryTransfers">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th class="text-center"> @lang('layout.Item') </th>
                            <th class="text-center"> @lang('layout.Quantity') </th>
                            <th class="text-center"> @lang('layout.FromSite') </th>
                            <th class="text-center"> @lang('layout.ToSite') </th>
                            <th class="text-center"> @lang('layout.MeasureUint') </th>
                            <th class="text-center"> @lang('layout.Quantity') </th>
                            <th class="text-center"></th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr v-for=" (row,itemIndex) in rows">
                            <td><span class="badge badge3 badge-success badge-roundless"> @{{itemIndex+1}} </span>
                            </td>
                            <td>
                                <!-- <div class="input-group"> -->
                                <select class="form-control"
                                        v-model="row.selectedItem" v-on:focus="addrow(itemIndex)">
                                    <option disabled value="">Select Employee</option>
                                    <option v-for="ite in item"
                                            :value='ite'>@{{ ite.name }}
                                    </option>
                                </select>
                                <input v-if="row.selectedItem" type="hidden" name="item[]" :value="row.selectedItem.id">

                                <!-- <v-select v-model="selectedItem"
                                :rows="rows" :item="item" @increment="addrow(itemIndex)">


                            </v-select> -->
                                <!-- <span class="input-group-addon">@{{(selectedItem)?selectedItem.qut_in:null}}</span>
                                </div> -->
                            </td>
                            <td class="col-md-1">

                                <input type="text"
                                       :value="(row.selectedItem)?( row.selectedItem.onHand-row.quantity):null"
                                       class="form-control" disabled name="qut[]">

                            </td>
                            <td>
                                {{Form::select('from_site[]',$site,null,['class' => 'form-control','placeholder' => __('layout.FromSite')])}}
                            </td>
                            <td>
                                {{Form::select('to_site[]',$site,null,['class' => 'form-control','placeholder' => __('layout.ToSite')])}}
                            </td>

                            <td>
                                <select class="form-control input-sm" v-on:change="convertMeasure(itemIndex)"
                                        v-model="!row.selectedItem?null:row.selectedItem.measure" required="required"
                                        placeholder="Measure"
                                        style="min-width: 120px">

                                    <option v-if="row.selectedItem"
                                            v-for="measureList in (!row.selectedItem?null:row.selectedItem.um)"
                                            :value="measureList">@{{measureList.name}}
                                    </option>
                                </select>

                                <input v-if="row.selectedItem" type="hidden" name="measure[]"
                                       v-bind:value="row.selectedItem.measure.id">

                            <td>
                                <input type="number" class="form-control" v-model="row.quantity" name="quantity[]">
                                <!-- <input type="hidden" name="q" :value="(row.quantity)?input_qut += row.quantity: input_qut"> -->
                            </td>
                            <td class="text-center">
                                <span span v-if="rows.length >1 " v-on:click="deleteRow(itemIndex)"><i
                                            class="paddint-both fa fa-trash"></i></span>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <div class="form-section"></div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="submit" class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('inventoryTransfer.index')}}" class="btn default"><i class="fa fa-mail-reply"></i>
                        Cancel</a>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
    @endsection


    @push('scripts')
        <script src="{{url('vue/accounting.min.js')}}"></script>
        <script src="{{url('vue/Sortable.js')}}"></script>
        <script src="{{url('vue/select2/vue-select@2.2.0.js')}}"></script>
        <script>
            Vue.component('v-select', {
                props: ['selectedItem', 'rows', 'item'],
                inheritAttrs: false,
                template: `<select v-bind="$attrs" v-bind:selectedItem="selectedItem" v-on:input="$emit('input', $event.target.selectedItem)"  class="form-control" v-on:focus="increment">
                <option disabled value="">Select Employee</option>
                <option v-for="ite in item" :value='ite'>
                @{{ ite.name }}
                </option>
                </select>`,
                methods: {
                    increment() {

                        this.$emit('increment');
                        // this.$emit('test',this.counter);
                    }
                }
            });
            new Vue({
                el: '#newrow',
                data: {
                    item:{!! $items !!},
                    // selectedItem:null,
                    default_quantity: 0,
                    input_qut: 0,
                    cost: null,

                    rows: [
                        {
                            quantity: null,
                            selectedItem: null
                        },
                        {
                            quantity: null,
                            selectedItem: null
                        },
                    ],
                },
                computed: {
                    // subtotal: function () {
                    //      var sum = 0;
                    //      for (var i = 0; i < this.rows.length; i++) {
                    //              sum += (parseInt(this.rows[i].weight))?parseInt(this.rows[i].weight):0
                    //      }
                    //      return sum;
                    //  },
                },
                methods: {
                    onComplete: function () {
                        document.getElementById("account-form").submit()
//                this.$emit('on-complete')
//                alert('Yay. Done!');
                    },
                    addrow(index) {

                        if ((this.rows.length - 1) == index) {
                            this.rows.push({quantity: null, selectedItem: null});
                        }
                    },
                    deleteRow: function (index) {
                        this.rows.splice(index, 1)
                    },
                    convertMeasure(index) {

                        var row = this.rows[index];
                        console.log('okjlkj', row.selectedItem);
                        if (row.selectedItem != null) {

                            row.selectedItem.onHand = ((row.selectedItem.dunint * row.selectedItem.dqty) / row.selectedItem.measure.unit);

                        }
                    },

                }
            });

        </script>


@endpush