@extends('layouts.app')
@section('content')
@section('style')
@stop
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewInventorySite')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                  
                </div>
                
            
            </div>


            <div class="portlet-body form" style="margin-bottom:50%;" id="inventory-site">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'inventorySite.store','method'=>'POST','class'=>'form-horizontal','id'=>'inventory-site-form')) !!}
                {{ csrf_field() }} 
                    <div class="form-body">
                        @if(getStockInfo()=="true")
                        <div class="col-md-7"> 
                        @else
                        <div class="col-md-9">
                        @endif 
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.SiteName'):</label>
                                <div class="col-md-9">
                                    {{Form::text('name',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.SiteName'),'placeholder' => __('layout.SiteName')])}}
                                    <span class="required">@{{ errors.first('name') }}</span>
                                </div>
                            </div> 
                             <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.ParentID'):</label>
                                <div class="col-md-9">
                                    {{Form::select('parent',$parent,null,['class' => 'form-control','placeholder' => __('layout.SelectParent')])}}
                                </div>
                            </div> 
                             <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Description'):</label>
                                <div class="col-md-9">
                                  {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 6, 'cols' => 30)) !!}
                                    
                                </div>
                            </div>
                        </div>   
                        @if(getStockInfo()=="true")
                        <div class="col-md-5">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Number'):</label>
                                 <div class="col-md-9">
                                    <input type="number" name="number" class="form-control"  v-model="number">
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.SiteOtherName'):</label>
                                 <div class="col-md-9">
                                    <input type="text" name="other_name" class="form-control"  placeholder="@lang('layout.SiteOtherName')">
                                </div>
                            </div> 

                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.StockManName'):</label>
                                <div class="col-md-9">
                                    {{Form::text('stock_man_name',null,['class' => 'form-control','placeholder' => __('layout.StockManName')])}}
                                </div>
                            </div> 
                             <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.StockManPhone'):</label>
                                 <div class="col-md-9">
                                    {{Form::text('stock_man_phone',null,['class' => 'form-control','placeholder' => __('layout.StockManPhone')])}}
                                </div>
                            </div>    
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.StockAddress'):</label>
                                 <div class="col-md-9">
                                    {{Form::text('stock_address',null,['class' => 'form-control','placeholder' => __('layout.StockAddress')])}}
                                </div>
                            </div>  

                            

                           
                        </div>  
                        @endif
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                        <button @click="handleSubmit($event)" type="button" class="btn green">@lang('layout.Submit')</button>
                         <button type="button" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
             
                        <a href="{{route('inventorySite.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                     </div>  
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div>

@endsection

@push('scripts')
    
    <script>
            
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    let vu = new Vue({
        el: '#inventory-site',
        data:{
            number: "{{$number}}",
            old_number: "{{$number}}"
        },
        methods:{
            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        // alert(e.target);
                        regForm(e.target);
                    }
                });
            },
            saveAndNew()
            {
                 this.$validator.validate()
                .then(valid =>{
                    if(valid)
                    {
                        
                      // saveAndNew('inventory-site-form',"{{route('inventorySite.store')}}")

                      var url = "{{route('inventorySite.store')}}";
                                form_id = 'inventory-site-form';
                                var data = $('#' + form_id).serialize();
                                toggleBlock(true);
                                axios.post(url, data)
                                    .then(function (response) {
                                        toggleBlock(0);
                                        if (response.data.result == 1) {
                                            $('#' + form_id).trigger('reset');
                                            toastr.success('', response.data.message);
                                            vu.number = Number(vu.old_number) + 1;
                                            vu.old_number = Number(vu.old_number) + 1;

                                            location.reload();
                                        }
                                        else {
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        }
                                    })
                                    .catch(function (error) {
                                        toggleBlock(0);
                                        console.log(error);
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    });
                    }
                })
            }
        }
    })
    </script>
@endpush
