
@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReportNew('inventory_site_index');
// dd($report, $report_percent);
$_description= !in_array('description', $report);
$_name= !in_array('name', $report);
$_parent= !in_array('parent', $report);
$_created_at= !in_array('created_at', $report);
$_updated_at= !in_array('updated_at', $report);

$report_percent = customeReportNewPercent('inventory_site_index');
$_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
$_name_percent= (array_key_exists('name___percent', $report_percent))?$report_percent['name___percent']:null;
$_parent_percent= (array_key_exists('parent___percent', $report_percent))?$report_percent['parent___percent']:null;
$_created_at_percent= (array_key_exists('created_at___percent', $report_percent))?$report_percent['created_at___percent']:null;
$_updated_at_percent= (array_key_exists('updated_at___percent', $report_percent))?$report_percent['updated_at___percent']:null;

// dd($_description_percent, $_description);
?>
      <h3 class="table-caption" style="text-align: center;">@lang('layout.InventorySiteReport')</h3>
  <table width="100%" class="report-table">
 
  <tr class="bg" >
   <th> @lang('layout.Record')</th>
   @if(getStockInfo()=="true")
   <th> @lang('layout.Number') </th>
   @endif
   @if($_created_at)<th @if($_created_at_percent) width="{{$_created_at_percent}}%" @endif> @lang('layout.CreatedAt')</th>@endif
   @if($_updated_at)<th @if($_updated_at_percent) width="{{$_updated_at_percent}}%" @endif> @lang('layout.UpdatedAt')</th>@endif
    @if($_description)<th @if($_description_percent) width="{{$_description_percent}}%" @endif> @lang('layout.Description')</th>@endif
    @if($_name)<th @if($_name_percent) width="{{$_name_percent}}%" @endif> @lang('layout.Name') </th>@endif

    @if($_parent)<th @if($_parent_percent) width="{{$_parent_percent}}%" @endif> @lang('layout.Parent')</th>@endif
 
     @if(getStockInfo()=="true")
        <th>@lang('layout.SiteOtherName')</th>
        <th>@lang('layout.StockManName')</th>
        <th>@lang('layout.StockManPhone')</th>
        <th>@lang('layout.StockAddress')</th>
    @endif
 </tr>
 <?php
 $count = 0;
 ?>
 @foreach($data AS $record)
 <tr>
 <td class="center">{{++$count}}</td>
 @if(getStockInfo()=="true")
 <td  class="center">{{$record->number}}</td>
 @endif

 @if($_created_at)<td class="center">

    {{convertDate($record->created_at)}}
   
   </td>@endif
   @if($_updated_at)<td class="center">
   
    {{convertDate($record->updated_at)}}
   
   </td>@endif
  @if($_description)<td  class="center" style="@if($_description_percent) text-align: justify; @endif">{{$record->description}}</td>@endif
  @if($_name)<td  class="center">{{$record->name}}</td>@endif

 @if($_parent)<td class="center">{{$record->Parent}}</td>@endif
 
 @if(getStockInfo()=="true")
<td class="center">{{$record->other_name}}</td>
<td class="center">{{$record->stock_man_name}}</td>
<td class="center">{{$record->stock_man_phone}}</td>
<td class="center">{{$record->stock_address}}</td>
 @endif
</tr>
  @endforeach  
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection
