@extends('layouts.app')

@section('content')
    <div class="row">
    
    </div>

    <!-- BEGIN TAB PORTLET-->
<div class="row">
  <!-- BEGIN EXAMPLE TABLE PORTLET-->
  <div class="portlet light bordered">
    <div class="portlet-title">
      <div class="caption font-dark">
        <i class="icon-settings font-dark"></i>
        <span class="caption-subject bold uppercase">  @lang('layout.TransportList')  </span>
      </div>
      <div class="tools"> </div>
      <div class="pull-right">
               
                @permission('transport-list')
                <a href="{{route('inventoryReceive.create')}}">
                    <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                    <button id="sample_editable_1_new" class="btn btn-success">
                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button>
                </a>
                @endpermission 
            </div>
  
      </div>
      <div class="portlet-body">
        <table class="table table-striped table-bordered table-hover" id="transport">
          <thead>
            <tr>
             {{-- <th>@lang('layout.ID')</th>--}}
              <th>@lang('layout.Name')</th>
              <th>@lang('layout.Fname')</th>
              <th>@lang('layout.Phone')</th>
              <th>@lang('layout.TazkeraNumber')</th>
              <th>@lang('layout.PlateNumber')</th>
              <th>@lang('layout.Type')</th>
              <th>@lang('layout.Actions')</th>
            </tr>
          </thead>
        </table>
      </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
  </div>


  <!-- END TAB PORTLET-->
  <iframe id="payframe" style="display: none;" ></iframe>
  <!-- END CONTENT BODY -->
  @stop

  @push('scripts')

  <script>


   $(document).ready(function() {
    $('#transport').DataTable( {
      ajax:'{{route("transport.index")}}',
      pageLength:'{{getPageRows()}}',
      scrollCollapse: true,
      paging:         true,
      serverSide: true,
      columns: [
     /* { data: 'id',                    name: 'id' },*/
      { data: 'name',                  name: 'users.name' },
      { data: 'fname',                 name: 'fname' },
      { data: 'phone',                 name: 'phone',orderable:false,searchable:false },
      { data: 'tazkira_number',        name: 'tazkira_number',orderable:false,searchable:false },
      { data: 'plate_number',         name: 'plate_number',orderable:false,searchable:false },
      { data: 'type',                  name: 'type',orderable:false,searchable:false },
      { data: 'actions',               name: 'actions',orderable:false,searchable:false },
      ]
    });
  });


 </script>
 @endpush