@extends('layouts.app')
@section('content')


    <!-- END PAGE HEADER-->

    <!-- BEGIN TAB PORTLET-->


    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title" id="backbtn">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.ListInventoryMinMax')</span>
                </div>
                <div class="tools"></div>
                <div class="btn-group pull-right">

                    @permission('openingInventory-export')
                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="openingInventory"/>
                    <button type="submit" id="sample_editable_1_new" class="btn btn-success"><i
                                class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="openingInventory"/>
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF')
                    </button>
                    {{Form::close()}}
                    @endpermission
                   


                    @if($inventoryMinMax_check)
                    @permission('inventory-create')
                    <div class="ui-group-buttons">
                    <a href="{{route('inventoryMinMax.edit',$inventory->id)}}">
                        <button class="btn btn-primary">
                            <i class="fa fa-pencil"></i>
                        </button>
                    </a>
                    <form action="{{route('inventoryMinMax.destroy',$inventory->id)}}" method="post">
                        {{csrf_field()}}
                        {{method_field('DELETE')}}
                        <button class="btn red" >
                            <i class="fa fa-times"></i>
                        </button>
                    </form>
                </div>
                    @endpermission
                    @else
                     @permission('inventory-create')
                    <a href="{{route('inventoryMinMax.create',$inventory->id)}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission   

                    @endif

                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="inventoryMinMax">
                    <thead>
                    <tr>
                        <th>@lang('layout.InventorySite')</th>
                        <th>@lang('layout.Min')</th>
                        <th>@lang('layout.Max')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>

    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->

@stop

@push('scripts')

    <script>

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#inventoryMinMax').DataTable({
                ajax: '{{route("inventoryMinMax.index",["id"=>$inventory->id])}}',
                pageLength: '{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                 pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'site', name: 'site'},
                    {data: 'itemMin', name: 'itemMin'},
                    {data: 'itemMax', name: 'itemMax'}
                ]
            });
        });
    </script>


@endpush