@extends('layouts.app')
@section('content')
@section('style')
@stop
<div class="row">
    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateInventoryMinMax')</span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools"></div>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;" id="inventory_min_max">
            <!-- BEGIN FORM-->
            {!! Form::open(array('route' => 'inventoryMinMax.store','method'=>'POST','class'=>'form-horizontal')) !!}
            {{ csrf_field() }}
            <input type="hidden" name="item_id" value="{{$inventory->id}}">
            <div class="form-body">
                <div class="row" style="margin-bottom: 20px; padding: 10px;">
                    <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
                        <div class="row" style="padding: 0.5% 1%;">
                            <div class="col-lg-12 margin-bottom-20">
                                <div class="col-md-4">
                                    <div class="">
                                        <label class="control-label"> @lang('layout.ItemName')</label>
                                        {{Form::text('name',$inventory->name,['class' => 'form-control','placeholder' => __('layout.EnterItemName'),'readonly'])}}
                                        {{--<span class="help-block"> This is inline help </span>--}}
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="">
                                        <label class="control-label">@lang('layout.ItemCode'):</label>
                                        {{Form::number('number',$inventory->number,['class' => 'form-control','min' =>'0' ,'placeholder' => __('layout.ItemCode'),'readonly'])}}
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="">
                                        <label class="control-label">@lang('layout.Unit')</label>
                                        <v-select :disabled="true" placeholder="@lang('layout.SelectUnitMeasure') " label="name"
                                        :options="measureList" v-model="measureSelected"></v-select>
                                        <input type="hidden" name="um_id" :value="(measureSelected)?measureSelected.id:null">
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
                                <div style="height: 200px; overflow:scroll; overflow-x: hidden;">
                                    <span v-for="site in sites" style="display: flex;gap: 20px;">
                                        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-4" style="margin-right: 5px;">
                                            <div class="form-group">
                                                <input type="hidden" name="site_id[]" :value="site.id">
                                                <input type="text" :value="site.name" disabled class='form-control'>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-4">
                                            <div class="form-group">
                                                <input name="min[]" type="number" class="form-control"
                                                placeholder="@lang('layout.Min')" >
                                            </div>
                                        </div>  
                                        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-4" style="margin-left: 5px;">
                                            <div class="form-group">
                                                <input name="max[]" type="number" class="form-control" placeholder="@lang('layout.Max')">
                                            </div>
                                        </div>
                                    </span>
            
                                </div>
                            </div>
                        </div>
                    </div>       
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center">
                <button @click="handleSubmit($event)" type="button" class="btn green">@lang('layout.Submit')</button>
                <a href="{{route('inventoryMinMax.index',['id'=>$inventory->id])}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                <hr>
            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>

@endsection

@push('scripts')

    <script>

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect)
        let vu = new Vue({
            el: '#inventory_min_max',
            data: {
                sites:{!! json_encode($site) !!},
                measureList:{!! json_encode($measure) !!},
                measureSelected: null
            },
            
            mounted: function () {
                console.log(this.sites);
                this.measureSelected = _.find(this.measureList, (o) => o.id == {{$inventory->um_id}});

            },
            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid ) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
            }
        })
    </script>
@endpush
