@extends('layouts.app')
@section('content')
    <div class="row">
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.UpdateInventoryCategory')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;">
                {!! Form::model($inventoryCategory, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['inventoryCategory.update',$inventoryCategory->id], 'files'=> true]) !!}
                    <div class="form-body">
                        <h4 class="text-center text-danger" style="margin-bottom: 30px;">!  @lang('message.OnlyUseTheSaveFunctionWhenUploadingPhotosToTheForm')</h4>
                        <div class="col-md-9"> 
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.CategoryName'):</label>
                                <div class="col-md-9">
                                    {{Form::text('name',null,['class' => 'form-control'])}}
                                </div>
                            </div> 
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.ParentID'):</label>
                                <div class="col-md-9">
                                    {{Form::select('parent_id',$parent,null,['class' => 'form-control','placeholder' => __('layout.SelectParent')])}}
                                </div>
                            </div> 
                            {{-- <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Photo'):</label>
                                <div style="width: 50%;margin: auto auto">
                                    <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                                        <div style="margin-top: 5px">
                                            <span class="btn default btn-file">
                                                <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                <span class="fileinput-exists">@lang('layout.Change')</span>
                                                <input type="hidden" value="" name=""><input type="file" name="image"> </span>        
                                            <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                        </div>
                                        <div class="fileinput-new thumbnail" style="width: 100%; height: 100px;">
                                            <img src="" alt=""> </div>
                                        <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 100px; line-height: 10px;"> </div>
                                    </div>
                                    {!! Form::file('image', null, array('placeholder' => 'photo','class' => 'form-control')) !!}
                                </div>
                            </div> --}}
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Photo')</label>
                                <?php
                                    $photo = null;
                                    if($inventoryCategory && $inventoryCategory->image!=null)
                                    {
                                        $photo =  $inventoryCategory->image;
                                    }
                                ?>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="fileinput fileinput-new" data-provides="fileinput"> 
                                            <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                <img src="{!!url('/uploads/itemCategory/'.$photo)!!}" alt=""/>
                                            </div>
                                            <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px;"></div>
                                            <div>
                                                <span class="btn default btn-file">
                                                    <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                                    <!-- <input type="file" name="photo">  -->
                                                    {!! Form::file('image', []) !!}
                                                </span>
                                                {!! Form::hidden('image1', (!$inventoryCategory)?null:$inventoryCategory->image) !!}
                                                <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput">@lang('layout.Remove')</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Description'):</label>
                                <div class="col-md-9">
                                  {!! Form::textarea('description', null, array('placeholder' => __("layout.Description"),'class' => 'form-control','rows' => 6, 'cols' => 30)) !!}
                                </div>
                            </div>
                        </div>  
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                        <button href="{{url('inventorySite.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</button>
                    </div>  
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 
@endsection
