@extends('layouts.app')
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewInventoryCategory') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="inventory-category">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'inventoryCategory.store','method'=>'POST','class'=>'form-horizontal','id'=>'inventory-category-form','files'=> true)) !!}
                {{ csrf_field() }} 
                    <div class="form-body">
                        <h4 class="text-center text-danger" style="margin-bottom: 30px;">!  @lang('message.OnlyUseTheSaveFunctionWhenUploadingPhotosToTheForm')</h4>
                        <div class="col-md-9"> 
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.CategoryName'):</label>
                                <div class="col-md-9">
                                    {{Form::text('name',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.CategoryName'),'placeholder' => __('layout.CategoryName')])}}
                                     <span class="required">@{{ errors.first('name') }}</span>
                                </div>
                            </div> 
                             <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.ParentID'):</label>
                                <div class="col-md-9">
                                    {{Form::select('parent',$parent,Null,['class' => 'form-control','placeholder' => __('layout.SelectParent')])}}
                                </div>
                            </div> 
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Photo'):</label>
                                <div style="width: 50%;margin: auto auto">
                                    <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                                        <div style="margin-top: 5px">
                                            <span class="btn default btn-file">
                                                <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                <span class="fileinput-exists">@lang('layout.Change')</span>
                                                <input type="hidden" value="" name=""><input type="file" name="image"> </span>        
                                            <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                        </div>
                                        <div class="fileinput-new thumbnail" style="width: 100%; height: 100px;">
                                            <img src="" alt=""> </div>
                                        <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 100px; line-height: 10px;"> </div>
                                    </div>
                                    {{-- {!! Form::file('image', null, array('placeholder' => 'photo','class' => 'form-control')) !!} --}}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Description'):</label>
                                <div class="col-md-9">
                                  {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 6, 'cols' => 30)) !!}
                                </div>
                            </div>
                            <!--   <div>
                                <input type="text" name="" class="form-control" @keyup.enter="handleSubmit($event)">
                            </div> -->
                        </div>  
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" @click="handleSubmit($event)"  class="btn green">@lang('layout.Submit')</button>
                        <button type="button" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                        <a href="{{route('inventoryCategory.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                   
                    </div>  
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div> 
@endsection
@push('scripts')
<script>
   /**
     * for creating shortcuts
     */
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif
    let vu = new Vue({
        el: '#inventory-category',
        data:{
        },
        methods:{
            handleSubmit(e)
            {
                this.$validator.validate()
                .then(valid =>{
                    if(valid)
                    {
                        
                    regForm(e.target);
                    }
                })
            },
            alertfun()
            {
                alert('ok');
            },
            saveAndNew()
            {
                 this.$validator.validate()
                .then(valid =>{
                    if(valid)
                    {
                        
                      saveAndNew('inventory-category-form',"{{route('inventoryCategory.store')}}")
                    }
                })
            }
        }
    })
</script>
@endpush