@extends('layouts.app')
@section('content')
<!-- END PAGE HEADER-->
<!-- BEGIN TAB PORTLET-->
<div class="row">

    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.InventoryBrandList')</span>
            </div>
            <div class="tools"> </div> 
             <div class="btn-group pull-right">
                    
                    @permission('inventoryBrand-export')

                    <span id="print-modal">
                        <a href="#" @click.prevent="is_show_modal = !is_show_modal" class="btn  btn-success">
                             <i class="fa fa-print"></i>
                        </a>

                        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                         v-if="is_show_modal" 
                            :value-type="'inventoryBrand'"
                            @closed="closeModal">
                        </report-modal>
                    </span>
                    @endpermission
                    @permission('inventoryBrand-create')  
                    <a href="{{route('inventoryBrand.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                         </button>
                    </a>
                    @endpermission 
                </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" cellspacing="0" id="inventoryBrand">
                <thead>
                <tr> 
                   {{-- <th>@lang('layout.ID')</th>--}}
                    <th>@lang('layout.Name')</th>
                    <th>@lang('layout.Parent')</th>
                    <th>@lang('layout.Description')</th>
                    <th>@lang('layout.CreatedAt')</th>
                    <th>@lang('layout.UpdatedAt')</th>
                    <th>@lang('layout.Actions')</th>
                </tr>
                </thead> 
            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>

<!-- END TAB PORTLET-->
<!-- END CONTENT BODY -->

@stop
@include('print.modal')
@push('scripts')

<script>
    /**
     * for creating shortcuts
     */
    document.onkeyup = function(e)
    {
        //new form
        if (e.which ==78) {
            window.location.href   = "{{route('inventoryBrand.create')}}"
        }
        
    }

    let data_table;
     $(document).ready(function() { 
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
       data_table = $('#inventoryBrand').DataTable( {
            ajax:           '{{route("inventoryBrand.index")}}',
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            serverSide: true,
            paging:         true,
            columns: [
           /* { data: 'id', name: 'id' },*/
            { data: 'name', name: 'name' },
            { data: 'Parent', name: 'Parent',orderable:false,searchable:false },
            { data: 'description', name: 'description' },
            { data: 'created_at', name: 'created_at' },
            { data: 'updated_at', name: 'updated_at' },
            { data: 'action', name: 'action' ,orderable:false,searchable:false },
 
            ] 
    }); 
    });

     new Vue({
            el: '#print-modal',
            data:{
                is_show_modal: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}'
            },
    
            methods:{
                closeModal: function(){
                    this.is_show_modal = !this.is_show_modal;
                }
            }
        });
</script>


@endpush
