@extends('layouts.app')
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.InventoryBrandCreate') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="inventory-category">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'inventoryBrand.store','method'=>'POST','class'=>'form-horizontal','id'=>'inventory-category-form')) !!}
                {{ csrf_field() }} 
                    <div class="form-body">
                      
                        <div class="col-md-9"> 
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Name'):</label>
                                <div class="col-md-9">
                                    {{Form::text('name',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Name'),'placeholder' => __('layout.Name')])}}
                                     <span class="required">@{{ errors.first('name') }}</span>
                                </div>
                            </div> 
                             <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.ParentID'):</label>
                                <div class="col-md-9">
                                    {{Form::select('parent',$parent,Null,['class' => 'form-control','placeholder' => __('layout.SelectParent')])}}
                                </div>
                            </div> 
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Description'):</label>
                                <div class="col-md-9">
                                  {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 6, 'cols' => 30)) !!}
                                </div>
                            </div>
                          <!--   <div>
                                <input type="text" name="" class="form-control" @keyup.enter="handleSubmit($event)">
                            </div> -->
                        </div>  
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" @click="handleSubmit($event)"  class="btn green">@lang('layout.Submit')</button>
                        <button type="button" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                        <a href="{{route('inventoryBrand.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                   
                    </div>  
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div> 
@endsection

@push('scripts')

<script>
   /**
     * for creating shortcuts
     */
   

    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    let vu = new Vue({
        el: '#inventory-category',
        data:{

        },
        methods:{
            handleSubmit(e)
            {
                this.$validator.validate()
                .then(valid =>{
                    if(valid)
                    {
                        
                    regForm(e.target);
                    }
                })
            },

            alertfun()
            {
                alert('ok');
            },
            saveAndNew()
            {
                 this.$validator.validate()
                .then(valid =>{
                    if(valid)
                    {
                        
                      saveAndNew('inventory-category-form',"{{route('inventoryBrand.store')}}")
                    }
                })
            }
        }
    })
</script>
@endpush