@extends('layouts.app')
@section('style')
    <style>
        .v-select input[type=search], .v-select input[type=search]:focus {
            width: 50% !important;
        }
        .table > tbody > tr > td, .table > tbody > tr > th, .table > tfoot > tr > td, .table > tfoot > tr > th, .table > thead > tr > td, .table > thead > tr > th {
            padding: 8px;
            padding: 4px 2px;
        }
        .input-has-error {
            outline: 1px solid #ff0000 !important;
            background-color: #ff000014;
        }
    </style>
@stop
@section('content')
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.InventoryImport')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="pull-right">
                </div>
            </div>
            <div class="row">
                <div class="col-lg-8">
                    <div class="tools text-center">
                        <a href="{{url('/')}}/import_file/simple_import_items_excels_file.xlsx" style="text-decoration: none; color: black;"> --------
                           <button class="btn btn-success">
                           <i class="fa fa-download"></i>
                           @lang('layout.InventoryImportSample')
                           </button>
                        -------- </a>
                   </div>
                   <!-- BEGIN FORM-->

                   {{Form::open(['route'=>'inventoryImport.store','method'=>'POST','enctype'=>'multipart/form-data','class'=>'form-horizontal','id'=>'import-form'])}}
                        {{ csrf_field() }}
                        <div class="form-body">
                            <div class="col-md-12">
                                <div class="form-group text-center" style="margin-top: 20px;">
                                    <label class="control-label col-md-5">@lang('layout.SelectFile') @lang('layout.Excel')
                                        :</label>
                                    <div class="col-md-7">
                                        {{Form::file('inventory_file',null,['class' => 'form-control','placeholder' => __('layout.File')])}}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-12 text-center" style="margin-top: 10px;">
                            <button type="button" onClick="sendFormData(this)" class="btn green">@lang('layout.Submit')</button>
                            <button type="reset" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')
                            </button>
                        </div>
                    {{Form::close()}}
               <!-- end form -->
                </div>
                <div class="col-lg-4">
                    <ul class="text-danger">
                        <p class="text-danger">@lang('message.Info')</p>
                        <li class="text-danger">@lang('message.TipOne')</li>
                        <li class="text-danger">@lang('message.TipTwo')</li>
                        <li class="text-danger">@lang('message.TipThree')</li>
                    </ul>
                </div>
            </div>
            <div id="app" v-cloak>
                <h1 v-if="flag=='no'">@lang('layout.import_measure_msg')</h1>
                <div v-if="flag=='yes'" class="portlet-body form" style="margin-bottom:10%;">
                    <div v-if="record.length>0">
                        <div style="overflow-x:scroll; width: 100%">
                            <!-- begint table -->
                            {{Form::open(['route'=>'inventoryImport.store','method'=>'POST','class'=>'form-horizontal','enctype'=>'multipart/form-data','id'=>'import-form-second'])}}
                            {{csrf_field()}}
                            <div class="row">
                                <div class="col-md-12 col-md-12">
                                    <div class="col-md-4">
                                        <label class="control-label col-md-3">@lang('layout.Site')</label>
                                        <select name="to_site" class="form-control">
                                            @foreach($site AS $k=>$v)
                                                <option value="{{$v['id']}}">{{$v['name']}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-12" style="height: 400px;">
                                        <table id="table_content" class="table table-bordered ">
                                            <thead>
                                            <tr>
                                                <th class="text-center" style="width:20px;">#</th>
                                                <th class="text-center" style="min-width: 90px;">
                                                    @lang('layout.ItemCode')
                                                </th>
                                                <th class="text-center" style="min-width: 230px;">
                                                    @lang('layout.Name')
                                                </th>
                                                <th class="text-center" style="min-width: 230px;">
                                                    @lang('layout.Type')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.ItemType')
                                                </th>
                                                <th class="text-center" style="min-width: 160px;">
                                                    @lang('layout.Gauge')
                                                </th>
                                                <th class="text-center" style="min-width: 160px;">
                                                    @lang('layout.Cost')
                                                </th>
                                                <th class="text-center" style="min-width: 160px;">
                                                    @lang('layout.Default_Rate')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Category')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Measure')
                                                </th>
                                                <th class="text-center" style="min-width: 230px;">
                                                    @lang('layout.IncomeAccount')
                                                </th>
                                                <th class="text-center" style="min-width: 230px;">
                                                    @lang('layout.CostAccount')
                                                </th>
                                                <th class="text-center" style="min-width: 230px;">
                                                    @lang('layout.AssetAccount')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Description')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Code')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Quantity')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Min')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Max')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Date')
                                                </th>


                                            </tr>
                                            </thead>
                                            <tr v-for="(obj,index) in record">
                                                <td class="td_one"><span
                                                            class="badge badge3 badge-success badge-roundless">@{{index+1}} </span>
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" name="code[]"
                                                           v-model="obj.number">
                                                </td>

                                                <td class="td_one">
                                                    <input type="text" class="form-control" name="name[]"
                                                           v-model="obj.name">
                                                </td>
                                                <td class="td_one">
                                                    <select class="form-control" name="type[]">
                                                        <option selected="selected" value="inventoryPart">@lang('layout.InventoryPart')</option>
                                                        <option value="inventoryAssembly">@lang('layout.InventoryAssembly')</option>
                                                        <option value="workingProgress">@lang('layout.WorkingProgress')</option>
                                                        <option value="procurement">@lang('layout.Procurement')</option>
                                                    </select>
                                                </td>
                                                <td class="td_one">
                                                    <select class="form-control" name="item_type[]">
                                                        <option selected="selected" value="">@lang('layout.MainItem')</option>
                                                        <option value="code">@lang('layout.Code')</option>
                                                    </select>
                                                </td>
                                                <td class="td_one">
                                                    <input type="number" class="form-control" name="gauge[]" v-model="obj.gauge">
                                                </td>
                                                <td class="td_one">
                                                    <input type="number" class="form-control" name="purchase_rate[]"
                                                           v-model="obj.purchase_rate">
                                                </td>
                                                <td class="td_one">
                                                    <input type="number" class="form-control" name="sale_rate[]"
                                                           v-model="obj.sale_rate">
                                                </td>
                                                <td class="td_one">
                                                    <select
                                                            class="form-control input-style" v-model="obj.category"
                                                            required="required" name="category[]">
                                                        <option value="">@lang('layout.Select')</option>
                                                        <option v-if="category_list"
                                                                v-for="cat in (category_list?category_list:null)"
                                                                :value="cat.id">
                                                            @{{cat.name}}
                                                        </option>
                                                    </select>
                                                </td>
                                                <td class="td_one">
                                                    <select name=measure[]
                                                            class="form-control input-style" v-model="obj.measure"
                                                            required="required">
                                                        <option value="0">@lang('layout.Select')</option>
                                                        <option v-if="measure_list"
                                                                v-for="mea in (measure_list?measure_list:null)"
                                                                :value="mea.id">
                                                            @{{mea.name}}
                                                        </option>
                                                    </select>  
                                                </td>
                                                <td class="td_one">
                                                    <select v-model="!obj.income?null:obj.income"
                                                            @change="changeIncome(this,index)"
                                                            class="form-control input-style" required="required">
                                                        <option v-if="income_list"
                                                                v-for="inc in (income_list?income_list:null)"
                                                                :value="inc.id">
                                                            @{{inc.name}}
                                                        </option>
                                                    </select>
                                                    <input type="hidden" name="income[]"
                                                           :value="!obj.income?null:obj.income">
                                                </td>

                                                <td class="td_one">
                                                    <select
                                                            v-model="!obj.cost?null:obj.cost"
                                                            @change="changeCost(this,index)"
                                                            class="form-control input-style" required="required">
                                                        <option v-if="cost_list"
                                                                v-for="cos in (cost_list?cost_list:null)"
                                                                :value="cos.id">
                                                            @{{cos.name}}
                                                        </option>
                                                    </select>
                                                    <input type="hidden" name="cost[]" :value="!obj.cost?null:obj.cost">
                                                </td>
                                                <td class="td_one">
                                                    <select v-model="!obj.asset?null:obj.asset"
                                                            @change="changeAsset(this,index)"
                                                            class="form-control input-style" required="required">
                                                        <option v-if="asset_list"
                                                                v-for="asse in (asset_list?asset_list:null)"
                                                                :value="asse.id">
                                                            @{{asse.name}}
                                                        </option>
                                                    </select>
                                                    <input type="hidden" name="asset[]"
                                                           :value="!obj.asset?null:obj.asset">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" name="description[]"
                                                           v-model="obj.description">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" name="item_code[]" :value="obj.code">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" name="quantity[]"
                                                           :value="!obj.quantity?null:obj.quantity">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" name="min[]" :value="!obj.min?null:obj.min">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" name="max[]" :value="!obj.max?null:obj.max">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" name="date[]" :value="!obj.date?null:obj.date">
                                                </td> 
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <!-- end table -->
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-12 text-center" style="margin-top: 10px;">
                            <button type="button" @click="sendFormData(this)" class="btn green">@lang('layout.Submit')</button>
                            <button type="reset" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</button>
                        </div>
                        {{Form::close()}}
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <center> ------------------------------- </center>
                    <h4 style="margin: 30px 0px;">@lang('layout.ImportCodeOnHandByExcel')</h4>
                    <div class="text-center" style="margin-top: 10px !important;">
                        <a href="{{url('/')}}/import_file/simple_import_code_excel_file.xlsx" style="text-decoration: none; color: black;"> --------
                            <button class="btn btn-success">
                            <i class="fa fa-download"></i>
                            @lang('layout.SampleExcelFile')
                            </button>
                         -------- </a>
                    </div>
                    <!-- BEGIN FORM-->

                    {{Form::open(['route'=>'inventoryImport.store','method'=>'POST','enctype'=>'multipart/form-data','class'=>'form-horizontal','id'=>'import-form-code'])}}
                        {{ csrf_field() }}
                        <div class="form-body">
                            <div class="col-md-12">
                                <div class="form-group" style="margin-top: 20px;">
                                    <label class="control-label col-md-5">@lang('layout.SelectFile') @lang('layout.Excel')
                                        :</label>
                                    <div class="col-md-7">
                                        {{Form::file('inventory_code_file',null,['class' => 'form-control','placeholder' => __('layout.File')])}}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-12 text-center" style="margin-top: 10px;">
                            <button type="button" onClick="sendFormData(this)" class="btn green">@lang('layout.Submit')</button>
                            <button type="reset" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</button>
                        </div>
                    {{Form::close()}}
                    <!-- end form -->
                </div>
                <div class="col-lg-6">

                </div>
            </div>
            <div id="app1" v-cloak>
                
                
                <div class="portlet-body form" style="margin-bottom:10%;">
                    
                    @if($codeData)
                    @if(count($codeData)>0)
                    <div>
                        <div style="overflow-x:scroll; width: 100%">
                            <!-- begint table -->
                            {{Form::open(['route'=>'inventoryImportCode.store','method'=>'POST','class'=>'form-horizontal','enctype'=>'multipart/form-data','id'=>'import-form-second-code'])}}
                            {{csrf_field()}}
                            <div class="row">
                                <div class="col-md-12 col-md-12">
                                    <br/>
                                    <div class="col-md-4">
                                        
                                    </div>
                                    <div class="col-md-12" style="height: 400px;">
                                        <table id="table_content" class="table table-bordered ">
                                            <thead>
                                            <tr>
                                                <th class="text-center" style="width:20px;">#</th>
                                                <th class="text-center" style="min-width: 90px;">
                                                    @lang('layout.ItemCode')
                                                </th>
                                                <th class="text-center" style="min-width: 90px;">
                                                    @lang('layout.Name')
                                                </th>
                                                <th class="text-center" style="min-width: 120px;">
                                                    @lang('layout.Measure')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Site')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Code')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Cost')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Default_Rate')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Quantity')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Width')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Length')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Wing')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.ApproxWeight')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Description')
                                                </th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php
                                                $count = 0;
                                            ?>
                                            @foreach($codeData AS $record)
                                            <tr>
                                                <td class="td_one">
                                                    <span class="badge badge3 badge-success badge-roundless">{{$count+1}}</span>
                                                </td>
                                                <td class="td_one">
                                                    {{$record['serial_number']}}
                                                    <input type="hidden" class="form-control" name="id[{{$count}}]" value="{{$record['id']}}" >
                                                </td>
                                                <td class="td_one">
                                                    {{$record['name']}}
                                                </td>
                                                <td class="td_one">
                                                    {{$record['measure']}}
                                                </td>
                                                <td class="td_one">
                                                    <select name="site[{{$count}}]" class="form-control">
                                                        @foreach($site AS $k=>$v)
                                                            <option value="{{$v['id']}}">{{$v['name']}}</option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" name="code[{{$count}}]" value="{{$record['code']}}" >
                                                </td>
                                                <td class="td_one">
                                                    <input type="number" class="form-control" name="cost[{{$count}}]" value="{{$record['cost']}}" >
                                                </td>
                                                <td class="td_one">
                                                    <input type="number" class="form-control" name="sale_price[{{$count}}]" value="{{$record['sale_price']}}" >
                                                </td>
                                                <td class="td_one">
                                                    <input type="number"  name="quantity[{{$count}}]" value="{{$record['quantity']}}">
                                                </td>
                                                <td class="td_one">
                                                    <input type="number" name="width[{{$count}}]" value="{{$record['width']}}">
                                                </td>
                                                <td class="td_one">
                                                    <input type="number" name="length[{{$count}}]" value="{{$record['length']}}">
                                                </td>
                                                <td class="td_one">
                                                    <input type="number" name="khada[{{$count}}]" value="{{$record['khada']}}">
                                                </td>
                                                <td class="td_one">
                                                    <input type="number" name="approx_weight[{{$count}}]" value="{{$record['approx_weight']}}">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" name="description[{{$count}}]" value="{{$record['description']}}" >
                                                </td>
                                            </tr>
                                            <?php $count++; ?>
                                            @endforeach
                                            </tbody>
                                        </table>

                                    </div>
                                </div>

                            </div>


                            <!-- end table -->
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                            <button type="button" @click="sendFormDataCode(this)" class="btn green">@lang('layout.Submit')</button>
                            <button type="reset" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</button>
                        </div>
                        {{Form::close()}}
                    </div>
                    @endif
                    @endif
                </div>


            </div>
        </div>
    </div>

@endsection
@push('scripts')


    <script>


        var data ={!! $data !!};
        var site ={!! $site !!};
        var income ={!! $income !!};
        var cost ={!! $cost !!};
        var asset ={!! $asset !!};
        var measure ={!! $measure !!};
        var category ={!! $category !!};
        var flag = "{{ $flag }}";
        new Vue({
            el: '#app',
            data: {
                flag: flag,
                record: data,
                income_list: income,
                cost_list: cost,
                asset_list: asset,
                site_list: site,
                measure_list: measure,
                category_list: category,
                site_q: [],
            },
            methods: {
                onchange(e) {

                },
                changeIncome(e, index) {

                    this.record[index].income = e.event.target.value;
                    return true;

                },
                changeCost(e, index) {
                    this.record[index].cost = e.event.target.value;
                    return true;

                },
                changeAsset(e, index) {
                    this.record[index].asset = e.event.target.value;
                    return true;

                },
                sendFormData(e) {
                    var el = $(e);
                    var form = el.parents('form').get(0);
                    var data = $('#import-form').serialize();
                    console.log('test 22', data);
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        icon: 'warning',
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                        dangerMode: true,
                    }).then((wichButton) => {
                        if (wichButton) {
                            //form.submit();
                            document.getElementById('import-form-second').submit();
                            return true;
                        }
                        return false;
                    });
                }
            },
            created: function () {
                console.log('ssssss', this.flag);
                for (var i = 0; i < this.record.length; i++) {
                    // for(var m=0;m<this.record[i].income_list.length;m++)
                    // {
                    //     console.log('ww',this.record[i].income_list[m].name);
                    // }
                }
            }
        });
 
 
        new Vue({
            el: '#app1',
            data: {
                flag: flag,
                record: data,
                income_list: income,
                cost_list: cost,
                asset_list: asset,
                site_list: site,
                measure_list: measure,
                category_list: category,
                site_q: [],
            },
            methods: {
            
                sendFormData(e) {
                    var el = $(e);
                    var form = el.parents('form').get(0);
                    var data = $('#import-form-code').serialize();
                    console.log('test 22', data);
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        icon: 'warning',
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                        dangerMode: true,
                    }).then((wichButton) => {
                        if (wichButton) {
                            //form.submit();
                            document.getElementById('import-form-code').submit();
                            return true;
                        }
                        return false;
                    });
                }, 

                sendFormDataCode(e) {
                    var el = $(e);
                    var form = el.parents('form').get(0);
                    var data = $('#import-form-second-code').serialize();
                    console.log('test 22', data);
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        icon: 'warning',
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                        dangerMode: true,
                    }).then((wichButton) => {
                        if (wichButton) {
                            //form.submit();
                            document.getElementById('import-form-second-code').submit();
                            return true;
                        }
                        return false;
                    });
                }
            },
            created: function () {
                // console.log('ssssss', this.flag);
                for (var i = 0; i < this.record.length; i++) {
                    // for(var m=0;m<this.record[i].income_list.length;m++)
                    // {
                    //     console.log('ww',this.record[i].income_list[m].name);
                    // }
                }
            }
        });

        function sendFormData(e) {
            var el = $(e);
            var form = el.parents('form').get(0);
            var data = $('#import-form').serialize();
            console.log('test 22', data);
            swal({
                title: "@lang('layout.AreYouSure?')",
                icon: 'warning',
                buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                dangerMode: true,
            }).then((wichButton) => {
                if (wichButton) {
                    form.submit();
                    return true;
                }
                return false;
            });
        }


        // to send inventory data

        function sendData(element) {
            e = $(e);
            var form = e.parents('form').get(0);
            swal({
                'title': "@lang('layout.AreYouSure?')",
                'icon': 'dander',
                'buttons': ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                danderMode: true
            }).then((whichButton) => {
                if (wichButton) {
                    form.submit();
                    return true;
                }
                return false;
            })
        }

        // end inventory data

    </script>


@endpush