@extends('layouts.app')
@section('style')
<style type="text/css">
  .modal-container {
    width: 30%;
  }
</style>
@stop
@section('content')
@include('inventories.modal')

<!-- BEGIN TAB PORTLET-->
<!-- app-->
<div id="app" v-cloak>
  <form id="d_form" action="{{route('export.PDFAll')}}" method="POST">
    <input type="hidden" name="_method" value="DELETE">
    {!! Form::token() !!}
    <input type="hidden" name="type" value="inventoryDetailRollByLocation" />
    <input type="hidden" name="qut" value="both" />
    <input type="hidden" name="id" value="{{$inventory->id}}" />

    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false">
      <div slot="body">
        <div class="row">
          <div class="form-group" id="dynamic_content">


          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
              <label class="control-label">@lang('layout.Location') </label>
              <input type="text" name="location" class="form-control" >
            </div>
          </div>

          <div class="col-md-6">
            <div class="form-group">

              <label class="control-label ">@lang('layout.InventorySite') </label>
              <select name="inventory_site_id" id="" class="form-control">
                <option value="">@lang('layout.SelectInventorySite')</option>
                @foreach($inventorySite as $site)
                <option value="{{$site->id}}">{{$site->name}}</option>
                @endforeach
              </select>
            </div>
          </div>
        </div>

        <!-- <div class="row">
          <div class="form-group">
            <div class="col-md-12">
              <label class="control-label"> @lang('layout.Date')</label>
              <div class="input-group">
                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                <span class="input-group-addon">@lang('layout.To') </span>
                <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">
              </div>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="form-group">
            <div class="col-md-12">
              <div class="form-group">
                <h3> <label class="control-label"> @lang('layout.OnHand') <input name="onHand" type="checkbox" value="true"> </label> </h3>
              </div>
            </div>
          </div>
        </div> -->
      </div>
      <div slot="footer">
        <button type="submit" class="btn btn-success" @click="ok">
          @lang('layout.Submit')
        </button>
        <button type="button" class="btn btn-danger" @click="close">
          @lang('layout.Cancel')
        </button>
      </div>
    </modal>
  </form>
</div>
<!-- app -->





<div class="portlet">
  <div class="portlet-title">
    <div class="caption"><i class=""></i>@lang('layout.InventoryInformation')
    </div>
    <div class="tools"><a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
      <a href="#portlet-config" data-toggle="modal" class="config" data- original-title="" title=""> </a>


    </div>
  </div>
  <div class="portlet-body">
    <div class="table-scrollable">
      <table class="table table-striped table-bordered table-advance table-hover">
        <thead>
          <tr>
            <th><i class="fa  fa-bars"></i> @lang('layout.Item')</th>
            <th class="hidden-xs"><i class="fa fa-briefcase"></i> @lang('layout.ItemName')
            </th>
            <th class="hidden-xs"><i ></i> @lang('layout.Unit')</th>
            <th><i class="fa  fa-bars"></i> @lang('layout.OnHand')</th>
            <th><i class="fa  fa-bars"></i> @lang('layout.TotalCode')</th>
            @if(getShowWing()!="false") <th><i class="fa  fa-bars"></i> @lang('layout.Wing')</th> @endif
            @if(getOtherMeasure()=="true")
                <th>{{ $inventory->o_measure_name}}</th>
            @endif
            @if(getOtherMeasure2()=="true")
                <th>{{ $inventory->other_um_id}}</th>
            @endif
            <th><i class="fa  fa-bars"></i> @lang('layout.Category')</th>
            <th><i class="fa  fa-bars"></i> @lang('menu.InventoryBrand')</th>
            <th><i class="fa  fa-bars"></i> @lang('layout.Location')</th>
           
            <th><i class="fa fa-dollar"></i> @lang('layout.Rate')
            </th>
            
            <th>
              <i class="fa fa-clock-o"></i> @lang('layout.CreatedAt')
            </th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td class="hidden-xs"> {{ $inventory->number}} </td>
            <td class="hidden-xs"> {{ $inventory->name}} @if(systemConfig()[9] == 0 ) -@lang('layout.Gauge')({{ $inventory->gauge}}) @endif </td>
            <td class="hidden-xs"> {{ $item_info[0]['unit']}}  </td>
            <td class="hidden-xs"> {{ ($inventoryOnHandRoll)?$inventoryOnHandRoll->onHand:0}} </td>
            <td class="hidden-xs"> {{ $OnHandCode}} </td>
            @if(getShowWing()!="false") <td class="hidden-xs"> {{ ($inventoryOnHandRoll)?$inventoryOnHandRoll->on_hand_khada:0}} </td> @endif
            @if(getOtherMeasure()=="true")
            <td class="hidden-xs"> {{ ($inventoryOnHandRoll)?$inventoryOnHandRoll->other_measure:0}} </td>
            @endif
            @if(getOtherMeasure2()=="true")
            <td class="hidden-xs"> {{ ($inventoryOnHandRoll)?$inventoryOnHandRoll->other_measure2:0}} </td>
            @endif
            <td class="hidden-xs"> {{ $inventory->inventoryCategory}} </td>
            <td class="hidden-xs"> {{ $inventory->inventoryBrand}} </td>
            <td class="hidden-xs"> {{ $inventory->item_location}} </td>
            <td class="hidden-xs"> {{ $inventory->rate }} </td>
            <td class="hidden-xs"> {{ convertDate($inventory->created_at)}} </td>

          </tr>
        </tbody>
      </table>

      <table
      class="table table-striped table-bordered table-advance table-hover">
      <thead>
        <tr>
          <th><i class="fa  fa-bars"></i> @lang('layout.IncomeAccount')</th>
          <th><i class="fa  fa-bars"></i> @lang('layout.CostAccount')</th>
          <th><i class="fa  fa-bars"></i> @lang('layout.AssetAccount')</th>
          <th><i class="fa fa-arrow-up"></i> @lang('layout.Max')</th>
          <th><i class="fa fa-arrow-down"></i> @lang('layout.Min')</th> 
        </tr>
      </thead>
      <tbody>
        <tr>
          <td class="hidden-xs"> {{ $item_info[0]['income'] }}  </td>
          <td class="hidden-xs"> {{ $item_info[0]['cost']}}  </td>
          <td class="hidden-xs"> {{ $item_info[0]['asset'] }}  </td>
          <td class="hidden-xs"> {{ $inventory->max}}  </td>
          <td class="hidden-xs"> {{ $inventory->min }}  </td>


        </tr>
      </tbody>
</table>

    </div>
  </div>
</div>
<div class="tabbable-line tabbable-custom-profile">
  <ul class="nav nav-tabs">
    <li class="active">
      <a href="#qut-onhand" data-toggle="tab" id="tab-qut-onhand">
        <i class="fa fa-credit-card-alt"></i><b> @lang('layout.OnHand') </b></a>
    </li>

  </ul>
  <div class="tab-content padding" style="padding: 0px;">
    <div class="tab-pane active" id="qut-onhand">
      <div class="row">
        <div class="col-md-12">
          <!-- BEGIN EXAMPLE TABLE PORTLET-->
          <div class="portlet light bordered">
            <div class="portlet-title">
              <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('layout.QtyOnHand')</span>
              </div>
              <div class="actions">

              <button type="button" onClick="report_by_type_pdf()" class="btn btn-success" id="print_excell_both"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
              <button id="print_pdf_both" type="button" onClick="report_by_type_pdf()" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>

              </div>
            </div>
            <div class="portlet-body">
              <table class="table table-striped table-bordered table-hover" id="qut-onhand-table">
                <thead>
                <tr>
                    <th>@lang('layout.Date')</th>
                    @if(showLocation()=="true")
                    <th>@lang('layout.Location')</th>
                    @endif
                    @if(getOtherMeasure()=="true")
                        <th>@lang('layout.OMeasureValue1')</th>
                    @endif
                    @if(getOtherMeasure2()=="true")
                        <th>@lang('layout.OMeasureValue2')</th>
                    @endif
                    @if(systemConfig()[9] == 0 )
                    <th>@lang('layout.Length') </th>
                    <th>@lang('layout.Width') </th>
                    @endif
                    @if(getShowWing()!="false")
                    <th>@lang('layout.Wing') </th>
                    <th>@lang('layout.ApproxWeight') </th>
                    @endif
                    @if(systemConfig()[9] != 0 )
                    <th>@lang('layout.Photo') </th>
                    @endif
                    @if(itemBrand()=="true")
                    <th>@lang('layout.Brand')</th>
                    @endif
                    <th>@lang('layout.Default_Rate')</th>
                    <th>@lang('layout.SiteName')</th>
                    <th>@lang('layout.Quantity')</th>
                    <th>@lang('layout.Measure')</th>
                    @if(getM2()!="" && getSubMeasure()!="true")
                    <th>@lang('layout.Unit') 2</th>
                    @endif
                    <th>@lang('layout.TotalPurchaseCost')</th>
                    <th>@lang('layout.User')</th>
                    <th>@lang('layout.Description')</th>

                  </tr>
                </thead>
              </table>
            </div>
          </div>
          <!-- END EXAMPLE TABLE PORTLET-->
        </div>
      </div>
    </div>

  </div>
</div>




</div>
@endsection
@push('scripts')
<script>
  Vue.component("v-select", VueSelect.VueSelect);
  var Modal = Vue.component('modal', {
    template: '#modal-template',
    methods: {
      ok: function() {
        this.$emit('ok')
      }
    }
  })
  // start app
  // start app
  var vm = new Vue({
    el: '#app',
    data: {
      showModal: false,
      selectedItem: null,
      itemlist: [],
    },
    methods: {
      //ajax call to get items
      onItemSearch(search) {
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'searchCode',
              'inventory_id': "{{$inventory->inventory_id}}",
              'keyword': search,
            }
          })
          .then(function(response) {
            this.itemlist = [];
            if (response.data.length > 0) {
              vm.itemlist = response.data;
              // console.log('data', vm.itemlist);
            }
          })
          .catch(function(error) {
            console.log(error);
          })
      },
      ok: function() {
        this.showModal = !this.showModal;
      },
      close: function(e) {
        this.showModal = !this.showModal;
      },
      getModalContent(myData) {
        //Your other code that launches the modal
        this.showModal = true;
        this.$nextTick(function() {
          $(document).ready(function() {
            var to, from;
            to = $("#range-to-example").persianDatepicker(modelDate());
            from = $("#range-from-example").persianDatepicker(modelDate());

            document.getElementById('dynamic_content').innerHTML = myData;
          });
        })
      }
    },
  })


  function report_by_type_pdf(e) {
    $('#show-modal').click();
    var myid = event.target.id;
    var type_id = myid;

    ////pdf both
    if (type_id == 'print_pdf_both') {
      var myhtml = `
            <input type="hidden" name="type" value="inventoryDetailRollByLocation"/>
            <input type="hidden" name="qut" value="both"/>
            <input type="hidden" name="id" value="{{$inventory->id}}"/>`;
      $('#d_form').attr('action', "{{route('export.PDFAll')}}");
      vm.getModalContent(myhtml);
    }
    ////excell both
    if (type_id == 'print_excell_both') {

      var myhtml = `
            <input type="hidden" name="type" value="inventoryDetailRollByLocation"/>
            <input type="hidden" name="qut" value="both"/>
            <input type="hidden" name="id" value="{{$inventory->id}}"/>`;
      $('#d_form').attr('action', "{{route('export.ExcelAll')}}");
      vm.getModalContent(myhtml);
    }
    ////pdf in
    if (type_id == 'print_pdf_in') {

      var myhtml = `<input type="hidden" name="type" value="inventoryDetailRollByLocation"/>
                     <input type="hidden" name="qut" value="in"/>
                     <input type="hidden" name="id" value="{{$inventory->id}}"/>`;
      $('#d_form').attr('action', "{{route('export.PDFAll')}}");
      vm.getModalContent(myhtml);
    }


    ////excell in
    if (type_id == 'print_excell_in') {

      var myhtml = `<input type="hidden" name="type" value="inventoryDetailRollByLocation"/>
                     <input type="hidden" name="qut" value="in"/>
                     <input type="hidden" name="id" value="{{$inventory->id}}"/>`;
      $('#d_form').attr('action', "{{route('export.ExcelAll')}}");
      vm.getModalContent(myhtml);
    }

    ////pdf out
    if (type_id == 'print_pdf_out') {

      var myhtml = `<input type="hidden" name="type" value="inventoryDetailRollByLocation"/>
                     <input type="hidden" name="qut" value="out"/>
                     <input type="hidden" name="id" value="{{$inventory->id}}"/>`;
      $('#d_form').attr('action', "{{route('export.PDFAll')}}");
      vm.getModalContent(myhtml);
    }

    ////pdf out
    if (type_id == 'print_excell_out') {

      var myhtml = `<input type="hidden" name="type" value="inventoryDetailRollByLocation"/>
                     <input type="hidden" name="qut" value="out"/>
                     <input type="hidden" name="id" value="{{$inventory->id}}"/>`;
      $('#d_form').attr('action', "{{route('export.ExcelAll')}}");
      vm.getModalContent(myhtml);
    }
  }

  // qut-onhand
  $(document).ready(function() {
    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
    
      $('#qut-onhand-table').DataTable({
        order: [["{{orderByColumn()=='number'?1:0}}", "{{getRowOrder()}}"]],
        responsive:'{{responsiveDataTable()}}',
        pagingType:'{{paginationType()}}',
        scrollCollapse: true,
        serverSide: true,
        paging: true,
        retrieve: true,
        ajax: {
          url: '{{route("inventory.show_by_location",$inventory->id)}}',
          data: {
            type: 'qut-onhand',
            m_type: "{{$inventory->m_type}}"
          }
        },
        buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
        columns: [
          {
            data: 'Date',
            name: 'Date',
            searchable: false
          },
          @if(showLocation()=="true")
          {
            data: 'location',
            name: 'location',
            searchable: false
          },
          @endif 
          @if(getOtherMeasure()=="true")
          {data: 'other_measure', name: 'other_measure', orderable: false, searchable: false },
          @endif
          @if(getOtherMeasure2()=="true")
          {data: 'other_measure2', name: 'other_measure2', orderable: false, searchable: false},
          @endif
          @if(systemConfig()[9] == 0) {
            data: 'Lengths',
            name: 'Lengths',
            orderable: false,
            searchable: false
          },
          {
            data: 'Widths',
            name: 'Widths',
            orderable: false,
            searchable: false
          },
          @endif
          @if(getShowWing()!="false")
          {
            data: 'khada',
            name: 'khada',
            orderable: false,
            searchable: false
          },
          {
            data: 'approx_weight',
            name: 'approx_weight',
            orderable: false,
            searchable: false
          },
          @endif
          @if(systemConfig()[9] != 0) {
            data: 'image',
            name: 'image',
            orderable: false,
            searchable: false
          },
          @endif
          @if(itemBrand() == "true") {
            data: 'brand',
            name: 'brand',
            searchable: false
          },
          @endif
          {
            data: 'price',
            name: 'price',
            searchable: false
          },
          {
            data: 'SiteName',
            name: 'SiteName',
            orderable: false,
            searchable: false
          },
          {
            data: 'Quantity',
            name: 'Quantity',
            orderable: false,
            searchable: false
          },
          {
            data: 'Measure',
            name: 'Measure',
            orderable: false,
            searchable: false
          },
          @if(getM2() != "" && getSubMeasure() != "true") {
            data: 'Unit2',
            name: 'Unit2',
            orderable: false,
            searchable: false
          },
          @endif
          {
            data: 'Total',
            name: 'Total',
            orderable: false,
            searchable: false
          },
          {
            data: 'user',
            name: 'user',
            orderable: false,
            searchable: false
          },
          {
            data: 'Description',
            name: 'Description',
            orderable: false,
            searchable: false
          },
        ]
      });
  });
  // end qut-onhand

  

</script>
@endpush