@extends('layouts.app')
@section('style')
<style type="text/css">
.modal-container{
  width: 30%;
}
</style>
@stop
@section('content')
@include('inventories.modal')
<!-- BEGIN TAB PORTLET-->
<!-- app-->
    <div id="app" v-cloak>
        <form id="d_form" action="{{route('export.PDFAll')}}" method="POST">
           <input type="hidden" name="_method" value="DELETE">
           {!! Form::token() !!}
        <input type="hidden" name="type" value="inventoryDetailWithType"/>
        <input type="hidden" name="qut" value="both"/>
        <input type="hidden" name="id" value="{{$inventory->id}}"/>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false"  >
            <div slot="body">
                <div class="row">
                    <div class="form-group" id="dynamic_content">
                    </div>
                </div>
                  <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                           <label class="control-label ">@lang('layout.InventorySite') </label>
                            <select name="inventory_site_id" id="" class="form-control">
                              <option  value="">@lang('layout.SelectInventorySite')</option>
                              @foreach($inventorySite as  $site)
                                <option  value="{{$site->id}}">{{$site->name}}</option>
                              @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                                <span class="input-group-addon">@lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        </form>
    </div>
<!-- app -->
<!--Begin Both Inventory Details-->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'allLoanReports'" @closed="closeModal">
            <div slot="body">
              <input type="hidden" name="type" value="inventoryDetailWithType"/>
              <input type="hidden" name="qut" value="both"/>
              <input type="hidden" name="id" value="{{$inventory->id}}"/>
           <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->
            <div class="row" v-cloak>
                     <div class="tabbable tabbable-tabdrop">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 )
                                @permission(['customreport-list'])
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
                        <div class="tab-content">
                             <div class="tab-pane active" id="tab1"> 
                                    <div class="portlet light bordered">
                                      <div class="row">
                                        <div class="form-group">
                                            <div class="col-md-6">
                                               <label class="control-label ">@lang('layout.InventorySite') </label>
                                                <select name="inventory_site_id" id="" class="form-control">
                                                  <option  value="">@lang('layout.SelectInventorySite')</option>
                                                  @foreach($inventorySite as  $site)
                                                    <option  value="{{$site->id}}">{{$site->name}}</option>
                                                  @endforeach
                                                </select>
                                            </div>
                                            @if(showLocation()=="true")
                                            <div class="col-md-3">
                                              <label class="control-label ">@lang('layout.Location') </label>
                                              <input type="text" name="location" class="form-control" autocomplete="off">
                                            </div>
                                            @endif
                                            <div class="col-md-3">
                                              <div class="form-group">
                                                <h4> <label class="control-label"> @lang('layout.Total') <input name="total" type="checkbox" value="true"> </label> </h4>
                                              </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label"> @lang('layout.Date')</label>
                                                <div class="input-group">
                                                    <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                                                   
                                                    <span class="input-group-addon">@lang('layout.To') </span>
                                                    <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    </div>
                            </div> 

                            <div class="tab-pane" id="tab2"> 
                               <div class="portlet light bordered">
                                    <div class="portlet-body"> 
                                        <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                            @csrf
                                            <input type="hidden" name="part_name" value="inventory_show_both"> 
                                            <div class="col-md-12 col-sm-12 col-xs-12">

                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                    <div class="form-group">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                                    <tr>
                                                                        <td style="text-align: center;">@{{ row.Name }}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td style="text-align: center;">
                                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                            <label class="switch">
                                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                                :checked="row.checkedColumn" >
                                                                                <span class="slider round"></span>
                                                                            </label>
                                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                              <option value="">@lang('layout.Select')</option>
                                                                              <option value="2">2 %</option>
                                                                                <option value="6">6 %</option>
                                                                              <option value="10">10 %</option>
                                                                              <option value="15">15 %</option>
                                                                              <option value="20">20 %</option>
                                                                              <option value="25">25 %</option>
                                                                              <option value="30">30 %</option>
                                                                              <option value="40">40 %</option>
                                                                              <option value="50">50 %</option>
                                                                              <option value="60">60 %</option>
                                                                          </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                         <!-- <label> @{{ row.Name }}</label>

                                                          <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                         <label class="switch">
                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                :checked="row.checkedColumn" >
                                                              <span class="slider round"></span>
                                                        </label> -->

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="margiv-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                                <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                            </div>
                                    </form>
                                    </div>
                            </div>
                    </div>
                    </div>
                </div>
            </div>
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->



            </div>

        </report-modal>
    </div>
    <!--Begin Both Inventory Details-->

    <!--Begin In Details-->
    <div id="print-modal-in">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'allLoanReports'"
                      @closed="closeModal">
            <div slot="body">

             <input type="hidden" name="type" value="inventoryDetailWithType"/>
             <input type="hidden" name="qut" value="in"/>
             <input type="hidden" name="id" value="{{$inventory->id}}"/>
           <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->
            <div class="row" v-cloak>
                     <div class="tabbable tabbable-tabdrop">

                        <ul class="nav nav-tabs">
                            
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 )
                                @permission(['customreport-list'])
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
                        <div class="tab-content">
                             <div class="tab-pane active" id="tab1"> 
                                    <div class="portlet light bordered">
                                      <div class="row">
                                        <div class="form-group">
                                            <div class="col-md-6">
                                               <label class="control-label ">@lang('layout.InventorySite') </label>
                                                <select name="inventory_site_id" id="" class="form-control">
                                                  <option  value="">@lang('layout.SelectInventorySite')</option>
                                                  @foreach($inventorySite as  $site)
                                                    <option  value="{{$site->id}}">{{$site->name}}</option>
                                                  @endforeach
                                                </select>
                                            </div>
                                            @if(showLocation()=="true")
                                            <div class="col-md-3">
                                              <label class="control-label ">@lang('layout.Location') </label>
                                              <input type="text" name="location" class="form-control" autocomplete="off">
                                            </div>
                                            @endif
                                            <div class="col-md-3">
                                              <div class="form-group">
                                                <h4> <label class="control-label"> @lang('layout.SortBy') @lang('layout.ExpireDate') <input name="expireDate" type="checkbox" value="true"> </label> </h4>
                                              </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label"> @lang('layout.Date')</label>
                                                <div class="input-group">
                                                    <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                                                   
                                                    <span class="input-group-addon">@lang('layout.To') </span>
                                                    <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    </div>
                            </div> 

                            <div class="tab-pane" id="tab2"> 
                               <div class="portlet light bordered">
                                    <div class="portlet-body">

                                        <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                            @csrf
                                            <input type="hidden" name="part_name" value="inventory_show_in">


                                            <div class="col-md-12 col-sm-12 col-xs-12">

                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                    <div class="form-group">

                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                                    <tr>
                                                                        <td style="text-align: center;">@{{ row.Name }}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td style="text-align: center;">
                                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                            <label class="switch">
                                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                                :checked="row.checkedColumn" >
                                                                                <span class="slider round"></span>
                                                                            </label>
                                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                              <option value="">@lang('layout.Select')</option>
                                                                              <option value="2">2 %</option>
                                                                                <option value="6">6 %</option>
                                                                              <option value="10">10 %</option>
                                                                              <option value="15">15 %</option>
                                                                              <option value="20">20 %</option>
                                                                              <option value="25">25 %</option>
                                                                              <option value="30">30 %</option>
                                                                              <option value="40">40 %</option>
                                                                              <option value="50">50 %</option>
                                                                              <option value="60">60 %</option>
                                                                          </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                         <!-- <label> @{{ row.Name }}</label>

                                                          <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                         <label class="switch">
                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                :checked="row.checkedColumn" >
                                                              <span class="slider round"></span>
                                                        </label> -->

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="margiv-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                                <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                            </div>
                                    </form>
                                    </div>
                            </div>
                    </div>
                    </div>
                </div>
            </div>
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->



            </div>

        </report-modal>
    </div>
    <!--Begin In Details-->    

    <!--Begin Out Details-->
    <div id="print-modal-out">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'allLoanReports'"
                      @closed="closeModal">
            <div slot="body">

           <input type="hidden" name="type" value="inventoryDetailWithType"/>
           <input type="hidden" name="qut" value="out"/>
           <input type="hidden" name="id" value="{{$inventory->id}}"/>
           <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->
            <div class="row" v-cloak>
                     <div class="tabbable tabbable-tabdrop">

                        <ul class="nav nav-tabs">
                            
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 )
                                @permission(['customreport-list'])
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
                        <div class="tab-content">
                             <div class="tab-pane active" id="tab1"> 
                                    <div class="portlet light bordered">
                                      <div class="row">
                                        <div class="form-group">
                                            <div class="col-md-6">
                                               
                                               <label class="control-label ">@lang('layout.InventorySite') </label>
                                                <select name="inventory_site_id" id="" class="form-control">
                                                  <option  value="">@lang('layout.SelectInventorySite')</option>
                                                  @foreach($inventorySite as  $site)
                                                    <option  value="{{$site->id}}">{{$site->name}}</option>
                                                  @endforeach
                                                </select>
                                            </div>
                                            @if(showLocation()=="true")
                                            <div class="col-md-3">
                                              <label class="control-label ">@lang('layout.Location') </label>
                                              <input type="text" name="location" class="form-control" autocomplete="off">
                                            </div>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label"> @lang('layout.Date')</label>
                                                <div class="input-group">
                                                    <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                                                   
                                                    <span class="input-group-addon">@lang('layout.To') </span>
                                                    <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    </div>
                            </div> 

                            <div class="tab-pane" id="tab2"> 
                               <div class="portlet light bordered">
                                    <div class="portlet-body">

                                        <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                            @csrf
                                            <input type="hidden" name="part_name" value="inventory_show_out">


                                            <div class="col-md-12 col-sm-12 col-xs-12">

                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                    <div class="form-group">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                                    <tr>
                                                                        <td style="text-align: center;">@{{ row.Name }}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td style="text-align: center;">
                                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                            <label class="switch">
                                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                                :checked="row.checkedColumn" >
                                                                                <span class="slider round"></span>
                                                                            </label>

                                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                              <option value="">@lang('layout.Select')</option>
                                                                              <option value="2">2 %</option>
                                                                                <option value="6">6 %</option>
                                                                              <option value="10">10 %</option>
                                                                              <option value="15">15 %</option>
                                                                              <option value="20">20 %</option>
                                                                              <option value="25">25 %</option>
                                                                              <option value="30">30 %</option>
                                                                              <option value="40">40 %</option>
                                                                              <option value="50">50 %</option>
                                                                              <option value="60">60 %</option>
                                                                          </select>



                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                         <!-- <label> @{{ row.Name }}</label>

                                                          <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                         <label class="switch">
                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                :checked="row.checkedColumn" >
                                                              <span class="slider round"></span>
                                                        </label> -->

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="margiv-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                                <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                            </div>
                                    </form>
                                    </div>
                            </div>
                    </div>
                    </div>
                </div>
            </div>
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->



            </div>

        </report-modal>
    </div>
    <!--Begin Out Details-->





<div class="portlet">
  <div class="portlet-title" id="backbtn">
    <div class="caption"><i
      class=""></i>@lang('layout.InventoryInformation')
    </div>
    <div class="tools"><a
      href="javascript:;" class="collapse" data-original-title="" title=""> </a>
      <a href="#portlet-config" data-toggle="modal" class="config" data-
      original-title="" title=""> </a>


    </div>
  </div>
  <div class="portlet-body">
  <div class="table-scrollable">
      @if(itemPicture() == "true") 

      @if($inventory->photo != Null && $inventory->photo != '')
      <div class="col-md-2" style="padding: 2px !important;">
        <ul class="list-unstyled profile-nav" style="margin: 0px !important;">
            <li>
                <div class="twPc-avatarLink">
                  <a href="{!! asset('uploads/items/' . $inventory->photo) !!}" target='_blank'>
                    <img class=" twPc-avatarImg" src="{!!url('/uploads/items/'.$inventory->photo)!!}" style="width: 100%; height:200px;">
                  </a>
                </div>
            </li>
        </ul>
      </div>
      <div class="col-md-10" style="padding: 2px !important;">
      @else
      <div class="col-md-12" style="padding: 2px !important;">
      @endif
      @else
      <div class="col-md-12" style="padding: 2px !important;">
      @endif
      <table
      class="table table-striped table-bordered table-advance table-hover">
      <thead>
        <tr>
          <th class="text-center"><i class="fa "></i> @lang('layout.ItemCode')</th>
          <th class="text-center"><i class="fa "></i> @lang('layout.ItemName')</th>
          @if(getSerailNumber() =="true")
            <!-- th class=""> @lang('layout.SerialNum')</th -->
          @endif
          <th class="text-center"><i ></i> @lang('layout.Unit')</th>
          <th class="text-center"><i class="fa "></i> @lang('layout.OnHand')</th>
          @permission(['price-create'])
          <th class="text-center"><i class="fa "></i> @lang('layout.AverageCost')</th>
          <th class="text-center"><i class="fa "></i> @lang('layout.SalePrice')</th>
          @endpermission
          <th class="text-center"><i class="fa "></i> @lang('layout.Category')</th>
          <th class="text-center"><i class="fa "></i> @lang('menu.InventoryBrand')</th>
          <th class="text-center"><i class="fa "></i> @lang('layout.CreatedAt')</th>
          <th class="text-center"><i class="fa "></i> @lang('layout.ItemCode')1</th>
          <th class="text-center"><i class="fa "></i> @lang('layout.ItemCode')2</th>
          <th class="text-center"><i class="fa "></i> @lang('layout.ItemCode')3</th>
        </tr>
  </thead>
  <tbody>
    <tr>
      <td class="text-center"> {{ $inventory->number}}  </td>
      <td class="text-center"> {{ $inventory->name}}  </td>
	    @if(getSerailNumber() =="true")
      <!--td class=""> {{ $inventory->serial_number}}  </td-->
      @endif
      <td class="text-center"> {{ $item_info[0]['unit']}}  </td>
      <td class="text-center"> {{ $Onhand}}  </td>
      @permission(['price-create'])
      <td class="text-center"> {{ $cost}}  </td>
      <td class="text-center"> {{ $inventory->rate }}  </td>
      @endpermission
      <td class="text-center"> {{ $inventory->inventoryCategory}}  </td>
      <td class="text-center"> {{ $inventory->inventoryBrand}}  </td>
      <td class="text-center"> {{ convertDate($inventory->created_at)}}  </td>
      <td class="text-center"> {{ $inventory->number1 }}  </td>
      <td class="text-center"> {{ $inventory->number2 }}  </td>
      <td class="text-center"> {{ $inventory->number3 }}  </td>
    </tr>
  </tbody>
</table>      
<table
      class="table table-striped table-bordered table-advance table-hover">
      <thead>
        <tr>
          <th class="text-center"><i class="fa  fa-bars"></i> @lang('layout.IncomeAccount')</th>
          <th class="text-center"><i class="fa  fa-bars"></i> @lang('layout.CostAccount')</th>
          <th class="text-center"><i class="fa  fa-bars"></i> @lang('layout.AssetAccount')</th>
          <th class="text-center"><i class="fa  fa-bars"></i> @lang('layout.Location')</th>
          <th class="text-center"><i class="fa fa-arrow-up"></i> @lang('layout.Max')</th>
          <th class="text-center"><i class="fa fa-arrow-down"></i> @lang('layout.Min')</th> 
          @if(getShowMakeCartan()=="true")
          <th class="text-center"><i class="fa fa-arrow-left"></i> @lang('layout.Length')</th> 
          <th class="text-center"><i class="fa fa-arrows-h"></i> @lang('layout.Width')</th> 
          <th class="text-center"><i class="fa fa-arrow-up"></i> @lang('layout.Height')</th> 
          @endif   
        </tr>
      </thead>
      <tbody>
        <tr>
          <td class="text-center"> {{ $item_info[0]['income'] }}  </td>
          <td class="text-center"> {{ $item_info[0]['cost']}}  </td>
          <td class="text-center"> {{ $item_info[0]['asset'] }}  </td>
          <td class="text-center"> {{ $inventory->item_location}}  </td>
          <td class="text-center"> {{ $inventory->max}}  </td>
          <td class="text-center"> {{ $inventory->min }}  </td>
          @if(getShowMakeCartan()=="true")
          <td class="text-center"> {{ $inventory->length }}  </td>
          <td class="text-center"> {{ $inventory->width }}  </td>
          <td class="text-center"> {{ $inventory->height }}  </td>
          @endif
        </tr>
      </tbody>
</table>
</div>
</div>
</div>
</div>
<div class="tabbable-line tabbable-custom-profile">
  <ul class="nav nav-tabs">  
    <li class="active">
      <a href="#both" data-toggle="tab" id="tab-both">
       <i class="fa  "></i><b> @lang('layout.InventoryDetails') </b></a>
     </li> 
     <li class="">
      <a href="#qut-in" data-toggle="tab" id="tab-qut-in">
       <i class="fa  "></i><b> @lang('layout.QutIn') </b></a>
     </li>
     <li class="">
      <a href="#qut-out" data-toggle="tab" id="tab-qut-out">
       <i class="fa fa-credit-card-alt"></i><b> @lang('layout.QutOut') </b></a>
     </li>
     <li class="">
      <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
  </li>

   </ul>  
   <div class="tab-content padding" style="padding: 0px;">
    <div class="tab-pane active" id="both">
     <div class="row">
      <div class="col-md-12">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
          <div class="portlet-title">
            <div class="caption font-dark">
              <i class="icon-settings font-dark"></i>
              <span class="caption-subject bold uppercase">@lang('layout.InventoryDetails')</span>
            </div>
             <div class="actions">
           <!--  <button type="button" onClick="report_by_type_pdf()" class="btn btn-success" id="print_excell_both"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
        
   
            <button id="print_pdf_both" type="button" onClick="report_by_type_pdf()" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button> -->

             <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success" >
                        <i class="fa fa-print"></i>
                     </a>
                </span> 
      
          </div>
          </div>

          <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" id="both_table">
              <thead>
                <tr>
                  <th>@lang('layout.Type')</th>
                  <th>@lang('layout.Number')</th>
                  <th>@lang('layout.ReferenceNumber')</th>
                  <th>@lang('layout.Member')</th>
                  <th>@lang('layout.Date')</th>
                  <th>@lang('layout.ExpireDate') </th>
                  <th>@lang('layout.SiteName')</th>
                  @if(showLocation()=="true")
                  <th>@lang('layout.Location')</th>
                  @endif
                  @if(getShowCBM()=="true")
                  <th>@lang('layout.CBM')</th>
                  @endif
                  @if(getSaleDescription()=="true")
                  <th>@lang('layout.Description1')</th>
                  <th>@lang('layout.Model')</th>
                  <th>@lang('layout.Color')</th>
                  @endif
                  <th>@lang('layout.Category')</th>
                  <th>@lang('layout.Quantity')</th>
                  <th>@lang('layout.Measure')</th>
                 @if(getM2()!="" && getSubMeasure()!="true")
                  <th>@lang('layout.Unit') 2</th>
                  @endif
                  @if(getShowPurchaseRate() != "false")
                  @if($inventory->type == "workingProgress")
                    <th>@lang('layout.WorkingProgressCost')</th>
                  @elseif($inventory->type == "inventoryAssembly")
                    <th>@lang('layout.BOMCost')</th>
                  @else
                    <th>@lang('layout.Cost')</th>
                  @endif
                    <th>@lang('layout.UnitCost')</th>
                  @endif
                  
                  @if(getShowSaleRate() != "false")
                    <th>@lang('layout.Price')</th>
                  @endif
                  @if(getShowPurchaseRate() != "false")
                    <th>@lang('layout.Total')</th>
                  @endif
                  <th>@lang('layout.User')</th>
                  <th>@lang('layout.Description')</th>

                </tr>
              </thead>
            </table>
          </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
      </div>
    </div>
  </div> 
  <div class="tab-pane" id="qut-in">
   <div class="row">
    <div class="col-md-12">
      <!-- BEGIN EXAMPLE TABLE PORTLET-->
      <div class="portlet light bordered">
        <div class="portlet-title">
          <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>
            <span class="caption-subject bold uppercase">@lang('layout.QutIn')</span>
          </div>
          <div class="actions">

           <!--  <button type="button" onClick="report_by_type_pdf()" id="print_excell_in" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
          
  
            <button type="button" onClick="report_by_type_pdf()" id="print_pdf_in" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button> -->

            <span id="anchore-modal-in">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
            </span>  
 
          </div>
        </div>
        <div class="portlet-body">
          <table class="table table-striped table-bordered table-hover" id="qut-in-table">
            <thead>
              <tr>   
                 <th>@lang('layout.Type')</th>
                 <th>@lang('layout.Number')</th>
                 <th>@lang('layout.ReferenceNumber')</th>
                 <th>@lang('layout.Vendor')</th>
                 <th>@lang('layout.Date')</th>
                 <th>@lang('layout.ExpireDate')</th>
                 <th>@lang('layout.SiteName')</th>
                 @if(showLocation()=="true")
                 <th>@lang('layout.Location')</th>
                 @endif
                 @if(getShowCBM()=="true")
                  <th>@lang('layout.CBM')</th>
                 @endif
                 @if(getSaleDescription()=="true")
                 <th>@lang('layout.Description1')</th>
                 <th>@lang('layout.Model')</th>
                 <th>@lang('layout.Color')</th>
                 @endif
                 <th>@lang('layout.Quantity')</th>
                 <th>@lang('layout.Measure')</th>
                 @if(getM2()!="" && getSubMeasure()!="true")
                 <th>@lang('layout.Unit') 2</th>
                 @endif
                 @if(getShowPurchaseRate() != "false")
                 @if($inventory->type == "workingProgress")
                 <th>@lang('layout.WorkingProgressCost')</th>
                 @elseif($inventory->type == "inventoryAssembly")
                 <th>@lang('layout.BOMCost')</th>
                 @else
                 <th>@lang('layout.Cost')</th>
                 @endif
                 {{-- @permission(['price-create']) --}}
                 <th>@lang('layout.UnitCost')</th>
                 {{-- @endpermission --}}
                  <th>@lang('layout.Total')</th>
                 @endif
                 <th>@lang('layout.User')</th>
                 <th>@lang('layout.Description')</th>

              </tr>
            </thead>
          </table>
        </div>
      </div>
      <!-- END EXAMPLE TABLE PORTLET-->
    </div>
  </div>
</div>
<div class="tab-pane" id="qut-out">
  <div class="row">
    <div class="col-md-12">
      <!-- BEGIN EXAMPLE TABLE PORTLET-->
      <div class="portlet light bordered">
        <div class="portlet-title">
          <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>
            <span class="caption-subject bold uppercase">@lang('layout.QutOut')</span>
          </div>
          <div class="actions">

          <!--   <button type="button" onClick="report_by_type_pdf()" id="print_excell_out" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
          
            <button type="button" onClick="report_by_type_pdf()" id="print_pdf_out" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button> -->

            <span id="anchore-modal-out">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
            </span>
    
          </div>
        </div>
        <div class="portlet-body">
          <table class="table table-striped table-bordered table-hover" id="qut-out-table">
            <thead>
              <tr>  
                 <th>@lang('layout.Type')</th>
                 <th>@lang('layout.Number')</th>
                 <th>@lang('layout.ReferenceNumber')</th>
                 <th>@lang('layout.Customer')</th>
                 <th>@lang('layout.Date')</th>
                 <th>@lang('layout.SiteName')</th>
                 @if(showLocation()=="true")
                 <th>@lang('layout.Location')</th>
                 @endif
                 @if(getShowCBM()=="true")
                  <th>@lang('layout.CBM')</th>
                 @endif
                 @if(getSaleDescription()=="true")
                  <th>@lang('layout.Description1')</th>
                  <th>@lang('layout.Model')</th>
                  <th>@lang('layout.Color')</th>
                 @endif
                 <th>@lang('layout.Quantity')</th>
                 <th>@lang('layout.Measure')</th>
                 @if(getM2()!="" && getSubMeasure()!="true")
                  <th>@lang('layout.Unit') 2</th>
                  @endif
                  @if(getShowSaleRate() != "false")
                    <th>@lang('layout.Price')</th>
                    <th>@lang('layout.Total')</th>
                 @endif
                 <th>@lang('layout.User')</th>
                 <th>@lang('layout.Description')</th>

              </tr>
            </thead>
          </table>
        </div>
      </div>
      <!-- END EXAMPLE TABLE PORTLET-->
    </div>
  </div>
</div>


<div class="tab-pane" id="tab2">
  <div class="portlet light bordered">
      <div class="portlet-title">
          <div class="caption font-dark">
              <i class="icon-settings font-dark"></i>
              <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
          </div>
      </div>
      <div class="portlet-body">
          <div class="portlet light bordered">
              <div class="portlet-body"> 
                  <form role="form" action="{{route('attachment.store')}}" method="post"
                        enctype="multipart/form-data"> 
                      @csrf   
                      <input type="hidden" name="redirect_route" value="inventory.show">
                      <input type="hidden" name="foreign_data_id" value="{{$inventory->id}}">
                      <input type="hidden" name="path" value="uploads/Inventory">
                      <input type="hidden" name="table_name" value="items"> 
                      <div class="row">
                          <div class="col-md-4">
                              <div class="form-group">
                                  <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                  <input type="text" name="title" class="form-control">
                              </div>
                          </div>
                          <div class="col-md-4">
                              <div class="form-group">
                                  <label class="control-label">@lang('layout.Description')</label>
                                  <textarea name="description" class="form-control"></textarea>
                              </div>
                          </div>
                          <div class="col-md-7">
                              <div class="form-group">
                                  <div class="fileinput fileinput-new" data-provides="fileinput">
                                      <div class="fileinput-new thumbnail"
                                           style="width: 200px; height: 150px;">
                                          <img src="" alt=""></div>
                                      <div class="fileinput-preview fileinput-exists thumbnail"
                                           style="max-width: 200px; max-height: 150px; line-height: 10px;"></div>
                                      <div>
                                                  <span class="btn default btn-file">
                                                      <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                      <span class="fileinput-exists">@lang('layout.Change')</span>
                                                      <input type="hidden" value="" name=""><input
                                                              type="file" name="photo"> </span>

                                          <a href="javascript:;" class="btn default fileinput-exists"
                                             data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                      </div>

                                  </div>
                              </div>
                          </div>
                      </div>

                      <div class="margiv-top-10">
                          <button type="button" onclick="regForm(this)"
                                  class="btn green"> @lang('layout.Submit') </button>
                          <a href="{{route('inventory.index')}}"
                             class="btn default">@lang('layout.Cancel')</a>
                      </div>
                  </form>
              </div>
          </div>
          <table class="table table-striped table-bordered table-hover" id="attachment">
              <thead>
              <tr>
                  <th>@lang('layout.AttachmentTitle')</th>
                  <th>@lang('layout.Description')</th>
                  <th>@lang('layout.Action')</th>
              </tr>
              </thead>
          </table>
      </div>
  </div>
</div>  


</div>
</div>


</div>
@endsection
@include('print.modal')
@push('scripts')
<script>
  var cust_rep = {!!customeReportNewData('inventory_show_both')!!};
  var cust_rep_in = {!!customeReportNewData('inventory_show_in')!!};
  var cust_rep_out = {!!customeReportNewData('inventory_show_out')!!};

   Vue.component("v-select", VueSelect.VueSelect);
  var Modal=Vue.component('modal', {
    template: '#modal-template',
    methods: {
      ok: function() {
        this.$emit('ok')
      }
    }
  })
// start app
// start app
var vm=new Vue({
  el: '#app',
  data: {
    showModal: false
  },
  methods:{
    ok:function(){
this.showModal = !this.showModal;
},
close:function(e)
{
  this.showModal = !this.showModal;
},
getModalContent(myData){
//Your other code that launches the modal
this.showModal= true;
this.$nextTick(function(){
  $(document).ready(function(){
    var to, from;
    to = $("#range-to-example").persianDatepicker(modelDate());
    from = $("#range-from-example").persianDatepicker(modelDate());
 
    document.getElementById('dynamic_content').innerHTML=myData;
  });
})
}
},
})


    function report_by_type_pdf(e)
     {
        $('#show-modal').click();
        var myid = event.target.id;
        var type_id=myid;

         ////pdf both
         if(type_id == 'print_pdf_both'){
         var myhtml=`
            <input type="hidden" name="type" value="inventoryDetailWithType"/>
            <input type="hidden" name="qut" value="both"/>
            <input type="hidden" name="id" value="{{$inventory->id}}"/>`;
          $('#d_form').attr('action',"{{route('export.PDFAll')}}"); 
         vm.getModalContent(myhtml);
          }
         ////excell both
         if(type_id == 'print_excell_both'){
        
         var myhtml=`
            <input type="hidden" name="type" value="inventoryDetailWithType"/>
            <input type="hidden" name="qut" value="both"/>
            <input type="hidden" name="id" value="{{$inventory->id}}"/>`;
             $('#d_form').attr('action',"{{route('export.ExcelAll')}}");
         vm.getModalContent(myhtml);
          }
         ////pdf in
         if(type_id == 'print_pdf_in'){
        
         var myhtml=`<input type="hidden" name="type" value="inventoryDetailWithType"/>
                     <input type="hidden" name="qut" value="in"/>
                     <input type="hidden" name="id" value="{{$inventory->id}}"/>`;
             $('#d_form').attr('action',"{{route('export.PDFAll')}}");
         vm.getModalContent(myhtml);
          }


          ////excell in
         if(type_id == 'print_excell_in'){
        
         var myhtml=`<input type="hidden" name="type" value="inventoryDetailWithType"/>
                     <input type="hidden" name="qut" value="in"/>
                     <input type="hidden" name="id" value="{{$inventory->id}}"/>`;
             $('#d_form').attr('action',"{{route('export.ExcelAll')}}");
         vm.getModalContent(myhtml);
          }

        ////pdf out
         if(type_id == 'print_pdf_out'){
        
         var myhtml=`<input type="hidden" name="type" value="inventoryDetailWithType"/>
                     <input type="hidden" name="qut" value="out"/>
                     <input type="hidden" name="id" value="{{$inventory->id}}"/>`;
             $('#d_form').attr('action',"{{route('export.PDFAll')}}");
         vm.getModalContent(myhtml);
          }

                  ////pdf out
         if(type_id == 'print_excell_out'){
        
         var myhtml=`<input type="hidden" name="type" value="inventoryDetailWithType"/>
                     <input type="hidden" name="qut" value="out"/>
                     <input type="hidden" name="id" value="{{$inventory->id}}"/>`;
             $('#d_form').attr('action',"{{route('export.ExcelAll')}}");
         vm.getModalContent(myhtml);
          }
      }


// qut-in

$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
  $('#tab-qut-in').on('shown.bs.tab', function(event){


    $('#qut-in-table').DataTable({  
      scrollCollapse: true,
      serverSide: true,
      paging: true,
      order: [["{{orderByColumn()=='number'?1:4}}", "{{getRowOrder()}}"]],
      responsive:'{{responsiveDataTable()}}',
      pagingType:'{{paginationType()}}',
      retrieve: true,
      ajax:{
        url:'{{route("inventory.show",$inventory->id)}}',
        data:{type:'qut-in'}
      },
      pageLength:'{{getPageRows()}}',
      buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
      columns: [
      { data: 'Type',          name: 'Type',searchable:false },
      { data: 'Number',        name: 'Number',searchable:false },
      { data: 'refNo',         name: 'refNo',searchable:false },
      { data: 'Vendor',        name: 'Vendor',searchable:false },
      { data: 'Date',          name: 'Date' ,searchable:false},
      { data: 'expire_date',          name: 'expire_date' ,searchable:false},
      { data: 'SiteName',      name: 'SiteName',searchable:false },
      @if(showLocation()=="true")
      { data: 'location',      name: 'location',searchable:false },
      @endif
      @if(getShowCBM()=="true")
      { data: 'cbm',      name: 'cbm',searchable:false },
      @endif
      @if(getSaleDescription()=="true")
      { data: 'description1',      name: 'description1',searchable:false },
      { data: 'model',      name: 'model',searchable:false },
      { data: 'color',      name: 'color',searchable:false },
      @endif
      { data: 'Quantity',      name: 'Quantity',searchable:false },
      { data: 'Measure',       name: 'Measure',searchable:false },
      @if(getM2() != "" && getSubMeasure() != "true") {
        data: 'Unit2',
        name: 'Unit2',
        orderable: false,
        searchable: false
      },
      @endif
      @if(getShowPurchaseRate() != "false")
      { data: 'Cost',          name: 'Cost',searchable:false },
      { data: 'total_cost',    name: 'total_cost',searchable:false },
      { data: 'Total',         name: 'Total' ,searchable:false},
      @endif
      { data: 'user',   name: 'user',searchable:false },
      { data: 'Description',   name: 'Description',searchable:false },
      ]
    });  
  });
});



// end qut-in 
// qut-in

$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
  $('#tab-qut-out').on('shown.bs.tab', function(event){

    $('#qut-out-table').DataTable({  
      order: [["{{orderByColumn()=='number'?1:4}}", "{{getRowOrder()}}"]],
      responsive:'{{responsiveDataTable()}}',
     pagingType:'{{paginationType()}}',
      scrollCollapse: true,
      serverSide: true,
      paging: true,
      retrieve: true,
      ajax:{
        url:'{{route("inventory.show",$inventory->id)}}',
        data:{type:'qut-out'}
      },
      pageLength:'{{getPageRows()}}',
      buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
      columns: [
      { data: 'Type',          name: 'Type',searchable:true },
      { data: 'Number',        name: 'Number',searchable:false },
      { data: 'refNo',         name: 'refNo',searchable:false },
      { data: 'Vendor',        name: 'Vendor' ,searchable:false},
      { data: 'Date',          name: 'Date',searchable:false },
      { data: 'SiteName',      name: 'SiteName',searchable:false },
      @if(showLocation()=="true")
      { data: 'location',      name: 'location', searchable:false,orderable:false },
      @endif
      @if(getShowCBM()=="true")
      { data: 'cbm',      name: 'cbm',searchable:false },
      @endif
      @if(getSaleDescription()=="true")
      { data: 'description1',      name: 'description1',searchable:false },
      { data: 'model',      name: 'model',searchable:false },
      { data: 'color',      name: 'color',searchable:false },
      @endif
      { data: 'Quantity',      name: 'Quantity' ,searchable:false},
      { data: 'Measure',       name: 'Measure',searchable:false },
      @if(getM2() != "" && getSubMeasure() != "true") {
        data: 'Unit2',
        name: 'Unit2',
        orderable: false,
        searchable: false
      },
      @endif
      @if(getShowSaleRate() != "false")
      { data: 'sales_price',   name: 'sales_price',searchable:false },
      { data: 'Total',         name: 'Total' ,searchable:false},
      @endif
      { data: 'user',   name: 'user',searchable:false },
      { data: 'Description',   name: 'Description',searchable:false },
      ]

    });  
  });
});



    $('#attachment').DataTable({
      ajax: { 
          url:'{{route("inventory.show",$inventory->id)}}',
          data:{type:'attachment' }
      },

      pageLength:'{{getPageRows()}}',
      responsive:'{{responsiveDataTable()}}',
      pagingType:'{{paginationType()}}',

      scrollCollapse: true,
      serverSide: true,
      paging: true,
      columns: [

          {data: 'title', name: 'attachments.title'},
          {data: 'description', name: 'attachments.description'},
          {data: 'actions', name: 'actions', orderable: false, searchable: false},
      ]
    });    





// end qut-in
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
    $('#both_table').DataTable({ 
      order: [["{{orderByColumn()=='number'?1:4}}", "{{getRowOrder()}}"]],
      responsive:'{{responsiveDataTable()}}',
    pagingType:'{{paginationType()}}',
      serverSide: true,
      paging: true,
      ajax:{
        url:'{{route("inventory.show",$inventory->id)}}',
        data:{type:'both'}
      },
      pageLength:'{{getPageRows()}}',
      buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
      columns: [
      { data: 'Type',          name: 'Type', searchable:false,orderable:true },
      { data: 'Number',        name: 'Number', searchable:false,orderable:true },
      { data: 'refNo',         name: 'refNo', searchable:false,orderable:true },
      { data: 'member',        name: 'member', searchable:false,orderable:false },
      { data: 'Date',          name: 'Date', searchable:false,orderable:true },
      { data: 'expire_date',          name: 'expire_date', searchable:false,orderable:true },
      { data: 'SiteName',      name: 'SiteName', searchable:false,orderable:false },
      @if(showLocation()=="true")
      { data: 'location',      name: 'location', searchable:false,orderable:false },
      @endif
      @if(getShowCBM()=="true")
      { data: 'cbm',      name: 'cbm',searchable:false },
      @endif
      @if(getSaleDescription()=="true")
      { data: 'description1',      name: 'description1',searchable:false },
      { data: 'model',      name: 'model',searchable:false },
      { data: 'color',      name: 'color',searchable:false },
      @endif
      { data: 'cat',           name: 'cat', searchable:false,orderable:false },
      { data: 'Quantity',      name: 'Quantity', searchable:false,orderable:false },
      { data: 'Measure',       name: 'Measure', searchable:false,orderable:false },
      @if(getM2() != "" && getSubMeasure() != "true") {
        data: 'Unit2',
        name: 'Unit2',
        orderable: false,
        searchable: false
      },
      @endif
      @if(getShowPurchaseRate() != "false")
      { data: 'Cost',          name: 'Cost' , searchable:false,orderable:false},
      { data: 'total_cost',    name: 'total_cost',searchable:false },
      @endif
      @if(getShowSaleRate() != "false")
      { data: 'sales_price',   name: 'sales_price', searchable:false,orderable:false },
      @endif
      @if(getShowPurchaseRate() != "false")
      { data: 'Total',         name: 'Total', searchable:false,orderable:false },
      @endif
      { data: 'user',   name: 'user',searchable:false },
      { data: 'Description',   name: 'Description', searchable:false,orderable:false },
      ]

    });  
});


        // for new modal

        var vm_both = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                customReportData:
                [


                 {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                 {Name: '@lang("layout.ReferenceNumber")', column_name: 'ref_no',checkedColumn:(cust_rep.ref_no)?'checked':'',column_percentage:(cust_rep.ref_no___percent)?cust_rep.ref_no___percent:''},
                 {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep.type)?'checked':'',column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''},
                 {Name: '@lang("layout.Member")', column_name: 'member',checkedColumn:(cust_rep.member)?'checked':'',column_percentage:(cust_rep.member___percent)?cust_rep.member___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},

                 {Name: '@lang("layout.SiteName")', column_name: 'site_name',checkedColumn:(cust_rep.site_name)?'checked':'',column_percentage:(cust_rep.site_name___percent)?cust_rep.site_name___percent:''},
                 {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_rep.measure)?'checked':'',column_percentage:(cust_rep.measure___percent)?cust_rep.measure___percent:''},
                 {Name: '@lang("layout.QutIn")', column_name: 'qut_in',checkedColumn:(cust_rep.qut_in)?'checked':'',column_percentage:(cust_rep.qut_in___percent)?cust_rep.qut_in___percent:''},
                 {Name: '@lang("layout.QutOut")', column_name: 'qut_out',checkedColumn:(cust_rep.qut_out)?'checked':'',column_percentage:(cust_rep.qut_out___percent)?cust_rep.qut_out___percent:''},
                 {Name: '@lang("layout.Cost")', column_name: 'purchase_rate',checkedColumn:(cust_rep.purchase_rate)?'checked':'',column_percentage:(cust_rep.purchase_rate___percent)?cust_rep.purchase_rate___percent:''},
                 {Name: '@lang("layout.UnitCost")', column_name: 'unit_cost',checkedColumn:(cust_rep.unit_cost)?'checked':'',column_percentage:(cust_rep.unit_cost___percent)?cust_rep.unit_cost___percent:''},
                 {Name: '@lang("layout.Default_Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},

                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                 {Name: '@lang("layout.TotalQty")', column_name: 'total_qty',checkedColumn:(cust_rep.total_qty)?'checked':'',column_percentage:(cust_rep.total_qty___percent)?cust_rep.total_qty___percent:''},
                 {Name: '@lang("layout.TotalAmount")', column_name: 'total_amount',checkedColumn:(cust_rep.total_amount)?'checked':'',column_percentage:(cust_rep.total_amount___percent)?cust_rep.total_amount___percent:''},
                 {Name: '@lang("layout.TotalBalanceAmount")', column_name: 'total_balance_amount',checkedColumn:(cust_rep.total_balance_amount)?'checked':'',column_percentage:(cust_rep.total_balance_amount___percent)?cust_rep.total_balance_amount___percent:''},
                 {Name: '@lang("layout.TotalBalanceQty")', column_name: 'total_balance_qty',checkedColumn:(cust_rep.total_balance_qty)?'checked':'',column_percentage:(cust_rep.total_balance_qty___percent)?cust_rep.total_balance_qty___percent:''},
                 {Name: '@lang("layout.ExpireDate")', column_name: 'expire_date',checkedColumn:(cust_rep.expire_date)?'checked':'',column_percentage:(cust_rep.expire_date___percent)?cust_rep.expire_date___percent:''},




                  ],
                  cust_rep:cust_rep


            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },


            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm_both.$data.is_show = true;

                }
            }
        });        


        var vm_in = new Vue({
            el: '#print-modal-in',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                customReportData:
                [


                 {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep_in.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                 {Name: '@lang("layout.ReferenceNumber")', column_name: 'ref_no',checkedColumn:(cust_rep_in.ref_no)?'checked':'',column_percentage:(cust_rep.ref_no___percent)?cust_rep.ref_no___percent:''},
                 {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep_in.type)?'checked':'',column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''},
                 {Name: '@lang("layout.Vendor")', column_name: 'vendor',checkedColumn:(cust_rep_in.vendor)?'checked':'',column_percentage:(cust_rep.vendor___percent)?cust_rep.vendor___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep_in.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep_in.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},

                 {Name: '@lang("layout.SiteName")', column_name: 'site_name',checkedColumn:(cust_rep_in.site_name)?'checked':'',column_percentage:(cust_rep.site_name___percent)?cust_rep.site_name___percent:''},
                 {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_rep_in.measure)?'checked':'',column_percentage:(cust_rep.measure___percent)?cust_rep.measure___percent:''},
                 {Name: '@lang("layout.Quantity")', column_name: 'qty',checkedColumn:(cust_rep_in.qty)?'checked':'',column_percentage:(cust_rep.qty___percent)?cust_rep.qty___percent:''},
                 {Name: '@lang("layout.Cost")', column_name: 'purchase_rate',checkedColumn:(cust_rep_in.purchase_rate)?'checked':'',column_percentage:(cust_rep.purchase_rate___percent)?cust_rep.purchase_rate___percent:''},
                 {Name: '@lang("layout.UnitCost")', column_name: 'unit_cost',checkedColumn:(cust_rep_in.unit_cost)?'checked':'',column_percentage:(cust_rep.unit_cost___percent)?cust_rep.unit_cost___percent:''},

                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep_in.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                 {Name: '@lang("layout.TotalQty")', column_name: 'total_qty',checkedColumn:(cust_rep_in.total_qty)?'checked':'',column_percentage:(cust_rep.total_qty___percent)?cust_rep.total_qty___percent:''},
                 {Name: '@lang("layout.ExpireDate")', column_name: 'expire_date_input',checkedColumn:(cust_rep_in.expire_date_input)?'checked':'',column_percentage:(cust_rep.expire_date_input___percent)?cust_rep.expire_date_input___percent:''},
 
                  ],
                  cust_rep_in:cust_rep_in


            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },


            }
        });


        new Vue({
            el: '#anchore-modal-in',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm_in.$data.is_show = true;

                }
            }
        });        

        var vm_out = new Vue({
            el: '#print-modal-out',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                customReportData:
                [


                 {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep_out.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                 {Name: '@lang("layout.ReferenceNumber")', column_name: 'ref_no',checkedColumn:(cust_rep_out.ref_no)?'checked':'',column_percentage:(cust_rep.ref_no___percent)?cust_rep.ref_no___percent:''},
                 {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep_out.type)?'checked':'',column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''},
                 {Name: '@lang("layout.Customer")', column_name: 'customer',checkedColumn:(cust_rep_out.customer)?'checked':'',column_percentage:(cust_rep.customer___percent)?cust_rep.customer___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep_out.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep_out.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},

                 {Name: '@lang("layout.Name")', column_name: 'name',checkedColumn:(cust_rep_out.name)?'checked':'',column_percentage:(cust_rep.name___percent)?cust_rep.name___percent:''},
                 {Name: '@lang("layout.SiteName")', column_name: 'site_name',checkedColumn:(cust_rep_out.site_name)?'checked':'',column_percentage:(cust_rep.site_name___percent)?cust_rep.site_name___percent:''},
                 {Name: '@lang("layout.Measure")', column_name: 'measure',checkedColumn:(cust_rep_out.measure)?'checked':'',column_percentage:(cust_rep.measure___percent)?cust_rep.measure___percent:''},
                 {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_rep_out.quantity)?'checked':'',column_percentage:(cust_rep.quantity___percent)?cust_rep.quantity___percent:''},
                 {Name: '@lang("layout.Price")', column_name: 'price',checkedColumn:(cust_rep_out.price)?'checked':'',column_percentage:(cust_rep.price___percent)?cust_rep.price___percent:''},

                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep_out.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                 {Name: '@lang("layout.TotalQty")', column_name: 'total_qty',checkedColumn:(cust_rep_out.total_qty)?'checked':'',column_percentage:(cust_rep.total_qty___percent)?cust_rep.total_qty___percent:''}




                  ],
                  cust_rep_out:cust_rep_out


            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },


            }
        });


        new Vue({
            el: '#anchore-modal-out',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm_out.$data.is_show = true;

                }
            }
        });

</script>
@endpush