@extends('layouts.app')
@section('style')
	
        <!-- BEGIN PAGE LEVEL STYLES -->
        <link href="{{url('assets/pages/css/search.css')}}" rel="stylesheet" type="text/css" />
        <!-- END PAGE LEVEL STYLES -->
@endsection

@section('content')

<div class="row">

    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('layout.SearchItemsPrice')</span>
			</div>
			<div class=" pull-right">
				<a type="button" class="btn green hidden-print" name="btnprint" onclick="window.print()" /><i class="fa fa-print"></i> @lang('layout.Print')</a>
			</div>

		</div>
		<div class="portlet-body">
			<div class="search-page search-content-4" id="app">
			    <div class="search-bar bordered">
			        <div class="row">
			            <div class="col-lg-10 col-md-10 col-sm-12">
			                <search></search>
			            </div>
			         
			        </div>
			    </div>
			</div>
		</div>
	</div>
</div>
@endsection
@push('scripts')

	<script>
		Vue.component('search',{
			template:`<div class="input-group col-lg-12 col-lg-offset-2 col-md-12 col-md-offset-2 col-sm-12 input-icon">
						
						<select name="inventory_category_id" v-model="category" style="width:50%" class="form-control hidden-print">
							<option value="">@lang('layout.SelectInventoryCategory')</option>
							@foreach($inventoryCategory as  $cat)
								<option value="{{$cat->id}}">{{$cat->name}}</option>
							@endforeach
						</select>
						<div class="col-lg-2 col-md-2 col-sm-2 hidden-print">
							<label class=" control-label">@lang('layout.DuplicateCode')</label>
							<div>
								<label class="mt-checkbox mt-checkbox-outline">
									<input type="checkbox" name="duplicate_code" v-model="duplicate_code" >
									<span></span>
								</label>
							</div>
						</div>
						<div class="col-lg-2 col-md-2 col-sm-2 hidden-print">
							<label class=" control-label">@lang('layout.DetailsAll')</label>
							<div>
								<label class="mt-checkbox mt-checkbox-outline">
									<input type="checkbox" name="details_all" v-model="details_all" >
									<span></span>
								</label>
							</div>
						</div>
	                    <input type="text" class="form-control hidden-print" placeholder="{{__('layout.SearchFor')}}" v-model="searchquery">
						<button type="button" @click="autoComplete" class="btn green hidden-print" style="width:100%;background-color: rgb(80, 129, 141) !important;border: 1px solid rgb(80, 129, 141);color:white !important; " >@lang('layout.Search')</button>
	                    <div  v-if="data_results.length">
					        <table class="table table-bordered table-hover">
					            <thead class="bg-blue">
					                <tr>
					                    <th>
					                    	<i class="fa fa-list-ol"></i>
					                        {{__('layout.Number')}}
					                    </th>
					                    <th>
					                    	<i class="fa fa-briefcase"></i>
					                        {{__('layout.ItemName')}}
					                    </th>
					                    <th>
					                    	<i class="fa fa-briefcase"></i>
					                        {{__('layout.Category')}}
					                    </th>
					                    <th>
					                    	<i class="fa fa-briefcase"></i>
					                        {{__('layout.PartNumber')}} ( {{__('layout.Code')}} )
					                    </th>
					                    <th>
					                    	<i class="fa fa-briefcase"></i>
					                        {{__('layout.Brand')}}
					                    </th>
					                    <th>
					                    	<i class="fa fa-briefcase"></i>
					                        {{__('layout.SuperceedNo')}}
					                    </th>
					                    <th>
					                    	<i class="fa fa-location"></i>
					                        {{__('layout.Location')}}
					                    </th>
					                    <th>
					                    	<i class="fa fa-briefcase"></i>
					                        {{__('layout.MeasureUnit')}}
					                    </th>
										@if(getOtherMeasure() == "true")
					                    <th>
					                    	<i class="fa fa-briefcase"></i>
					                        {{__('layout.OMeasureValue1')}}
					                    </th>
										@endif
										@if(getOtherMeasure2() == "true")
					                    <th>
					                    	<i class="fa fa-briefcase"></i>
					                        {{__('layout.OMeasureValue2')}}
					                    </th>
										@endif
					                    <th>
					                    	<i class="fa fa-briefcase"></i>
					                        {{__('layout.OnHand')}}
					                    </th>
					                    <th>
					                    	<i class="fa fa-money"></i>
					                        {{__('layout.LastPurchaseCost')}}
					                    </th>
					                     <th>
					                    	<i class="fa fa-money"></i>
					                        {{__('layout.LastSaleCost')}}
					                    </th>
					                       <th>
					                    	<i class="fa fa-money"></i>
					                        {{__('layout.Price')}}
					                    </th>
					                       <th>
					                    	<i class="fa "></i>
					                        {{__('layout.Description')}}
					                    </th>
					                    <th class="hidden-print"> </th>
					                   
					                </tr>
					            </thead>
					            <tbody>
					                <tr v-for="result in data_results">
					                    <td class="table-date font-blue">
					                        @{{result.number}}
					                    </td>
					                    <td class="table-date font-blue">
					                        @{{result.name}}
					                    </td>
					                    <td class="table-date font-blue">
					                        @{{result.category_name}}
					                    </td>
					                    <td class="table-date font-blue">
					                        @{{result.code}}
					                    </td>
					                    <td class="table-date font-blue">
					                        @{{result.brand_name}}
					                    </td>
					                    <td class="table-date font-blue">
					                        @{{result.superceed}}
					                    </td>
					                    <td class="table-date font-blue">
					                        @{{result.location}}
					                    </td>
					                    <td class="table-date font-blue">
					                        @{{result.measure}}
					                    </td>
										@if(getOtherMeasure() == "true")
					                    <td class="table-date font-blue">
					                        @{{result.other_m_hand}}
					                    </td>
										@endif
										@if(getOtherMeasure2() == "true")
					                    <td class="table-date font-blue">
					                        @{{result.other_m2_hand}}
					                    </td>
										@endif
					                    <td class="table-date font-blue">
					                        @{{result.quantity}}
					                    </td>
					                    <td class="table-date font-blue">
					                        @{{(result.cost)}}
					                    </td>
					                     <td class="table-date font-blue">
					                        @{{(result.lastPrice)}}
					                    </td>
					                     <td class="table-date font-blue">
					                        @{{(result.itemPrice)}}
					                    </td>
					                     <td class="table-date font-blue">
					                        @{{(result.description)}}
					                    </td>
										<td class="table-date font-blue" class="hidden-print" >
					                        <a :href="result.url" ><span class="fa fa-info-circle"></span></a>
					                    </td>

					                </tr>
					            </tbody>
					        </table>
					    </div>
						
						<div  v-if="data_result_details.length">
					        <table class="table table-bordered table-hover">
					            <thead class="bg-blue">
					                <tr>
										<th>@lang('layout.ItemCode')</th>
										<th>@lang('layout.Item')</th>
										<th>@lang('layout.Type')</th>
										<th>@lang('layout.Number')</th>
										<th>@lang('layout.Member')</th>
										<th>@lang('layout.Code')</th>
										<th>@lang('layout.Date')</th>
										@if(getShowWing()!="false")
										<th>@lang('layout.Wing') </th>
										<th>@lang('layout.ApproxWeight') </th>
										@endif
										@if(getShowSuperceedNo()=="true")
										<th>@lang('layout.SuperceedNo')</th>
										@endif
										@if(showLocation()=="true")
										<th>@lang('layout.Location')</th>
										@endif
										<th>@lang('layout.SiteName')</th>
										<th>@lang('layout.Category')</th>
										<th>@lang('layout.Quantity')</th>
										<th>@lang('layout.Measure')</th>
										<th>@lang('layout.Cost')</th>
										<th>@lang('layout.UnitCost')</th>
										<th>@lang('layout.Price')</th>
										<th>@lang('layout.Total')</th>
										<th class="hidden-print"> </th>
									</tr>
					            </thead>
					            <tbody>
									<tr v-for="result in data_result_details">
										<td class="table-date font-blue"> @{{result.ItemCode}} </td>
										<td class="table-date font-blue"> @{{result.Name}} </td>
										<td class="table-date font-blue"> @{{result.Type}} </td>
										<td class="table-date font-blue"> @{{result.Number}} </td>
										<td class="table-date font-blue"> @{{result.member}} </td>
										<td class="table-date font-blue"> @{{result.Code}} </td>
										<td class="table-date font-blue"> @{{result.Date}} </td>
										@if(getShowWing()!="false")
										<td class="table-date font-blue"> @{{result.khada}} </td>
										<td class="table-date font-blue"> @{{result.approx_weight}} </td>
										@endif
										@if(getShowSuperceedNo()=="true")
										<td class="table-date font-blue"> @{{result.superceed}} </td>
										@endif
										@if(showLocation()=="true")
										<td class="table-date font-blue"> @{{result.location}} </td>
										@endif
										<td class="table-date font-blue"> @{{result.SiteName}} </td>
										<td class="table-date font-blue"> @{{result.cat}} </td>
										<td class="table-date font-blue"> @{{result.Quantity}} </td>
										<td class="table-date font-blue"> @{{result.Measure}} </td>
										<td class="table-date font-blue"> @{{result.Cost}} </td>
										<td class="table-date font-blue"> @{{result.total_cost}} </td>
										<td class="table-date font-blue"> @{{result.sales_price}} </td>
										<td class="table-date font-blue"> @{{result.Total}} </td>
										<td class="table-date font-blue" class="hidden-print" >
					                        <a :href="result.url" ><span class="fa fa-info-circle"></span></a>
					                    </td>
									</tr>
					            </tbody>
					        </table>
					    </div>
	                </div>`, 
	                
	        data: function(){
	        	return {
	        		searchquery: '',
	        		category: '',
	        		duplicate_code:null,
	        		details_all:null,
	        		data_results: [],
	        		data_result_details: []
	        	}
	        },
	        methods: {
	        	autoComplete(){
	        		this.data_results = [];
	        		this.data_result_details = [];
					// console.log('Date',this.duplicate_code);
	        		if(this.searchquery.length || this.category.length || this.duplicate_code != null || this.details_all != null){
	        			axios.get('{{route("searchPriceCodeItem.search")}}',{params:{searchquery:this.searchquery,category:this.category,duplicate_code:this.duplicate_code,details_all:this.details_all}})
	        			.then(response=>{
							// console.log('Date', response.data, this.details_all);
							if (this.details_all != null && this.details_all == true) {
	        					this.data_result_details = response.data;
							} else {
	        					this.data_results = response.data;
							}
	        			});
	        		}
	        	}
	        },
		})


		const app = new Vue({
			el: "#app"
		});
	</script>
@endpush

    