@extends('layouts.app')
@section('style')
	
        <!-- BEGIN PAGE LEVEL STYLES -->
        <link href="{{url('assets/pages/css/search.css')}}" rel="stylesheet" type="text/css" />
        <!-- END PAGE LEVEL STYLES -->
@endsection

@section('content')

<div class="row">

    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('layout.SearchItemsPrice')</span>
            </div>

		</div>
		<div class="portlet-body">
			<div class="search-page search-content-4" id="app">
			    <div class="search-bar bordered">
			        <div class="row">
			            <div class="col-lg-10 col-md-10 col-sm-12">
			                <search></search>
			            </div>
			         
			        </div>
			    </div>
			</div>
		</div>
	</div>
</div>
@endsection
@push('scripts')

	<script>
		Vue.component('search',{
			template:`<div class="input-group col-lg-12 col-lg-offset-2 col-md-12 col-md-offset-2 col-sm-12 input-icon">
						<i class="icon-magnifier"></i>
	                    <input type="text" class="form-control hidden-print" placeholder="{{__('layout.SearchFor')}}" v-model="searchquery" v-on:keyup="autoComplete">
						<div v-if="isLoading">
							<div class="table-scrollable">
								<table class="table">
									<tr>
										<td colspan="3" style="text-align: center">
											<img src="{{asset('ltr/assets/layouts/layout/img/load8.gif')}}" style="width: 80px"/>
										</td>

									</tr>
								</table>
							</div>
						</div>

                	    <div  v-if="data_results.length">
					        <table class="table table-bordered table-hover">
					            <thead class="bg-blue">
					                <tr>
					                    <th>
					                    	<i class="fa fa-list-ol"></i>
					                        {{__('layout.Number')}}
					                    </th>
					                    <th>
					                    	<i class="fa fa-briefcase"></i>
					                        {{__('layout.ItemName')}}
					                    </th>
										@if(searchByCodeLocation()=="true" && showLocation()=="true")
					                    <th>
					                    	<i class="fa fa-briefcase"></i>
					                        {{__('layout.Location')}}
					                    </th>
										@endif
					                    <th>
					                    	<i class="fa fa-briefcase"></i>
					                        {{__('layout.U/M')}}
					                    </th>
					                    <th>
					                    	<i class="fa fa-briefcase"></i>
					                        {{__('layout.OnHand')}}
					                    </th>

					                    <th>
					                    	<i class="fa fa-money"></i>
					                        {{__('layout.LastPurchaseCost')}}
					                    </th>
					                     <th>
					                    	<i class="fa fa-money"></i>
					                        {{__('layout.LastSaleCost')}}
					                    </th>
					                       <th>
					                    	<i class="fa fa-money"></i>
					                        {{__('layout.Price')}}
					                    </th>
					                    <th>
					                    </th>
					                   
					                </tr>
					            </thead>
					            <tbody>
					                <tr v-for="result in data_results">
					                    <td class="table-date font-blue">
					                        @{{result.number}}
					                    </td>
					                    <td class="table-date font-blue">
					                        @{{result.name}}
					                    </td>
										@if(searchByCodeLocation()=="true" && showLocation()=="true")
					                    <td class="table-date font-blue">
					                        @{{result.location}}
					                    </td>
										@endif
					                    <td class="table-date font-blue">
					                        @{{result.measure}}
					                    </td>
					                    <td class="table-date font-blue">
					                        @{{result.quantity}}
					                    </td>
					                    <td class="table-date font-blue">
					                        @{{(result.cost)}}
					                    </td>
					                     <td class="table-date font-blue">
					                        @{{(result.lastPrice)}}
					                    </td>
					                     <td class="table-date font-blue">
					                        @{{(result.itemPrice)}}
					                    </td>
										<td class="table-date font-blue">
					                        <a :href="result.url" class="hidden-print"><span class="fa fa-info-circle"></span></a>
					                    </td>

					                </tr>
					            </tbody>
					        </table>
					    </div>
	                </div>`, 
	                
	        data: function(){
	        	return {
	        		searchquery: '',
	        		data_results: [],
					isLoading:false
	        	}
	        },
	        methods: {
	        	autoComplete(){
	        		this.data_results = [];
					this.isLoading = true;

	        		if(this.searchquery.length){
	        			axios.get('{{route("searchPrice.search")}}',{params:{searchquery:this.searchquery}})
	        			.then(response=>{
	        				this.data_results = response.data;
							this.isLoading = false
	        			});
	        		}
					else{
						this.isLoading = false
					}
	        	}
	        },
		})


		const app = new Vue({
			el: "#app"
		});
	</script>
@endpush

    