@extends('layouts.app')
@section('style')
<style>
  .main-table {
    width: 100%;
    border: solid 1.5px black;
    border-collapse: collapse;
    font-size: 14px;
  }  
</style>
@stop
@section('content')
<div class="row" id="app" v-cloak>
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fa fa-qrcode font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.QrCode') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'export.PDFAll','method'=>'DELETE','class'=>'form-horizontal')) !!}
                <input type="hidden" name="type" value="items_qrCode">
                    <div class="form-body">
                      <div class="row" style="margin-bottom: 20px; padding: 10px;">
                        <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
                          <div class="row" style="padding: 0.5% 1%;">
                            <div class="col-lg-12 margin-bottom-20">
                              <div class="col-lg-12" style="padding: 0px !important;">
                                <div class="col-lg-2 col-md-2 col-sm-12">
                                  <div class="form-group">
                                      <label class="control-label">@lang('menu.InventoryCategory')</label>
                                      <select class="list-style form-control" @change="changeCategory(this)" name="inventory_category_id">
                                        <option value="">@lang('layout.Select')</option>
                                        <option v-for="cat in category" :value="cat.id">@{{cat.name}}</option>
                                      </select>
                                  </div>
                                </div>
                                {{-- <div class="col-lg-3">
                                  <label class="control-label">@lang('layout.QrTextSize')</label>
                                  <input type="number" name="qr_text_size" class="form-control" value="14">
                                </div> --}}
                                {{-- <div class="col-lg-2">
                                  <label class="control-label">@lang('layout.QrTextColor')</label>
                                  <input type="color" name="qr_text_color" class="form-control" value="#000000">
                                </div> --}}
                                <div class="col-lg-2 col-md-2 col-sm-12">
                                  <label class="control-label">@lang('layout.Type')</label>
                                  <select class="list-style form-control" name="qur_type">
                                    <option value="QRCODE" selected>QRCODE</option>
                                    <option value="C39" >CODE 39</option>
                                    <option value="C93" >CODE 93</option>
                                    <option value="C128" >CODE 128</option>
                                    <option value="I25" >I25</option>
                                    <option value="CODABAR" >CODABAR</option>
                                    <option value="PHARMA" >PHARMA</option>
                                    <option value="UPCA" >UPCA</option>
                                    <option value="RMS4CC" >RMS4CC</option>
                                    <option value="PHARMA2T" >PHARMA2T</option>
                                    <option value="KIX" >KIX</option>
                                  </select>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12">
                                  <label class="control-label">@lang('layout.PageHeight')</label>
                                  <input type="number" name="page_height" class="form-control" value="15">
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12">
                                  <label class="control-label">@lang('layout.PageWidth')</label>
                                  <input type="number" name="page_width" class="form-control" value="100">
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12">
                                  <label class="control-label">@lang('layout.MarginTop')</label>
                                  <input type="number" name="margin_top" class="form-control" value="1">
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12">
                                  <label class="control-label">@lang('layout.MarginBottom')</label>
                                  <input type="number" name="margin_bottom" class="form-control" value="1">
                                </div>
                              </div>
                              <div class="col-lg-12" style="padding: 0px !important;">
                                <div class="col-lg-2 col-md-2 col-sm-12">
                                  <label class="control-label">@lang('layout.MarginLeft')</label>
                                  <input type="number" name="margin_left" class="form-control" value="25">
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12">
                                  <label class="control-label">@lang('layout.MarginRight')</label>
                                  <input type="number" name="margin_right" class="form-control" value="25">
                                </div>

                                <div class="col-lg-2 col-md-2 col-sm-12" style="padding: 0px !important;">
                                  <label class="control-label">@lang('layout.NumberOfCopy')</label>
                                  <input type="number" name="amount" class="form-control" v-model="amount">
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12">
                                  <label class="control-label">@lang('layout.NumberPerLine')</label>
                                  <input type="number" name="number_per_line" class="form-control" value="3">
                                </div>
                                
                                <div class="col-lg-2">
                                  <label class="control-label">@lang('layout.ShowQrCode')</label>
                                    <select class="list-style form-control" name="show_qr_code">
                                      <option value="yes" selected>@lang('layout.yes')</option>
                                      <option value="no">@lang('layout.Not')</option>
                                    </select>
                                </div>
                                <div class="col-lg-2">
                                  <label class="control-label">@lang('layout.ShowItemName')</label>
                                    <select class="list-style form-control" name="show_item_name">
                                      <option value="no" selected>@lang('layout.Not')</option>
                                        <option value="yes">@lang('layout.yes')</option>
                                    </select>
                                </div>
                                <div class="col-lg-2">
                                  <label class="control-label">@lang('layout.ShowCode')</label>
                                    <select class="list-style form-control" name="show_item_number">
                                      <option value="no" selected>@lang('layout.Not')</option>
                                        <option value="yes">@lang('layout.yes')</option>
                                    </select>
                                </div>
                                <div class="col-lg-2">
                                  <label class="control-label">@lang('layout.ShowSaleRate')</label>
                                    <select class="list-style form-control" name="show_item_rate">
                                      <option value="no" selected>@lang('layout.Not')</option>
                                        <option value="yes">@lang('layout.yes')</option>
                                    </select>
                                </div>
                                <div class="col-lg-2">
                                  <label class="control-label">@lang('layout.ItemNameInsteadOfSerialNumber')</label>
                                    <select class="list-style form-control" name="item_name_instead_of_serial">
                                      <option value="no" selected>@lang('layout.Not')</option>
                                        <option value="yes">@lang('layout.yes')</option>
                                    </select>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12">
                                  <label class="control-label">@lang('layout.AssemblyCode')</label>
                                  <input type="text" name="build_number" class="form-control">
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12">
                                  <label class="control-label">@lang('layout.BuildDate')</label>
                                  <input type="text" name="build_date" class="form-control">
                                </div>

                                {{-- <div class="col-lg-2">
                                  <label class="control-label">@lang('layout.QrSize')</label>
                                  <select class="list-style form-control" name="qr_size">
                                    <option value="1" >1</option>
                                    <option value="2" >2</option>
                                    <option value="3" >3</option>
                                    <option value="4" selected>4</option>
                                    <option value="5" >5</option>
                                    <option value="6" >6</option>
                                    <option value="7" >7</option>
                                    <option value="8" >8</option>
                                    <option value="9" >9</option>
                                    <option value="10" >10</option>
                                  </select>
                                </div> --}}
                                {{-- <div class="col-lg-2">
                                  <label class="control-label">@lang('layout.Color')</label>
                                  <input type="color" name="qr_color" class="form-control" value="#000000">
                                </div>
                                <div class="col-lg-2">
                                  <label class="control-label">@lang('layout.BackgroundColor')</label>
                                  <input type="color" name="qr_bg_color" class="form-control" value="#ffffff">
                                </div> --}}
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>  
                      <div style=" overflow-y: scroll; height:600px;">             
                      <table class="table table-striped table-bordered table-hover">
                          <thead>
                               <tr style="background-color: rgb(174, 183, 178)">
                                 <th colspan="5">@lang('layout.SelectAll') </th>
                                </tr>
                                <tr style="background-color: rgb(174, 183, 178);">
                                  <th style="background-color: #6b716b;" class="text-center"><input type="checkbox" name="selectedItem" class="form-control" @change="selectAll(this)" v-model="selectedAll"> </th>
                                  <th class="text-center">@lang('layout.Code') </th>
                                  <th class="text-center">@lang('layout.ItemName') </th>
                                  <th class="hidden-xs text-center">@lang('layout.Measure') </th>
                                  <th class="text-center"> @lang('layout.NumberOfCopy') </th>
                              </tr>
                          </thead>
                          <tbody>
                              <tr v-for="(item,index) in items">
                                  <input type="hidden" name="item[]" v-model="item.id">
                                  <td class="highlight text-center" style="background-color: rgb(174, 183, 178);">
                                      <div class="success"></div>
                                      <input type="checkbox" @click="toggleCheck(index)" class="form-control" :checked="item.selected">
                                      <input type="hidden" name="selected_item[]" :value="item.selected">
                                  </td>
                                  <td class="highlight text-center">
                                      <div class="success"></div>
                                      @{{item.number}} 
                                  </td>
                                  <td class="highlight text-center">
                                      <div class="success"></div>
                                      <a href="javascript:;"> @{{item.name}} </a>
                                  </td>
                                  <td class="hidden-xs text-center"> @{{item.measure}} </td>
                                  <td class="text-center"> 
                                    <input type="number" name="amounts[]" class="form-control" :value="!item.selected?null:(Number(amount)+Number(item.amount))">
                                   </td>
                              </tr>
                          </tbody>
                      </table>
                    </div>

                                        
                                   
                     
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                        <a href="{{route('inventorySite.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 

@endsection
@push('scripts')


<script type="text/javascript">

  var inventory_category = {!! $inventory_category !!}
  var items = {!!$items!!}
  new Vue({
    el: '#app',
    data: {
      category:inventory_category,
      items:items,
      amount:1,
      selected_type:'percent',
      selectedAll:false,
      selected_advance_pricing_type:'up',
      selected_pricing_type:'add_new_price'

    },
    methods:
    {
      changeCategory(e)
      {
        var value=e.event.target.value;
        for(var i=0;i<this.items.length;i++)
        { 
           this.items[i].selected=null;
           if(this.items[i].inventory_category_id==value)
           {
              this.items[i].selected=true;
           }
        }
      },
      toggleCheck(index)
      {
        this.items[index].selected=!this.items[index].selected;
      },
      changeType()
      {
        console.log('test 22',this.selected_type);
      },
      amountChange()
      {
        console.log('ssss');
      },
      selectAll(e)
      {
        
         for(var i=0;i<this.items.length;i++)
        { 
           if(this.selectedAll==true)
           {
             this.items[i].selected=true;
           }
           else
           {
               this.items[i].selected=false;
           }
         
        }
      }
    },
    created:function()
    {
        console.log('test 22',this.record);
    }

  });

</script>


@endpush