@extends('layouts.factor-master')

@section('content')
<h3 class="table-caption" style="text-align: center;">@lang('layout.PurchaseItem')</h3>
<table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>

@if($inventory_site_name)
<table class="main-table" style="margin: 6px 0px;" >
   
    <tr>
      @if($inventory_site_name)
      <td>
        <span>@lang('layout.SiteName')</span>: {{$inventory_site_name}}
      </td>
      @endif
   
    </tr>
   
</table>
@endif


<br>
  <table class="main-table">
   
    <thead>
      <tr class="bg">
      <td  class="center" ><div> @lang('layout.Record')</div></td>
      <td  class="center" ><div> @lang('layout.Number') </div></td>
      <td  class="center" ><div> @lang('layout.Date')</div></td>
      <td  class="center" ><div> @lang('layout.Description')</div></td>
      <td  class="center" ><div> @lang('layout.MemberClass') </div></td>
      <td  class="center" ><div> @lang('layout.Vendor')</div></td>
      <td  class="center" ><div> @lang('layout.PurchaseNumber') </div></td>
      <td  class="center" ><div> @lang('layout.PaletNumber') </div></td>
      <td  class="center" ><div> @lang('layout.Name') </div></td>
      @if(!$inventory_site_name) <td  class="center" ><div> @lang('layout.SiteName') </div></td> @endif
      <td  class="center" ><div> @lang('layout.Measure')</div></td>
      @if(systemConfig()[4] != 0 )
      <td  class="center" ><div> @lang('layout.Code')</div></td>
      @if(getShowWing()!="false")
        <td  class="center" ><div> @lang('layout.Wing')</div></td>
      @endif
      @endif
      @if(getShowPurchaseRate() != "false")
        <td  class="center" ><div> @lang('layout.Cost')</div></td>
      @endif
      <td  class="center" ><div> @lang('layout.Quantity')</div></td>
      <td  class="center" ><div> @lang('layout.TransferedQuantity')</div></td>
      <td  class="center" ><div> @lang('layout.RemainQuantity')</div></td>
      @if(getShowPurchaseRate() != "false")
        <td  class="center" ><div> @lang('layout.Total') {{getHomeCurrency()[getCurrencyType()]}}</div></td>
      @endif
    </tr>
    </thead>
    <?php
    $count = 0;
    $total=0;
    $totalPrice=0;
    $items=[];
    ?>
    @foreach($data AS $record)
        <?php
        $total +=$record->Quantity;
        $totalPrice+=$record->Total;
        if(array_key_exists($record->Name, $items))
        {
          $items[$record->Name]['Qty']=$items[$record->Name]['Qty']+$record->Quantity;
          $items[$record->Name]['qut_out']=$items[$record->Name]['qut_out']+$record->qut_out;
          $items[$record->Name]['on_hand']=$items[$record->Name]['on_hand']+$record->on_hand;
        }
        else
        {
            $items[$record->Name]['Qty']=$record->Quantity;
            $items[$record->Name]['qut_out']=$record->qut_out;
            $items[$record->Name]['Measure']=$record->Measure;
            $items[$record->Name]['on_hand']=$record->on_hand;
        }
      ?>
    <tr>
      <td class="center">{{++$count}}</td>
      <!-- <td><div class="center">{{(isset($typee))?round($typee,2):0}}</div></td> -->
      <td class="center">{{$record->Number}}</td>
         <td class="center">
        {{convertDate($record->Date)}}
        </td>
        <td class="center">
        
          @if(isset($report_format))
          {{$record->Description}}
          @else
          {!! wordwrap($record->Description,40,"<br/>\n",false) !!}
          @endif
        </td>
      <td class="center">{{$record->memberClass}}</td>
      <td class="center">{{$record->Vendor}}</td>
      <td class="center">{{$record->Number}}</td>
      <td class="center">{{$record->paletNumber}}</td>
      <td class="center">{{$record->Name}}</td>
      @if(!$inventory_site_name) <td class="center">{{$record->SiteName}}</td> @endif
      <td class="center">{{$record->Measure}}</td>
      @if(systemConfig()[4] != 0 )
      <td class="center">{{$record->Code}}</td>
      @if(getShowWing()!="false")
        <td class="center">{{$record->khada}}</td>
      @endif
      @endif
      @if(getShowPurchaseRate() != "false")
        <td class="center">{{myRound($record->total_cost)}}</td>
      @endif
      <td class="center">{{myRound($record->Quantity)}}</td>
      <td class="center">{{myRound($record->qut_out)}}</td>
      <td class="center">{{myRound($record->on_hand)}}</td>
      @if(getShowPurchaseRate() != "false")
        <td class="center">{{myRound($record->Total)}}</td>
      @endif
     
    </tr>
    @endforeach
</table>
<table class="main-table">
 <tr class="bg">
  <td colspan="6"><div class="center">@lang('layout.PerType')</div></td>
</tr>
<tr>
  <td><div class="center"> @lang('layout.Record')</div></td>
  <td><div class="center"> @lang('layout.Item') </div></td>
  <td><div class="center"> @lang('layout.Measure') </div></td>
  <td><div class="center"> @lang('layout.Quantity') </div></td>
  <td><div class="center"> @lang('layout.TransferedQuantity') </div></td>
  <td><div class="center"> @lang('layout.RemainQuantity') </div></td>
</tr>
<?php
$count=0;
if(isset($items))
{
  foreach($items As $key=>$typee)
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{$typee['Measure']}}</div></td>
    <td><div class="center">{{myRound($typee['Qty'])}}</div></td>
    <td><div class="center">{{myRound($typee['qut_out'])}}</div></td>
    <td><div class="center">{{myRound($typee['on_hand'])}}</div></td>
  </tr>
  <?php
}
}
  ?>
  @if(getShowPurchaseRate() != "false")
  <tr class="bg">
    <td colspan="6"><div class="center">{{myRound($totalPrice)}} {{getHomeCurrency()[getCurrencyType()]}}</div></td>
  </tr>
  @endif
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection