@extends('layouts.factor-master')

@section('content')
<h3 class="table-caption" style="text-align: center;">@lang('layout.OutItems')</h3>
<table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>

@if($inventory_site_name)
<table class="main-table" style="margin: 6px 0px;" >
   
    <tr>
      @if($inventory_site_name)
      <td>
        <span>@lang('layout.SiteName')</span>: {{$inventory_site_name}}
      </td>
      @endif
   
    </tr>
   
</table>
@endif

<br>
  <table class="main-table">
   
    <thead>
      <tr class="bg">
      <td  class="center" ><div> @lang('layout.Record') </div></td>
      <td  class="center" ><div> @lang('layout.Type') </div></td>
      <td  class="center" ><div> @lang('layout.Number') </div></td>
      <td  class="center" ><div> @lang('layout.Date')</div></td>
      <td  class="center" ><div> @lang('layout.Customer')</div></td>
      <td  class="center" ><div> @lang('layout.Name') </div></td>
      @if(!$inventory_site_name)  <td  class="center" ><div> @lang('layout.SiteName') </div></td> @endif
      <td  class="center" ><div> @lang('layout.Measure')</div></td>
      @if(systemConfig()[4] != 0 )
      <td  class="center" ><div> @lang('layout.Code')</div></td>
      @if(getShowWing()!="false")
        <td  class="center" ><div> @lang('layout.Wing')</div></td>
      @endif
      @endif
      @if(getShowSaleRate() != "false") 
        <td  class="center" ><div> @lang('layout.Price')</div></td>
      @endif
      <td  class="center" ><div> @lang('layout.Quantity')</div></td>
      @if(getShowSaleRate() != "false") 
        <td  class="center" ><div> @lang('layout.Total')</div></td>
      @endif
      <td  class="center" ><div> @lang('layout.Description')</div></td>
    </tr>
    </thead>
    <?php
    $count = 0;
    $total=0;
    $totalPrice=0;
    $type=[];
    ?>
    @foreach($data AS $record)
        <?php
        $total +=$record->Quantity;
        $totalPrice+=$record->Total;
        if(array_key_exists($record->cat, $type))
        {

            $type[$record->cat]=$type[$record->cat]+$record->Quantity;
            
        }
        else
        {
            $type[$record->cat]=$record->Quantity;
        }
      ?>
    <tr>
      <td class="center">{{++$count}}</td>
      <!-- <td><div class="center">{{(isset($typee))?round($typee,2):0}}</div></td> -->
      <td class="center">
        
         <span class="center">{{__('type.'.ucfirst($record->Type))}}</span>
      
        </td>
        <td class="center">{{$record->Number}}</td>
         <td class="center">
        {{convertDate($record->Date)}}
        </td>
      <td class="center">{{$record->Vendor}}</td>
      <td class="center">{{$record->Name}}</td>
      @if(!$inventory_site_name) <td class="center">{{$record->SiteName}}</td> @endif
      <td class="center">{{$record->Measure}}</td>
      @if(systemConfig()[4] != 0 )
      <td class="center">{{$record->Code}}</td>
      @if(getShowWing()!="false")
        <td class="center">{{$record->khada}}</td>
      @endif
      @endif
      @if(getShowSaleRate() != "false")
        <td class="center">{{myRound($record->sales_price)}}</td>
      @endif
      <td class="center">{{myRound($record->Quantity)}}</td>
      @if(getShowSaleRate() != "false")
        <td class="center">{{myRound($record->Total)}}</td>
      @endif
      <td class="center">

        @if(isset($report_format))
        {{$record->Description}}
        @else
        {!! wordwrap($record->Description,40,"<br/>\n",false) !!}
        @endif


      </td>
    </tr>
    @endforeach
</table>
<table class="main-table">
 <tr class="bg">
  <td colspan="4"><div class="center">@lang('layout.PerType')</div></td>
</tr>
<tr>
  <td><div class="center"> #</div></td>
  <td><div class="center"> @lang('layout.Type') </div></td>
  <td><div class="center"> @lang('layout.Total') </div></td>
   @if(getShowSaleRate() != "false")
    <td><div class="center"> @lang('layout.TotalPrice') </div></td>
   @endif
</tr>
<?php
$count=0;

if(isset($type))
{
  foreach($type As $key=>$typee)
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{$total}}</div></td>
     @if(getShowSaleRate() != "false")
      <td><div class="center">{{$totalPrice}} {{getHomeCurrency()[getCurrencyType()]}}</div></td>
      @endif

  </tr>
  <?php
}
}

  ?>


</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection