@extends('layouts.app')
@section('style')
<style type="text/css">
  .modal-container {
    width: 30%;
  }
</style>
@stop
@section('content')
@include('inventories.modal')
<!-- BEGIN TAB PORTLET-->
<!-- app-->
<div id="app" v-cloak>
  <form id="d_form" action="{{route('export.PDFAll')}}" method="POST">
    <input type="hidden" name="_method" value="DELETE">
    {!! Form::token() !!}
    <input type="hidden" name="type" value="inventoryDetailWithTypeRoll" />
    <input type="hidden" name="qut" value="both" />
    <input type="hidden" name="id" value="{{$inventory->id}}" />
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false">
      <div slot="body">
        <div class="row">
          <div class="form-group" id="dynamic_content">
          </div>
        </div>
        <div class="row">
          <div class="col-md-4">
            <div class="form-group">
              <label class="control-label ">@lang('layout.Code') </label>
              <v-select class="vue-select2" v-model="selectedItem" label="code" @search="onItemSearch" :options="itemlist">
              </v-select>
              <input type="hidden" name="code" v-model.number="(!selectedItem)?null:selectedItem.code">
              <input type="hidden" name="m_stocks_in_id" v-model.number="(!selectedItem)?null:selectedItem.id">
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-group">
              <label class="control-label ">@lang('layout.InventorySite') </label>
              <select name="inventory_site_id" id="" class="form-control">
                <option value="">@lang('layout.SelectInventorySite')</option>
                @foreach($inventorySite as $site)
                <option value="{{$site->id}}">{{$site->name}}</option>
                @endforeach
              </select>
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-group">
              <label class="control-label ">@lang('layout.Location') </label>
              <input type="text" name="location" class="form-control" autocomplete="off">
            </div>
          </div>
        </div>
        <div class="row">
          <div class="form-group">
            <div class="col-md-12">
              <label class="control-label"> @lang('layout.Date')</label>
              <div class="input-group">
                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                <span class="input-group-addon">@lang('layout.To') </span>
                <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">
              </div>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="form-group">
            <div class="col-md-12">
              <div class="form-group">
                <h3> <label class="control-label"> @lang('layout.OnHand') <input name="onHand" type="checkbox" value="true"> </label> </h3>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div slot="footer">
        <button type="submit" class="btn btn-success" @click="ok">
          @lang('layout.Submit')
        </button>
        <button type="button" class="btn btn-danger" @click="close">
          @lang('layout.Cancel')
        </button>
      </div>
    </modal>
  </form>
</div>
<!-- app -->
<div class="portlet">
  <div class="portlet-title">
    <div class="caption"><i class=""></i>@lang('layout.InventoryInformation')
    </div>
    <div class="tools"><a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
      <a href="#portlet-config" data-toggle="modal" class="config" data- original-title="" title=""> </a>
    </div>
  </div>
  <div class="portlet-body">
  <div class="table-scrollable">
      @if(itemPicture() == "true") 
      @if($inventory->photo != Null && $inventory->photo != '')
      <div class="col-md-2" style="padding: 2px !important;">
        <ul class="list-unstyled profile-nav" style="margin: 0px !important;">
            <li>
                <div class="twPc-avatarLink">
                  <a href="{!! asset('uploads/items/' . $inventory->photo) !!}" target='_blank'>
                    <img class=" twPc-avatarImg" src="{!!url('/uploads/items/'.$inventory->photo)!!}" style="width: 100%; height:200px; border-radius: 10px;">
                  </a>
                </div>
            </li>
        </ul>
      </div>
      <div class="col-md-10" style="padding: 2px !important;">
      @else
      <div class="col-md-12" style="padding: 2px !important;">
      @endif
      @else
      <div class="col-md-12" style="padding: 2px !important;">
      @endif
      <table class="table table-striped table-bordered table-advance table-hover">
        <thead>
          <tr>
            <th class="text-center"><i class="fa  fa-bars"></i> @lang('layout.Item')</th>
            <th class="text-center"><i class="fa fa-briefcase"></i> @lang('layout.ItemName')
            </th>
            <th class="text-center"><i ></i> @lang('layout.Unit')</th>
            <th class="text-center"><i class="fa  fa-bars"></i> @lang('layout.OnHand')</th>
            <th class="text-center"><i class="fa  fa-bars"></i> @lang('layout.TotalCode')</th>
            <th class="text-center"><i class="fa  fa-bars"></i> @lang('layout.AverageCost')</th>
            @if(getShowWing()!="false") <th class="text-center"><i class="fa  fa-bars"></i> @lang('layout.Wing')</th> @endif
            @if(getOtherMeasure()=="true")
                <th class="text-center">{{ $inventory->o_measure_name}}</th>
            @endif
            @if(getOtherMeasure2()=="true")
                <th class="text-center">{{ $inventory->other_um_id}}</th>
            @endif
            <th class="text-center"><i class="fa  fa-bars"></i> @lang('layout.Category')</th>
            <th class="text-center"><i class="fa  fa-bars"></i> @lang('menu.InventoryBrand')</th>
            <th class="text-center"><i class="fa  fa-bars"></i> @lang('layout.Location')</th>
            <th class="text-center"><i class="fa fa-dollar"></i> @lang('layout.Rate')
            </th>
            <th class="text-center">
              <i class="fa fa-clock-o"></i> @lang('layout.CreatedAt')
            </th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td class="text-center"> {{ $inventory->number}} </td>
            <td class="text-center"> {{ $inventory->name}} @if(systemConfig()[9] == 0 ) -@lang('layout.Gauge')({{ $inventory->gauge}}) @endif </td>
            <td class="text-center"> {{ $item_info[0]['unit']}}  </td>
            <td class="text-center"> {{ ($inventoryOnHandRoll)?myRound($inventoryOnHandRoll->onHand):0}} </td>
            <td class="text-center"> {{ $OnHandCode}} </td>
            <td class="text-center"> {{ ($inventoryOnHandRoll)?myRound($inventoryOnHandRoll->averageCost):0}} </td>
            @if(getShowWing()!="false") <td class="text-center"> {{ ($inventoryOnHandRoll)?myRound($inventoryOnHandRoll->on_hand_khada):0}} </td> @endif
            @if(getOtherMeasure()=="true")
            <td class="text-center"> {{ ($inventoryOnHandRoll)?$inventoryOnHandRoll->other_measure:0}} </td>
            @endif
            @if(getOtherMeasure2()=="true")
            <td class="text-center"> {{ ($inventoryOnHandRoll)?$inventoryOnHandRoll->other_measure2:0}} </td>
            @endif
            <td class="text-center"> {{ $inventory->inventoryCategory}} </td>
            <td class="text-center"> {{ $inventory->inventoryBrand}} </td>
            <td class="text-center"> {{ $inventory->item_location}} </td>
            <td class="text-center"> {{ $inventory->rate }} </td>
            <td class="text-center"> {{ convertDate($inventory->created_at)}} </td>
          </tr>
        </tbody>
      </table>

      <table class="table table-striped table-bordered table-advance table-hover">
        <thead>
          <tr>
            <th class="text-center"><i class="fa  fa-bars"></i> @lang('layout.IncomeAccount')</th>
            <th class="text-center"><i class="fa  fa-bars"></i> @lang('layout.CostAccount')</th>
            <th class="text-center"><i class="fa  fa-bars"></i> @lang('layout.AssetAccount')</th>
            <th class="text-center"><i class="fa fa-arrow-up"></i> @lang('layout.Max')</th>
            <th class="text-center"><i class="fa fa-arrow-down"></i> @lang('layout.Min')</th> 
          </tr>
        </thead>
        <tbody>
          <tr>
            <td class="text-center"> {{ $item_info[0]['income'] }}  </td>
            <td class="text-center"> {{ $item_info[0]['cost']}}  </td>
            <td class="text-center"> {{ $item_info[0]['asset'] }}  </td>
            <td class="text-center"> {{ $inventory->max}}  </td>
            <td class="text-center"> {{ $inventory->min }}  </td>
          </tr>
        </tbody>
      </table>

    </div>
  </div>
</div>
<div class="tabbable-line tabbable-custom-profile">
  <ul class="nav nav-tabs">
    <li class="active">
      <a href="#both" data-toggle="tab" id="tab-both">
        <i class="fa fa-money"></i><b> @lang('layout.InventoryDetails') </b></a>
    </li>
    <li class="">
      <a href="#qut-in" data-toggle="tab" id="tab-qut-in">
        <i class="fa fa-money"></i><b> @lang('layout.QutIn') </b></a>
    </li>
    <li class="">
      <a href="#qut-out" data-toggle="tab" id="tab-qut-out">
        <i class="fa fa-credit-card-alt"></i><b> @lang('layout.QutOut') </b></a>
    </li>
    <li class="">
      <a href="#qut-onhand" data-toggle="tab" id="tab-qut-onhand">
        <i class="fa fa-credit-card-alt"></i><b> @lang('layout.OnHandCode') </b></a>
    </li>
    <li class="">
      <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
  </li>

  </ul>
  <div class="tab-content padding" style="padding: 0px;">
    <div class="tab-pane active" id="both">
      <div class="row">
        <div class="col-md-12">
          <!-- BEGIN EXAMPLE TABLE PORTLET-->
          <div class="portlet light bordered">
            <div class="portlet-title">
              <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('layout.InventoryDetails')</span>
              </div>
              <div class="actions">
                <button type="button" onClick="report_by_type_pdf()" class="btn btn-success" id="print_excell_both"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                <button id="print_pdf_both" type="button" onClick="report_by_type_pdf()" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
              </div>
            </div> 
            <div class="portlet-body">
              <table class="table table-striped table-bordered table-hover" id="both_table">
                <thead>
                  <tr>
                    <th>@lang('layout.Type')</th>
                    <th>@lang('layout.Number')</th>
                    <th>@lang('layout.Code')</th>
                    <th>@lang('layout.ContractCode')</th>
                    <th>@lang('layout.Member')</th>
                    <th>@lang('layout.Date')</th>
                    <th>@lang('layout.SiteName')</th>
                    <th>@lang('layout.Category')</th>
                    @if(getOtherMeasure()=="true")
                        <th>@lang('layout.OMeasureValue1')</th>
                    @endif
                    @if(getOtherMeasure2()=="true")
                        <th>@lang('layout.OMeasureValue2')</th>
                    @endif
                    @if(systemConfig()[9] == 0 || getCubicMetereItems()=="true")
                    <th>@lang('layout.Length') </th>
                    <th>@lang('layout.Width') </th>
                    @endif
                    @if(getCubicMetereItems()=="true")
                    <th>@lang('layout.Gauge') </th>
                    @endif
                    @if(getShowWing()!="false")
                    <th>@lang('layout.Wing') </th>
                    <th>@lang('layout.ApproxWeight') </th>
                    @endif
                    @if(systemConfig()[9] != 0 )
                    <th>@lang('layout.Photo') </th>
                    <th>@lang('layout.ExpireDate') </th>
                    @endif
                    @if(getShowSuperceedNo()=="true")
                    <th>@lang('layout.SuperceedNo')</th>
                    @endif
                    @if(itemBrand()=="true")
                    <th>@lang('layout.Brand')</th>
                    @endif
                    @if(showLocation()=="true")
                    <th>@lang('layout.Location')</th>
                    @endif
                    <th>@lang('layout.Quantity')</th>
                    <th>@lang('layout.Measure')</th>
                    @if(getM2()!="" && getSubMeasure()!="true")
                    <th>@lang('layout.Unit') 2</th>
                    @endif
                    @if(getShowPurchaseRate() != "false")
                    @if($inventory->type == "workingProgress")
                    <th>@lang('layout.WorkingProgressCost')</th>
                    @elseif($inventory->type == "inventoryAssembly")
                      <th>@lang('layout.BOMCost')</th>
                    @else
                      <th>@lang('layout.Cost')</th>
                    @endif
                      <th>@lang('layout.UnitCost')</th>
                    @endif
                    
                    @if(getShowSaleRate() != "false") 
                      <th>@lang('layout.Price')</th>
                    @endif
                    @if(getShowPurchaseRate() != "false")
                       <th>@lang('layout.Total')</th>
                    @endif
                    <th>@lang('layout.User')</th>
                    <th>@lang('layout.Description')</th>

                  </tr>
                </thead>
              </table>
            </div>
          </div>
          <!-- END EXAMPLE TABLE PORTLET-->
        </div>
      </div>
    </div>
    <div class="tab-pane" id="qut-in">
      <div class="row">
        <div class="col-md-12">
          <!-- BEGIN EXAMPLE TABLE PORTLET-->
          <div class="portlet light bordered">
            <div class="portlet-title">
              <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('layout.QutIn')</span>
              </div>
              <div class="actions">

                <button type="button" onClick="report_by_type_pdf()" id="print_excell_in" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>


                <button type="button" onClick="report_by_type_pdf()" id="print_pdf_in" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
              </div>
            </div>
            <div class="portlet-body">
              <table class="table table-striped table-bordered table-hover" id="qut-in-table">
                <thead>
                  <tr>
                    <th>@lang('layout.Type')</th>
                    <th>@lang('layout.Number')</th>
                    <th>@lang('layout.Code')</th>
                    <th>@lang('layout.ContractCode')</th>
                    <th>@lang('layout.Date')</th>
                    @if(getOtherMeasure()=="true")
                        <th>@lang('layout.OMeasureValue1')</th>
                    @endif
                    @if(getOtherMeasure2()=="true")
                        <th>@lang('layout.OMeasureValue2')</th>
                    @endif
                    @if(systemConfig()[9] == 0 || getCubicMetereItems()=="true")
                    <th>@lang('layout.Length') </th>
                    <th>@lang('layout.Width') </th>
                    @endif
                    @if(getCubicMetereItems()=="true")
                    <th>@lang('layout.Gauge') </th>
                    @endif
                    @if(getShowWing()!="false")
                    <th>@lang('layout.Wing') </th>
                    <th>@lang('layout.ApproxWeight') </th>
                    @endif
                    @if(systemConfig()[9] != 0 )
                    <th>@lang('layout.Photo') </th>
                    <th>@lang('layout.ExpireDate') </th>
                    @endif
                    @if(getShowSuperceedNo()=="true")
                    <th>@lang('layout.SuperceedNo')</th>
                    @endif
                    @if(itemBrand()=="true")
                    <th>@lang('layout.Brand')</th>
                    @endif
                    @if(showLocation()=="true")
                    <th>@lang('layout.Location')</th>
                    @endif
                    <th>@lang('layout.Default_Rate')</th>
                    <th>@lang('layout.Vendor')</th>
                    <th>@lang('layout.SiteName')</th>
                    <th>@lang('layout.Quantity')</th>
                    <th>@lang('layout.Measure')</th>
                    @if(getM2()!="" && getSubMeasure()!="true")
                    <th>@lang('layout.Unit') 2</th>
                    @endif
                    @if(getShowPurchaseRate() != "false")
                    @if($inventory->type == "workingProgress")
                    <th>@lang('layout.WorkingProgressCost')</th>
                    @elseif($inventory->type == "inventoryAssembly")
                      <th>@lang('layout.BOMCost')</th>
                    @else
                      <th>@lang('layout.Cost')</th>
                    @endif
                    <th>@lang('layout.UnitCost')</th>
                    <th>@lang('layout.Total')</th>
                    @endif
                    <th>@lang('layout.User')</th>
                    <th>@lang('layout.Description')</th>

                  </tr>
                </thead>
              </table>
            </div>
          </div>
          <!-- END EXAMPLE TABLE PORTLET-->
        </div>
      </div>
    </div>
    <div class="tab-pane" id="qut-out">
      <div class="row">
        <div class="col-md-12">
          <!-- BEGIN EXAMPLE TABLE PORTLET-->
          <div class="portlet light bordered">
            <div class="portlet-title">
              <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('layout.QutOut')</span>
              </div>
              <div class="actions">

                <button type="button" onClick="report_by_type_pdf()" id="print_excell_out" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>

                <button type="button" onClick="report_by_type_pdf()" id="print_pdf_out" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>

              </div>
            </div>
            <div class="portlet-body">
              <table class="table table-striped table-bordered table-hover" id="qut-out-table">
                <thead>
                  <tr>
                    <th>@lang('layout.Type')</th>
                    <th>@lang('layout.Number')</th>
                    <th>@lang('layout.Code')</th>
                    <th>@lang('layout.Date')</th>
                    @if(getOtherMeasure()=="true")
                        <th>@lang('layout.OMeasureValue1')</th>
                    @endif
                    @if(getOtherMeasure2()=="true")
                        <th>@lang('layout.OMeasureValue2')</th>
                    @endif
                    @if(systemConfig()[9] == 0 || getCubicMetereItems()=="true")
                    <th>@lang('layout.Length') </th>
                    <th>@lang('layout.Width') </th>
                    @endif
                    @if(getCubicMetereItems()=="true")
                    <th>@lang('layout.Gauge') </th>
                    @endif
                    @if(getShowWing()!="false")
                    <th>@lang('layout.Wing') </th>
                    <th>@lang('layout.ApproxWeight') </th>
                    @endif
                    @if(systemConfig()[9] != 0 )
                    <th>@lang('layout.Photo') </th>
                    @endif
                    <th>@lang('layout.Customer')</th>
                    <th>@lang('layout.SiteName')</th>
                    <th>@lang('layout.Quantity')</th>
                    <th>@lang('layout.Measure')</th>
                    @if(getM2()!="" && getSubMeasure()!="true")
                    <th>@lang('layout.Unit') 2</th>
                    @endif
                    @if(getShowSaleRate() != "false")
                      <th>@lang('layout.Price')</th>
                      <th>@lang('layout.Total')</th>
                    @endif
                    <th>@lang('layout.User')</th>
                    <th>@lang('layout.Description')</th>

                  </tr>
                </thead>
              </table>
            </div>
          </div>
          <!-- END EXAMPLE TABLE PORTLET-->
        </div>
      </div>
    </div>
    <div class="tab-pane" id="qut-onhand">
      <div class="row">
        <div class="col-md-12">
          <!-- BEGIN EXAMPLE TABLE PORTLET-->
          <div class="portlet light bordered">
            <div class="portlet-title">
              <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('layout.OnHandCode')</span>
              </div>
              <div class="actions">

              <button type="button" onClick="report_by_type_pdf()" class="btn btn-success" id="print_excell_both"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
              <button id="print_pdf_both" type="button" onClick="report_by_type_pdf()" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>

              </div>
            </div>
            <div class="portlet-body">
              <table class="table table-striped table-bordered table-hover" id="qut-onhand-table">
                <thead>
                <tr>
                    <th>@lang('layout.Type')</th>
                    <th>@lang('layout.Code')</th>
                    <th>@lang('layout.Date')</th>
                    @if(getOtherMeasure()=="true")
                        <th>@lang('layout.OMeasureValue1')</th>
                    @endif
                    @if(getOtherMeasure2()=="true")
                        <th>@lang('layout.OMeasureValue2')</th>
                    @endif
                    @if(systemConfig()[9] == 0 || getCubicMetereItems()=="true")
                    <th>@lang('layout.Length') </th>
                    <th>@lang('layout.Width') </th>
                    @endif
                    @if(getCubicMetereItems()=="true")
                    <th>@lang('layout.Gauge') </th>
                    @endif
                    @if(getShowWing()!="false")
                    <th>@lang('layout.Wing') </th>
                    <th>@lang('layout.ApproxWeight') </th>
                    @endif
                    @if(systemConfig()[9] == 1 )
                    <th>@lang('layout.Photo') </th>
                    <th>@lang('layout.ExpireDate') </th>
                    @endif
                    @if(getShowSuperceedNo()=="true")
                    <th>@lang('layout.SuperceedNo')</th>
                    @endif
                    @if(itemBrand()=="true")
                    <th>@lang('layout.Brand')</th>
                    @endif
                    @if(showLocation()=="true")
                    <th>@lang('layout.Location')</th>
                    @endif
                    <th>@lang('layout.Default_Rate')</th>
                    <th>@lang('layout.SiteName')</th>
                    <th>@lang('layout.Quantity')</th>
                    <th>@lang('layout.Measure')</th>
                    @if(getM2()!="" && getSubMeasure()!="true")
                    <th>@lang('layout.Unit') 2</th>
                    @endif
                    @if(systemConfig()[21] == 1 )
                    <th>@lang('layout.UnitPrice') </th>
                    @endif
                    @if(getShowPurchaseRate() != "false")
                    @if($inventory->type == "workingProgress")
                    <th>@lang('layout.WorkingProgressCost')</th>
                    @elseif($inventory->type == "inventoryAssembly")
                      <th>@lang('layout.BOMCost')</th>
                    @else
                      <th>@lang('layout.Cost')</th>
                    @endif
                    <th>@lang('layout.UnitCost')</th>
                    <th>@lang('layout.Total')</th>
                    @endif
                    <th>@lang('layout.User')</th>
                    <th>@lang('layout.Description')</th>

                  </tr>
                </thead>
              </table>
            </div>
          </div>
          <!-- END EXAMPLE TABLE PORTLET-->
        </div>
      </div>
    </div>



    <div class="tab-pane" id="tab2">
      <div class="portlet light bordered">
          <div class="portlet-title">
              <div class="caption font-dark">
                  <i class="icon-settings font-dark"></i>
                  <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
              </div>
          </div>
          <div class="portlet-body">
              <div class="portlet light bordered">
                  <div class="portlet-body"> 
                      <form role="form" action="{{route('attachment.store')}}" method="post"
                            enctype="multipart/form-data"> 
                          @csrf   
                          <input type="hidden" name="redirect_route" value="inventory.m_show">
                          <input type="hidden" name="foreign_data_id" value="{{$inventory->id}}">
                          <input type="hidden" name="path" value="uploads/Inventory">
                          <input type="hidden" name="table_name" value="items"> 
                          <div class="row">
                              <div class="col-md-4">
                                  <div class="form-group">
                                      <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                      <input type="text" name="title" class="form-control">
                                  </div>
                              </div>
                              <div class="col-md-4">
                                  <div class="form-group">
                                      <label class="control-label">@lang('layout.Description')</label>
                                      <textarea name="description" class="form-control"></textarea>
                                  </div>
                              </div>
                              <div class="col-md-7">
                                  <div class="form-group">
                                      <div class="fileinput fileinput-new" data-provides="fileinput">
                                          <div class="fileinput-new thumbnail"
                                               style="width: 200px; height: 150px;">
                                              <img src="" alt=""></div>
                                          <div class="fileinput-preview fileinput-exists thumbnail"
                                               style="max-width: 200px; max-height: 150px; line-height: 10px;"></div>
                                          <div>
                                                      <span class="btn default btn-file">
                                                          <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                          <span class="fileinput-exists">@lang('layout.Change')</span>
                                                          <input type="hidden" value="" name=""><input
                                                                  type="file" name="photo"> </span>
    
                                              <a href="javascript:;" class="btn default fileinput-exists"
                                                 data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                          </div>
    
                                      </div>
                                  </div>
                              </div>
                          </div>
    
                          <div class="margiv-top-10">
                              <button type="button" onclick="regForm(this)"
                                      class="btn green"> @lang('layout.Submit') </button>
                              <a href="{{route('inventory.index')}}"
                                 class="btn default">@lang('layout.Cancel')</a>
                          </div>
                      </form>
                  </div>
              </div>
              <table class="table table-striped table-bordered table-hover" id="attachment">
                  <thead>
                  <tr>
                      <th>@lang('layout.AttachmentTitle')</th>
                      <th>@lang('layout.Description')</th>
                      <th>@lang('layout.Action')</th>
                  </tr>
                  </thead>
              </table>
          </div>
      </div>
    </div>  
    


  </div>
</div>




</div>
@endsection
@push('scripts')
<script>
  Vue.component("v-select", VueSelect.VueSelect);
  var Modal = Vue.component('modal', {
    template: '#modal-template',
    methods: {
      ok: function() {
        this.$emit('ok')
      }
    }
  })
  // start app
  // start app
  var vm = new Vue({
    el: '#app',
    data: {
      showModal: false,
      selectedItem: null,
      itemlist: [],
    },
    methods: {
      //ajax call to get items
      onItemSearch(search) {
        axios.get("{{route('callMethod.search')}}", {
            params: {
              method_name: 'searchCode',
              'inventory_id': "{{$inventory->inventory_id}}",
              'keyword': search,
            }
          })
          .then(function(response) {
            this.itemlist = [];
            if (response.data.length > 0) {
              vm.itemlist = response.data;
              // console.log('data', vm.itemlist);
            }
          })
          .catch(function(error) {
            console.log(error);
          })
      },
      ok: function() {
        this.showModal = !this.showModal;
      },
      close: function(e) {
        this.showModal = !this.showModal;
      },
      getModalContent(myData) {
        //Your other code that launches the modal
        this.showModal = true;
        this.$nextTick(function() {
          $(document).ready(function() {
            var to, from;
            to = $("#range-to-example").persianDatepicker(modelDate());
            from = $("#range-from-example").persianDatepicker(modelDate());

            document.getElementById('dynamic_content').innerHTML = myData;
          });
        })
      }
    },
  })


  function report_by_type_pdf(e) {
    $('#show-modal').click();
    var myid = event.target.id;
    var type_id = myid;

    ////pdf both
    if (type_id == 'print_pdf_both') {
      var myhtml = `
            <input type="hidden" name="type" value="inventoryDetailWithTypeRoll"/>
            <input type="hidden" name="qut" value="both"/>
            <input type="hidden" name="id" value="{{$inventory->id}}"/>`;
      $('#d_form').attr('action', "{{route('export.PDFAll')}}");
      vm.getModalContent(myhtml);
    }
    ////excell both
    if (type_id == 'print_excell_both') {

      var myhtml = `
            <input type="hidden" name="type" value="inventoryDetailWithTypeRoll"/>
            <input type="hidden" name="qut" value="both"/>
            <input type="hidden" name="id" value="{{$inventory->id}}"/>`;
      $('#d_form').attr('action', "{{route('export.ExcelAll')}}");
      vm.getModalContent(myhtml);
    }
    ////pdf in
    if (type_id == 'print_pdf_in') {

      var myhtml = `<input type="hidden" name="type" value="inventoryDetailWithTypeRoll"/>
                     <input type="hidden" name="qut" value="in"/>
                     <input type="hidden" name="id" value="{{$inventory->id}}"/>`;
      $('#d_form').attr('action', "{{route('export.PDFAll')}}");
      vm.getModalContent(myhtml);
    }


    ////excell in
    if (type_id == 'print_excell_in') {

      var myhtml = `<input type="hidden" name="type" value="inventoryDetailWithTypeRoll"/>
                     <input type="hidden" name="qut" value="in"/>
                     <input type="hidden" name="id" value="{{$inventory->id}}"/>`;
      $('#d_form').attr('action', "{{route('export.ExcelAll')}}");
      vm.getModalContent(myhtml);
    }

    ////pdf out
    if (type_id == 'print_pdf_out') {

      var myhtml = `<input type="hidden" name="type" value="inventoryDetailWithTypeRoll"/>
                     <input type="hidden" name="qut" value="out"/>
                     <input type="hidden" name="id" value="{{$inventory->id}}"/>`;
      $('#d_form').attr('action', "{{route('export.PDFAll')}}");
      vm.getModalContent(myhtml);
    }

    ////pdf out
    if (type_id == 'print_excell_out') {

      var myhtml = `<input type="hidden" name="type" value="inventoryDetailWithTypeRoll"/>
                     <input type="hidden" name="qut" value="out"/>
                     <input type="hidden" name="id" value="{{$inventory->id}}"/>`;
      $('#d_form').attr('action', "{{route('export.ExcelAll')}}");
      vm.getModalContent(myhtml);
    }
  }


  // qut-in
  $(document).ready(function() {
    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
    $('#tab-qut-in').on('shown.bs.tab', function(event) {

      $('#qut-in-table').DataTable({
        order: [["{{orderByColumn()=='number'?1:4}}", "{{getRowOrder()}}"]],
        responsive:'{{responsiveDataTable()}}',
        pagingType:'{{paginationType()}}',
        scrollCollapse: true,
        serverSide: true,
        paging: true,
        retrieve: true,
        ajax: {
          url: '{{route("inventory.m_show",$inventory->id)}}',
          data: {
            type: 'qut-in',
            m_type: "{{$inventory->m_type}}"
          }
        },
        buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
        columns: [{
            data: 'Type',
            name: 'Type',
            orderable: false,
            searchable: false
          },
          {
            data: 'Number',
            name: 'Number',
            searchable: false
          },
          {
            data: 'Code',
            name: 'Code',
            searchable: false
          },
          {
            data: 'orderNumber',
            name: 'orderNumber',
            searchable: false
          },
          {
            data: 'Date',
            name: 'Date',
            searchable: false
          },
          @if(getOtherMeasure()=="true")
          {data: 'other_measure', name: 'other_measure', orderable: false, searchable: false },
          @endif
          @if(getOtherMeasure2()=="true")
          {data: 'other_measure2', name: 'other_measure2', orderable: false, searchable: false},
          @endif
          @if(systemConfig()[9] == 0 || getCubicMetereItems()=="true") {
            data: 'Lengths',
            name: 'Lengths',
            orderable: false,
            searchable: false
          },
          {
            data: 'Widths',
            name: 'Widths',
            orderable: false,
            searchable: false
          },
          @endif
          @if(getCubicMetereItems()=="true")
          {
            data: 'gauge',
            name: 'gauge',
            orderable: false,
            searchable: false
          },
          @endif
          @if(getShowWing()!="false")
          {
            data: 'khada',
            name: 'khada',
            orderable: false,
            searchable: false
          },
          {
            data: 'approx_weight',
            name: 'approx_weight',
            orderable: false,
            searchable: false
          },
          @endif
          @if(systemConfig()[9] != 0) {
            data: 'image',
            name: 'image',
            orderable: false,
            searchable: false
          },
          {
            data: 'expire_date',
            name: 'expire_date',
            orderable: false,
            searchable: false
          },
          @endif
          @if(getShowSuperceedNo()=="true")
          {
            data: 'superceed',
            name: 'superceed',
            searchable: false
          },
          @endif
          @if(itemBrand() == "true") {
            data: 'brand',
            name: 'brand',
            searchable: false
          },
          @endif
          @if(showLocation()=="true")
          {
            data: 'location',
            name: 'location',
            searchable: false
          },
          @endif 
          {
            data: 'price',
            name: 'price',
            searchable: false
          },
          {
            data: 'Vendor',
            name: 'Vendor',
            searchable: false
          },
          {
            data: 'SiteName',
            name: 'SiteName',
            orderable: false,
            searchable: false
          },
          {
            data: 'Quantity',
            name: 'Quantity',
            orderable: false,
            searchable: false
          },
          {
            data: 'Measure',
            name: 'Measure',
            orderable: false,
            searchable: false
          },
          @if(getM2() != "" && getSubMeasure() != "true") {
            data: 'Unit2',
            name: 'Unit2',
            orderable: false,
            searchable: false
          },
          @endif
          @if(getShowPurchaseRate() != "false")
          {
            data: 'Cost',
            name: 'Cost',
            orderable: false,
            searchable: false
          },
          {
            data: 'total_cost',
            name: 'total_cost',
            orderable: false,
            searchable: false
          },
          {
            data: 'Total',
            name: 'Total',
            orderable: false,
            searchable: false
          },
          @endif
          {
            data: 'user',
            name: 'user',
            orderable: false,
            searchable: false
          },
          {
            data: 'Description',
            name: 'Description',
            orderable: false,
            searchable: false
          },
        ]
      });
    });
  });
  // end qut-in

  $('#attachment').DataTable({
      ajax: { 
          url:'{{route("inventory.m_show",$inventory->id)}}',
          data:{type:'attachment' }
      },

      pageLength:'{{getPageRows()}}',
      responsive:'{{responsiveDataTable()}}',
      pagingType:'{{paginationType()}}',

      scrollCollapse: true,
      serverSide: true,
      paging: true,
      columns: [

          {data: 'title', name: 'attachments.title'},
          {data: 'description', name: 'attachments.description'},
          {data: 'actions', name: 'actions', orderable: false, searchable: false},
      ]
    });    




  // qut-onhand
  $(document).ready(function() {
    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
    $('#tab-qut-onhand').on('shown.bs.tab', function(event) {

      $('#qut-onhand-table').DataTable({
        order: [["{{orderByColumn()=='number'?1:4}}", "{{getRowOrder()}}"]],
        responsive:'{{responsiveDataTable()}}',
        pagingType:'{{paginationType()}}',
        scrollCollapse: true,
        serverSide: true,
        paging: true,
        retrieve: true,
        ajax: {
          url: '{{route("inventory.m_show",$inventory->id)}}',
          data: {
            type: 'qut-onhand',
            m_type: "{{$inventory->m_type}}"
          }
        },
        buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
        columns: [{
            data: 'Type',
            name: 'Type',
            orderable: false,
            searchable: false
          },
          {
            data: 'Code',
            name: 'Code',
            searchable: false
          },
          {
            data: 'Date',
            name: 'Date',
            searchable: false
          },
          @if(getOtherMeasure()=="true")
          {data: 'other_measure', name: 'other_measure', orderable: false, searchable: false },
          @endif
          @if(getOtherMeasure2()=="true")
          {data: 'other_measure2', name: 'other_measure2', orderable: false, searchable: false},
          @endif
          @if(systemConfig()[9] == 0 || getCubicMetereItems()=="true") {
            data: 'lengths',
            name: 'lengths',
            orderable: false,
            searchable: false
          },
          {
            data: 'widths',
            name: 'widths',
            orderable: false,
            searchable: false
          },
          @endif
          @if(getCubicMetereItems()=="true")
          {
            data: 'gauge',
            name: 'gauge',
            orderable: false,
            searchable: false
          },
          @endif
          @if(getShowWing()!="false")
          {
            data: 'khada',
            name: 'khada',
            orderable: false,
            searchable: false
          },
          {
            data: 'approx_weight',
            name: 'approx_weight',
            orderable: false,
            searchable: false
          },
          @endif
          @if(systemConfig()[9] == 1) {
            data: 'image',
            name: 'image',
            orderable: false,
            searchable: false
          },
          {
            data: 'expire_date',
            name: 'expire_date',
            orderable: false,
            searchable: false
          },
          @endif
          @if(getShowSuperceedNo()=="true")
          {
            data: 'superceed',
            name: 'superceed',
            searchable: false
          },
          @endif
          @if(itemBrand() == "true") {
            data: 'brand',
            name: 'brand',
            searchable: false
          },
          @endif
          @if(showLocation()=="true")
          {
            data: 'location',
            name: 'location',
            searchable: false
          },
          @endif {
            data: 'price',
            name: 'price',
            searchable: false
          },
          {
            data: 'SiteName',
            name: 'SiteName',
            orderable: false,
            searchable: false
          },
          {
            data: 'Quantity',
            name: 'Quantity',
            orderable: false,
            searchable: false
          },
          {
            data: 'Measure',
            name: 'Measure',
            orderable: false,
            searchable: false
          },
          @if(getM2() != "" && getSubMeasure() != "true") {
            data: 'Unit2',
            name: 'Unit2',
            orderable: false,
            searchable: false
          },
          @endif
          
          @if(systemConfig()[21] == 1 )
          {
            data: 'prime_cost',
            name: 'prime_cost',
            orderable: false,
            searchable: false
          },
          @endif
          @if(getShowPurchaseRate() != "false")
          {
            data: 'Cost',
            name: 'Cost',
            orderable: false,
            searchable: false
          },
          {
            data: 'total_cost',
            name: 'total_cost',
            orderable: false,
            searchable: false
          },
          {
            data: 'Total',
            name: 'Total',
            orderable: false,
            searchable: false
          },
          @endif
          {
            data: 'user',
            name: 'user',
            orderable: false,
            searchable: false
          },
          {
            data: 'Description',
            name: 'Description',
            orderable: false,
            searchable: false
          },
        ]
      });
    });
  });
  // end qut-onhand

  // qut-out

  $(document).ready(function() {
    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
    $('#tab-qut-out').on('shown.bs.tab', function(event) {

      $('#qut-out-table').DataTable({
        order: [["{{orderByColumn()=='number'?1:3}}", "{{getRowOrder()}}"]],
        responsive:'{{responsiveDataTable()}}',
        pagingType:'{{paginationType()}}',
        scrollCollapse: true,
        serverSide: true,
        paging: true,
        retrieve: true,
        ajax: {
          url: '{{route("inventory.m_show",$inventory->id)}}',
          data: {
            type: 'qut-out',
            m_type: "{{$inventory->m_type}}"
          }
        },
        buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
        columns: [{
            data: 'Type',
            name: 'Type',
            orderable: false,
            searchable: false
          },
          {
            data: 'Number',
            name: 'Number',
            searchable: false
          },
          {
            data: 'Code',
            name: 'Code',
            searchable: false
          },
          {
            data: 'Date',
            name: 'Date',
            searchable: false
          },
          @if(getOtherMeasure()=="true")
          {data: 'other_measure', name: 'other_measure', orderable: false, searchable: false },
          @endif
          @if(getOtherMeasure2()=="true")
          {data: 'other_measure2', name: 'other_measure2', orderable: false, searchable: false},
          @endif
          @if(systemConfig()[9] == 0 || getCubicMetereItems()=="true") {
            data: 'Lengths',
            name: 'Lengths',
            orderable: false,
            searchable: false
          },
          {
            data: 'Widths',
            name: 'Widths',
            orderable: false,
            searchable: false
          },
          @endif
          @if(getCubicMetereItems()=="true")
          {
            data: 'gauge',
            name: 'gauge',
            orderable: false,
            searchable: false
          },
          @endif
          @if(getShowWing()!="false")
          {
            data: 'khada',
            name: 'khada',
            orderable: false,
            searchable: false
          },
          {
            data: 'approx_weight',
            name: 'approx_weight',
            orderable: false,
            searchable: false
          },
          @endif
          @if(systemConfig()[9] != 0) {
            data: 'image',
            name: 'image',
            orderable: false,
            searchable: false
          },
          @endif {
            data: 'Vendor',
            name: 'Vendor',
            orderable: false,
            searchable: false
          },
          {
            data: 'SiteName',
            name: 'SiteName',
            orderable: false,
            searchable: false
          },
          {
            data: 'Quantity',
            name: 'Quantity',
            orderable: false,
            searchable: false
          },
          {
            data: 'Measure',
            name: 'Measure',
            orderable: false,
            searchable: false
          },
          @if(getM2() != "" && getSubMeasure() != "true") {
            data: 'Unit2',
            name: 'Unit2',
            orderable: false,
            searchable: false
          },
          @endif
          @if(getShowSaleRate() != "false")
          {
            data: 'sales_price',
            name: 'sales_price',
            orderable: false,
            searchable: false
          },
          {
            data: 'Total',
            name: 'Total',
            orderable: false,
            searchable: false
          },
          @endif
          {
            data: 'user',
            name: 'user',
            orderable: false,
            searchable: false
          },
          {
            data: 'Description',
            name: 'Description',
            orderable: false,
            searchable: false
          },
        ]

      });
    });
  });

  // end qut-all
  $(document).ready(function() {
    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

    $('#both_table').DataTable({
      order: [["{{orderByColumn()=='number'?1:5}}", "{{getRowOrder()}}"]],
      responsive:'{{responsiveDataTable()}}',
      pagingType:'{{paginationType()}}',
      serverSide: true,
      paging: true,
      ajax: {
        url: '{{route("inventory.m_show",$inventory->id)}}',
        data: {
          type: 'both',
          m_type: "{{$inventory->m_type}}"
        }
      },
      buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
      columns: [{
          data: 'Type',
          name: 'Type',
          orderable: false,
          searchable: false
        },
        {
          data: 'Number',
          name: 'Number',
          searchable: false
        },
        {
          data: 'Code',
          name: 'Code',
          searchable: false
        },
        {
          data: 'orderNumber',
          name: 'orderNumber',
          searchable: false
        },
        {
          data: 'member',
          name: 'member',
          orderable: false,
          searchable: false
        },
        {
          data: 'Date',
          name: 'Date',
          searchable: false
        },
        {
          data: 'SiteName',
          name: 'SiteName',
          orderable: false,
          searchable: false
        },
        {
          data: 'cat',
          name: 'cat',
          orderable: false,
          searchable: false
        },
        @if(getOtherMeasure()=="true")
        {data: 'other_measure', name: 'other_measure', orderable: false, searchable: false },
        @endif
        @if(getOtherMeasure2()=="true")
        {data: 'other_measure2', name: 'other_measure2', orderable: false, searchable: false},
        @endif
        @if(systemConfig()[9] == 0 || getCubicMetereItems()=="true") {
          data: 'Lengths',
          name: 'Lengths',
          searchable: false,
          orderable: false
        },
        {
          data: 'Widths',
          name: 'Widths',
          orderable: false,
          searchable: false
        },
        @endif
        @if(getCubicMetereItems()=="true")
          {
            data: 'gauge',
            name: 'gauge',
            orderable: false,
            searchable: false
          },
        @endif
        @if(getShowWing()!="false")
        {
          data: 'khada',
          name: 'khada',
          orderable: false,
          searchable: false
        },
        {
          data: 'approx_weight',
          name: 'approx_weight',
          orderable: false,
          searchable: false
        },
        @endif
        @if(systemConfig()[9] != 0) {
          data: 'image',
          name: 'image',
          orderable: false,
          searchable: false
        },
        {
          data: 'expire_date',
          name: 'expire_date',
          searchable: false
        },
        @endif
        @if(getShowSuperceedNo()=="true")
          {
            data: 'superceed',
            name: 'superceed',
            searchable: false
          },
        @endif
        @if(itemBrand() == "true") {
          data: 'brand',
          name: 'brand',
          searchable: false
        },
        @endif
        @if(showLocation()=="true")
        {
          data: 'location',
          name: 'location',
          searchable: false
        },
        @endif {
          data: 'Quantity',
          name: 'Quantity',
          searchable: false
        },
        {
          data: 'Measure',
          name: 'Measure',
          orderable: false,
          searchable: false
        },
        @if(getM2() != "" && getSubMeasure() != "true") {
            data: 'Unit2',
            name: 'Unit2',
            orderable: false,
            searchable: false
          },
          @endif
        @if(getShowPurchaseRate() != "false")
        {
          data: 'Cost',
          name: 'Cost',
          orderable: false,
          searchable: false
        },
        {
          data: 'total_cost',
          name: 'total_cost',
          orderable: false,
          searchable: false
        },
        @endif
        
        @if(getShowSaleRate() != "false")
        {
          data: 'sales_price',
          name: 'sales_price',
          orderable: false,
          searchable: false
        },
        @endif
        @if(getShowPurchaseRate() != "false")
        {
          data: 'Total',
          name: 'Total',
          orderable: false,
          searchable: false
        },
        @endif
        {
            data: 'user',
            name: 'user',
            orderable: false,
            searchable: false
          },
        {
          data: 'Description',
          name: 'Description',
          orderable: false,
          searchable: false
        },
      ]

    });
  });
</script>
@endpush