@extends('layouts.app')
@section('style')

<style>
.v-select input[type=search], .v-select input[type=search]:focus {

    width: 50% !important;
}

.table > tbody > tr > td, .table > tbody > tr > th, .table > tfoot > tr > td, .table > tfoot > tr > th, .table > thead > tr > td, .table > thead > tr > th {
    padding: 8px;
    padding: 4px 2px;
}
.input-has-error {
    outline: 1px solid #ff0000 !important;
    background-color: #ff000014;
} 
</style>
@stop
@section('content')
@include('inventories.modal')
<!-- BEGIN CONTENT BODY -->
 
<!-- END PAGE BAR -->
<div class="row">

    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.OpeningCode')</span>
            </div>
        </div>
        <div class="portlet-body form" id="item-service" v-cloak style="margin-bottom:20%;">
            <!-- BEGIN FORM-->
            {{Form::open(['route' => 'inventory.opening_store','method' => 'POST','id' => 'inventory-form','files'=> true])}}
            <div class="form-body">
                
		<!--/row-->
		<div class=" row" style="margin-bottom: 10px;">
		<div class=" col-md-4">
			<div class="form-group">
				<label class="control-label">@lang('layout.Date')</label>
				<input type="text" name="date" placeholder="@lang('layout.Date')" value="{{$date}}" class="form-control date" autocomplete="off">
			</div>
		</div>
		</div>
        <!-- <br/> -->
		<div class="row" style="overflow-x: scroll;">
			<!-- begin payments -->
			<table id="table_content" class="table table-striped table-bordered table-advance table-hover">
			  <thead>
				<tr>
				  <th class="text-center" style="min-width: 8px;"> # </th>
				  <th class="text-center" style="min-width: 160px;">@lang('layout.Item')</th>
				  <th class="text-center" style="min-width: 160px;">@lang('layout.Site')</th>
				  <th class="text-center" style="min-width: 160px;">@lang('layout.Code')</th>
				  <th class="text-center" style="min-width: 160px;">@lang('layout.Measure')</th>
				  <th class="text-center" style="min-width: 160px;">@lang('layout.OnHand')</th>
				  <th class="text-center" style="min-width: 160px;">@lang('layout.CostInInventory')</th>
				  @if(systemConfig()[21] == 1)
					<th class="text-center" style="min-width: 160px;">@lang('layout.UnitPrice')</th>
				  @endif
				  <th class="text-center" style="min-width: 160px;">@lang('layout.Default_Rate')</th>
				  @if(systemConfig()[9] != 0 )
				  <th class="text-center" style="min-width: 160px;">@lang('layout.Photo')</th>
				  <th v-show="showWhat('expire_date')=='yes'" class="text-center" style="min-width: 160px;">@lang('layout.ExpireDate')</th>
				  @endif
				  @if(getShowWing()!="false")
					<th class="text-center" style="min-width: 160px;">@lang('layout.Wing')</th>
					<th class="text-center" style="min-width: 160px;">@lang('layout.ApproxWeight')</th>
				  @endif
				  @if(systemConfig()[9] == 0 || getCubicMetereItems()=="true")
				  <th class="text-center" style="min-width: 160px;">@lang('layout.Width')</th>
				  <th class="text-center" style="min-width: 160px;">@lang('layout.Length')</th>
				  @endif
				  @if(getCubicMetereItems()=="true")
				<th class="text-center" style="min-width: 80px;"> @lang('layout.Gauge')</th>
				@endif
				  @if(getShowSuperceedNo()=="true")
					<th style="min-width: 150px;">@lang('layout.SuperceedNo')</th>
				  @endif
				  @if(itemBrand()=="true")
				  <th class="text-center" style="min-width: 160px;">@lang('layout.Brand')</th>
				  <th class="text-center" style="min-width: 160px;">@lang('layout.Description')</th>
				  @endif
				  @if(showLocation()=="true")
				  <th class="text-center" style="min-width: 160px;">@lang('layout.Location')</th>
				  @endif
				  @if(getOtherMeasure()=="true")
				  <th class="text-center" style="min-width: 160px;">@lang('layout.OMeasureValue') 1</th>
				  @endif
                  @if(getOtherMeasure2()=="true")
                  <th class="text-center" style="min-width: 160px;">@lang('layout.OMeasureValue') 2</th>
				  @endif
				  <th></th>
				  
				</tr>
			  </thead>
			  <tbody>
				<tr v-for="(service,index) in services">
				  <td>@{{index+1}}</td>
				  <td class="highlight">
				  <v-select v-model="service.inventory" :options="temp_items" @search="onItemSearch" placeholder="@lang('layout.SelectItem') " label="name" @click.native="addNew(index)" @keyup.native="addNew(index)" ></v-select>
                   <input type="hidden" :name="'id['+index+']'"  :value="(service.inventory)?service.inventory.id:null">
                   <input type="hidden" :name="'m_stocks_in_id['+index+']'"  :value="(service.inventory)?service.inventory.m_stocks_in_id:null">
				  </td>
				  <td class="highlight">
				  <v-select placeholder="@lang('layout.SelectSite') " label="site_name"  :options="sites" @click.native="addNew(index)" @keyup.native="addNew(index)" v-model="service.site" ></v-select>
                   <input type="hidden" :name="'site_id['+index+']'"  :value="(service.site)?service.site.site_id:null">
				  </td>
				  <td>
					<input :name="'code['+index+']'" :value="(service.item.code)?service.item.code:null" ref="code" @input="setRate()" type="text" class="form-control" placeholder="@lang('layout.Code')" />
				  </td>
				  <td>
					<input :value="(service.inventory)?service.inventory.measure:null" class="form-control" placeholder="@lang('layout.Measure')" readonly />
				  </td>
				  <td>
					<input :name="'qut_in['+index+']'" :value="(service.item.qut_in)?service.item.qut_in:null" ref="qut_in" @input="setRate(),changeMetraz(index)" type="number" class="form-control" placeholder="@lang('layout.OnHand')" />
                  </td>
				  <td>
					<input :name="'cost_in['+index+']'" :value="(service.item.cost_in)?service.item.cost_in:null" ref="cost_in" @input="setRate()" type="number" class="form-control" placeholder="@lang('layout.CostInInventory')" />
				  </td>
				  @if(systemConfig()[21] == 1)
					<td>
						<input :name="'unit_price['+index+']'" type="number" @input="setRate(), changeCost(index)" class="form-control" placeholder="@lang('layout.UnitPrice')" ref="unit_price" :value="(service.item)?service.item.unit_price:null" >
					</td>
					@endif
				  <td>
					<input :name="'price_in['+index+']'" :value="(service.item.price_in)?service.item.price_in:null" ref="price_in" @input="setRate()" type="number" class="form-control" placeholder="@lang('layout.Default_Rate')" />
                  </td>
				  @if(systemConfig()[9] != 0 )
				  <td>
					<input :name="'image['+index+']'" type="file" class="form-control" placeholder="@lang('layout.Photo')" />
					<input  type="hidden" :name="'last_image['+index+']'" v-model="(service.item==null)?null:service.item.image" />
				  </td>
				  <td v-show="showWhat('expire_date')=='yes'">
					<date_picker :name="'expire_date['+index+']'" :value="(service.item.expire_date)?service.item.expire_date:null"  placeholder="@lang('layout.ExpireDate')" ></date_picker>
				  </td>
				  @endif
				  @if(getShowWing()!="false") 
				  <td>
					<input :name="'khada['+index+']'" :value="(service.item.khada)?service.item.khada:null" ref="khada" @input="setRate()" type="number" class="form-control" placeholder="@lang('layout.Wing')" />
				  </td>
				  <td>
					<input :name="'approx_weight['+index+']'" :value="(service.item.approx_weight)?service.item.approx_weight:null" ref="approx_weight" @input="setRate()" type="number" class="form-control" placeholder="@lang('layout.ApproxWeight')" />
				  </td>
				  @endif
				  @if(systemConfig()[9] == 0 || getCubicMetereItems()=="true")
				  <td>
                    <input :name="'widths['+index+']'" :value="(service.item.widths)?service.item.widths:null" ref="widths" @input="setRate(), changeMetraz(index)" type="number" class="form-control" placeholder="@lang('layout.Width')" />
				  </td>
				  <td>
                    <input :name="'lengths['+index+']'" :value="(service.item.lengths)?service.item.lengths:null" ref="lengths" @input="setRate(), changeMetraz(index)" type="number" class="form-control" placeholder="@lang('layout.Length')" />
				  </td>
				  @endif
				  @if(getCubicMetereItems()=="true")
				  <td>
					  <input :name="'item_gauge['+index+']'" type="number" :value="(service.item.gauge)?service.item.gauge:null" ref="gauge" @input="setRate(),changeMetraz(index)" class="form-control" placeholder="@lang('layout.Gauge')">
				  </td>
				  @endif
				  @if(getShowSuperceedNo()=="true")
				  <td>
					<input :name="'superceed['+index+']'" type="text" v-model="service.item.superceed" ref="superceed" @input="setRate()" class="form-control" placeholder="@lang('layout.SuperceedNo')" >
				  </td>
				  @endif
				  @if(itemBrand()=="true")
				  <td>
					<v-select placeholder="@lang('layout.Brand')" label="name"  :options="brand" v-model="service.item.selectedBrand" ></v-select>
					<input type="hidden" :name="'brand_id['+index+']'" :value="(service.item.selectedBrand)?service.item.selectedBrand.id:null">
				  </td>
				  <td>
					<input :name="'description['+index+']'" type="text" v-model="service.item.description" ref="description" @input="setRate()" class="form-control" placeholder="@lang('layout.Description')" >
				  </td>
				  @endif
				  @if(showLocation()=="true")
				  <td>
					<input :name="'location['+index+']'" type="text" v-model="service.item.location" ref="location" @input="setRate()" class="form-control" placeholder="@lang('layout.Location')" >
				  </td>
				  @endif
				  @if(getOtherMeasure()=="true")
					<td>
						<input :name="'other_measure['+index+']'" type="number" v-model="service.item.other_measure" ref="other_measure" @input="setRate()" class="form-control" placeholder="@lang('layout.OMeasureValue') 1">
					</td>
				@endif
                @if(getOtherMeasure2()=="true")
					<td>
						<input :name="'other_measure2['+index+']'" type="number" v-model="service.item.other_measure2" ref="other_measure2" @input="setRate()" class="form-control" placeholder="@lang('layout.OMeasureValue') 2">
					</td>
				  @endif
				 <td>
				   <span  v-on:click="deleteItem(index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
				 </td>
				</tr>
			</tbody>
			</table>
			<br/>
			<br/>
			<br/> 
		</div>	
        <div class="row text-center margin-top-10">
			<button type="button" @click="addNew(1000)" class="btn btn-success" ><i class="fa fa-plus"></i></button>
		</div>
    
    </div>

    <div class="col-xs-12 col-sm-12 col-md-12 collg-12 text-center">
        <a @click="submitInventory" class="btn green">@lang('layout.Submit')</a>
        <a href="{{route('inventory.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
    </div>
    {{Form::close()}}
    <!-- END FORM-->
</div>
</div>
</div>

@endsection
@push('scripts')


<script>

    Vue.component('modal', {
        template: '#vendor-template'
    })

    Vue.component('modal', {
        template: '#modal-template'

    })

    Vue.component('v-select', VueSelect.VueSelect)
    
    let vu = new Vue({
        el: '#item-service',
        data: {
            category:null,
			brand:{!! json_encode($brand) !!},
            selectedBrand:null,
            site:null,
            sites:{!! json_encode($site) !!},
            type: 'inventoryPart',
            cost: 1,
            total: 0,
            errorMessage: '',
            showModal: false,
            fieldErrors: [],
            temp_items: [],
            selectedMetric: {},
            senddata: {},
            open_stock_data:{!!json_encode($opening)!!},
			services:[
			],
        },
        computed: {

            isError:function()
            {
                var isError=false;
                if(this.cost>0)
                {
                    isError= true;
                }
                return isError;
            },
            description: function (createElement) {
                this.total = this.cost * this.noHand
            },
            result: function () {
				var total = 0
				var cost = this.cost;
				
				this.services.forEach(function (item) {
                    total += (item.item.qut_in)? (Number.parseFloat(item.item.qut_in)*((Number.parseFloat(item.item.cost_in) > 0)?Number.parseFloat(item.item.cost_in):0)):0;
                })
				return total;
				
                // return this.cost * this.onHand;
            },
            onHand: function () {

                var total = 0
                this.services.forEach(function (item) {
                    total += (item.item.qut_in)? (Number.parseFloat(item.item.qut_in)):0;
                })
			// console.log('hh',this.services);
                return total;
            }
			
			
        },
        
		
		
	     mounted:function(){
          // initialize the selected item
        for(var i=0;i<this.open_stock_data.length;i++)
        {
		  this.open_stock_data[i].selectedBrand  = _.find({!!json_encode($brand) !!}, (o) => o.id == this.open_stock_data[i]['brand_id']);
        //   console.log('ssssssss',this.open_stock_data[i]);
		  
          this.services.push({inventory:this.open_stock_data[i],item:this.open_stock_data[i], site:this.open_stock_data[i]});
		  
        }
		
		
		
		// console.log('hh',this.services[0].item);
		
		
        },
		
	methods: {
  
		changeMetraz(index) {
			@if(getCubicMetereItems()=="true")
				setTimeout(() => {
					if (vu.services[index]) {
						if (vu.services[index].item != null) {
							if (vu.services[index].item.lengths != null && vu.services[index].item.widths != null && vu.services[index].item.qut_in != null) {
								var qty =  Number.parseFloat(vu.services[index].item.qut_in);
								var width =  Number.parseFloat(vu.services[index].item.widths);
								var length =  Number.parseFloat(vu.services[index].item.lengths);
								var gauge =  Number.parseFloat(vu.services[index].item.gauge);

								vu.services[index].item.khada = Number.parseFloat(qty * (width * length)).toFixed(precision());
								if (vu.services[index].item.gauge != null) {
									vu.services[index].item.other_measure = Number.parseFloat(qty * gauge * width * length).toFixed(precision());
								}
							}
						}
					}
				}, 400);
			@else
				@if(systemConfig()[21] == 1)
				if (vu.services[index].item) {
					if (vu.services[index].item.lengths != null && vu.services[index].item.widths != null) {
						// console.log(vu.services[index].item.lengths, vu.services[index].item.widths);
						var lengths = vu.services[index].item.lengths;
						var widths = vu.services[index].item.widths;

						vu.services[index].item.other_measure = myRound(lengths * widths);

						if (vu.services[index].item.other_measure != null && vu.services[index].item.unit_price != null) {
							var other_measure = vu.services[index].item.other_measure;
							var unit_price = vu.services[index].item.unit_price;

							vu.services[index].item.cost_in = myRound(other_measure * unit_price);
						}
					}
				}
				@endif
			@endif
		},
		changeCost(index) {
			@if(systemConfig()[21] == 1)
			if (vu.services[index].item) {
					// console.log(1212, vu.services[index].item.other_measure, vu.services[index].item.unit_price);
				if (vu.services[index].item.other_measure != null && vu.services[index].item.unit_price != null) {
					var other_measure = vu.services[index].item.other_measure;
					var unit_price = vu.services[index].item.unit_price;
					vu.services[index].item.cost_in = myRound(other_measure * unit_price);
				}
			}
			@endif
		},

	submitInventory:function(){

		swal({
			title:"@lang('layout.AreYouSure?')",

			buttons: ["@lang('layout.Cancel')","@lang('layout.Submit')"],

			text: "",
			icon: "info",
			dangerMode: true,
		}).then((willDelete) => {
			if (willDelete) {
				document.getElementById("inventory-form").submit()

			} else {

			}
		});
	},
	onItemSearch: _.debounce((search, loading) => {

	loading(true);
	
	axios.get("{{route('callMethod.search')}}", {
		params: {
			method_name: 'itemSearchNameRoll',
			keyword: search,
		}
	})
		.then(function (response) {
			vu.temp_items = [];
			if (response.data.length > 0) {
				vu.temp_items = response.data;
			}
			loading(false);
		})
		.catch(function (error) {
			console.log(error);
		})
	}, getDebounceTime()),

setData:function() {



},

setRate()
{
		for(var i=0;i<this.services.length;i++)
		{
			this.services[i].item.code = this.$refs.code[i].value;
			@if(getShowWing()!="false")
			if (this.$refs.khada) {
				this.services[i].item.khada = this.$refs.khada[i].value;
			}
			if (this.$refs.approx_weight) {
				this.services[i].item.approx_weight = this.$refs.approx_weight[i].value;
			}
			@endif
			@if(getCubicMetereItems()=="true")
			if (this.$refs.gauge) {
				this.services[i].item.gauge = this.$refs.gauge[i].value;
			}
			@endif
			if(this.$refs.widths){
				// console.log('eee');
			this.services[i].item.lengths = this.$refs.lengths[i].value;
			this.services[i].item.widths = this.$refs.widths[i].value;
			}
			if(this.$refs.cost_in){
			// this.services[i].item.expire_date = this.$refs.expire_date[i].value;
			this.services[i].item.cost_in = this.$refs.cost_in[i].value;
			this.services[i].item.price_in = this.$refs.price_in[i].value;
			}
			@if(itemBrand()=="true")
			if(this.$refs.description) {
				this.services[i].item.description = this.$refs.description[i].value;
			}
			@endif
			@if(showLocation()=="true")
			if(this.$refs.location) {
				this.services[i].item.location = this.$refs.location[i].value;
			}
			@endif
			@if(getShowSuperceedNo()=="true")
			if(this.$refs.superceed) {
				this.services[i].item.superceed = this.$refs.superceed[i].value;
			}
			@endif
			@if(getOtherMeasure()=="true")
			if(this.$refs.other_measure) {
				this.services[i].item.other_measure = this.$refs.other_measure[i].value;
			}
			@endif
            @if(getOtherMeasure2()=="true")
			if(this.$refs.other_measure2) {
				this.services[i].item.other_measure2 = this.$refs.other_measure2[i].value;
			}
			@endif
			@if(systemConfig()[21] == 1)
			if(this.$refs.unit_price) {
				this.services[i].item.unit_price = this.$refs.unit_price[i].value;
			}
			@endif
			this.services[i].item.qut_in = this.$refs.qut_in[i].value;
	  
		}
		
		
},

// generic function for adding item to list
addNew(index)
{
		this.setRate();
	
		if(this.services[index+1]==undefined)
		{
		  this.services.push({
			item:{
				name:null,
				site:null,
				id:0,
				inventory_site_id:null,
				main_stocks_id:null,
				m_stocks_in_id:null,
				code:null,
				lengths:null,
				widths:null,
				khada:null,
				approx_weight:null,
				// expire_date:null,
				qut_in:null,
				cost_in:null,
				unit_price:null,
				price_in:null,
				selectedBrand:null,
				other_measure: null,
                other_measure2: null
			},
		});
		
		}
	 
  
},
// delete item from list
deleteItem(index)
{	
	this.setRate();
	this.services.splice(index, 1);
  
}


}



});

vu.setData();
</script>


@endpush