@extends('layouts.app')
@section('style')
<style>
    .v-select input[type=search],
    .v-select input[type=search]:focus {
        width: 50% !important;
    }
    .table>tbody>tr>td,
    .table>tbody>tr>th,
    .table>tfoot>tr>td,
    .table>tfoot>tr>th,
    .table>thead>tr>td,
    .table>thead>tr>th {
        padding: 8px;
        padding: 4px 2px;
    }
    .input-has-error {
        outline: 1px solid #ff0000 !important;
        background-color: #ff000014;
    }
</style>
@stop
@section('content')
@include('inventories.modal')
<!-- BEGIN CONTENT BODY -->
<!-- END PAGE BAR -->
<div class="row">
    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.AddNewItem')</span>
                {{--<span class="caption-helper">@lang('layout.someinfo...')</span>--}}
            </div>
        </div>
        <div class="portlet-body form" id="item-service" v-cloak style="margin-bottom:20%;">
            <!-- BEGIN FORM-->
            {!! Form::model($inventory, ['method' => 'PATCH','route' => ['inventory.m_update',$inventory->id],'class'=>'form-horizont','id'=>'inventory-edit-form','files'=> true]) !!}
            <div class="form-body">
                <div class="row" style="margin-bottom: 20px; padding: 10px;">
                    <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
                        <div class="row" style="padding: 0.5% 1%;">
                            <div class="col-lg-12">
                                <div class="col-lg-3">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.ItemName')</label>
                                        {{Form::text('name',null,['class' => 'form-control','placeholder' => __('layout.EnterItemName'),'v-validate' =>'"required|min:2"','data-vv-as' => __('layout.Name')])}}
                                        <span class="required">@{{ errors.first('name') }}</span>
                                        {{--<span class="help-block"> This is inline help </span>--}}
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.ItemType')</label>
                                        <select class="form-control" name="type">
                                            <option <?php if($inventory->type == 'inventoryPart'){echo 'selected="selected"';} ?> value="inventoryPart">@lang('layout.InventoryPart')</option>
                                            <option <?php if($inventory->type == 'inventoryAssembly'){echo 'selected="selected"';} ?> value="inventoryAssembly">@lang('layout.InventoryAssembly')</option>
                                            <option <?php if($inventory->type == 'workingProgress'){echo 'selected="selected"';} ?> value="workingProgress">@lang('layout.WorkingProgress')</option>
                                            <option <?php if($inventory->type == 'procurement'){echo 'selected="selected"';} ?> value="procurement">@lang('layout.Procurement')</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.ItemCode')</label>
                                        {{Form::text('number',null,['class' => 'form-control','min' =>'0' ,'placeholder' => __('layout.ItemCode')])}}
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    @if(systemConfig()[9] == 0 )
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.Gauge')</label>
                                            {{Form::number('gauge',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.Gauge')])}}
                                            <span class="required"></span>
                                        </div>
                                    @endif
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.Category')</label>
                                        <v-select placeholder="@lang('layout.SelectInventoryCategory')" label="name" :options="{{ json_encode($category) }}" v-model="category"></v-select>
                                        <input type="hidden" name="category" :value="(category)?category.id:null">
                                        {{--{{Form::select('inventory_category_id',$category,null,['class' => 'form-control','min' =>'0' ,'placeholder' => __('layout.ItemCode')])}}--}}
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <label class="control-label">@lang('layout.U_M_Set')</label>
                                    <div class="input-group">
                                        <v-select :disabled="canUpdate=='canNot'" placeholder="@lang('layout.SelectUnitMeasure') " label="name" :options="measureList" v-model="measureSelected"></v-select>
                                        <input type="hidden" name="um_id" v-validate="'required'" data-vv-as="@lang('layout.U_M_Set')" :value="(measureSelected)?measureSelected.id:null">
                                        <span class="required">@{{ errors.first('um_id') }}</span>
                                        {{--{{Form::select('income_account',$income,null,['class' => 'form-control'])}}--}}
                                        <span class="btn btn-success  input-group-addon" @click="showModal = true, acount_type = 'income'" style="background-color:  rgb(84, 199, 211)"> <i class="fa fa-plus" style="color: white"></i>
                                        </span>
                                    </div>
                                    <div id="measure">
                                        <modal v-if="showModal" @close="showModal = false">
                                            <div slot="body">
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <h4>@lang('layout.MetricType')</h4>
                                                        <span v-for="metric in metricList">
                                                            <div class="mt-radio-list">
                                                                <label class="mt-radio"> @{{ metric.name }}
                                                                    <input name="metric" type="radio" v-bind:value="metric" v-model="selectedMetric" v-on:change="selectedMeasure = {}">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </span>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <h4>@lang('layout.Measure') </h4>
                                                        <span v-for="measure1 in selectedMetric.measure">
                                                            <div class="mt-radio-list">
                                                                <label class="mt-radio"> @{{ measure1.text }}
                                                                    <input name="measureds" type="radio" v-bind:value="measure1" v-model="selectedMeasure">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </span>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <span v-if="selectedMeasure.text == 'Other'">
                                                            <h4 class="text-center">@lang('layout.OtherMeasure') </h4>
                                                            <div>
                                                                <div class="form-group">
                                                                    <label class="control-label col-md-5">
                                                                        @lang('layout.MeasureName')</label>
                                                                    <div class="col-md-7">
                                                                        <input type="text" class="form-control" placeholder="@lang('layout.EnterMeasureName')" v-model.trim="selectedMeasure.name">
                                                                        <span class="help-block"> </span>
                                                                    </div>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label class="control-label col-md-5">
                                                                        @lang('layout.MeasureName')
                                                                    </label>
                                                                    <div class="col-md-7">
                                                                        <input type="number" class="form-control" placeholder="@lang('layout.EnterMeasureuint')" v-model.number="selectedMeasure.unit">
                                                                        <span class="help-block"> </span>
                                                                    </div>
                                                                </div>
                                                                <div class="form-group ">
                                                                    <label class="control-label col-md-5">
                                                                        @lang('layout.MeasureSymbol')
                                                                    </label>
                                                                    <div class="col-md-7">
                                                                        <input type="text" class="form-control" placeholder="@lang('layout.EnterMeasureSymbol')" v-model.trim="selectedMeasure.symbol">
                                                                        <span class="help-block"> </span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                            <h3 slot="header">
                                                <div class="col-lg-12">
                                                    <h3>
                                                        @lang('layout.AddNewMeasure')
                                                    </h3>
                                                </div>
                                                <div class="col-md-4">
                                                    <div v-if="fieldErrors.length > 0">
                                                        <p class="text-danger" fieldErrors>
                                                            <spna v-text="fieldErrors"></spna>
                                                        </p>
                                                    </div>
                                                </div>
                                            </h3>
                                            <div slot="footer">
                                                <button type=button class="modal-default-button btn btn-success" v-on:click="addMeasure">
                                                    @lang('layout.OK')
                                                </button>
                                                <button type=button class="modal-default-button btn btn-danger" v-on:click="showModal = false ,measure = null , type=null">
                                                    @lang('layout.Cancel')
                                                </button>
                                            </div>
                                        </modal>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.CostInInventory')</label>
                                        {{Form::number('cost',$itemCost,['class' => 'form-control','v-model'=>'cost','v-model'=>'cost',':class'=>'{"input-has-error":!isError}' ,'step' => 'any','min' =>'0'])}}
                                    </div>
                                </div>
                                <div class="col-lg-3 margin-bottom-10">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.Default_Rate')</label>
                                        {{Form::number('rate',$inventory->rate,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.Default_Rate')])}}
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.Photo')</label>
                                        {!! Form::file('photo', null, array('placeholder' => 'photo','class' => 'form-control')) !!}
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.Min')</label>
                                        {{Form::number('min',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.Min')])}}
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.Max')</label>
                                        {{Form::number('max',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.Max')])}}
                                    </div>
                                </div>
                                @if(itemBrand()=="true")
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Location')</label>
                                            {{Form::text('item_location',null,['class' => 'form-control','placeholder' => __('layout.Location')])}}
                                        </div>
                                    </div>
                                @endif
                                <div class="col-lg-3">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.AssetAccount')</label>
                                        <v-select :disabled="canUpdate=='canNot'" placeholder="@lang('layout.SelectAssetAccount')" label="name" :options="{{ json_encode($asset) }}" v-model="assetAccount"></v-select>
                                        <input type="hidden" name="asset_account" :value="(assetAccount)?assetAccount.id:null">
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.IncomeAccount')</label>
                                        <v-select :disabled="canUpdate=='canNot'" placeholder="@lang('layout.SelectIncomeAccount')" label="name" :options="{{ json_encode($income) }}" v-model="incomeAccount"></v-select>
                                        <input type="hidden" name="income_account" :value="(incomeAccount)?incomeAccount.id:null">
                                        {{--{{Form::select('income_account',$income,null,['class' => 'form-control'])}}--}}
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.CostAccount')</label>
                                        <v-select :disabled="canUpdate=='canNot'" placeholder="@lang('layout.SelectCostAccount')" label="name" :options="{{ json_encode($cost) }}" v-model="costAccount"></v-select>
                                        <input type="hidden" name="cost_account" :value="(costAccount)?costAccount.id:null">
                                    </div>
                                </div>
                                @if(itemBrand()=="true")
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('menu.InventoryBrand')</label>
                                            <v-select placeholder="@lang('menu.InventoryBrand')" label="name" tabindex='4' :options="brand" v-model="selectedBrand"></v-select>
                                            <input type="hidden" name="inventory_brand_id" :value="(selectedBrand)?selectedBrand.id:null">
                                        </div>
                                    </div>
                                @endif
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.Description')</label>
                                        {{Form::textarea('description',null,['class' => 'form-control','rows' => '1','placeholder' => __('layout.Description')])}}
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.TotalValue')</label>
                                        {{Form::number('total',null,['class' => 'form-control','v-model'=>'result','step' => 'any','min' =>'0' ,'disabled'])}}
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.Date')</label>
                                        <input type="text" name="date" placeholder="@lang('layout.Date')" value="{{$date}}" class="form-control date" autocomplete="off">
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.OnHand')</label>
                                        <input type="number" disabled class="form-control" v-model='onHand'>
                                        {{--{{Form::number('quantity',null,['class' => 'form-control','v-model'=>'onHand','step' => 'any','min' =>'0'])}}--}}
                                    </div>
                                </div>
                                @if(getOtherMeasure()=="true")
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.OMeasureName') 1</label>
                                                <input type="text" name="o_measure_name" value="{{$inventory->o_measure_name}}" placeholder="@lang('layout.OMeasureName') " class="form-control">
                                            </div>
                                        </div>
                                        <!--<div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.OMeasureValue')</label>
                                                {{Form::number('o_measure_value',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.OMeasureValue')])}}
                                            </div>
                                        </div> -->
                                    <!-- </div>
                                    <div class="row"> -->
                                @endif
                                @if(getOtherMeasure2()=="true")
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.OMeasureName') 2</label>
                                            <input type="text" name="other_um_id" value="{{$inventory->other_um_id}}" placeholder="@lang('layout.OMeasureName') " class="form-control">
                                        </div>
                                    </div>
                                    <!-- <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.OMeasureValue')</label>
                                            {{Form::number('um_exchange',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.OMeasureValue')])}}
                                        </div>
                                    </div> -->
                                    <!-- <div class="row">
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.OMeasureName')</label>
                                                    <v-select :disabled="canUpdate=='canNot'" placeholder="@lang('layout.SelectUnitMeasure')" label="name"  :options="otherMeasureList" v-model="otherMeasureSelected" ></v-select>
                                                    <input type="hidden" name="other_um_id" :value="(otherMeasureSelected)?otherMeasureSelected.id:null">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.OMeasureExchangeValue')</label>
                                                {{Form::number('um_exchange',null,['class' => 'form-control','disabled','step' => 'any','min' =>'0','placeholder' => __('layout.OMeasureExchangeValue')])}}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.OMeasureName')</label>
                                                <input type="text" name="o_measure_name" value="{{$inventory->o_measure_name}}" placeholder="@lang('layout.OMeasureName') " class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.OMeasureValue')</label>
                                                {{Form::number('o_measure_value',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.OMeasureValue')])}}
                                            </div>
                                        </div>
                                    </div> -->
                                @endif
                                @if(getM2()!="")
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Measure2')</label>
                                            <v-select placeholder="@lang('layout.SelectUnitMeasure2') " label="name" :options="measureList" @input="OtherMeasureChange" v-model="measureSelected2"></v-select>
                                            <input type="hidden" name="um_id2" :value="(measureSelected2)?measureSelected2.id:null">
                                        </div>
                                    </div>
                                @endif
                                @if(getM3()!="")
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Measure3')</label>
                                            <v-select placeholder="@lang('layout.SelectUnitMeasure3') " label="name" :options="measureList" @input="OtherMeasureChange" v-model="measureSelected3"></v-select>
                                            <input type="hidden" name="um_id3" :value="(measureSelected3)?measureSelected3.id:null">
                                        </div>
                                    </div>
                                @endif
                                @if(getM4()!="")
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Measure4')</label>
                                            <v-select placeholder="@lang('layout.SelectUnitMeasure4') " label="name" :options="measureList" @input="OtherMeasureChange" v-model="measureSelected4"></v-select>
                                            <input type="hidden" name="um_id4" :value="(measureSelected4)?measureSelected4.id:null">
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    
                </div>
                <div class="row">
                    <div class="col-md-6">
                        {{--<div class="form-group">--}}
                        {{--<label class="control-label col-md-3">tax</label>--}}
                        {{--<div class="col-md-9">--}}
                        {{--{{Form::select('tax',[],null,['class' => 'form-control'])}}--}}
                        {{--</div>--}}
                        {{--</div>--}}
                    </div>
                    <!--/span-->
                    <input type="hidden" name="edit_sale" value="{{$edit_sale}}">
                </div>
                <!--/row-->
                <br />
                <div class="row" style="overflow-x: scroll;margin-bottom: 10px;">
                    <!-- begin payments -->
                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> # </th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Site')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Code')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.OnHand')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.CostInInventory')</th>
                                @if(systemConfig()[21] == 1)
                                <th class="text-center" style="min-width: 160px;">@lang('layout.UnitPrice')</th>
                                @endif
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Default_Rate')</th>
                                @if(systemConfig()[9] != 0 )
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Photo')</th>
                                <th v-show="showWhat('expire_date')=='yes'" class="text-center" style="min-width: 160px;">@lang('layout.ExpireDate')</th>
                                @endif
                                @if(getShowWing()!="false")
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Wing')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.ApproxWeight')</th>
                                @endif
                                @if(systemConfig()[9] == 0 || getCubicMetereItems()=="true")
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Width')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Length')</th>
                                @endif
                                @if(getCubicMetereItems()=="true")
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Gauge')</th>
                                @endif
                                @if(getShowSuperceedNo()=="true")
                                <th style="min-width: 150px;">@lang('layout.SuperceedNo')</th>
                                @endif
                                @if(itemBrand()=="true")
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Brand')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Description')</th>
                                @endif
                                @if(showLocation()=="true")
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Location')</th>
                                @endif
                                @if(getOtherMeasure()=="true")
                                <th class="text-center" style="min-width: 160px;">@lang('layout.OMeasureValue') 1</th>
                                @endif
                                @if(getOtherMeasure2()=="true")
                                <th class="text-center" style="min-width: 160px;">@lang('layout.OMeasureValue') 2</th>
                                @endif
                                <th></th>

                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="(service,index) in services">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select placeholder="@lang('layout.SelectSite') " label="name" :options="sites" @click.native="addNew(index)" @keyup.native="addNew(index)" v-model="service.site"></v-select>
                                    <input type="hidden" :name="'site_id['+index+']'" :value="(service.site)?service.site.id:null">
                                    <input type="hidden" :name="'main_stocks_id['+index+']'" :value="(service.item)?service.item.main_stocks_id:null">
                                    <input type="hidden" :name="'m_stocks_in_id['+index+']'" :value="(service.item)?service.item.m_stocks_in_id:null">
                                </td>
                                <td>
                                    <input :name="'code['+index+']'" :value="(service.item.code)?service.item.code:null" ref="code" @input="setRate()" type="text" class="form-control" placeholder="@lang('layout.Code')" />
                                </td>
                                <td>
                                    <input :name="'qut_in['+index+']'" :value="(service.item.qut_in)?service.item.qut_in:null" ref="qut_in" @input="setRate(),changeApproxWeight(index),changeMetraz(index)" type="number" class="form-control" placeholder="@lang('layout.OnHand')" />
                                </td>
                                <td>
                                    <input :name="'cost_in['+index+']'" :value="(service.item.cost_in)?service.item.cost_in:null" ref="cost_in" @input="setRate()" type="number" class="form-control" placeholder="@lang('layout.CostInInventory')" />
                                </td>
                                @if(systemConfig()[21] == 1)
                                <td>
                                    <input :name="'unit_price['+index+']'" type="number" @input="setRate(), changeCost(index)" class="form-control" placeholder="@lang('layout.UnitPrice')" ref="unit_price" :value="(service.item)?service.item.unit_price:null" >
                                </td>
                                @endif
                                <td>
                                    <input :name="'price_in['+index+']'" :value="(service.item.price_in)?service.item.price_in:null" ref="price_in" @input="setRate()" type="number" class="form-control" placeholder="@lang('layout.Default_Rate')" />
                                </td>
                                @if(systemConfig()[9] != 0 )
                                <td>
                                    <input :name="'image['+index+']'" type="file" class="form-control" placeholder="@lang('layout.Photo')" />
                                    <input type="hidden" :name="'last_image['+index+']'" v-model="(service.item==null)?null:service.item.image" />
                                </td>
                                <td v-show="showWhat('expire_date')=='yes'">
                                    <date_picker :name="'expire_date['+index+']'" :value="(service.item.expire_date)?service.item.expire_date:null" placeholder="@lang('layout.ExpireDate')"></date_picker>
                                </td>
                                @endif
                                @if(getShowWing()!="false")
                                <td>
                                    <input :name="'khada['+index+']'" :value="(service.item.khada)?service.item.khada:null" ref="khada" @input="setRate(),changeApproxWeight(index)" type="number" class="form-control" placeholder="@lang('layout.Wing')" />
                                </td>
                                <td>
                                    <input :name="'approx_weight['+index+']'" :value="(service.item.approx_weight)?service.item.approx_weight:null" ref="approx_weight" @input="setRate()" type="number" step="any" class="form-control" placeholder="@lang('layout.ApproxWeight')" />
                                </td>
                                @endif
                                @if(systemConfig()[9] == 0 || getCubicMetereItems()=="true")
                                <td>
                                    <input :name="'widths['+index+']'" :value="(service.item.widths)?service.item.widths:null" ref="widths" @input="setRate(),changeMetraz(index)" type="number" class="form-control" placeholder="@lang('layout.Width')" />
                                </td>
                                <td>
                                    <input :name="'lengths['+index+']'" :value="(service.item.lengths)?service.item.lengths:null" ref="lengths" @input="setRate(),changeMetraz(index)" type="number" class="form-control" placeholder="@lang('layout.Length')" />
                                </td>
                                @endif
                                @if(getCubicMetereItems()=="true")
                                <td>
                                    <input :name="'item_gauge['+index+']'" type="number" :value="(service.item.gauge)?service.item.gauge:null" ref="gauge" @input="setRate(),changeMetraz(index)" class="form-control" placeholder="@lang('layout.Gauge')">
                                </td>
                                @endif
                                @if(getShowSuperceedNo()=="true")
                                <td>
                                    <input :name="'superceed['+index+']'" type="text" v-model="service.item.superceed" ref="superceed" @input="setRate()" class="form-control" placeholder="@lang('layout.SuperceedNo')">
                                </td>
                                @endif
                                @if(itemBrand()=="true")
                                <td>
                                    <v-select placeholder="@lang('layout.Brand')" label="name" :options="brand" v-model="service.item.selectedBrand"></v-select>
                                    <input type="hidden" :name="'brand_id['+index+']'" :value="(service.item.selectedBrand)?service.item.selectedBrand.id:null">
                                </td>
                                <td>
                                    <input :name="'description_in['+index+']'" type="text" v-model="service.item.description" ref="description" @input="setRate()" class="form-control" placeholder="@lang('layout.Description')">
                                </td>
                                @endif
                                @if(showLocation()=="true")
                                <td>
                                    <input :name="'location['+index+']'" type="text" v-model="service.item.location" ref="location" @input="setRate()" class="form-control" placeholder="@lang('layout.Location')">
                                </td>
                                @endif
                                @if(getOtherMeasure()=="true")
                                <td>
                                    <input :name="'o_measure_value1['+index+']'" type="number" v-model="service.item.o_measure_value1" ref="o_measure_value1" @input="setRate(), changeCost(index)" class="form-control" placeholder="@lang('layout.OMeasureValue') 1">
                                </td>
                                @endif
                                @if(getOtherMeasure2()=="true")
                                <td>
                                    <input :name="'o_measure_value2['+index+']'" type="number" v-model="service.item.o_measure_value2" ref="o_measure_value2" @input="setRate()" class="form-control" placeholder="@lang('layout.OMeasureValue') 2">
                                </td>
                                @endif
                                <td>

                                    @if($edit_sale != "yes")
                                    <span v-on:click="deleteItem(index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                    @endif
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="text-center">
                    <button type="button" @click="addNew(1000)" class="btn btn-success"><i class="fa fa-plus"></i></button>
                </div>
            </div>

            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center">
                <a v-if="isError" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</a>
                <a href="{{route('inventory.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
            </div>
            {{Form::close()}}
            <!-- END FORM-->
        </div>
    </div>
</div>

@endsection
@push('scripts')


<script>
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    Vue.component('modal', {
        template: '#vendor-template'
    })

    Vue.component('modal', {
        template: '#modal-template'

    })

    Vue.component('v-select', VueSelect.VueSelect)
    // var s_u_m={!! $my_o_um_id !!};
    // console.log('test 33',s_u_m);
    let vu = new Vue({
        el: '#item-service',
        data: {
            incomeAccount: null,
            canUpdate: "{{ $canUpdate }}",
            costAccount: null,
            assetAccount: null,
            measureSelected: null,
            measureSelected2: null,
            measureSelected3: null,
            measureSelected4: null,
            otherMeasureSelected:null,
            allMeasureList:{!! json_encode($measure) !!},
            measureList:{!! json_encode($measure) !!},
            otherMeasureList:{!! json_encode($measure) !!},
            category:null,
			brand:{!! json_encode($brand) !!},
            selectedBrand:null,
            site:null,
            sites:{!! json_encode($site) !!},
            type: 'inventoryPart',
            measures: {!! json_encode($measure) !!},
            cost: {!! $itemCost !!},
            // othermeasure:s_u_m ,
            total: 0,
            errorMessage: '',
            showModal: false,
            fieldErrors: [],
            selectedMetric: {},
            senddata: {},
            selectedMeasure: {},
            metricList:{!!json_encode(getMeasures())!!},
            open_stock_data:{!!json_encode($opening)!!},
            services: [],
        },
        computed: {

            isError: function() {
                @if(getAddItemWithZeroRate() != 'true')
                var isError=false;
                if(this.cost>0)
                {
                    isError= true;
                }
                @else
                var isError=true;
                @endif
                
                return isError;
            },
            description: function(createElement) {
                this.total = this.cost * this.noHand
            },
            result: function() {
                var total = 0
                var cost = this.cost;

                this.services.forEach(function(item) {
                    total += (item.item.qut_in) ? (Number.parseFloat(item.item.qut_in) * ((Number.parseFloat(item.item.cost_in) > 0) ? Number.parseFloat(item.item.cost_in) : cost)) : 0;
                })
                return total;

                // return this.cost * this.onHand;
            },
            onHand: function() {

                var total = 0
                this.services.forEach(function(item) {
                    total += (item.item.qut_in) ? (Number.parseFloat(item.item.qut_in)) : 0;
                })
                // console.log('hh',this.services);
                return total;
            }


        },



        mounted: function() {
            // initialize the selected item
            for (var i = 0; i < this.open_stock_data.length; i++) {
                this.open_stock_data[i].selectedBrand = _.find({!!json_encode($brand) !!}, (o) => o.id == this.open_stock_data[i]['brand_id']);
                // console.log('ssssssss', this.open_stock_data[i]);

                this.services.push({
                    item: this.open_stock_data[i],
                    site: this.open_stock_data[i]
                });

            }

        },

        methods: {
            onComplete: function() {
                // document.getElementById("account-form").submit()
                //                this.$emit('on-complete')
                //                alert('Yay. Done!');
            },
            OtherMeasureChange: function() {
                this.measureList = this.allMeasureList.slice();
                this.othermeasureList = this.allMeasureList.slice();

                if (this.measureSelected) {
                    var temp = [];
                    for (var i = 0; i < this.measureList.length; i++) {
                        if (this.measureList[i].quantity_id != this.measureSelected.quantity_id) {
                            temp.push(this.measureList[i]);
                        }
                    }
                    this.othermeasureList = temp;

                }

            },
            changeCost(index) {
                @if(systemConfig()[21] == 1)
                if (vu.services[index].item) {
                    if (vu.services[index].item.o_measure_value1 != null && vu.services[index].item.unit_price != null) {
                        var o_measure_value1 = vu.services[index].item.o_measure_value1;
                        var unit_price = vu.services[index].item.unit_price;
                        vu.services[index].item.cost_in = myRound(o_measure_value1 * unit_price);
                    }
                }
                @endif
            },
            changeApproxWeight(index) {
                @if(getShowWing()!="false")
                if (vu.services[index]) {
                    if (vu.services[index].item != null) {
                        if (vu.services[index].item.khada && vu.services[index].item.qut_in) {
                            // console.log(vu.services[index].item.khada, vu.services[index].item.qut_in);
                            var khada = Number.parseFloat(vu.services[index].item.khada);
                            var quantity = Number.parseFloat(vu.services[index].item.qut_in);

                            if (khada != null && quantity != null) {
                                vu.services[index].item.approx_weight = Number.parseFloat(quantity / khada).toFixed(10);
                            }
                        }
                    }
                }
                @endif
            },
            changeMetraz(index) {
                @if(getCubicMetereItems()=="true")
                    setTimeout(() => {
                        if (vu.services[index]) {
                            if (vu.services[index].item != null) {
                                if (vu.services[index].item.lengths != null && vu.services[index].item.widths != null && vu.services[index].item.qut_in != null) {
                                    var qty =  Number.parseFloat(vu.services[index].item.qut_in);
                                    var width =  Number.parseFloat(vu.services[index].item.widths);
                                    var length =  Number.parseFloat(vu.services[index].item.lengths);
                                    var gauge =  Number.parseFloat(vu.services[index].item.gauge);

                                    vu.services[index].item.khada = Number.parseFloat(qty * (width * length)).toFixed(precision());
                                    if (vu.services[index].item.gauge != null) {
                                        vu.services[index].item.o_measure_value1 = Number.parseFloat(qty * gauge * width * length).toFixed(precision());
                                    }
                                }
                            }
                        }
                    }, 400);
                @endif
            },

            addMeasure: function() {

                let senddata = _.clone(this.selectedMetric);

                senddata.measure = _.clone(this.selectedMeasure);

                var req = axios.post("{{route('measure.store')}}", senddata)
                    .then(function(response) {
                        vu.showModal = false;
                        vu.fieldErrors = [];
                        vu.selectedMetric = {};
                        vu.selectedMeasure = {};

                        axios.get("{{route('inventory.create')}}").then(function(response) {

                            vu.measureList = response.data;
                        });


                    })
                    .catch(function(error) {
                        axios.get("{{route('inventory.create')}}").then(function(response) {

                            vu.measureList = response.data;
                        });

                        vu.fieldErrors = error.response.data

                    });

            },
            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        // alert(e.target);
                        vu.submitInventory(e.target);
                    }
                });
            },
            submitInventory: function() {

                swal({
                    title: "@lang('layout.AreYouSure?')",

                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],

                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("inventory-edit-form").submit()

                    } else {

                    }
                });
            },

            setData: function() {

                this.measureSelected = _.find(this.measureList, (o) => o.id == {{$inventory->um_id }});

                @if(getM2() != "" && $inventory->um1_id != null)
                vu.measureSelected2 = _.find(this.measureList, (o) => o.id == {{$inventory->um1_id }});
                @endif

                @if(getM3() != "" && $inventory->um2_id)
                vu.measureSelected3 = _.find(this.measureList, (o) => o.id == {{$inventory->um2_id}});
                @endif

                @if(getM4() != "" && $inventory->um3_id)
                vu.measureSelected4 = _.find(this.measureList, (o) => o.id == {{$inventory->um3_id}});
                @endif

                // if(this.othermeasure)
                // {
                //     this.otherMeasureSelected   = _.find(this.measureList, (o) => o.id == this.othermeasure);
                // }
                // console.log('test',this.othermeasure);

                this.incomeAccount = _.find({!!json_encode($income) !!}, (o) => o.id == {{$inventory->income}});
                this.costAccount = _.find({!!json_encode($cost) !!}, (o) => o.id == {{$inventory->cost_account}});
                this.assetAccount = _.find({!!json_encode($asset) !!}, (o) => o.id == {{$inventory->asset}});
                @if($inventory->category)
                this.category = _.find({!!json_encode($category) !!}, (o) => o.id == {{$inventory->category}});
                @endif
                @if($inventory->inventory_brand_id)
                this.selectedBrand = _.find({!!json_encode($brand) !!}, (o) => o.id == {{$inventory->inventory_brand_id}});
                @endif

            },

            setRate() {
                for (var i = 0; i < this.services.length; i++) {
                    this.services[i].item.code = this.$refs.code[i].value;
                    @if(getShowWing()!="false")
                    if (this.$refs.khada) {
                        this.services[i].item.khada = this.$refs.khada[i].value;
                    }
                    if (this.$refs.approx_weight) {
                        this.services[i].item.approx_weight = this.$refs.approx_weight[i].value;
                    }
                    @endif
                    @if(getCubicMetereItems()=="true")
                    if (this.$refs.gauge) {
                        this.services[i].item.gauge = this.$refs.gauge[i].value;
                    }
                    @endif
                    if (this.$refs.widths) {
                        // console.log('eee');
                        this.services[i].item.lengths = this.$refs.lengths[i].value;
                        this.services[i].item.widths = this.$refs.widths[i].value;
                    }
                    // this.services[i].item.expire_date = this.$refs.expire_date[i].value;
                    this.services[i].item.cost_in = this.$refs.cost_in[i].value;
                    this.services[i].item.price_in = this.$refs.price_in[i].value;
                
                    @if(itemBrand()=="true")
                    if(this.$refs.description) {
                        this.services[i].item.description = this.$refs.description[i].value;
                    }
                    @endif
                    @if(showLocation()=="true")
                    if(this.$refs.location) {
                        this.services[i].item.location = this.$refs.location[i].value;
                    }
                    @endif
                    @if(getShowSuperceedNo()=="true")
                    if(this.$refs.superceed) {
                        this.services[i].item.superceed = this.$refs.superceed[i].value;
                    }
                    @endif
                    @if(getOtherMeasure()=="true")
                    if(this.$refs.o_measure_value1) {
                        this.services[i].item.o_measure_value1 = this.$refs.o_measure_value1[i].value;
                    }
                    @endif
                    @if(getOtherMeasure2()=="true")
                    if(this.$refs.o_measure_value2) {
                        this.services[i].item.o_measure_value2 = this.$refs.o_measure_value2[i].value;
                    }
                    @endif
                    @if(systemConfig()[21] == 1)
                    if(this.$refs.unit_price) {
                        this.services[i].item.unit_price = this.$refs.unit_price[i].value;
                    }
                    @endif
                    this.services[i].item.qut_in = this.$refs.qut_in[i].value;
                }
            },

            // generic function for adding item to list
            addNew(index) {
                this.setRate();

                if (this.services[index + 1] == undefined) {
                    this.services.push({
                        item: {
                            name: null,
                            site: null,
                            id: 0,
                            inventory_site_id: null,
                            main_stocks_id: null,
                            m_stocks_in_id: null,
                            code: null,
                            lengths: null,
                            widths: null,
                            khada: null,
                            approx_weight: null,
                            // expire_date:null,
                            qut_in: null,
                            cost_in: null,
                            price_in: null,
                            unit_price: null,
                            selectedBrand: null,
                            o_measure_value1: null,
                            o_measure_value2: null
                        }
                    });

                }


            },
            // delete item from list
            deleteItem(index) {
                this.setRate();
                this.services.splice(index, 1);

            }


        }



    });

    vu.setData();
</script>


@endpush