@extends('layouts.app')
@section('style')
<style>
    .v-select input[type=search],
    .v-select input[type=search]:focus {
        width: 50% !important;
    }
    .table>tbody>tr>td,
    .table>tbody>tr>th,
    .table>tfoot>tr>td,
    .table>tfoot>tr>th,
    .table>thead>tr>td,
    .table>thead>tr>th {
        padding: 8px;
        padding: 4px 2px;
    }
    .input-has-error {
        outline: 1px solid #ff0000 !important;
        background-color: #ff000014;
    }
    .dropdown-toggle .clear {
        display: none;
    }
    .required {
        padding-left: 0px !important;
    }
</style>
@stop
@section('content')
@include('inventories.cmodal')
@include('inventories.modal')
<!-- BEGIN CONTENT BODY -->
<!-- END PAGE BAR -->
<div class="row">
    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.AddNewItem')</span>
                {{--<span class="caption-helper">@lang('layout.someinfo...')</span>--}}
            </div>
        </div>
        <div class="portlet-body form" id="item-service" v-cloak style="margin-bottom:20%;">
            <!-- BEGIN FORM-->
            {{Form::open(['route' => 'inventory.m_store','method' => 'POST','id' => 'inventory-form','files'=> true])}}
            <div class="form-body">
                <div class="row" style="margin-bottom: 20px; padding: 10px;">
                    <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
                        <div class="row" style="padding: 0.5% 1%;">
                            <div class="col-lg-12">
                                <div class="row">
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.ItemName')</label>
                                            {{Form::text('name',null,['class' => 'form-control','placeholder' => __('layout.EnterItemName'),'v-validate' =>'"required|min:2"','data-vv-as' => __('layout.Name')])}}
                                            <span class="required">@{{ errors.first('name') }}</span>
                                            {{--<span class="help-block"> This is inline help </span>--}}
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                           <label class="control-label">@lang('layout.ItemType')</label>
                                             <select class="form-control" name="type">
                                                 <option selected="selected" value="inventoryPart">@lang('layout.InventoryPart')</option>
                                                 <option value="inventoryAssembly">@lang('layout.InventoryAssembly')</option>
                                                 <option value="workingProgress">@lang('layout.WorkingProgress')</option>
                                                 <option value="procurement">@lang('layout.Procurement')</option>
                                             </select>
                                       </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.ItemCode'):</label>
                                            <input type="text" name="number" v-model="number" @input="checkNo()" placeholder = "@lang('layout.ItemCode')" v-validate='"required"' data-vv-as="@lang('layout.ItemCode')" class='form-control' />
                                            <span class="required">@{{ errors.first('number') }}</span>
                                            <span v-if="number_Error ==true" class="input-has-error" style="color: red">@{{number_msg}}</span>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        @if(systemConfig()[9] == 0 )
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.Gauge')</label>
                                            {{Form::number('gauge',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.Gauge'),'v-validate' =>'"required"','data-vv-as' => __('layout.Gauge')])}}
                                            <span class="required">@{{ errors.first('gauge') }}</span>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                                <div class="row"> 
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.U_M_Set')</label>
                                        <div class="input-group">
                                            <v-select placeholder="@lang('layout.SelectUnitMeasure') " label="name" :options="measureList" @input="OtherMeasureChange" v-model="measureSelected"></v-select>
                                            <input type="hidden" name="um_id" v-validate="'required'" data-vv-as="@lang('layout.U_M_Set')" :value="(measureSelected)?measureSelected.id:null">
                                            <span class="required">@{{ errors.first('um_id') }}</span>
                                            {{--{{Form::select('income_account',$income,null,['class' => 'form-control'])}}--}}
                                            <span class="btn btn-success  input-group-addon" @click="showModal = true, acount_type = 'income'" style="background-color:  rgb(84, 199, 211)"> <i class="fa fa-plus" style="color: white"></i>
                                            </span>
                                        </div>
                                        <div id="measure">
                                            <modal v-if="showModal" @close="showModal = false">
                                                <div slot="body">
                                                    <div class="row">
                                                        <div class="col-md-3">
                                                            <h4>@lang('layout.MetricType')</h4>
                                                            <span v-for="metric in metricList">
                                                                <div class="mt-radio-list">
                                                                    <label class="mt-radio"> @{{ metric.name }}
                                                                        <input name="metric" type="radio" v-bind:value="metric" v-model="selectedMetric" v-on:change="selectedMeasure = {}">
                                                                        <span></span>
                                                                    </label>
                                                                </div>
                                                            </span>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <h4>@lang('layout.Measure') </h4>
                                                            <span v-for="measure1 in selectedMetric.measure">
                                                                <div class="mt-radio-list">
                                                                    <label class="mt-radio"> @{{ measure1.text }}
                                                                        <input name="measureds" type="radio" v-bind:value="measure1" v-model="selectedMeasure">
                                                                        <span></span>
                                                                    </label>
                                                                </div>
                                                            </span>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <span v-if="selectedMeasure.text == 'Other'">
                                                                <h4 class="text-center">@lang('layout.OtherMeasure') </h4>
                                                                <div>
                                                                    <div class="form-group">
                                                                        <label class="control-label col-md-5">
                                                                            @lang('layout.MeasureName')</label>
                                                                        <div class="col-md-7">
                                                                            <input type="text" class="form-control" placeholder="@lang('layout.EnterMeasureName')" v-model.trim="selectedMeasure.name">
                                                                            <span class="help-block"> </span>
                                                                        </div>
                                                                    </div>
                                                                    <div class="form-group">
                                                                        <label class="control-label col-md-5">
                                                                            @lang('layout.MeasureAmount')
                                                                        </label>
                                                                        <div class="col-md-7">
                                                                            <input type="number" class="form-control" placeholder="@lang('layout.EnterMeasureuint')" v-model.number="selectedMeasure.unit">
                                                                            <span class="help-block"> </span>
                                                                        </div>
                                                                    </div>
                                                                    <div class="form-group ">
                                                                        <label class="control-label col-md-5">
                                                                            @lang('layout.MeasureSymbol')
                                                                        </label>
                                                                        <div class="col-md-7">
                                                                            <input type="text" class="form-control" placeholder="@lang('layout.EnterMeasureSymbol')" v-model.trim="selectedMeasure.symbol">
                                                                            <span class="help-block"> </span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <h3 slot="header">
                                                    <div class="col-md-12">
                                                        <h3>
                                                            @lang('layout.AddNewMeasure')
                                                        </h3>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div v-if="fieldErrors.length > 0">
                                                            <p class="text-danger" fieldErrors>
                                                                <spna v-text="fieldErrors"></spna>
                                                            </p>
                                                        </div>
                                                    </div>
                                                </h3>
                                                <div slot="footer">
                                                    <button type=button class="modal-default-button btn btn-success" v-on:click="addMeasure">
                                                        @lang('layout.OK')
                                                    </button>
                                                    <button type=button class="modal-default-button btn btn-danger" v-on:click="showModal = false ,measure = null , type=null">
                                                        @lang('layout.Cancel')
                                                    </button>
                                                </div>
                                            </modal>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.CostInInventory')</label>
                                            {{Form::number('cost',null,['class' => 'form-control','v-model'=>'cost',':class'=>'{"input-has-error":!isError}','step' => 'any','min' =>'0','v-validate' =>'"required"','data-vv-as' => __('layout.CostInInventory')])}}
                                            <span class="required">@{{ errors.first('cost') }}</span>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.Default_Rate')</label>
                                            {{Form::number('rate',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.Default_Rate'),'v-validate' =>'"decimal:10"','data-vv-as' => __('layout.Default_Rate')])}}
                                            <span class="required">@{{ errors.first('rate') }}</span>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Photo')</label>
                                            {!! Form::file('photo', null, array('placeholder' => 'photo','class' => 'form-control')) !!}
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.AssetAccount')</label>
                                            <v-select placeholder="@lang('layout.SelectAssetAccount')" label="name" :options="{{ json_encode($asset) }}" v-model="assetAccount"></v-select>
                                            <input type="hidden" name="asset_account" v-validate="'required'" data-vv-as="@lang('layout.AssetAccount')" :value="(assetAccount)?assetAccount.id:null">
                                            <span class="required">@{{ errors.first('asset_account') }}</span>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.IncomeAccount')</label>
                                            <v-select placeholder="@lang('layout.SelectIncomeAccount')" label="name" :options="{{ json_encode($income) }}" v-model="incomeAccount"></v-select>
                                            <input type="hidden" name="income_account" v-validate="'required'" data-vv-as="@lang('layout.IncomeAccount')" :value="(incomeAccount)?incomeAccount.id:null">
                                            <span class="required">@{{ errors.first('income_account') }}</span>
                                            {{--{{Form::select('income_account',$income,null,['class' => 'form-control'])}}--}}
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.CostAccount')</label>
                                            <v-select placeholder="@lang('layout.SelectCostAccount')" label="name" :options="{{ json_encode($cost) }}" v-model="costAccount"></v-select>
                                            <input type="hidden" name="cost_account" v-validate="'required'" data-vv-as="@lang('layout.CostAccount')" :value="(costAccount)?costAccount.id:null">
                                            <span class="required">@{{ errors.first('cost_account') }}</span>
                                        </div>
                                    </div>
                                    @if(itemBrand()=="true")
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Location')</label>
                                                {{Form::text('item_location',null,['class' => 'form-control','placeholder' => __('layout.Location')])}}
                                            </div>
                                        </div>
                                    @endif
                                </div>
                                <div class="row">
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Min')</label>
                                            {{Form::number('min',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.Min')])}}
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Max')</label>
                                            {{Form::number('max',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.Max')])}}
                                        </div>
                                    </div> 
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.Category'):</label>
                                        <div class="input-group">
                                            <v-select placeholder="@lang('layout.SelectInventoryCategory')" label="name" tabindex='10' :options="categories" v-model="category"></v-select>   
                                            <input type="hidden" name="category" :value="(category)?category.id:null">
                                            <span class="btn btn-success input-group-addon " @click="showcModal = true, acount_type = 'otherCurrentAsset'" style="background-color:  rgb(84, 199, 211)"><i class="fa fa-plus" style="color: white"></i></span>
                                        </div>
                                        <div id="measure">
                                            <modal v-if="showModal" @close="showModal = false">
                                                <div slot="body">
                                                    <div class="row">
                                                        <div class="col-md-3">
                                                            <h4>@lang('layout.MetricType')</h4>
                                                            <span v-for="metric in metricList">
                                                                <div class="mt-radio-list">
                                                                    <label class="mt-radio"> @{{ metric.name }}
                                                                        <input name="metric" type="radio" v-bind:value="metric" v-model="selectedMetric" v-on:change="selectedMeasure = {}">
                                                                        <span></span>
                                                                    </label>
                                                                </div>
                                                            </span>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <h4>@lang('layout.Measure') </h4>
                                                            <span v-for="measure1 in selectedMetric.measure">
                                                                <div class="mt-radio-list">
                                                                    <label class="mt-radio"> @{{ measure1.text }}
                                                                        <input name="measureds" type="radio" v-bind:value="measure1" v-model="selectedMeasure">
                                                                        <span></span>
                                                                    </label>
                                                                </div>
                                                            </span>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <span v-if="selectedMeasure.text == 'Other'">
                                                                <h4 class="text-center">@lang('layout.OtherMeasure') </h4>
                                                                <div>
                                                                    <div class="form-group">
                                                                        <label class="control-label col-md-5">
                                                                            @lang('layout.MeasureName')</label>
                                                                        <div class="col-md-7">
                                                                            <input type="text" class="form-control" placeholder="@lang('layout.EnterMeasureName')" v-model.trim="selectedMeasure.name">
                                                                            <span class="help-block"> </span>
                                                                        </div>
                                                                    </div>
                                                                    <div class="form-group">
                                                                        <label class="control-label col-md-5">
                                                                            @lang('layout.MeasureAmount')
                                                                        </label>
                                                                        <div class="col-md-7">
                                                                            <input type="number" class="form-control" placeholder="@lang('layout.EnterMeasureuint')" v-model.number="selectedMeasure.unit">
                                                                            <span class="help-block"> </span>
                                                                        </div>
                                                                    </div>
                                                                    <div class="form-group ">
                                                                        <label class="control-label col-md-5">
                                                                            @lang('layout.MeasureSymbol')
                                                                        </label>
                                                                        <div class="col-md-7">
                                                                            <input type="text" class="form-control" placeholder="@lang('layout.EnterMeasureSymbol')" v-model.trim="selectedMeasure.symbol">
                                                                            <span class="help-block"> </span>
                                                                        </div>
                                                                    </div>
                                                                </div>
        
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <h3 slot="header">
                                                    <div class="col-md-4">
                                                        <h3>
                                                            @lang('layout.AddNewMeasure')
                                                        </h3>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div v-if="fieldErrors.length > 0">
                                                            <p class="text-danger" fieldErrors>
                                                                <spna v-text="fieldErrors"></spna>
                                                            </p>
                                                        </div>
                                                    </div>
                                                </h3>
                                                <div slot="footer">
                                                    <button type=button class="modal-default-button btn btn-success" v-on:click="addMeasure">
                                                        @lang('layout.OK')
                                                    </button>
                                                    <button type=button class="modal-default-button btn btn-danger" v-on:click="showModal = false ,measure = null , type=null">
                                                        @lang('layout.Cancel')
                                                    </button>
                                                </div>
                                            </modal>
                                        </div>
                                    </div>
                                    @if(itemBrand()=="true")
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('menu.InventoryBrand'):</label>
                                                <v-select placeholder="@lang('menu.InventoryBrand')" label="name" :options="brand" v-model="selectedBrand"></v-select>
                                                <input type="hidden" name="inventory_brand_id" :value="(selectedBrand)?selectedBrand.id:null">
                                            </div>
                                        </div>
                                    @endif
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            {{Form::textarea('description',null,['class' => 'form-control','rows' => '1','placeholder' => __('layout.Description')])}}
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.TotalValue')</label>
                                            {{Form::number('total',null,['class' => 'form-control','v-model'=>'result','step' => 'any','min' =>'0' ,'disabled'])}}
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Date')</label>
                                            <input type="text" name="date" placeholder="@lang('layout.Date')" class="form-control date" autocomplete="off">
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.OnHand')</label>
                                            <input type="number" disabled class="form-control" v-model='onHand'>
                                            {{--{{Form::number('quantity',null,['class' => 'form-control','v-model'=>'onHand
                                            ','step' => 'any','min' =>'0'])}}--}}
                                        </div>
                                    </div>
                                    @if(getOtherMeasure()=="true")
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.OMeasureName') 1</label>
                                                <input type="text" name="o_measure_name" placeholder="@lang('layout.OMeasureName') " class="form-control">
                                            </div>
                                        </div>
                                        <!-- <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.OMeasureValue')</label>
                                                {{Form::number('o_measure_value',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.OMeasureValue')])}}
                                            </div>
                                        </div> -->
                                        <!-- </div>
                                        <div class="row"> -->
                                    @endif
                                </div>
                                <div class="row">
                                    @if(getOtherMeasure2()=="true")
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.OMeasureName') 2</label>
                                                <input type="text" name="other_um_id" placeholder="@lang('layout.OMeasureName') " class="form-control">
                                            </div>
                                        </div>
                                        <!-- <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.OMeasureValue')</label>
                                                {{Form::number('um_exchange',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.OMeasureValue')])}}

                                            </div>
                                        </div> -->
                                        <!-- <div class="row">
                                            <div class="col-md-8">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.OMeasureName')</label>
                                                    <v-select placeholder="@lang('layout.OMeasureName') " label="name"  :options="othermeasureList" v-model="othermeasureSelected" ></v-select>
                                                    <input type="hidden" name="other_um_id" :value="(othermeasureSelected)?othermeasureSelected.id:null">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.OMeasureExchangeValue')</label>
                                                    {{Form::number('um_exchange',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.OMeasureExchangeValue')])}}

                                                </div>
                                            </div>
                                            </div>
                                            <div class="row">
                                            <div class="col-md-8">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.OMeasureName')</label>
                                                    
                                                    <input type="text" name="o_measure_name" placeholder="@lang('layout.OMeasureName') " class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.OMeasureValue')</label>
                                                    {{Form::number('o_measure_value',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.OMeasureValue')])}}

                                                </div>
                                            </div>
                                        </div> -->
                                    @endif
                                    @if(getM2()!="")
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Measure2')</label>
                                                <v-select placeholder="@lang('layout.SelectUnitMeasure2') " label="name" :options="measureList" @input="OtherMeasureChange" v-model="measureSelected2"></v-select>
                                                <input type="hidden" name="um_id2" :value="(measureSelected2)?measureSelected2.id:null">
                                            </div>
                                        </div>
                                    @endif
                                    @if(getM3()!="")
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Measure3')</label>
                                                <v-select placeholder="@lang('layout.SelectUnitMeasure3') " label="name" :options="measureList" @input="OtherMeasureChange" v-model="measureSelected3"></v-select>
                                                <input type="hidden" name="um_id3" :value="(measureSelected3)?measureSelected3.id:null">
                                            </div>
                                        </div>
                                    @endif
                                    @if(getM4()!="")
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Measure4')</label>
                                                <v-select placeholder="@lang('layout.SelectUnitMeasure4') " label="name" :options="measureList" @input="OtherMeasureChange" v-model="measureSelected4"></v-select>
                                                <input type="hidden" name="um_id4" :value="(measureSelected4)?measureSelected4.id:null">
                                            </div>
                                        </div>
                                    @endif
                                </div>
                                <div class="row" style="margin-top: 5px;">
                                    @if(ImportEngineNumberByExcel()=="true")
                                        <div class="col-lg-3 col-md-12 col-sm-12 col-xs-12">
                                            <div class="col-md-12 form-group">
                                                <label class=" control-label">@lang('layout.ImportEngineNumberByExcel')</label>
                                                <div>
                                                    <label class="mt-checkbox mt-checkbox-outline">
                                                        <input type="checkbox" name="import_engine_number" v-model="import_engine_number">
                                                        <span></span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-3 col-md-12 col-sm-12 col-xs-12">
                                            <a href="{{url('/')}}/import_file/simple_import_engine_chassis_number_excel_file.xlsx">
                                            <span class="btn btn-success">
                                            <i class="fa fa-download"></i>
                                            @lang('layout.SampleExcelFile')
                                            </span>
                                            </a>
                                        </div>
                                    @endif
                                </div>
                                
                                
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        {{--<div class="form-group">--}}
                        {{--<label class="control-label col-md-3">tax</label>--}}
                        {{--<div class="col-md-9">--}}
                        {{--{{Form::select('tax',[],null,['class' => 'form-control'])}}--}}
                        {{--</div>--}}
                        {{--</div>--}}
                    </div>
                    <!--/span-->
                </div>
                <!--/row-->
                <br />
                <div class="row" style="overflow-x: scroll;">
                    <!-- begin payments -->
                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> # </th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Site')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Code')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.OnHand')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.CostInInventory')</th>
                                @if(systemConfig()[21] == 1)
                                <th class="text-center" style="min-width: 160px;">@lang('layout.UnitPrice')</th>
                                @endif
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Default_Rate')</th>
                                @if(systemConfig()[9] != 0 )
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Photo')</th>
                                <th v-show="showWhat('expire_date')=='yes'" class="text-center" style="min-width: 160px;">@lang('layout.ExpireDate')</th>
                                @endif
                                @if(getShowWing()!="false")
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Wing')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.ApproxWeight')</th>
                                @endif
                                @if(systemConfig()[9] == 0 || getCubicMetereItems()=="true")
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Width')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Length')</th>
                                @endif
                                @if(getCubicMetereItems()=="true")
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Gauge')</th>
                                @endif
                                @if(getShowSuperceedNo()=="true")
                                <th style="min-width: 50px;">@lang('layout.SuperceedNo')</th>
                                @endif
                                @if(itemBrand()=="true")
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Brand')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Description')</th>
                                @endif
                                @if(showLocation()=="true")
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Location')</th>
                                @endif
                                @if(getOtherMeasure()=="true")
                                <th class="text-center" style="min-width: 160px;">@lang('layout.OMeasureValue1')</th>
                                @endif
                                @if(getOtherMeasure2()=="true")
                                <th class="text-center" style="min-width: 160px;">@lang('layout.OMeasureValue2')</th>
                                @endif
                                @if(ImportEngineNumberByExcel()=="true")
                                <th v-if="import_engine_number" style="min-width: 50px">@lang('layout.EngineNumber') @lang('layout.File')</th>
                                @endif
                                <th></th>

                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="(service,index) in services">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select placeholder="@lang('layout.SelectSite') " label="name" :options="sites" @click.native="addNew(index)" @keyup.native="addNew(index)" v-model="service.site"></v-select>
                                    <input type="hidden" :name="'site_id['+index+']'" :value="(service.site)?service.site.id:null">
                                </td>
                                <td>
                                    <input :name="'code['+index+']'" type="text" v-model="service.maxCode" class="form-control" placeholder="@lang('layout.Code')">
                                </td>
                                <td>
                                    <input :name="'qut_in['+index+']'" type="number" class="form-control" placeholder="@lang('layout.OnHand')" v-model.number="service.qty" @input="changeApproxWeight(index),changeMetraz(index)">
                                </td>
                                <td>
                                    <input :name="'cost_in['+index+']'" type="number" class="form-control" placeholder="@lang('layout.CostInInventory')" v-model.number="service.cost_in">
                                </td>
                                @if(systemConfig()[21] == 1)
                                <td>
                                    <input :name="'unit_price['+index+']'" type="number" @input="changeCost(index)" class="form-control" placeholder="@lang('layout.UnitPrice')" v-model.number="service.unit_price">
                                </td>
                                @endif
                                <td>
                                    <input :name="'price_in['+index+']'" type="number" class="form-control" placeholder="@lang('layout.Default_Rate')" v-model.number="service.price_in">
                                </td>
                                @if(systemConfig()[9] != 0 )
                                <td>
                                    <input :name="'image['+index+']'" type="file" class="form-control" placeholder="@lang('layout.Photo')">
                                </td>
                                <td v-show="showWhat('expire_date')=='yes'">
                                    <date_picker :name="'expire_date['+index+']'" placeholder="@lang('layout.ExpireDate')"></date_picker>
                                </td>
                                @endif
                                @if(getShowWing()!="false")
                                <td>
                                    <input :name="'khada['+index+']'" type="number" v-model="service.khada" @input="changeApproxWeight(index)" class="form-control" placeholder="@lang('layout.Wing')">
                                </td>
                                <td>
                                    <input :name="'approx_weight['+index+']'" type="number"  v-model="service.approx_weight" step="any" class="form-control" placeholder="@lang('layout.ApproxWeight')">
                                </td>
                                @endif
                                @if(systemConfig()[9] == 0 || getCubicMetereItems()=="true")
                                <td>
                                    <input :name="'widths['+index+']'" type="number" v-model="service.widths" @input="changeMetraz(index)" class="form-control" placeholder="@lang('layout.Width')">
                                </td>
                                <td>
                                    <input :name="'lengths['+index+']'" type="number" v-model="service.lengths" @input="changeMetraz(index)" class="form-control" placeholder="@lang('layout.Length')">
                                </td>
                                @endif
                                @if(getCubicMetereItems()=="true")
                                <td>
                                    <input :name="'item_gauge['+index+']'" type="number" v-model="service.gauge" @input="changeMetraz(index)" class="form-control" placeholder="@lang('layout.Gauge')">
                                </td>
                                @endif
                                @if(getShowSuperceedNo()=="true")
                                <td>
                                    <input :name="'superceed['+index+']'" type="text" v-model="service.superceed" class="form-control" placeholder="@lang('layout.SuperceedNo')">
                                </td>
                                @endif
                                @if(itemBrand()=="true")
                                <td>
                                    <v-select placeholder="@lang('layout.Brand')" label="name" :options="brand" v-model="service.selectedBrand"></v-select>
                                    <input type="hidden" :name="'brand_id['+index+']'" :value="(service.selectedBrand)?service.selectedBrand.id:null">
                                </td>
                                <td>
                                    <input :name="'description_in['+index+']'" type="text" v-model="service.description" class="form-control" placeholder="@lang('layout.Description')">
                                </td>
                                @endif
                                @if(showLocation()=="true")
                                <td>
                                    <input :name="'location['+index+']'" type="text" v-model="service.location" class="form-control" placeholder="@lang('layout.Location')">
                                </td>
                                @endif
                                @if(getOtherMeasure()=="true")
                                <td>
                                    <input :name="'o_measure_value1['+index+']'" type="number" v-model="service.o_measure_value1" class="form-control" placeholder="@lang('layout.OMeasureValue') 1">
                                </td>
                                @endif
                                @if(getOtherMeasure2()=="true")
                                <td>
                                    <input :name="'o_measure_value2['+index+']'" type="number" v-model="service.o_measure_value2" class="form-control" placeholder="@lang('layout.OMeasureValue') 2">
                                </td>
                                @endif
                                @if(ImportEngineNumberByExcel()=="true")
                                <td v-if="import_engine_number">
                                    <input :name="'engine_number_file['+index+']'" type="file" class="form-control" placeholder="@lang('layout.EngineNumber')">
                                </td>
                                @endif
                                <td>
                                    <span v-on:click="deleteItem(index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <br />
                    <br />
                    <br />
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center">
                <a v-if="((isError) && (number_Error == false))" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</a>
                <button type="button" class="btn blue" @click="saveAndNew($event)" v-if="((isError) && (number_Error == false))" >@lang('layout.SaveAndNew')</button>
                <a href="{{route('inventory.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
            </div>
            {{Form::close()}}
            {!! Form::open(array('method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }}
                <cmodal :show="showcModal" @close="showcModal = false">
                    <h3 slot='cheader'>@lang('layout.AddNewCategory')</h3>
                    <div slot="cbody">
                        <label class="cform-label" for="name">@lang('layout.CategoryName'):</label>
                        {{Form::text('name',null,['class' => 'cform-control','placeholder' => __('layout.CategoryName'),'v-model'=>'nameCat'])}}

                        <label class="cform-label" for="parent">@lang('layout.ParentID'):</label>
                        {{Form::select('parent',$parent,Null,['class' => 'cform-control','placeholder' => __('layout.SelectParent'),'v-model'=>'parentCat'])}}

                        <label class="cform-label" for="description">@lang('layout.Description'):</label>
                        {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'cform-control','rows' => 6, 'cols' => 30,'v-model'=>'descriptionCat')) !!}

                    </div>
                    <div slot="cfooter">
                        <button type="button" class="modal-default-button btn btn-success" @click="savePost">
                            @lang('layout.Submit')
                        </button>
                    </div>
                </cmodal>
                <!-- <button id="show-modal" @click="showcModal = true">New Post</button> -->
            {!! Form::close() !!}
            <!-- END FORM-->
        </div>
    </div>
</div>

@endsection
@push('scripts')

<script>
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif


    Vue.component('modal', {
        template: '#vendor-template'
    })

    Vue.component('modal', {
        template: '#modal-template'
    })
    Vue.component('cmodal', {
        template: '#cmodal-template',
        props: ['show']
    });
    Vue.component('v-select', VueSelect.VueSelect)
    var income = {!! $income !!};
    var asset = {!! $asset !!};
    var cost_a= {!! $cost !!};
	var maxCode = {!! $maxCode !!};
    let vu = new Vue({
        el: '#item-service',
        data: {
            number:"{{$number}}",
            number_msg: '',
            import_engine_number: false,
            number_Error: false,
            showcModal: false,
            incomeAccount: null,
            costAccount: null,
            assetAccount: null,
            measureSelected: null,
            measureSelected2: null,
            measureSelected3: null,
            measureSelected4: null,
            subMeasureSelected: null,
            othermeasureSelected: null,
            allMeasureList: {!!json_encode($measure) !!},
            measureList: {!!json_encode($measure) !!},
            othermeasureList: [],
            categories: {!!json_encode($category) !!},
            category: null,
            brand: {!!json_encode($brand) !!},
            selectedBrand: null,
            sites: {!!json_encode($site) !!},
            site: [],
            type: 'inventoryPart',
            measures: {!!json_encode($measure) !!},
            maxCode: maxCode,
            cost: 0,
            nameCat: null,
            descriptionCat: null,
            parentCat: null,
            total: 0,
            errorMessage: '',
            showModal: false,
            fieldErrors: [],
            selectedMetric: {},
            senddata: {},
            selectedMeasure: {},
            metricList: {!!json_encode(getMeasures()) !!},
            services: [{
                site: null,
                qty: null,
                cost_in: null,
                unit_price: null,
                o_measure_value1: null,
                price_in: null,
                khada: null,
                approx_weight: null,
                maxCode: maxCode,
            }, ],
        },

        computed: {

            isError: function() {
                @if(getAddItemWithZeroRate() != 'true')
                var isError=false;
                if(this.cost>0)
                {
                    isError= true;
                }
                @else
                var isError=true;
                @endif
                
                return isError;
            },
            description: function(createElement) {
                this.total = this.cost * this.noHand
            },
            result: function() {
                var total = 0
                var cost = this.cost;
                this.services.forEach(function(site) {
                    // console.log('sssss',cost);
                    total += (site.qty) ? (site.qty * ((site.cost_in > 0) ? site.cost_in : cost)) : 0;
                })
                return total;
                // return this.cost * this.onHand;
            },
            onHand: function() {
                var total = 0
                this.services.forEach(function(site) {
                    total += (site.qty) ? (site.qty) : 0;
                })
                return total;
            }
        },
        mounted: function() {
            this.defaultValue();
        },
        methods: {

            defaultValue() {

                if (income.length > 0) {
                    this.incomeAccount = income[0];
                }
                if (asset.length > 0) {
                    this.assetAccount = asset[0];
                }
                if (cost_a.length > 0) {
                    this.costAccount = cost_a[0];
                }
            },
            checkNo() {
                var chack = 'false';
                var number = vu.number;
                if (number != null) {
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                number: vu.number,
                                method_name: 'Search_number',
                                table_name: 'items'
                            },
                        })
                        .then(function(response) {
                            // console.log(response.data.result);
                            if (response.data.result != null) {
                                vu.number_msg = "@lang('layout.DuplicateData')";
                                vu.number_Error = true;
                            } else {
                                vu.number_msg = 'no';
                                vu.number_Error = false;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });

                }
            },

            changeMetraz(index) {
                @if(getCubicMetereItems()=="true")
                    if (this.services[index]) {
                        if (this.services[index].lengths != null && this.services[index].widths != null && this.services[index].qty != null) {
                            var qty =  Number.parseFloat(this.services[index].qty);
                            var width =  Number.parseFloat(this.services[index].widths);
                            var length =  Number.parseFloat(this.services[index].lengths);
                            var gauge =  Number.parseFloat(this.services[index].gauge);

                            this.services[index].khada = Number.parseFloat(qty * (width * length)).toFixed(precision());
                            if (this.services[index].gauge != null) {
                                this.services[index].o_measure_value1 = Number.parseFloat(qty * gauge * width * length).toFixed(precision());
                            }
                        }
                    }
                @else
                    @if(systemConfig()[21] == 1)
                    if (this.services[index]) {
                        if (this.services[index].lengths != null && this.services[index].widths != null) {

                            var lengths = this.services[index].lengths;
                            var widths = this.services[index].widths;

                            this.services[index].o_measure_value1 = myRound(lengths * widths);

                            if (this.services[index].o_measure_value1 != null && this.services[index].unit_price != null) {
                                var o_measure_value1 = this.services[index].o_measure_value1;
                                var unit_price = this.services[index].unit_price;

                                this.services[index].cost_in = myRound(o_measure_value1 * unit_price);
                            }
                        }
                    }
                    @endif
                @endif
            },

            changeApproxWeight(index) {
                @if(getShowWing()!="false")
                if (this.services[index]) {
                    if (this.services[index].khada != null && this.services[index].qty) {
                        var khada = this.services[index].khada;
                        var quantity = this.services[index].qty;

                        if (khada != null && quantity != null) {
                            this.services[index].approx_weight = Number.parseFloat(quantity / khada).toFixed(10);
                        }
                    }
                }
                @endif
            },

            changeCost(index) {
                @if(systemConfig()[21] == 1)
                if (this.services[index]) {
                    if (this.services[index].o_measure_value1 != null && this.services[index].unit_price != null) {
                        var o_measure_value1 = this.services[index].o_measure_value1;
                        var unit_price = this.services[index].unit_price;

                        this.services[index].cost_in = myRound(o_measure_value1 * unit_price);
                    }
                }
                @endif
            },

            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        // alert(e.target);
                        vu.submitInventory(e.target);
                    }
                });
            },
            OtherMeasureChange: function() {
                this.measureList = this.allMeasureList.slice();
                this.othermeasureList = this.allMeasureList.slice();

                if (this.measureSelected) {
                    var temp = [];
                    for (var i = 0; i < this.measureList.length; i++) {
                        if (this.measureList[i].quantity_id != this.measureSelected.quantity_id) {
                            temp.push(this.measureList[i]);
                        }
                    }
                    this.othermeasureList = temp;

                }

            },

            onComplete: function() {
                // document.getElementById("account-form").submit()
                //                this.$emit('on-complete')
                //                alert('Yay. Done!');
            },
            savePost: function() {

                var test = {
                    name: this.nameCat,
                    description: this.descriptionCat,
                    parent: this.parentCat,
                    add: true
                };
                var req = axios.post("{{route('inventoryCategory.addCategory')}}", test)
                    .then(function(response) {
                        if (response) {
                            vu.category = response.data.category;
                        }
                        vu.showcModal = false;
                        vu.fieldErrors = [];
                        var data = {
                            id: response.data.id,
                            name: response.data.name
                        };
                        // vu.categories = response.data;
                        axios.get("{{route('inventoryCategory.create')}}").then(function(response) {
                            vu.nameCat = null,
                                vu.descriptionCat = null,
                                vu.parentCat = null,
                                vu.categories = response.data;
                        });
                    });
            },
            addMeasure: function() {
                let senddata = _.clone(this.selectedMetric);
                senddata.measure = _.clone(this.selectedMeasure);

                var req = axios.post("{{route('measure.store')}}", senddata)
                    .then(function(response) {
                        if (response) {
                            if (response.data) {
                                vu.measureSelected = response.data.me;
                                // console.log(444, response, measure_id);
                            }
                        }
                        vu.showModal = false;
                        vu.fieldErrors = [];
                        vu.selectedMetric = {};
                        vu.selectedMeasure = {};
                        axios.get("{{route('inventory.create')}}").then(function(response) {
                            vu.measureList = response.data;
                        });
                    })
                    .catch(function(error) {
                        axios.get("{{route('inventory.create')}}").then(function(response) {

                            vu.measureList = response.data;
                        });

                        vu.fieldErrors = error.response.data

                    });

            },
            submitInventory: function() {

                swal({
                    title: "@lang('layout.AreYouSure?')",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("inventory-form").submit()

                    } else {

                    }
                });
            },
            // generic function for adding item to list
            addNew(index) {
                if (this.services[index + 1] == undefined) {
                    this.services.push({
                        site: null,
                        qty: null,
                        cost_in: null,
                        unit_price: null,
                        o_measure_value1: null,
                        price_in: null,
                        khada: null,
                        approx_weight: null,
                        maxCode: (this.maxCode + index + 1),
                    });
                }


            },
            // delete item from list
            deleteItem(index) {
                this.services.splice(index, 1);

            },

            saveAndNew()
            {
                this.$validator.validate()
                .then(valid =>{
                    if(valid)
                    {
                        
                        var url="{{route('inventory.m_store')}}";
                        form_id='inventory-form';
                        var data= $('#'+form_id).serialize();
                        // console.log(444, data);
                        toggleBlock(true);
                        axios.post(url,data)
                        .then(function(response){
                                toggleBlock(0);
                                if(response.data.result==1)
                                {
                                    $('#'+form_id).trigger('reset');
                                    
                                    toastr.success('',response.data.message); 
                                    location.reload();
                                
                                }
                                else
                                {
                                    var message="{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('',message);
                                }
                        })
                        .catch(function(error){
                        toggleBlock(0);
                            console.log(error);
                            var message="{{__('message.Warning')}}";
                            //$('#error-sound')[0].play();
                            toastr.warning('',message);
                        });
                    
                    }
                })
            },
        }
    });
</script>


@endpush