@extends('layouts.app')
@section('style')
<style>
  .main-table {
    width: 100%;
    border: solid 1.5px black;
    border-collapse: collapse;
    font-size: 14px;
  }
</style>
@stop
@section('content')
<div class="" id="app" v-cloak>
  <div class="portlet light bg-inverse" style="min-height: 100%;">
    <div class="portlet-title">
      <div class="caption">
        <i class="fa fa-print font-green-haze"></i>&nbsp;
        <span class="caption-subject font-green-haze bold uppercase">@lang('layout.Report') </span>
        <!-- <span class="caption-helper">some info...</span> -->
      </div>
      <div class="tools">
      </div>
    </div>
    <!-- BEGIN FORM-->
    <form action="{{route('export.PDFAll')}}" method="POST" id="dd_form" >
      <input type="hidden" name="_method" value="DELETE">
      {!! Form::token() !!}
      <input type="hidden" name="type" value="allInventoryReport" />
      <div class="portlet-body form" style="margin-bottom:10%;">
        <div class="row" style="margin-bottom: 20px; padding: 10px;">
          <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
            <div class="row" style="padding: 0.5% 1%;">
              <div class="col-lg-12 margin-bottom-0">
                <div class="col-lg-3">
                  <div class="form-group">
                    <label class="control-label">@lang('menu.InventoryCategory')</label>
                    <select class="list-style form-control" @change="changeCategory(this)" name="inventory_category_id">
                      <option value="">@lang('layout.Select')</option>
                      <option v-for="cat in category" :value="cat.id">@{{cat.name}}</option>
                    </select>
                  </div>
                </div>
                <div class="col-lg-3">
                  <div class="form-group">
                    <label class="control-label ">@lang('layout.SelectInventorySite') </label>
                    <select name="inventory_site_id" id="" class="form-control">
                      <option value="">@lang('layout.SelectInventorySite')</option>
                      @foreach($inventorySite as $site)
                      <option value="{{$site->id}}">{{$site->name}}</option>
                      @endforeach
                    </select>
                  </div>
                </div>
                <div class="col-lg-2">
                  <div class="form-group">
                    <label class="control-label">@lang('layout.ItemType')</label>
                    <select class="form-control" name="inventory_type">
                      <option value="">@lang('layout.Select')</option>
                      <option value="inventoryPart">@lang('layout.InventoryPart')</option>
                      <option value="inventoryAssembly">@lang('layout.InventoryAssembly')</option>
                      <option value="workingProgress">@lang('layout.WorkingProgress')</option>
                      <option value="procurement">@lang('layout.Procurement')</option>
                    </select>
                  </div>
                </div>
                <div class="col-lg-2">
                  <div class="form-group">
                    <label class="control-label"> @lang('layout.Type')</label>
                    <select v-model="istype" class="form-control" name="exportType">
                      <option value="all">@lang('layout.All')</option>
                      <option value="withOnHand">@lang('layout.WithOnHand')</option>
                      <option value="daily">@lang('layout.Daily')</option>
                      <option value="OnhandComparison">@lang('layout.OnhandComparison')</option>
                    </select>
                  </div>
                </div>
                <div class="col-lg-2">
                  <div class="form-group">
                    <label class="control-label ">@lang('menu.InventoryBrand') </label>
                    <select name="inventory_brand_id" id="" class="form-control">
                      <option value="">@lang('layout.Select')</option>
                      @foreach($inventoryBrand as $brand)
                      <option value="{{$brand->id}}">{{$brand->name}}</option>
                      @endforeach
                    </select>
                  </div>
                </div>
                <div class="col-lg-2">
                  <div class="form-group">
                    <label class="control-label ">@lang('layout.GroupBy') </label>
                    <select name="group_by" id="" class="form-control">
                      <option value="">@lang('layout.Select')</option>
                      <option value="site">@lang('layout.Site')</option>
                    </select>
                  </div>
                </div>
                <div class="col-lg-3">
                  <div class="form-group">
                    <label class="control-label ">@lang('layout.SelectU/M')(1) </label>
                    <select name="measure_id" id="" class="form-control">
                      <option value="">@lang('layout.SelectU/M')</option>
                      @foreach($measures as $measure)
                      <option value="{{$measure->id}}">{{$measure->name}}</option>
                      @endforeach
                    </select>
                  </div>
                </div>
                <div class="col-lg-1">
                  <div class="form-group">
                    <label class="control-label" style="color: red">@lang('layout.TotalCode')</label>
                    <input type="checkbox" name="total_code" value="ok" class="form-control">
                  </div>
                </div>
                <div class="col-lg-2" v-show="(istype !='all' && istype !='withOnHand')">
                  <div class="form-group">
                      <label class="control-label"> @lang('layout.Date')</label>
                      <div class="input-group">
                        <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                        <span class="input-group-addon">@lang('layout.To') </span>
                        <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">
                      </div>   
                  </div>
                </div>
                <div class="col-lg-2">
                  <div class="form-group">
                    <label class="control-label" style="color: red">@lang('layout.JustOnHand')</label>
                    <input type="checkbox" name="all_onhund" class="form-control">
                  </div>
                </div>
                <div class="col-lg-2">
                  <div class="form-group">
                    <label class="control-label ">@lang('layout.ReportType') </label>
                    <select name="report_type" v-modal="report_type" @click="change_type(this)" class="form-control">
                        <option value="pdf" selected>@lang('layout.PDF')</option>
                        <option value="excel">@lang('layout.Excel')</option>
                    </select>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div style=" overflow-y: scroll; height:600px;">
          <table class="table table-striped table-bordered table-hover">
            <thead>
              <tr style="background-color: rgb(174, 183, 178)">
                <th colspan="5">@lang('layout.SelectAll') </th>
              </tr>
              <tr style="background-color: rgb(174, 183, 178);">
                <th style="background-color: #6b716b;" class="text-center"><input type="checkbox" name="selectedItem" class="form-control" @change="selectAll(this)" v-model="selectedAll"> </th>
                <th class="text-center">@lang('layout.Code') </th>
                <th class="text-center">@lang('layout.ItemName') </th>
                <th class="text-center">@lang('layout.Measure') </th>
              </tr>
            </thead>
            <tbody>
              <tr v-for="(item,index) in items">
                <td class="highlight text-center" style="background-color: rgb(174, 183, 178);">
                  <div class="success"></div>
                  <input type="checkbox" @click="toggleCheck(index)" class="form-control" :checked="item.selected">
                  <input type="hidden" name="item_id[]" v-if="item.selected" :value="item.id">
                </td>
                <td class="highlight text-center">
                  <div class="success"></div>
                  @{{item.number}}
                </td>
                <td class="highlight text-center">
                  <div class="success"></div>
                  @{{item.name}}
                </td>
                <td class="text-center"> @{{item.measure}} </td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
      <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center">
        <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
        <a href="{{route('inventory.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
      </div>
    </form>
  </div>
  <!-- END FORM-->
</div>
@endsection
@push('scripts')
<script type="text/javascript">
  var inventory_category = {!! $inventory_category !!}
  var items = {!!$items!!}
  new Vue({
    el: '#app',
    data: {
      category: inventory_category,
      items: items,
      amount: 1,
      selected_type: 'percent',
      selectedAll: false,
      selected_advance_pricing_type: 'up',
      selected_pricing_type: 'add_new_price',
      selectedItem: null,
      inventory_type: null,
      report_type: 'pdf',
      itemlist: [],
      type: 'pdf',
      istype: 'all',
      item_id: [],
      inv_category: null
    },
    methods: {
      changeCategory(e) {
        var value = e.event.target.value;
        for (var i = 0; i < this.items.length; i++) {
          this.items[i].selected = null;
          if (this.items[i].inventory_category_id == value) {
            this.items[i].selected = true;
          }
        }
      },
      toggleCheck(index) {
        this.items[index].selected = !this.items[index].selected;
      },
      change_type(e) {
        this.report_type = e.event.target.value;
        if (this.report_type == 'pdf') {
            $('#dd_form').attr('action', "{{route('export.PDFAll')}}");
        }else{
            $('#dd_form').attr('action', "{{route('export.ExcelAll')}}");
        }
      },
      selectAll(e) {
        for (var i = 0; i < this.items.length; i++) {
          if (this.selectedAll == true) {
            this.items[i].selected = true;
          } else {
            this.items[i].selected = false;
          }
        }
      }
    },
    created: function() {
      // console.log('test 22', this.record);
    }

  });
</script>
@endpush