@extends('layouts.factor-master')
<?php 
$reportTitle = __('layout.InventoryDetails');
?>
@section('content')
<h4></h4>
<?php
$report = customeReport('inventory','detail');
?>

<h4>@lang('layout.ItemName'): {{ $info->name}} @if(systemConfig()[9] == 0 ) -- @lang('layout.Gauge')({{ $info->gauge}}) @endif @if($location) -- @lang('layout.Location'): {{$location}} @endif</h4>
  <table class="main-table">
    <thead>
      <tr class="bg">
      <td><div class="center"> @lang('layout.Record') </div></td>
      <td style="display: <?=(!show('type',$report))?'none':'';?>"><div class="center"> @lang('layout.Type')</div></td>
      <td style="display: <?=(!show('type',$report))?'none':'';?>"><div class="center"> @lang('layout.Number')</div></td>
      <td style=""><div class="center"> @lang('layout.Code')</div></td>
      <td style=""><div class="center"> @lang('layout.ContractCode')</div></td>
	  @if(systemConfig()[9] != 0 )
      <td style=""><div class="center"> @lang('layout.ExpireDate')</div></td>
    @endif
    @if(getOtherMeasure()=="true")
          <th>@lang('layout.OMeasureValue1')</th>
      @endif
    @if(getOtherMeasure2()=="true")
          <th>@lang('layout.OMeasureValue2')</th>
      @endif
    @if(getShowWing()!="false")
    <td style=""><div class="center"> @lang('layout.Wing')</div></td>
    <td style=""><div class="center"> @lang('layout.ApproxWeight')</div></td>
    @endif
	  @if(systemConfig()[9] == 0 || getCubicMetereItems()=="true")
      <td style=""><div class="center"> @lang('layout.Length')</div></td>
      <td style=""><div class="center"> @lang('layout.Width')</div></td>
    @endif
    @if(getCubicMetereItems()=="true")
    <th>@lang('layout.Gauge') </th>
    @endif
    @if(getShowSuperceedNo()=="true")
      <td style=""><div class="center"> @lang('layout.SuperceedNo')</div></td>
    @endif
    @if(showLocation()=="true")
      <td style=""><div class="center"> @lang('layout.Location')</div></td>
    @endif
      <td style="display: <?=(!show('member',$report))?'none':'';?>"><div class="center"> @lang('layout.Member')</div></td>
      <td style="display: <?=(!show('date',$report))?'none':'';?>"><div class="center"> @lang('layout.Date')</div></td>
      <td style="display: <?=(!show('site_name',$report))?'none':'';?>"><div class="center"> @lang('layout.SiteName')</div></td>
      <td><div class="center"> @lang('layout.Category') </div></td>
      <td style="display: <?=(!show('measure',$report))?'none':'';?>"><div class="center"> @lang('layout.Measure') </div></td>
      <td style="display: <?=(!show('quantity',$report))?'none':'';?>"><div class="center"> @lang('layout.Quantity')</div></td>
      @if(getShowPurchaseRate() != "false")
      @if($info->type == "workingProgress")
        <td style="display: <?=(!show('purchase_rate',$report))?'none':'';?>"><div class="center"> @lang('layout.WorkingProgressCost')</div></td>
      @elseif($info->type == "inventoryAssembly")
        <td style="display: <?=(!show('purchase_rate',$report))?'none':'';?>"><div class="center"> @lang('layout.BOMCost')</div></td>
      @else
      <td style="display: <?=(!show('purchase_rate',$report))?'none':'';?>"><div class="center"> @lang('layout.Cost')</div></td>
      @endif
        <td><div class="center"> @lang('layout.UnitCost')</div></td>
      @endif
      @if(getShowSaleRate() != "false")
        <td style="display: <?=(!show('rate',$report))?'none':'';?>"><div class="center"> @lang('layout.Default_Rate')</div></td>
      @endif
      @if(getShowPurchaseRate() != "false")
       <td style="display: <?=(!show('total',$report))?'none':'';?>"><div class="center"> @lang('layout.Total')</div></td>
      @endif
      <td><div class="center"> @lang('layout.User')</div></td>
      <td style="display: <?=(!show('description',$report))?'none':'';?>"><div class="center"> @lang('layout.Description')</div></td>
    </tr>
    </thead>
    <?php
    $count = 0;
    $in=0;
    $out=0;
    ?>
    @foreach($data AS $record)
    <?php
    if($record->cat == 'in')
    {
      $in +=$record->Quantity;
    }
    if($record->cat == 'out')
    {
     $out +=$record->Quantity;
    }
    
    ?>
    <tr>
      <td class="center">{{++$count}}</td>
      <td style="display: <?=(!show('type',$report))?'none':'';?>" class="center">{{__('type.'.ucfirst($record->Type))}}</td>
      <td style="display: <?=(!show('type',$report))?'none':'';?>" class="center">{{$record->Number}}</td>
      <td style="" class="center">{{$record->Code}}</td>
      <td style="" class="center">{{$record->orderNumber}}</td>
	  @if(systemConfig()[9] != 0 )
      <td style="" class="center">{{convertDate($record->expire_date)}}</td>
    @endif
    @if(getOtherMeasure()=="true")
        <td style="" class="center">{{$record->other_measure}}</td>
      @endif
    @if(getOtherMeasure2()=="true")
        <td style="" class="center">{{$record->other_measure2}}</td>
      @endif
    @if(getShowWing()!="false")
    <td style="" class="center">{{$record->khada}}</td>
    <td style="" class="center">{{round($record->approx_weight, 7)}}</td>
    @endif
	  @if(systemConfig()[9] == 0 || getCubicMetereItems()=="true")
      <td style="" class="center">{{$record->Lengths}}</td>
      <td style="" class="center">{{$record->Widths}}</td>
    @endif
    @if(getCubicMetereItems()=="true")
    <td style="" class="center">{{$record->gauge}}</td>
    @endif
    @if(getShowSuperceedNo()=="true")
      <td style=""><div class="center">{{$record->superceed}}</div></td>
    @endif
    @if(showLocation()=="true")
      <td style=""><div class="center">{{$record->location}}</div></td>
    @endif
      <td style="display: <?=(!show('member',$report))?'none':'';?>" class="center">{{$record->member}}</td>
      <td style="display: <?=(!show('date',$report))?'none':'';?>" class="center">{{convertDate($record->Date)}}</td>
      <td style="display: <?=(!show('site_name',$report))?'none':'';?>" class="center">{{$record->SiteName}}</td>
      <td style="" class="center">{{$record->cat}}</td>
      <td style="display: <?=(!show('measure',$report))?'none':'';?>" class="center">{{$record->Measure}}</td>
      <td style="display: <?=(!show('quantity',$report))?'none':'';?>" class="center">{{$record->Quantity}}</td>

      @if(getShowPurchaseRate() != "false")
        <td style="display: <?=(!show('purchase_rate',$report))?'none':'';?>" class="center">{{myRound($record->Cost)}}</td>
        <td class="center">{{myRound($record->total_cost)}}</td>
      @endif
      @if(getShowSaleRate() != "false")
        <td style="display: <?=(!show('rate',$report))?'none':'';?>" class="center">{{myRound($record->sales_price)}}</td>
      @endif
      @if(getShowPurchaseRate() != "false")
        <td style="display: <?=(!show('total',$report))?'none':'';?>" class="center">{{myRound($record->Total)}}</td>
      @endif
      <td class="center">{{$record->user}}</td>
      <td style="display: <?=(!show('description',$report))?'none':'';?>" class="center">{{$record->Description}}</td>
    </tr>
    @endforeach
</table>
<table class="main-table">

    <tr class="bg">
      <th>@lang('layout.InItems')</th>
      <th>@lang('layout.OutItems')</th>
      <th>@lang('layout.Total')</th>
    </tr>
  <tbody>
    <tr>
      <td style="text-align: center;">{{$in}}</td>
      <td style="text-align: center;">{{$out}}</td>
      <td style="text-align: center;">{{$in-$out}}</td>
    </tr>
  </tbody>
</table>


<table class="main-table">

    <tr class="bg">
      <th>@lang('layout.OnHand')</th>
      <th>@lang('layout.OnHand') @lang('layout.Code')</th>
      <th>@lang('layout.OnHand') @lang('layout.Wing')</th>
      @if(getShowPurchaseRate() != "false")
      <th>@lang('layout.Amount') @lang('layout.Total')</th>
      @endif
    </tr>
  <tbody>
    <tr>
      <td style="text-align: center;">{{ ($OnHandQty)?myRound($OnHandQty):0}}</td>
      <td style="text-align: center;">{{ $OnHandCode}}</td>
      <td style="text-align: center;">{{ ($inventoryOnHandRoll)?myRound($inventoryOnHandRoll->on_hand_khada):0}}</td>
      @if(getShowPurchaseRate() != "false")
      <td style="text-align: center;">{{ ($total_cost)?myRound($total_cost):0}}</td>
      @endif
    </tr>
  </tbody>
  
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection


