@extends('layouts.factor-master')
<?php
$reportTitle = __('layout.InventoryDetails');
?>
@section('content')
<h4></h4>
<?php
$report = customeReport('inventory', 'detail');
?>

<h4>@lang('layout.ItemName'): {{ $info->name}} @if(systemConfig()[9] == 0 ) - @lang('layout.Gauge')({{ $info->gauge}}) @endif</h4>
<table class="main-table">
  <thead>
    <tr class="bg">
      <td  class="center" >
        <div> @lang('layout.Record') </div>
      </td>
      @if(showLocation()=="true")
      <td  class="center" >
        <div> @lang('layout.Location')</div>
      </td>
      @endif
      <td  class="center"  style="display: <?= (!show('date', $report)) ? 'none' : ''; ?>">
        <div> @lang('layout.Date')</div>
      </td>
      @if(getOtherMeasure()=="true")
      <th>@lang('layout.OMeasureValue1')</th>
      @endif
      @if(getOtherMeasure2()=="true")
      <th>@lang('layout.OMeasureValue2')</th>
      @endif
      @if(getShowWing()!="false")
      <td  class="center"  style="">
        <div> @lang('layout.Wing')</div>
      </td>
      <td  class="center"  style="">
        <div> @lang('layout.ApproxWeight')</div>
      </td>
      @endif
      @if(systemConfig()[9] == 0 )
      <td  class="center"  style="">
        <div> @lang('layout.Length')</div>
      </td>
      <td  class="center"  style="">
        <div> @lang('layout.Width')</div>
      </td>
      @endif
      <td  class="center"  style="display: <?= (!show('site_name', $report)) ? 'none' : ''; ?>">
        <div> @lang('layout.SiteName')</div>
      </td>
      <td  class="center" >
        <div> @lang('layout.Category') </div>
      </td>
      <td  class="center"  style="display: <?= (!show('measure', $report)) ? 'none' : ''; ?>">
        <div> @lang('layout.Measure') </div>
      </td>
      <td  class="center"  style="display: <?= (!show('quantity', $report)) ? 'none' : ''; ?>">
        <div> @lang('layout.Quantity')</div>
      </td>
      @if(getShowPurchaseRate() != "false")
      <td  class="center"  style="display: <?= (!show('total', $report)) ? 'none' : ''; ?>">
        <div> @lang('layout.Total')</div>
      </td>
      @endif
      <td  class="center" >
        <div> @lang('layout.User')</div>
      </td>
      <td  class="center"  style="display: <?= (!show('description', $report)) ? 'none' : ''; ?>">
        <div> @lang('layout.Description')</div>
      </td>
    </tr>
  </thead>
  <?php
  $count = 0;
  $in = 0;
  $out = 0;
  ?>
  @foreach($data AS $record)

  <tr>
    <td class="center">{{++$count}}</td>
    @if(showLocation()=="true")
    <td class="center">{{$record->location}}</td>
    @endif
    <td style="display: <?= (!show('date', $report)) ? 'none' : ''; ?>" class="center">{{convertDate($record->Date)}}</td>
    @if(getOtherMeasure()=="true")
    <td style="" class="center">{{$record->other_measure}}</td>
    @endif
    @if(getOtherMeasure2()=="true")
    <td style="" class="center">{{$record->other_measure2}}</td>
    @endif
    @if(getShowWing()!="false")
    <td style="" class="center">{{$record->khada}}</td>
    <td style="" class="center">{{$record->approx_weight}}</td>
    @endif
    @if(systemConfig()[9] == 0 )
    <td style="" class="center">{{$record->Lengths}}</td>
    <td style="" class="center">{{$record->Widths}}</td>
    @endif
    <td style="display: <?= (!show('site_name', $report)) ? 'none' : ''; ?>" class="center">{{$record->SiteName}}</td>
    <td style="" class="center">{{$record->cat}}</td>
    <td style="display: <?= (!show('measure', $report)) ? 'none' : ''; ?>" class="center">{{$record->Measure}}</td>
    <td style="display: <?= (!show('quantity', $report)) ? 'none' : ''; ?>" class="center">{{$record->Quantity}}</td>
    @if(getShowPurchaseRate() != "false")
    <td style="display: <?= (!show('total', $report)) ? 'none' : ''; ?>" class="center">{{myRound($record->Total)}}</td>
    @endif
    <td class="center">{{$record->user}}</td>
    <td style="display: <?= (!show('description', $report)) ? 'none' : ''; ?>" class="center">{{$record->Description}}</td>
  </tr>
  @endforeach
</table>

<table class="main-table">

  <tr class="bg">
    <th>@lang('layout.OnHand')</th>
    <th>@lang('layout.OnHand') @lang('layout.Code')</th>
    @if(getShowPurchaseRate() != "false")
    <th>@lang('layout.Amount') @lang('layout.Total')</th>
    @endif
  </tr>
  <tbody>
    <tr>
      <td style="text-align: center;">{{ ($OnHandQty)?myRound($OnHandQty):0}}</td>
      <td style="text-align: center;">{{ $OnHandCode}}</td>
      @if(getShowPurchaseRate() != "false")
      <td style="text-align: center;">{{ ($total_cost)?myRound($total_cost):0}}</td>
      @endif
    </tr>
  </tbody>

</table>

<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->
@endsection