@extends('layouts.factor-master')

@section('content')

<?php
$report = customeReportNew('inventory_show_both');
$_type = !in_array('type', $report);
$_number = !in_array('number', $report);
$_ref_no = !in_array('ref_no', $report);
$_member = !in_array('member', $report);
$_date = !in_array('date', $report);
$_site_name = !in_array('site_name', $report);
$_measure = !in_array('measure', $report);
$_quantity = !in_array('quantity', $report);
$_qut_in = !in_array('qut_in', $report);
$_qut_out = !in_array('qut_out', $report);
$_purchase_rate = !in_array('purchase_rate', $report);
$_rate = !in_array('rate', $report);
$_total = !in_array('total', $report);
$_description = !in_array('description', $report);
$_unit_cost = !in_array('unit_cost', $report);
$_total_qty = !in_array('total_qty', $report);
$_total_amount = !in_array('total_amount', $report);
$_total_balance_amount = !in_array('total_balance_amount', $report);
$_total_balance_qty = !in_array('total_balance_qty', $report);


?>

<h4>@lang('layout.ItemName'): {{$info->name}} ---- @lang('layout.Number'): {{$info->number }}</h4>
<h3 class="table-caption" style="text-align: center;">@lang('layout.InventoryDetails')</h3>
<table class="main-table">
    <tr>
        @if($from_date)
        <td>
            <span>@lang('layout.FromDate')</span>:
            <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
        </td>
        @endif
        @if($to_date)
        <td>
            <span>@lang('layout.ToDate')</span>:
            <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
        </td>
        @endif
    </tr>
</table>
<br>
<table class="main-table">

    <thead>
        <tr class="bg">
            <td class="center">
                <div >  @lang('layout.Record') </div>
            </td>
            @if($_date) <td class="center">
                <div > @lang('layout.ExpireDate')</div>
            </td>@endif
            @if($_date) <td class="center">
                <div > @lang('layout.RemainDate')</div>
            </td>@endif
            @if($_site_name) <td class="center">
                <div > @lang('layout.SiteName')</div>
            </td>@endif
            @if($_measure) <td class="center">
                <div > @lang('layout.Measure') </div>
            </td>@endif
            @if($_qut_in) <td class="center">
                <div > @lang('layout.Quantity')</div>
            </td>@endif

            @if(getShowPurchaseRate() != "false")
            @if($_total)<td class="center">
                <div > @lang('layout.Total')   {{getHomeCurrency()[getCurrencyType()]}}</div>
            </td>@endif
            @endif
        </tr>
    </thead>
    <?php
    $count = 0;
    $totalAmount = 0;
    $total_quantity = 0;
    ?>
    @foreach($data AS $record)
    <?php
        $total_quantity += $record->on_hand;
        $totalAmount += $record->totalAmount;

        $day = 0;
        if ($record->sort_date && $record->sort_date != 0) {
            $end_date = date_create($record->sort_date);
            $diff = date_diff($today, $end_date);
            $day = $diff->format("%a");
            $day = ($diff->invert == 1)? ((int)$day * -1):(int)$day;
        }
    ?>
    <tr>
        <td class="center">{{++$count}}</td>
        @if($_date)<td class="center" @if($day<10)style="background-color: #ffb5b5;" @endif>{{convertDate($record->date)}}</td>@endif
        @if($_date)<td class="center" @if($day<10)style="background-color: #ffb5b5;" @endif>{{$day}} @lang('layout.Day') </td>@endif
        @if($_site_name)<td class="center">{{$record->site}}</td>@endif
        @if($_measure)<td class="center">{{$record->measure}}</td>@endif
        @if($_qut_in)<td class="center">
            {{myRound($record->on_hand)}}
        </td>
        @endif
        @if(getShowPurchaseRate() != "false")
        @if($_total)<td class="center">{{myRound($record->totalAmount)}}</td>@endif
        @endif
    </tr>
    @endforeach
</table>

@if($_total_qty)
<table class="main-table">
    <tr class="bg">
        <th></th>
        <th>@lang('layout.TotalQuantity')</th>
        <th>@lang('layout.TotalAmount')</th>
    </tr>
    <tbody>
        <tr>
            <td></td>
            <td style="text-align: center;">{{myRound($total_quantity)}}</td>
            <td style="text-align: center;">{{myRound($totalAmount)}}</td>
        </tr>
    </tbody>
</table>
@endif

<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>

                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>

            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->
@endsection