@extends('layouts.factor-master')

@section('content')

<?php
$report = customeReportNew('inventory_show_both');
$_type= !in_array('type', $report);
$_number= !in_array('number', $report);
$_ref_no= !in_array('ref_no', $report);
$_member= !in_array('member', $report);
$_date= !in_array('date', $report);
$_site_name= !in_array('site_name', $report);
$_measure= !in_array('measure', $report);
$_quantity= !in_array('quantity', $report);
$_qut_in= !in_array('qut_in', $report);
$_qut_out= !in_array('qut_out', $report);
$_purchase_rate= !in_array('purchase_rate', $report);
$_rate= !in_array('rate', $report);
$_total= !in_array('total', $report);
$_description= !in_array('description', $report);
$_unit_cost= !in_array('unit_cost', $report);
$_total_qty= !in_array('total_qty', $report);
$_total_amount= !in_array('total_amount', $report);
$_total_balance_amount= !in_array('total_balance_amount', $report);
$_total_balance_qty= !in_array('total_balance_qty', $report);
$_expire_date= !in_array('expire_date', $report);


$report_percent = customeReportNewPercent('inventory_show_both');
    $_type_percent= (array_key_exists('type___percent', $report_percent))?$report_percent['type___percent']:null;
    $_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
    $_ref_no_percent= (array_key_exists('ref_no___percent', $report_percent))?$report_percent['ref_no___percent']:null;
    $_member_percent= (array_key_exists('member___percent', $report_percent))?$report_percent['member___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_site_name_percent= (array_key_exists('site_name___percent', $report_percent))?$report_percent['site_name___percent']:null;
    $_measure_percent= (array_key_exists('measure___percent', $report_percent))?$report_percent['measure___percent']:null;
    $_quantity_percent= (array_key_exists('quantity___percent', $report_percent))?$report_percent['quantity___percent']:null;
    $_qut_in_percent= (array_key_exists('qut_in___percent', $report_percent))?$report_percent['qut_in___percent']:null;
    $_qut_out_percent= (array_key_exists('qut_out___percent', $report_percent))?$report_percent['qut_out___percent']:null;
    $_purchase_rate_percent= (array_key_exists('purchase_rate___percent', $report_percent))?$report_percent['purchase_rate___percent']:null;
    $_rate_percent= (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null;
    $_total_percent= (array_key_exists('total___percent', $report_percent))?$report_percent['total___percent']:null;
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
    $_unit_cost_percent= (array_key_exists('unit_cost___percent', $report_percent))?$report_percent['unit_cost___percent']:null;
    $_total_qty_percent= (array_key_exists('total_qty___percent', $report_percent))?$report_percent['total_qty___percent']:null;
    $_total_amount_percent= (array_key_exists('total_amount___percent', $report_percent))?$report_percent['total_amount___percent']:null;
    $_total_balance_amount_percent= (array_key_exists('total_balance_amount___percent', $report_percent))?$report_percent['total_balance_amount___percent']:null;
    $_total_balance_qty_percent= (array_key_exists('total_balance_qty___percent', $report_percent))?$report_percent['total_balance_qty___percent']:null;
    $_expire_date_percent= (array_key_exists('expire_date___percent', $report_percent))?$report_percent['expire_date___percent']:null;

?>

<h4>@lang('layout.ItemName'): {{$info->name}}</h4>
  <h3 class="table-caption" style="text-align: center;">@lang('layout.InventoryDetails')</h3>
  <table class="main-table">
    <tr>
        @if($from_date)
            <td>
                <span>@lang('layout.FromDate')</span>:
                <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($from_date)}}</BDO>
            </td>
        @endif
        @if($to_date)
            <td>
                <span>@lang('layout.ToDate')</span>:
                <BDO DIR="LTR">@if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($to_date)}}</BDO>
            </td>
        @endif
    </tr>
  </table>
<br>
  <table class="main-table">
    <thead>
      <tr class="bg">
      <td class="center" ><div >  @lang('layout.Record') </div></td>
      @if($_type)<td  class="center"  @if($_type_percent) width="{{$_type_percent}}%" @endif><div > @lang('layout.Type')</div></td>@endif
      @if($_number)<td  class="center"  @if($_number_percent) width="{{$_number_percent}}%" @endif><div > @lang('layout.Number')</div></td>@endif
      @if($_date) <td  class="center"  @if($_date_percent) width="{{$_date_percent}}%" @endif><div > @lang('layout.Date')</div></td>@endif
      @if($_expire_date) <td  class="center"  @if($_expire_date_percent) width="{{$_expire_date_percent}}%" @endif><div > @lang('layout.ExpireDate')</div></td>@endif
      @if($_description)<td class="center"   @if($_description_percent) width="{{$_description_percent}}%" @endif ><div > @lang('layout.Description')</div></td>@endif
 
      @if($_ref_no)<td class="center"   @if($_ref_no_percent) width="{{$_ref_no_percent}}%" @endif><div > @lang('layout.ReferenceNumber')</div></td>@endif
     @if($_member) <td class="center"   @if($_member_percent) width="{{$_member_percent}}%" @endif><div > @lang('layout.Member')</div></td>@endif
    
     @if($_site_name) <td  class="center"  @if($_site_name_percent) width="{{$_site_name_percent}}%" @endif><div > @lang('layout.SiteName')</div></td>@endif
     @if(showLocation()=="true")<td><div > @lang('layout.Location') </div></td>@endif
     @if(getSaleDescription()=="true")
      <td  class="center"  ><div > @lang('layout.Description1') </div></td>
      <td  class="center"  ><div > @lang('layout.Model') </div></td>
      <td  class="center"  ><div > @lang('layout.Color') </div></td>
      @endif
     @if($_measure) <td class="center"   @if($_measure_percent) width="{{$_measure_percent}}%" @endif><div > @lang('layout.Measure') </div></td>@endif
     @if($_qut_in) <td class="center"   @if($_qut_in_percent) width="{{$_qut_in_percent}}%" @endif><div > @lang('layout.QutIn')</div></td>@endif
      @if($_qut_out)<td class="center"   @if($_qut_out_percent) width="{{$_qut_out_percent}}%" @endif><div > @lang('layout.QutOut')</div></td>@endif
      @permission(['price-create'])
      @if(getShowPurchaseRate() != "false")
      @if($info->type == "workingProgress")
        @if($_purchase_rate)<td class="center"   @if($_purchase_rate_percent) width="{{$_purchase_rate_percent}}%" @endif><div > @lang('layout.WorkingProgressCost')</div></td>@endif
      @elseif($info->type == "inventoryAssembly")
        @if($_purchase_rate)<td class="center"   @if($_purchase_rate_percent) width="{{$_purchase_rate_percent}}%" @endif><div > @lang('layout.BOMCost')</div></td>@endif
      @else
        @if($_purchase_rate)<td class="center"   @if($_purchase_rate_percent) width="{{$_purchase_rate_percent}}%" @endif><div > @lang('layout.Cost')</div></td>@endif
      @endif
        @if($_unit_cost)<td class="center"   @if($_unit_cost_percent) width="{{$_unit_cost_percent}}%" @endif><div > @lang('layout.UnitCost')</div></td>@endif
      @endif
      @if(getShowSaleRate() != "false")
        @if($_rate)<td  class="center"  @if($_rate_percent) width="{{$_rate_percent}}%" @endif><div > @lang('layout.Default_Rate')</div></td>@endif
      @endif
      @if(getShowPurchaseRate() != "false")
        @if($_total)<td class="center"   @if($_total_percent) width="{{$_total_percent}}%" @endif><div > @lang('layout.Total')</div></td>@endif
      @endif

      @endpermission

      @if($_total_balance_qty)<td class="center"   @if($_total_balance_qty_percent) width="{{$_total_balance_qty_percent}}%" @endif><div > @lang('layout.TotalBalanceQty')</div></td>@endif
      @if(getShowPurchaseRate() != "false")
        @if($_total_balance_amount)<td class="center" @if($_total_balance_amount_percent) width="{{$_total_balance_amount_percent}}%" @endif><div > @lang('layout.TotalBalanceAmount')</div></td>@endif
      @endif
      <td class="center"><div > @lang('layout.User')</div></td>
    </tr>
    </thead>
    <?php
    $count = 0;
    $in=0;
    $out=0;
    $outAmount=0;
    $outCostAmount=0;
    $inAmountCost=0;
    $inAmountUnitCost=0;
    $total_balance_amount=0;
    $total_balance_qty=0;
    ?>
    @foreach($data AS $record)
    <?php


    if($record->cat == 'in')
    {
      $in +=$record->Quantity;
      
      $inAmountCost +=$record->Quantity*$record->Cost;
      $inAmountUnitCost +=$record->Quantity*$record->total_cost;

      $total_balance_amount += ($record->Quantity*$record->total_cost);
      $total_balance_qty += $record->Quantity;

    }
    if($record->cat == 'out')
    {
     $out +=$record->Quantity;
     $outAmount +=$record->Quantity*$record->total_cost;
     $outCostAmount +=$record->Quantity*$record->Cost;
     
      $total_balance_amount -= ($record->Quantity*$record->total_cost);
      $total_balance_qty -= $record->Quantity;

    }

    ?>
    <tr>
      <td class="center">{{++$count}}</td>
      @if($_type)<td  class="center">{{__('type.'.ucfirst($record->Type))}}</td>@endif
      @if($_number)<td  class="center">{{$record->Number}}</td>@endif
      @if($_date)<td  class="center">{{convertDate($record->Date)}}</td>@endif
      @if($_expire_date)<td  class="center">{{convertDate($record->expire_date)}}</td>@endif
      @if($_description)<td  style="@if($_description_percent) text-align: justify; @endif" class="center">{{$record->Description}}</td>@endif

      @if($_ref_no)<td  class="center">{{$record->refNo}}</td>@endif
      @if($_member)<td  class="center">{{$record->member}}</td>@endif
      @if($_site_name)<td  class="center">{{$record->SiteName}}</td>@endif
      @if(showLocation()=="true")<td class="center">{{$record->location}}</td>@endif
      @if(getSaleDescription()=="true")
      <td class="center">{{$record->description1}}</td>
      <td class="center">{{$record->model}}</td>
      <td class="center">{{$record->color}}</td>
      @endif
      @if($_measure)<td  class="center">{{$record->Measure}}</td>@endif
      @if($_qut_in)<td  class="center">
        @if($record->cat == 'in')
        {{$record->Quantity}}
        @endif
      </td>@endif
      @if($_qut_out)<td  class="center">
        @if($record->cat == 'out')
        {{$record->Quantity}}

        @endif
      </td>@endif
      @permission(['price-create'])
      @if(getShowPurchaseRate() != "false")
        @if($_purchase_rate)<td class="center">{{myRound($record->Cost)}}</td>@endif
        @if($_unit_cost)<td class="center">{{myRound($record->total_cost)}}</td>@endif
      @endif
      @if(getShowSaleRate() != "false")
        @if($_rate)<td  class="center">{{myRound($record->sales_price)}}</td>@endif
      @endif
      @if(getShowPurchaseRate() != "false")
         @if($_total)<td  class="center">{{myRound($record->Total)}}</td>@endif
      @endif
      @endpermission
      @if($_total_balance_qty)<td  class="center">{{myRound($total_balance_qty)}}</td>@endif
      @if(getShowPurchaseRate() != "false")
        @if($_total_balance_amount)<td  class="center">{{myRound($total_balance_amount)}}</td>@endif
      @endif
      <td  class="center" style="text-align: center;">{{$record->user}}</td>
    </tr>
    @endforeach
</table>

@if($_total_qty)
<table class="main-table">

    <tr class="bg">
      <th>@lang('layout.InItems')</th>
      <th>@lang('layout.OutItems')</th>
      <th>@lang('layout.Total')</th>
    </tr>
  <tbody>
    <tr>
      <td style="text-align: center;">{{myRound($in)}}</td>
      <td style="text-align: center;">{{myRound($out)}}</td>
      <td style="text-align: center;">{{myRound($in-$out)}}</td>
    </tr>
  </tbody>
</table>
@endif
<br>


@if($_total_amount)
@permission(['price-create'])
<table class="main-table">
    <tr class="bg">
      @if(getShowPurchaseRate() != "false")
        <th>@lang('layout.InAmountCost')</th>
        <th>@lang('layout.InAmountUnitCost')</th>
      @endif
      @if(getShowSaleRate() != "false")
        <th>@lang('layout.OutAmount')</th>
      @endif
      @if(getShowPurchaseRate() != "false")
        <th>@lang('layout.TotalInAmountCost')</th>
        <th>@lang('layout.TotalInAmountUnitCost')</th>
      @endif
    </tr> 
  
  <tbody>
    <tr>
      @if(getShowPurchaseRate() != "false")
        <td style="text-align: center;">{{$inAmountCost}}</td>
        <td style="text-align: center;">{{$inAmountUnitCost}}</td>
      @endif
      @if(getShowSaleRate() != "false")
        <td style="text-align: center;">{{$outAmount}}</td>
      @endif
      @if(getShowPurchaseRate() != "false")
        <td style="text-align: center;">{{$inAmountCost-$outCostAmount}}</td>
        <td style="text-align: center;">{{$inAmountUnitCost-$outAmount}}</td>
      @endif

    </tr>
  </tbody>
</table>
@endpermission
@endif

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection


