@extends('layouts.factor-master')

@section('content')

<?php
$report = customeReportNew('inventory_show_both');
$_type= !in_array('type', $report);
$_number= !in_array('number', $report);
$_ref_no= !in_array('ref_no', $report);
$_member= !in_array('member', $report);
$_date= !in_array('date', $report);
$_site_name= !in_array('site_name', $report);
$_measure= !in_array('measure', $report);
$_quantity= !in_array('quantity', $report);
$_qut_in= !in_array('qut_in', $report);
$_qut_out= !in_array('qut_out', $report);
$_purchase_rate= !in_array('purchase_rate', $report);
$_rate= !in_array('rate', $report);
$_total= !in_array('total', $report);
$_description= !in_array('description', $report);
$_unit_cost= !in_array('unit_cost', $report);
$_total_qty= !in_array('total_qty', $report);
$_total_amount= !in_array('total_amount', $report);
$_total_balance_amount= !in_array('total_balance_amount', $report);
$_total_balance_qty= !in_array('total_balance_qty', $report);


?>

<h4>@lang('layout.ItemName'): {{$info->name}}</h4>
  <h3 class="table-caption" style="text-align: center;">@lang('layout.InventoryDetails')</h3>
  <table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>
<br>
  <table class="main-table">

    <thead>
      <tr class="bg">
      <td  class="center" ><div> @lang('layout.Record') </div></td>
      @if($_type)<td  class="center" ><div> @lang('layout.Type')</div></td>@endif
     @if($_date) <td  class="center" ><div> @lang('layout.Date')</div></td>@endif
     @if($_site_name) <td  class="center" ><div> @lang('layout.SiteName')</div></td>@endif
     @if($_measure) <td  class="center" ><div> @lang('layout.Measure') </div></td>@endif
     @if($_qut_in) <td  class="center" ><div> @lang('layout.QutIn')</div></td>@endif
      @if($_qut_out)<td  class="center" ><div> @lang('layout.QutOut')</div></td>@endif

      @if(getShowPurchaseRate() != "false")
        @if($_total)<td  class="center" ><div> @lang('layout.Total')   {{getHomeCurrency()[getCurrencyType()]}}</div></td>@endif
      @endif

      @if($_total_balance_qty)<td  class="center" ><div> @lang('layout.TotalBalanceQty')</div></td>@endif
      @if(getShowPurchaseRate() != "false")
        @if($_total_balance_amount)<td  class="center" ><div> @lang('layout.TotalBalanceAmount')  {{getHomeCurrency()[getCurrencyType()]}}</div></td>@endif
      @endif
    </tr>
    </thead>
    <?php
    $count = 0;
    $in=0;
    $out=0;
    $outAmount=0;
    $inAmountCost=0;
    $inAmountUnitCost=0;
    $total_balance_amount=0;
    $total_balance_qty=0;
    ?>
    @foreach($data AS $record)
    <?php


    if($record->cat == 'in')
    {
      $in +=$record->Quantity;
      
      $inAmountUnitCost +=$record->Total;

      $total_balance_amount += ($record->Total);
      $total_balance_qty += $record->Quantity;

    }
    if($record->cat == 'out')
    {
     $out +=$record->Quantity;
     $outAmount +=$record->Total;
     
      $total_balance_amount -= ($record->Total);
      $total_balance_qty -= $record->Quantity;

    }

    ?>
    <tr>
      <td class="center">{{++$count}}</td>
      @if($_type)<td  class="center">{{__('type.'.ucfirst($record->Type))}}</td>@endif
      @if($_date)<td  class="center">{{convertDate($record->Date)}}</td>@endif
      @if($_site_name)<td  class="center">{{$record->SiteName}}</td>@endif
      @if($_measure)<td  class="center">{{$record->Measure}}</td>@endif
      @if($_qut_in)<td  class="center">
        @if($record->cat == 'in')
        {{$record->Quantity}}
        @endif
      </td>@endif
      @if($_qut_out)<td  class="center">
        @if($record->cat == 'out')
        {{$record->Quantity}}

        @endif
      </td>@endif

      @if(getShowPurchaseRate() != "false")
         @if($_total)<td  class="center">{{myRound($record->Total)}}</td>@endif
      @endif
      @if($_total_balance_qty)<td  class="center">{{myRound($total_balance_qty)}}</td>@endif
      @if(getShowPurchaseRate() != "false")
        @if($_total_balance_amount)<td  class="center">{{myRound($total_balance_amount)}}</td>@endif
      @endif
    </tr>
    @endforeach
</table>

@if($_total_qty)
<table class="main-table">

    <tr class="bg">
      <th>@lang('layout.InItems')</th>
      <th>@lang('layout.OutItems')</th>
      <th>@lang('layout.Total')</th>
    </tr>
  <tbody>
    <tr>
      <td style="text-align: center;">{{myRound($in)}}</td>
      <td style="text-align: center;">{{myRound($out)}}</td>
      <td style="text-align: center;">{{myRound($in-$out)}}</td>
    </tr>
  </tbody>
</table>
@endif
<br>


@if($_total_amount)
<table class="main-table">






    <tr class="bg">
      @if(getShowPurchaseRate() != "false")
        <th>@lang('layout.InAmountUnitCost')</th>
      @endif
      @if(getShowSaleRate() != "false")
        <th>@lang('layout.OutAmount')</th>
      @endif
      @if(getShowPurchaseRate() != "false")
        <th>@lang('layout.TotalInAmountUnitCost')</th>
      @endif
    </tr> 
  
  <tbody>
    <tr>
      @if(getShowPurchaseRate() != "false")
        <td style="text-align: center;">{{$inAmountUnitCost}}</td>
      @endif
      @if(getShowSaleRate() != "false")
        <td style="text-align: center;">{{$outAmount}}</td>
      @endif
      @if(getShowPurchaseRate() != "false")
        <td style="text-align: center;">{{$inAmountUnitCost-$outAmount}}</td>
      @endif

    </tr>
  </tbody>
</table>
@endif

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection


