@extends('layouts.app')
@section('style')
<style type="text/css">
    body, html{
        height: 100%;
    }
    .background{
        position: relative;
        width: 100%;
        height: 100vh;
        background-image: url('{{asset('menu_img/SaleImages/Capture6.PNG')}}');
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        overflow-y: auto;
    }
    .overlay{
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100vh;
        background-color: rgba(0, 0, 0, 0.651);
        display: flex;
        justify-content: center;
        align-items: flex-start;
        padding-top: 20px;
    }
    .cards{
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        width: 100%;
        max-width: 1600px;
        padding: 10px;
        box-sizing: border-box;
        gap: 10px;
    }
    .allCards{ 
        width: 19%;
        /* height: 80px; */
        min-height: 90px;
        background-color: white;
        border-radius: 10px;
        box-shadow: 0 4px 8px rgba(235, 232, 232, 0.877);
        transition: .5s;
    }
    .allMainCard{ 
        width: 19%;
        /* height: 80px; */
        min-height: 100px;
        border-radius: 10px;
        transition: .5s;
    }
    .allMainCard:hover{
        text-decoration: none;
    }
    .allCards:hover{
        background-color: rgba(255, 255, 255, 0.787);
        transition: .5s;
    }
    .allCards:hover a{
        text-decoration: none;
    }
    @media(max-width: 1024px){
        .allCards{
            width: 22%;
        }
        .allMainCard{
            width: 22%;
        }
    }
    @media(max-width: 768px){
        .allCards{
            width: 45%;
        }
        .allMainCard{
            width: 45%;
        }
    }
    @media(max-width: 480px){
        .allCards{
            width: 90%;
        }
        .allMainCard{
            width: 90%;
        }
    }
    .caret{
        transition: transform 0.3s ease;
    }
    .caret.open{
        transform: rotate(90deg);
    }
</style>
@stop
@section('content')
<div class="background">
    <div class="overlay">
        <div class="cards">
            <div class="mainHeader" style="display: flex; justify-content: space-between;width: 100%;flex-wrap: wrap;">
                <h3 style="color: white;">@lang('menu.Inventory')</h3>
                <div>
                    <div class="btn-group">
                        @if(systemConfig()[23] == 1)
                        @permission('purchase-create')
                        <a href="{{route('purchase.create')}}" type="button" class="btn topBtn" style="background-color: #50818d;color: white;">@lang('layout.AddNew')</a>
                        <button type="button" class="btn topBtn dropdown-toggle btn-success" data-toggle="dropdown" id="dropdownButton">
                            <span class="caret"></span>
                        </button>
                        @endpermission
                        @endif
                        <ul class="dropdown-menu dropdown-menu-right" role="menu">
                            @if(systemConfig()[23] == 1)
                            @permission('inventory-create')
                            <li>
                                <a href="{{route('inventory.create')}}">@lang('menu.Inventory')</a>
                            </li>
                            @endpermission
                            @endif
    
                            @if(systemConfig()[23] == 1)
                            @permission('procurement-create')
                            <li>
                                <a href="{{route('procurement.create')}}">@lang('layout.Procurement')</a>
                            </li>
                            @endpermission
                            @endif
    
                            @if(systemConfig()[23] == 1)
                            @if(systemConfig()[4] != 0 )
                            @permission('procurement-create')
                            <li>
                                <a href="{{route('procurement_roll.create')}}">@lang('layout.ProcurementRoll')</a>
                            </li>
                            @endpermission
                            @endif
                            @endif
    
                            @if(systemConfig()[23] == 1)
                            @permission('sales-create')
                            <li>
                                <a href="{{route('adjustment.create')}}">@lang('menu.Adjustment')</a>
                            </li>
                            @endpermission
                            @endif
    
                            @if(systemConfig()[23] == 1)
                            @if(systemConfig()[4] != 0 )
                            @permission('sales-create')
                            <li>
                                <a href="{{route('adjustment_roll.create')}}">@lang('menu.Adjustment_roll')</a>
                            </li>
                            @endpermission
                            @endif
                            @endif
    
                            @if(systemConfig()[23] == 1)
                            @if(systemConfig()[4] != 0 )
                            @permission('sales-create')
                            <li>
                                <a href="{{route('add_stock_code.create')}}">@lang('menu.AddToCode')</a>
                            </li>
                            @endpermission
                            @endif
                            @endif
    
                            @if(systemConfig()[23] == 1)
                            @permission('inventorySite-create')
                            <li>
                                <a href="{{route('inventorySite.create')}}">@lang('menu.InventorySite')</a>
                            </li>
                            @endpermission
                            @endif
    
                            @if(systemConfig()[23] == 1)
                            @permission('inventoryCategory-create')
                            <li>
                                <a href="{{route('inventoryCategory.create')}}">@lang('menu.InventoryCategory')</a>
                            </li>
                            @endpermission
                            @endif
                            
                            @if(systemConfig()[23] == 1)
                            @permission('inventoryBrand-create')
                            <li>
                                <a href="{{route('inventoryBrand.create')}}">@lang('menu.InventoryBrand')</a>
                            </li>
                            @endpermission
                            @endif
    
                            @if(systemConfig()[23] == 1)
                            @permission('inventoryTransfer-create')
                            <li>
                                <a href="{{route('inventoryTransfer.create')}}">@lang('menu.InventoryTransfer')</a>
                            </li>
                            @endpermission
                            @endif
    
                            @if(systemConfig()[23] == 1)
                            @permission('branchTransfer-create')
                            <li>
                                <a href="{{route('branch.transfer.create')}}">@lang('menu.BranchTransfer')</a>
                            </li>
                            @endpermission
                            @endif
    
                            @if(systemConfig()[23] == 1)
                            @if(systemConfig()[4] != 0 )
                            @permission('branchTransfer-create')
                            <li>
                                <a href="{{route('branchTransferRoll.create')}}">@lang('menu.BranchTransferRoll')</a>
                            </li>
                            @endpermission
                            @endif
                            @endif
    
                            @if(systemConfig()[23] == 1)
                            @if(systemConfig()[4] != 0 )
                            @permission('inventoryTransfer-create')
                            <li>
                                <a href="{{route('InventoryTransferRoll.create')}}">@lang('menu.InventoryTransferRoll')</a>
                            </li>
                            @endpermission
                            @endif 
                            @endif
    
                            @if(systemConfig()[23] == 1)
                            @if(systemConfig()[7] != 0)
                            @permission('transferAndLoading-create')
                            <li>
                                <a href="{{route('transferAndLoading.create')}}">@lang('menu.TransferAndLoading')</a>
                            </li>
                            @endpermission
                            @endif
                            @endif
    
                            @if(systemConfig()[23] == 1)
                            @permission('itemNoneCost-create')
                            <li>
                                <a href="{{route('itemNoneCost.create')}}">@lang('menu.ItemNoneCost')</a>
                            </li>
                            @endpermission
                            @endif
    
                            @if(systemConfig()[23] == 1)
                            @if(systemConfig()[4] != 0 )
                            @permission('itemNoneCost-create')
                            <li>
                                <a href="{{route('itemNoneCostCode.create')}}">@lang('menu.ItemNoneCostCode')</a>
                            </li>
                            @endpermission
                            @endif
                            @endif
    
                            @if(systemConfig()[23] == 1)
                            @if(salePriceCalculate()=="static_item_price")
                            @permission('StaticItemPrice-create')
                            <li>
                                <a href="{{route('staticItemPrice.create')}}">@lang('menu.StaticItemPrice')</a>
                            </li>
                            @endpermission
                            @endif
                            @endif
                            @if(systemConfig()[23] == 1)
                            @if(salePriceCalculate()=="static_item_price")
                            <li>
                                <a href="{{route('staticItemPrice.create')}}">@lang('menu.StaticItemPrice')</a>
                            </li>
                            @endif
                            @endif
                        </ul>
                    </div>
                    <a href="#" class="btn btn-danger">@lang('layout.Back') <i class="fa fa-reply"></i></a>
                </div>
            </div>
            <div class="cards">
                @if(systemConfig()[23] == 1)
                @permission('inventory-list')
                <a href="{{route('inventory.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Inventory')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #7ccc04;" class="fa fa-database"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">@if($inventory_cost){{myRound($inventory_cost)}} {{getHomeCurrency()['code']}} @else 0 @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[23] == 1)
                @permission('procurement-list')
                <a href="{{route('procurement.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.Procurement')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #b6babf;" class="fa fa-database"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$procurement}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[23] == 1)
                @if(systemConfig()[4] != 0 )
                @permission('procurement-list')
                <a href="{{route('procurement_roll.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.ProcurementRoll')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #fb8001;" class="fa fa-database"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">@if($procurementRoll){{myround($procurementRoll)}} {{getHomeCurrency()['code']}} @else 0 @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @endif
                @if(systemConfig()[23] == 1)
                @permission('adjustment-list')
                <a href="{{route('adjustment.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Adjustment')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #0175c0;" class="fa fa-money"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">@if($adjustments){{$adjustments}} @else 0 @endif</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[23] == 1)
                @if(systemConfig()[4] != 0 )
                @permission('adjustment-list')
                <a href="{{route('adjustment_roll.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Adjustment_roll')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #1fa7f2;" class="fa fa-database"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$adjustmentRoll}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @endif
                @if(systemConfig()[23] == 1)
                @if(systemConfig()[4] != 0 )
                @permission('inventory-list')
                <a href="{{route('add_stock_code.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.AddToCode')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(251, 239, 91, 1);" class="fa fa-plus"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$addToStock}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @endif
                @if(systemConfig()[23] == 1)
                @permission('inventorySite-list')
                <a href="{{route('inventorySite.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.InventorySite')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(163, 209, 118, 1);" class="fa fa-location-arrow"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$inventorySite}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[23] == 1)
                @permission('inventoryCategory-list')
                <a href="{{route('inventoryCategory.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.InventoryCategory')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(89, 192, 148, 1);" class="fa fa-reorder"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$inventoryCategory}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[23] == 1)
                @permission('inventoryBrand-list')
                <a href="{{route('inventoryBrand.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.InventoryBrand')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(1, 131, 128, 1);" class="fa fa-stack-exchange"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$inventoryBrand}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[23] == 1)
                @permission('inventoryTransfer-list')
                <a href="{{route('inventoryTransfer.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.InventoryTransfer')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(1, 166, 164, 1);" class="fa fa-stack-exchange"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$inventoryTransfer}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[23] == 1)
                @permission('branchTransfer-list')
                <a href="{{route('branch.transfer.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.BranchTransfer')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(1, 193, 191, 1);" class="fa fa-stack-exchange"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$branchTransfer}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[23] == 1)
                @if(systemConfig()[4] != 0 )
                @permission('branchTransfer-list')
                <a href="{{route('branchTransferRoll.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.BranchTransferRoll')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(21, 239, 233, 1);" class="fa fa-stack-exchange"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$branchTransferRoll}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @endif
                @if(systemConfig()[23] == 1)
                @if(systemConfig()[4] != 0 )
                @permission('inventoryTransfer-list')
                <a href="{{route('InventoryTransferRoll.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.InventoryTransferRoll')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(77, 94, 137, 1);" class="fa fa-stack-exchange"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$inventoryTransferRoll}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @endif
                @if(systemConfig()[23] == 1)
                @if(systemConfig()[7] != 0)
                @permission('transferAndLoading-list')
                <a href="{{route('transferAndLoading.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.TransferAndLoading')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(32, 57, 87, 1);" class="fa fa-stack-exchange"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$transferAndLoading}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @endif
                @if(systemConfig()[23] == 1)
                @permission('itemNoneCost-list')
                <a href="{{route('itemNoneCost.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.ItemNoneCost')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(110, 140, 168, 1);" class="fa fa-stack-exchange"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$noneCost}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @if(systemConfig()[23] == 1)
                @if(systemConfig()[4] != 0 )
                @permission('itemNoneCost-list')
                <a href="{{route('itemNoneCostCode.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.ItemNoneCostCode')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(247, 111, 0, 1);" class="fa fa-stack-exchange"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$noneCostCode}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @endif
                @if(systemConfig()[23] == 1)
                @if(salePriceCalculate()=="static_item_price")
                <a a href="{{route('staticItemPrice.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.StaticItemPrice')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(44, 160, 28, 1);" class="fa fa-stack-exchange"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$staticItemPrice}}</p>
                        </div>
                    </div>
                </a>
                @endif
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
    const dropdownButton = document.getElementById('dropdownButton');
    const caret = dropdownButton.querySelector('.caret');
    dropdownButton.addEventListener('click', ()=>{
        caret.classList.toggle('open');
    });
    function toggleContent(){
        var content = document.querySelector('.content');
        var icon = document.getElementById('icon');
        if(content.classList.contains('collapsed')){
            content.classList.remove('collapsed');
            content.classList.add('expanded');
            icon.classList.remove('fa-chevron-down');
            icon.classList.add('fa-chevron-up');
        }else{
            content.classList.remove('expanded');
            content.classList.add('collapsed');
            icon.classList.remove('fa-chevron-up');
            icon.classList.add('fa-chevron-down');
        }
    }
</script>
<script type="text/javascript">
    new Vue({
        el: "#system_setting",
        data: {
            settings: settingAll,
            measures: measures,
            sites: sites,
            enable_notify: false
        },
        mounted() {
        },
        methods: {
        }
    });
</script>
@endpush