@extends('layouts.factor-master')

@section('content')

<?php
$report = customeReportNew('inventory_show_in');
$_type= !in_array('type', $report);
$_number= !in_array('number', $report);
$_ref_no= !in_array('ref_no', $report);
$_vendor= !in_array('vendor', $report);
$_date= !in_array('date', $report);
$_site_name= !in_array('site_name', $report);
$_measure= !in_array('measure', $report);
$_quantity= !in_array('quantity', $report);
$_qty= !in_array('qty', $report);
$_purchase_rate= !in_array('purchase_rate', $report);
$_rate= !in_array('rate', $report);
$_total= !in_array('total', $report);
$_description= !in_array('description', $report);
$_unit_cost= !in_array('unit_cost', $report);
$_total_qty= !in_array('total_qty', $report);
$_expire_date_input= !in_array('expire_date_input', $report);


$report_percent = customeReportNewPercent('inventory_show_in');
    $_type_percent= (array_key_exists('type___percent', $report_percent))?$report_percent['type___percent']:null;                                           
    $_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
    $_ref_no_percent= (array_key_exists('ref_no___percent', $report_percent))?$report_percent['ref_no___percent']:null;
    $_vendor_percent= (array_key_exists('vendor___percent', $report_percent))?$report_percent['vendor___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_site_name_percent= (array_key_exists('site_name___percent', $report_percent))?$report_percent['site_name___percent']:null;
    $_measure_percent= (array_key_exists('measure___percent', $report_percent))?$report_percent['measure___percent']:null;
    $_quantity_percent= (array_key_exists('quantity___percent', $report_percent))?$report_percent['quantity___percent']:null;
    $_qty_percent= (array_key_exists('qty___percent', $report_percent))?$report_percent['qty___percent']:null;
    $_purchase_rate_percent= (array_key_exists('purchase_rate___percent', $report_percent))?$report_percent['purchase_rate___percent']:null;
    $_rate_percent= (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null;
    $_total_percent= (array_key_exists('total___percent', $report_percent))?$report_percent['total___percent']:null;
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
    $_unit_cost_percent= (array_key_exists('unit_cost___percent', $report_percent))?$report_percent['unit_cost___percent']:null;
    $_total_qty_percent= (array_key_exists('total_qty___percent', $report_percent))?$report_percent['total_qty___percent']:null;
    $_expire_date_input_percent= (array_key_exists('expire_date_input___percent', $report_percent))?$report_percent['expire_date_input___percent']:null;
 
// dd($_number_percent);

?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.InItems')</h3>
 <table class="main-table">
    @if($info && $info !=[])
    <tr>
      <td>
      <span>@lang('layout.ItemName')</span>:
      <span>{{$info->name}}</span>
    </td>  
    </tr>
    <tr>
    
         <td>
          <span>@lang('layout.Max')</span>:
          <span>{{$info->max}}</span>
        </td> 
       <td>
      <span>@lang('layout.Min')</span>:
      <span>{{$info->min}}</span>
    </td> 
    </tr>
    @endif
    <tr>
  
</tr>
   
   </table>
   <table class="main-table">
    <tr>
        @if($from_date)
            <td>
                <span>@lang('layout.FromDate')</span>:
                <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($from_date)}}</BDO>
            </td>
        @endif
        @if($to_date)
            <td>
                <span>@lang('layout.ToDate')</span>:
                <BDO DIR="LTR">@if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($to_date)}}</BDO>
            </td>
        @endif
    </tr>
  </table>
   <br>
  <table class="main-table">
   
    <thead>
      <tr class="bg">
            <td><div > #</div></td>
      @if($_type)<td class="center" @if($_type_percent) width="{{$_type_percent}}%" @endif><div > @lang('layout.Type') </div></td>@endif
      @if($_number)<td class="center" @if($_number_percent) width="{{$_number_percent}}%" @endif><div > @lang('layout.Number') </div></td>@endif
      @if($_ref_no)<td class="center" @if($_ref_no_percent) width="{{$_ref_no_percent}}%" @endif><div > @lang('layout.ReferenceNumber')</div></td>@endif
      @if($_date)<td class="center" @if($_date_percent) width="{{$_date_percent}}%" @endif><div > @lang('layout.Date')</div></td>@endif
      @if($_expire_date_input)<td class="center" @if($_expire_date_input_percent) width="{{$_expire_date_input_percent}}%" @endif><div > @lang('layout.ExpireDate')</div></td>@endif
      @if($_description)<td class="center"  @if($_description_percent) width="{{$_description_percent}}%" @endif ><div > @lang('layout.Description')</div></td>@endif
      @if($_vendor)<td class="center" @if($_vendor_percent) width="{{$_vendor_percent}}%" @endif><div > @lang('layout.Vendor')</div></td>@endif
      @if($_site_name)<td class="center" @if($_site_name_percent) width="{{$_site_name_percent}}%" @endif><div > @lang('layout.SiteName') </div></td>@endif
      @if(showLocation()=="true")<td class="center"><div > @lang('layout.Location') </div></td>@endif
      @if(getSaleDescription()=="true")
      <td  class="center"  ><div > @lang('layout.Description1') </div></td>
      <td  class="center"  ><div > @lang('layout.Model') </div></td>
      <td  class="center"  ><div > @lang('layout.Color') </div></td>
      @endif
      @if($_measure)<td class="center" @if($_measure_percent) width="{{$_measure_percent}}%" @endif><div > @lang('layout.Measure')</div></td>@endif
      @if(getShowPurchaseRate() != "false")
      @if($info->type == "workingProgress")
        @if($_purchase_rate)<td class="center" @if($_purchase_rate_percent) width="{{$_purchase_rate_percent}}%" @endif><div > @lang('layout.WorkingProgressCost')</div></td>@endif
      @elseif($info->type == "inventoryAssembly")
        @if($_purchase_rate)<td class="center" @if($_purchase_rate_percent) width="{{$_purchase_rate_percent}}%" @endif><div > @lang('layout.BOMCost')</div></td>@endif
      @else
      @permission(['price-create'])
        @if($_purchase_rate)<td class="center" @if($_purchase_rate_percent) width="{{$_purchase_rate_percent}}%" @endif><div > @lang('layout.Cost')</div></td>@endif
        @endpermission
      @endif
      @permission(['price-create'])
        @if($_unit_cost)<td class="center" @if($_unit_cost_percent) width="{{$_unit_cost_percent}}%" @endif><div > @lang('layout.UnitCost')</div></td>@endif
        @endpermission
        @endif
      @if($_qty)<td class="center" @if($_qty_percent) width="{{$_qty_percent}}%" @endif><div > @lang('layout.Quantity')</div></td>@endif
      @if(getShowPurchaseRate() != "false")
      @permission(['price-create'])
        @if($_total)<td class="center"><div > @lang('layout.Total')</div></td>@endif
        @endpermission
      @endif
      <td class="center"><div > @lang('layout.User')</div></td>
    </tr>
    </thead>
    <?php
    $count = 0;
    $total=0;
    $totalPrice=0;
    $type=[];
    ?>
    @foreach($data AS $record)
        <?php
        $total +=$record->Quantity;
        $totalPrice+=$record->Total;
        if(array_key_exists($record->cat, $type))
        {

            $type[$record->cat]=$type[$record->cat]+$record->Quantity;
            
        }
        else
        {
            $type[$record->cat]=$record->Quantity;
        }
      ?>
    <tr>
      <td class="center">{{++$count}}</td>
      @if($_type)<td class="center">
        {{__('type.'.ucfirst($record->Type))}}
        </td>@endif
        @if($_number)<td class="center">{{$record->Number}}</td>@endif
        @if($_ref_no)<td  class="center">{{$record->refNo}}</td>@endif
         @if($_date)<td class="center">
        {{convertDate($record->Date)}}
        </td>@endif
         @if($_expire_date_input)<td class="center">
        {{convertDate($record->expire_date)}}
        </td>@endif
        @if($_description)<td style="@if($_description_percent) text-align: justify; @endif">{{$record->Description}}</td>@endif

      @if($_vendor)<td class="center">{{$record->Vendor}}</td>@endif
      @if($_site_name)<td class="center">{{$record->SiteName}}</td>@endif
      @if(showLocation()=="true")<td class="center">{{$record->location}}</td>@endif
      @if(getSaleDescription()=="true")
      <td class="center">{{$record->description1}}</td>
      <td class="center">{{$record->model}}</td>
      <td class="center">{{$record->color}}</td>
      @endif
      @if($_measure)<td class="center">{{$record->Measure}}</td>@endif
      @if(getShowPurchaseRate() != "false")
      @permission(['price-create'])
        @if($_purchase_rate)<td class="center">{{myRound($record->Cost)}}</td>@endif
        @if($_unit_cost)<td class="center">{{myRound($record->total_cost)}}</td>@endif
        @endpermission
      @endif
      @if($_qty)<td class="center">{{myRound($record->Quantity)}}</td>@endif
      @if(getShowPurchaseRate() != "false")
      @permission(['price-create'])
        @if($_total)<td class="center">{{myRound($record->Total)}}</td>@endif
        @endpermission
      @endif
      <td style="text-align: center;">{{$record->user}}</td>
    </tr>
    @endforeach
</table>

@if($_total_qty)
<table class="main-table">

<tr class="bg">
  <td class="center"><div > #</div></td>
  <td class="center"><div > @lang('layout.Type') </div></td>
  <td class="center"><div > @lang('layout.Total') </div></td>
  @if(getShowPurchaseRate() != "false")
  @permission(['price-create'])
    <td class="center"><div > @lang('layout.TotalPrice') </div></td>
    @endpermission
  @endif
</tr>
<?php
$count=0;

if(isset($type))
{
  foreach($type As $key=>$typee)
{
  ?>
  <tr>
    <td class="center"><div >{{++$count}}</div></td>
    <td class="center"><div >{{$key}}</div></td>
    <td class="center"><div >{{$total}}</div></td>
    @if(getShowPurchaseRate() != "false")
    @permission(['price-create'])
     <td class="center"><div >{{$totalPrice}}</div></td>
     @endpermission
    @endif

  </tr>
  <?php
}
}

  ?>


</table>
@endif

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection