@extends('layouts.app')
@section('style')
<style>
    .hide_btn {
        display: none;
    }
    .v-select .selected-tag{
        height: 26px !important;
        margin: 4px 1px 0 3px !important;
    }
    .v-select .selected-tag > button >span{
        display: none !important;
    }
</style>
@endsection
@section('content')
@include('inventories.modal')
<!-- END PAGE HEADER-->
<!--Begin Custome Report Modal-->
<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'allInventoryReport'" @closed="closeModal">
        <div slot="body">
            <!---------------------------------------------- 
            ----Begin Report Body And Custome Report------- 
            ----------------------------------------------->
            <div class="row" v-cloak>
                <div class="tabbable tabbable-tabdrop">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="tab_main">@lang('layout.CustomReportM')</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                            <div class="portlet light bordered">
                                <form id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                    @csrf
                                    <input type="hidden" name="part_name" value="inventory_index">
                                    <div class="col-md-12 col-sm-12 col-xs-12">
                                        <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                            <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                    <tr>
                                                        <td style="text-align: center;">@{{ row.Name }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td style="text-align: center;">
                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                            <label class="switch">
                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" :checked="row.checkedColumn">
                                                                <span class="slider round"></span>
                                                            </label>
                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                <option value="">@lang('layout.Select')</option>
                                                                <option value="2">2 %</option>
                                                                <option value="6">6 %</option>
                                                                <option value="10">10 %</option>
                                                                <option value="15">15 %</option>
                                                                <option value="20">20 %</option>
                                                                <option value="25">25 %</option>
                                                                <option value="30">30 %</option>
                                                                <option value="40">40 %</option>
                                                                <option value="50">50 %</option>
                                                                <option value="60">60 %</option>
                                                            </select>
                                                        </td>
                                                    </tr>
                                                </table> 
                                            </div>
                                        </div>
                                    </div>
                                    <div class="margiv-top-10">
                                        <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                        <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->
        </div>
    </report-modal>
</div>
<!--Begin Custome Report Modal-->
<div id="appdetail" v-cloak>
    <form id="dd_form" action="{{route('export.PDFAll')}}" method="POST">
        <input type="hidden" name="_method" value="DELETE">
        {!! Form::token() !!}
        <!-- use the modal component, pass in the prop -->
        <modal v-if="show_modal_detail" @close="show_modal_detail = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group" id="dynamic_content">
                    </div>
                </div>
                <!------ begain Out ----->
                <div class="row" v-if="(showDiv['out_inventory_detail_pdf'])">
                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.InventorySite') </label>
                        <select name="inventory_site_id" id="" class="form-control">
                            <option value="">@lang('layout.SelectInventorySite')</option>
                            @foreach($inventorySite as $site)
                            <option value="{{$site->id}}">{{$site->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <!------ End Out ----->
                <!------ begain In ----->
                <div class="row" v-if="(showDiv['in_inventory_detail_pdf'])">
                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.InventorySite') </label>
                        <select name="inventory_site_id" id="" class="form-control">
                            <option value="">@lang('layout.SelectInventorySite')</option>
                            @foreach($inventorySite as $site)
                            <option value="{{$site->id}}">{{$site->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <!------ End In ----->
                <!------ begain All ----->
                <div class="row" v-if="(showDiv['both_inventory_detail_pdf'])">
                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.InventorySite') </label>
                        <select name="inventory_site_id" id="" class="form-control">
                            <option value="">@lang('layout.SelectInventorySite')</option>
                            @foreach($inventorySite as $site)
                            <option value="{{$site->id}}">{{$site->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <!------ End All ----->
                <!------ begain Project ----->
                <div class="row" v-if="(showDiv['project_items_in_out'])">
                    <div class="col-md-12" style="padding-right: 0px !important; padding-left: 0px !important;" >
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.Contract') </label>
                            <v-select class="vue-select2" label="name" v-model="selected_contract" :options="contract">
                            </v-select>
                            <input type="hidden" name="contract_id" v-model.number="(!selected_contract)?null:selected_contract.id">
                        </div>
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.Type') </label>
                            <select name="types" id="" class="form-control">
                                <option value="">@lang('layout.Select')</option>
                                <option value="detail">@lang('layout.Details')</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectItem') </label>
                            <v-select class="vue-select2" v-model="selectedItem1" label="name" @search="onItemSearch" :options="itemlist" >
                            </v-select>
                            <input type="hidden" name="item_id" v-model.number="(!selectedItem1)?null:selectedItem1.id" >
                        </div>
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.InventorySite') </label>
                            <select name="inventory_site_id" id="" class="form-control">
                                <option value="">@lang('layout.SelectInventorySite')</option>
                                @foreach($inventorySite as $site)
                                <option value="{{$site->id}}">{{$site->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <!------ End Project ----->
                <!------ begain purchase item ----->
                <div class="row" v-if="(showDiv['purchase_item'])">
                    <div class="col-md-12" style="padding-right: 0px !important; padding-left: 0px !important;" >
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2"
                                      v-model="selectedMember" label="name"
                                      @search="searchMember"
                                      :options="memberlist">
                            </v-select>
                            <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id" >
                        </div>
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectClass') </label>
                            <v-select class="vue-select2"
                                      v-model="selectedMemberClass" label="name"
                                      @search="searchMemberClass"
                                      :options="memberClass">
                            </v-select>
                            <input type="hidden" name="member_class_id" v-model.number="(!selectedMemberClass)?null:selectedMemberClass.id" >
                        </div>
                    </div>
                    <div class="col-md-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectItem') </label>
                            <v-select class="vue-select2" v-model="selectedItem1" label="name" @search="onItemSearch" :options="itemlist" >
                            </v-select>
                            <input type="hidden" name="item_id" v-model.number="(!selectedItem1)?null:selectedItem1.id" >
                        </div>
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.InventorySite') </label>
                            <select name="inventory_site_id" id="" class="form-control">
                                <option value="">@lang('layout.SelectInventorySite')</option>
                                @foreach($inventorySite as $site)
                                <option value="{{$site->id}}">{{$site->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <!------ End purchase item ----->
                <!------ begain Inventory general report code ----->
                <div class="row" v-if="(showDiv['inventory_general_report_code'])">
                    <div class="form-group">
                        <div class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectInventoryCategory') </label>
                        <select name="inventory_category_id" id="" class="form-control">
                            <option value="">@lang('layout.SelectInventoryCategory')</option>
                            @foreach($inventoryCategory as $cat)
                            <option value="{{$cat->id}}">{{$cat->name}}</option>
                            @endforeach
                        </select>
                        </div>
                        <div class="col-md-6">
                            <label class="control-label ">@lang('menu.InventoryBrand') </label>
                            <select name="inventory_brand_id" id="" class="form-control">
                                <option value="">@lang('layout.Select')</option>
                                @foreach($inventoryBrand as  $brand)
                                <option value="{{$brand->id}}">{{$brand->name}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectInventorySite') </label>
                        <select name="inventory_site_id" id="" class="form-control">
                            <option value="">@lang('layout.SelectInventorySite')</option>
                            @foreach($inventorySite as $site)
                            <option value="{{$site->id}}">{{$site->name}}</option>
                            @endforeach
                        </select>
                        </div>
                        <div class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectItem') </label>
                        <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist" :multiple="true">
                        </v-select>
                        <input type="hidden" name="item_id" :value="item_id.length > 0 ? item_id:null">
                        </div>
                    </div>
                </div>
                <!------ End Inventory general report code ----->
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.Date')</label>
                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                <option value="Today">@lang('type.Today')</option>
                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                <option value="YearToDate">@lang('type.YearToDate')</option>
                            </select>
                        </div>
                        <div class="col-md-8" v-show="period == 'CustomDates'">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <br>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.ReportType') </label>
                            <select name="report_type" id="" class="form-control">
                                <option value="pdf">@lang('layout.PDF')</option>
                                <option value="excel" selected="selected">@lang('layout.Excel')</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
    </form>
</div>
<!-- app -->
<div id="app3" v-cloak>
    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="allInventoryReport" />
    <input type="hidden" name="inventory_site_id" :value="site_id" />
    <button id="show-modal3" style="display: none" type="button" @click="editExample3">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false">
        <div slot="body">
            <div class="row">
                <div class="form-group">
                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectInventoryCategory') </label>
                        <select name="inventory_category_id" id="" class="form-control">
                            <option value="">@lang('layout.SelectInventoryCategory')</option>
                            @foreach($inventoryCategory as $cat)
                            <option value="{{$cat->id}}">{{$cat->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <div class="col-md-12">
                                <label class="control-label" style="color: red">@lang('layout.TotalCode')</label>
                                <input type="checkbox" name="total_code" value="ok" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example3" name="from_date" autocomplete="off">
                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example3" name="to_date" autocomplete="off">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>
        </div>
    </modal>
    {{Form::close()}}
</div>
<!-- app -->
<div id="app4" v-cloak>
    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="allInventoryReport" />
    <input type="hidden" name="inventory_site_id" :value="site_id" />
    <button id="show-modal4" style="display: none" type="button" @click="editExample4">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false">
        <div slot="body">
            <div class="row">
                <div class="form-group">
                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectInventoryCategory') </label>
                        <select name="inventory_category_id" id="" class="form-control">
                            <option value="">@lang('layout.SelectInventoryCategory')</option>
                            @foreach($inventoryCategory as $cat)
                            <option value="{{$cat->id}}">{{$cat->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <div class="col-md-12">
                                <label class="control-label" style="color: red">@lang('layout.TotalCode')</label>
                                <input type="checkbox" name="total_code" value="ok" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example4" name="from_date" autocomplete="off">
                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example4" name="to_date" autocomplete="off">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>
        </div>
    </modal>
    {{Form::close()}}
</div>
<div id="app" v-cloak>
    <form id="d_form" action="{{route('export.PDFAll')}}" method="POST">
        <input type="hidden" name="_method" value="DELETE">
        {!! Form::token() !!}
        <input type="hidden" name="type" value="allInventoryReport" />
        <!-- <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button> -->
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group" id="dynamic_content">
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.SelectInventoryCategory') </label>
                            <select name="inventory_category_id" id="" class="form-control">
                                <option value="">@lang('layout.SelectInventoryCategory')</option>
                                @foreach($inventoryCategory as $cat)
                                <option value="{{$cat->id}}">{{$cat->name}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.SelectInventorySite') </label>   

                            <v-select class="vue-select2" v-model="selectedSite" label="name" :options="inventorySite" :multiple="true">
                            </v-select>
                            <input type="hidden" name="inventory_site_id" :value="inventory_site_id.length > 0 ? inventory_site_id:null">
                            {{-- <input v-if="!all_onhund" type="hidden" name="inventory_site_id" :value="selectedSite ? selectedSite.id:null"> --}}

                            {{-- <select name="inventory_site_id" id="" class="form-control">
                                <option value="">@lang('layout.SelectInventorySite')</option>
                                @foreach($inventorySite as $site)
                                <option value="{{$site->id}}">{{$site->name}}</option>
                                @endforeach
                            </select> --}}
                        </div>
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.SelectItem') </label>
                            <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist" :multiple="true">
                            </v-select>
                            <input type="hidden" name="item_id" :value="item_id.length > 0 ? item_id:null">
                            <!--   <input type="hidden" name="item_id"
                            v-model.number="(!selectedItem)?null:selectedItem.id" > -->
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-4">
                            <label class="control-label"> @lang('layout.Type')</label>
                            <select v-model="istype" class="form-control" name="exportType">
                                <option value="all">@lang('layout.All')</option>
                                <option value="withOnHand">@lang('layout.WithOnHand')</option>
                                <option value="daily">@lang('layout.Daily')</option>
                                <option value="OnhandComparison">@lang('layout.OnhandComparison')</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="control-label ">@lang('menu.InventoryBrand') </label>
                            <select name="inventory_brand_id" id="" class="form-control">
                                <option value="">@lang('layout.Select')</option>
                                @foreach($inventoryBrand as $brand)
                                <option value="{{$brand->id}}">{{$brand->name}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-1">
                            @if(ShowSaveTempItemToCustomer() == "true")
                            <div class="form-group">
                                <div class="col-md-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                                    <label class="control-label" >@lang('layout.CustomerStock')</label>
                                    <input type="checkbox" name="customerStock" value="ok" class="form-control">
                                </div>
                            </div>
                            @endif
                        </div>
                        <div class="col-md-3">
                            <label class="control-label ">@lang('layout.GroupBy') </label>
                            <select name="group_by" id="" class="form-control">
                                <option value="">@lang('layout.Select')</option>
                                <option value="site">@lang('layout.Site')</option>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <div class="form-group">
                                <div class="col-md-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                                    <label class="control-label" style="color: red">@lang('layout.TotalCode')</label>
                                    <input type="checkbox" name="total_code" value="ok" class="form-control">
                                </div>
                            </div>
                        </div>
                        <div v-show="(istype !='all' && istype !='withOnHand')" class="col-md-8">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                                <span class="input-group-addon">@lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-4">
                            <label class="control-label">@lang('layout.ItemType')</label>
                            <select class="form-control" name="inventory_type">
                                <option value="">@lang('layout.Select')</option>
                                <option value="inventoryPart">@lang('layout.InventoryPart')</option>
                                <option value="inventoryAssembly">@lang('layout.InventoryAssembly')</option>
                                <option value="workingProgress">@lang('layout.WorkingProgress')</option>
                                <option value="procurement">@lang('layout.Procurement')</option>
                            </select>
                        </div>
                        @if(searchByCodeLocation()=="true")
                        <div class="col-md-4">
                            <label class="control-label">@lang('layout.Location')</label>
                            <input class="form-control" name="location" autocomplete="off">
                        </div>
                        @endif
                    </div>
                </div>
                <!--Begin Measure-->
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-3">
                            <label class="control-label ">@lang('layout.SelectU/M')(1) </label>
                            <select name="measure_id" id="" class="form-control">
                                <option value="">@lang('layout.SelectU/M')</option>
                                @foreach($measures as $measure)
                                <option value="{{$measure->id}}">{{$measure->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    @if(getM2() != '')
                    <div class="form-group">
                        <div class="col-md-3">
                            <label class="control-label ">@lang('layout.SelectU/M')(2) </label>
                            <select name="measure_id2" id="" class="form-control">
                                <option value="">@lang('layout.SelectU/M')</option>
                                @foreach($measures as $measure)
                                <option value="{{$measure->id}}">{{$measure->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    @endif
                    @if(getM3() != '')
                    <div class="form-group">
                        <div class="col-md-3">
                            <label class="control-label ">@lang('layout.SelectU/M')(3) </label>
                            <select name="measure_id3" id="" class="form-control">
                                <option value="">@lang('layout.SelectU/M')</option>
                                @foreach($measures as $measure)
                                <option value="{{$measure->id}}">{{$measure->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    @endif
                    @if(getM4() != '')
                    <div class="form-group">
                        <div class="col-md-3">
                            <label class="control-label ">@lang('layout.SelectU/M')(4) </label>
                            <select name="measure_id4" id="" class="form-control">
                                <option value="">@lang('layout.SelectU/M')</option>
                                @foreach($measures as $measure)
                                <option value="{{$measure->id}}">{{$measure->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    @endif
                </div>
                <!--End Measure-->
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-2">
                            <label class="control-label" style="color: red">@lang('layout.JustOnHand')</label>
                            <input type="checkbox" name="all_onhund" v-model="all_onhund" class="form-control">
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
    </form>
</div>
<!-- app -->
<!-- BEGIN TAB PORTLET-->
<div class="row">
    <div class="portlet light bordered">
        <!--Begin Inventory Category-->
        <!--         <div class="col-md-3">
            <select class="form-control"  v-model="inv_category" placeholder="{{__('Search1')}} "  name="inv_category">
                <option value="">@lang('layout.Select')</option>
                @foreach($inventoryCategory as $cat)
                <option value="{{$cat->id}}">{{$cat->name}}</option>
                @endforeach
            </select>
        </div> -->
        <!--End Inventory Category-->
        <div class="portlet-body">
            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>
            <div class="tabbable-custom ">
                <div class="row">
                    <div class="col-md-9">
                        <ul class="nav nav-tabs mytabs" id="mytabs">
                            @if($show_site)
                            <li class="active">
                                <a href="#tab" data-toggle="tab" id="default">@lang('layout.AllSite')</a>
                            </li>
                            @endif
                            <?php
                            $counter = 0;
                            ?>
                            @foreach($inventorySite AS $rec)
                            @if (($loop->index)<5) 
                                @if(!$show_site && $rec->id == $inventorySite[0]->id)
                                <li class="active">
                                @else
                                <li>
                                @endif
                                <a href="#tab{{$rec->id}}" id="{{$rec->id}}" data-toggle="tab">{{$rec->name}}</a>
                                </li>
                                @endif
                                @if (($loop->index)>=5)
                                <?php
                                $counter++;
                                if ($counter == 1) {
                                ?>
                                    <li class="dropdown">
                                        <a href="javascript:;" id="myTabDrop1" class="dropdown-toggle" data-toggle="dropdown"> @lang('layout.OtherSites')
                                            <i class="fa fa-angle-down"></i>
                                        </a>
                                        <ul class="dropdown-menu" role="menu" aria-labelledby="myTabDrop1">
                                        <?php
                                    }
                                        ?>
                                        <li>
                                            <a href="#tab{{$rec->id}}" id="{{$rec->id}}" data-toggle="tab">{{$rec->name}}</a>
                                        </li>
                                        <?php
                                        if ($loop->last) {
                                        ?>
                                        </ul>
                                    </li>
                                <?php
                                        }
                                ?>
                            @endif
                            @endforeach
                            @if(showZeroOnHand() == "false")
                            <li>
                                <a href="#tab" data-toggle="tab" id="default_and_zero">@lang('layout.AllSiteZero')</a>
                            </li>
                            @endif
                        </ul>
                    </div>
                    @if(itemType()=="true")
                    <div class="col-md-3" style="padding-right: 20px !important; padding-left: 20px !important;">
                        <div class="form-group" id="type_part">
                            <label class="control-label">@lang('layout.ItemType')</label>
                            <select class="form-control" @Click="getData()" v-model="type" name="type">
                                <option selected="selected" value="inventoryPart">@lang('layout.InventoryPart')</option>
                                <option value="inventoryAssembly">@lang('layout.InventoryAssembly')</option>
                                <option value="workingProgress">@lang('layout.WorkingProgress')</option>
                                <option value="procurement">@lang('layout.Procurement')</option>
                            </select>
                        </div>
                    </div>
                    @endif
                </div>
                <!-- template for the modal component -->
                <div class="tab-content">
                    <div class="tab-pane  @if($show_site) active @endif" id="tab">
                        <div class="page-toolbar">
                            <div class=" pull-right">
                                @permission('inventory-export')
                                <button type="button" onClick="report_by_type_pdf()" id="inventory_excell_all" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')</button>
                                <button type="button" onClick="report_by_type_pdf()" class="btn btn-success" id="print_pdf_all"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF')
                                </button>
                                <a href="{{route('inventory.qrCode')}}">
                                    <button class="btn btn-success">
                                        <i class="fa fa-qrcode"></i> @lang('layout.QrCode')
                                    </button>
                                </a>
                                @endpermission
                                @permission('inventory-create')
                                <a href="{{route('inventory.create')}}">
                                    <button class="btn btn-success">
                                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                                    </button>
                                </a>
                                @if(systemConfig()[4] != 0 )
                                <a href="{{route('inventory.m_create')}}">
                                    <button class="btn btn-success">
                                        <i class="fa fa-plus"></i> @lang('layout.AddNewRoll')
                                    </button>
                                </a>
                                <a href="{{route('inventory.opening')}}">
                                    <button class="btn btn-success">
                                        <i class="fa fa-plus"></i> @lang('layout.OpeningCode')
                                    </button>
                                </a>
                                @endif
                                @endpermission
                            </div>
                            <div class="btn-group pull-right">
                                <button type="button" class="btn green  dropdown-toggle" data-toggle="dropdown"> @lang('layout.More')
                                    <i class="fa fa-angle-down"></i>
                                </button>
                                <ul class="dropdown-menu pull-right" role="menu">
                                    @permission('inventory-create')
                                    <li>
                                        <button type="button" onclick="window.location.href='{{route("inventoryImport.create")}}'" id="both_inventory_detail_pdf" class="btn btn-success btn-block">@lang('menu.InventoryImport')</button>
                                    </li>
                                    @endpermission
                                    <li>
                                        <button type="button" onClick="report_by_type_pdf_detail()" id="both_inventory_detail_pdf" class="btn btn-success btn-block">@lang('layout.All')</button>
                                    </li>
                                    <li>
                                        <a href="{{route('inventory.itemReport')}}" class="btn btn-success btn-block" style="color: white;" > @lang('layout.SelectItem') </a>
                                    </li>
                                    <li>
                                        <button type="button" onClick="report_by_type_pdf_detail()" id="in_inventory_detail_pdf" class="btn btn-success btn-block">@lang('layout.InItems')</button>
                                    </li>
                                    <li>
                                        <button type="button" onClick="report_by_type_pdf_detail()" id="out_inventory_detail_pdf" class="btn btn-success btn-block">@lang('layout.OutItems')</button>
                                    </li>
                                    <li>
                                        <button type="button" onClick="report_by_type_pdf_detail()" id="purchase_item" class="btn btn-success btn-block">@lang('layout.PurchaseItem')</button>
                                    </li>
                                    <li>
                                        <button type="button" onClick="report_by_type_pdf_detail()" id="project_items_in_out" class="btn btn-success btn-block">@lang('layout.Contract')</button>
                                    </li>
                                    <li>
                                        <button type="button" onClick="report_by_type_pdf_detail()" id="inventory_general_report_code" class="btn btn-success btn-block">@lang('layout.InventoryGeneralReportCode')</button>
                                    </li>
                                    @if(systemConfig()[2] != 0 )
                                    @permission(['customreport-list'])
                                    <li>
                                        <span id="anchore-modal">
                                            <a href="#" @click.prevent="showModal" id="" class="btn  btn-success btn-block">
                                                <i class="fa fa-print"></i>@lang('layout.CustomReportM')
                                            </a>
                                        </span>
                                    </li>
                                    @endpermission
                                    @endif
                                </ul>
                            </div>
                        </div>
                        <table id="tab1_table" class="table table-striped table-bordered grid table-hover" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    @if(searchByCodeLocation()=="true")
                                        <th>@lang('layout.ItemName')</th>
                                        <th>@lang('layout.SerialNum')</th>
                                    @else
                                        <th>@lang('layout.SerialNum')</th>
                                        <th>@lang('layout.ItemName')</th>
                                    @endif
                                    @if(itemCategory()=="true")
                                    <th>@lang('layout.Category')</th>
                                    @endif
                                    @if(itemBrand()=="true")
                                    <th>@lang('layout.Brand')</th>
                                    @endif
                                    @if(getShowMakeCartan()=="true")
                                    <th>@lang('layout.Length')</th>
                                    <th>@lang('layout.Width')</th>
                                    <th>@lang('layout.Height')</th>
                                    @endif
                                    @if(itemPicture()=="true")
                                    <!-- <th>@lang('layout.Photo')</th> -->
                                    @endif
                                    @if(itemType()=="true")
                                    <th>@lang('layout.ItemType')</th>
                                    @endif
                                    <th>@lang('layout.MeasureUnit')</th>
                                    <th>@lang('layout.OnHand')</th>
                                    @if(systemConfig()[4] != 0 )
                                    <th>@lang('layout.TotalCode')</th>
                                    @endif
                                    @if(getOtherMeasure()=="true" || systemConfig()[27] == 1)
                                    <th>@lang('layout.OMeasureValue1')</th>
                                    @endif
                                    @if(getOtherMeasure2()=="true")
                                    <th>@lang('layout.OMeasureValue2')</th>
                                    @endif
                                    @if(getM2()!="" && getSubMeasure()!="true")
                                    <th>@lang('layout.Unit') 2</th>
                                    @endif
                                    @if(getM3()!="" && getSubMeasure()!="true")
                                    <th>@lang('layout.Unit') 3</th>
                                    @endif
                                    @if(getM4()!="")
                                    <th>@lang('layout.Unit') 4</th>
                                    @endif
                                    @if(getSubMeasure()=="true")
                                    <th>@lang('layout.SubMeasure')</th>
                                    <th>@lang('layout.MeasureRatio')</th>
                                    <th>@lang('layout.WeightFee')</th>
                                    @endif
                                    @if(itemOnSaleOrder()=="true")
                                    <th>@lang('layout.OnSaleOrder')</th>
                                    @endif
                                    @if(systemConfig()[4] != 0 && systemConfig()[9] == 0 && itemOnSaleOrder()=="true")
                                    <th>@lang('layout.BundlOrder')</th>
                                    @endif
                                    @if(invetoryPercent()=="true")
                                    <th>@lang('layout.Percent')</th>
                                    @endif
                                    <th>@lang('layout.Default_Rate')</th>
                                    <th>@lang('layout.User')</th>
                                    <th>@lang('layout.Actions')</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                    @foreach($inventorySite AS $rec)
                    @if(!$show_site && $rec->id == $inventorySite[0]->id)
                    <div class="tab-pane active" id="tab{{$rec->id}}">
                    @else
                    <div class="tab-pane" id="tab{{$rec->id}}">
                    @endif
                        <div class="page-toolbar">
                            <div class="pull-right">
                                @permission('inventory-export')
                                <input type="hidden" name="type" value="allInventoryReport" />
                                <input type="hidden" name="inventory_site_id" value="{{$rec->id}}" />
                                <button type="button" id="sample_editable_1_new" onClick="inventory_of_site_excell({{$rec->id}})" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')</button>
                                <input type="hidden" name="type" value="allInventoryReport" />
                                <input type="hidden" name="inventory_site_id" value="{{$rec->id}}" />
                                <button type="button" id="{{$rec->id}}" onClick="inventory_of_site({{$rec->id}})" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF')</button>
                                @endpermission
                                @permission('inventory-create')
                                <a href="{{route('inventory.create')}}">
                                    <button class="btn btn-success">
                                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                                    </button>
                                </a>
                                @if(systemConfig()[4] != 0 )
                                <a href="{{route('inventory.m_create')}}">
                                    <button class="btn btn-success">
                                        <i class="fa fa-plus"></i> @lang('layout.AddNewRoll')
                                    </button>
                                </a>
                                @endif
                                @endpermission
                            </div>
                        </div>
                        <table id="my_table_{{$rec->id}}" class="table table-striped table-bordered my-generic-table table-hover" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    @if(searchByCodeLocation()=="true")
                                    <th>@lang('layout.ItemName')</th>
                                    @else
                                    <th>@lang('layout.SerialNum')</th>
                                    @endif
                                    
                                    <th>@lang('layout.SiteName')</th>
                                    @if(searchByCodeLocation()=="true")
                                    <th>@lang('layout.SerialNum')</th>
                                    @else
                                    <th>@lang('layout.ItemName')</th>
                                    @endif
                                    @if(itemCategory()=="true")
                                    <th>@lang('layout.Category')</th>
                                    @endif
                                    @if(itemBrand()=="true")
                                    <th>@lang('layout.Brand')</th>
                                    @endif
                                    @if(getShowMakeCartan()=="true")
                                    <th>@lang('layout.Length')</th>
                                    <th>@lang('layout.Width')</th>
                                    <th>@lang('layout.Height')</th>
                                    @endif
                                    @if(itemPicture()=="true")
                                    <!-- <th>@lang('layout.Photo')</th> -->
                                    @endif
                                    @if(itemType()=="true")
                                    <th>@lang('layout.ItemType')</th>
                                    @endif
                                    <th>@lang('layout.Unit')</th>
                                    <th>@lang('layout.OnHand')</th>
                                    @if(systemConfig()[4] != 0 )
                                    <th>@lang('layout.TotalCode')</th>
                                    @endif
                                    @if(getOtherMeasure()=="true" || systemConfig()[27] == 1)
                                    <th>@lang('layout.OMeasureValue1')</th>
                                    @endif
                                    @if(getOtherMeasure2()=="true")
                                    <th>@lang('layout.OMeasureValue2')</th>
                                    @endif
                                    @if(getM2()!="" && getSubMeasure()!="true")
                                    <th>@lang('layout.Unit') 2</th>
                                    @endif
                                    @if(getM3()!="" && getSubMeasure()!="true")
                                    <th>@lang('layout.Unit') 3</th>
                                    @endif
                                    @if(getM4()!="")
                                    <th>@lang('layout.Unit') 4</th>
                                    @endif
                                    @if(getSubMeasure()=="true")
                                    <th>@lang('layout.SubMeasure')</th>
                                    <th>@lang('layout.MeasureRatio')</th>
                                    <th>@lang('layout.WeightFee')</th>
                                    @endif
                                    @if(itemOnSaleOrder()=="true")
                                    <th>@lang('layout.OnSaleOrder')</th>
                                    @endif
                                    @if(systemConfig()[4] != 0 && systemConfig()[9] == 0 && itemOnSaleOrder()=="true")
                                    <th>@lang('layout.BundlOrder')</th>
                                    @endif
                                    @if(invetoryPercent() == "true")
                                    <th>@lang('layout.Percent')</th>
                                    @endif
                                    <th>@lang('layout.User')</th>
                                    <th>@lang('layout.Actions')</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
<!-- END CONTENT BODY -->
@stop
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')
<script>
    var cust_rep = {!!customeReportNewData('inventory_index')!!};
    Vue.component("v-select", VueSelect.VueSelect);
    var my_site_id = 0;
    let data_table1 = null;
    function getAllRecord(zero_item = null) {
        // console.log(213);
        /**
         *
         * { load all inventory by default }
         */
        var my_site_id = 0;
        data_table1 = $('#tab1_table').DataTable({
            ajax: {
                url: '{{route("inventory.index")}}',
                data: {
                    type: vtr.type,
                    zero_item: zero_item
                }
            },
            pageLength: '{{getPageRows()}}',
            responsive: '{{responsiveDataTable()}}',
            pagingType: '{{paginationType()}}',
            scrollCollapse: false,
            sort: true,
            order: [
                ["{{orderByColumn()=='number'?0:2}}", "{{getRowOrder()}}"]
            ],
            paging: true,
            serverSide: true,
            autoWidth: false,
            destroy: true,
            buttons: [{
                extend: 'excel',
                text: '',
                key: {
                    key: 'x',
                    altkey: true
                }
            }],
            columns: [
                {
                    data: 'id',
                    name: 'items.id',
                    searchable: false
                },
                @if(searchByCodeLocation()=="true")
                {
                    data: 'name',
                    name: 'items.name'
                },
                {
                    data: 'number',
                    name: 'items.number'
                },
                @else
                {
                    data: 'number',
                    name: 'items.number'
                },
                {
                    data: 'name',
                    name: 'items.name'
                },
                @endif
                @if(itemCategory() == "true") {
                    data: 'categoryName',
                    name: 'inventory_categories.name'
                },
                @endif
                @if(itemBrand() == "true") {
                    data: 'brandName',
                    name: 'inventory_brand.name'
                },
                @endif
                @if(getShowMakeCartan()=="true")
                {
                    data: 'length',
                    name: 'inventories.length'
                },
                {
                    data: 'width',
                    name: 'inventories.width'
                },
                {
                    data: 'height',
                    name: 'inventories.height'
                },
                @endif
                @if(itemPicture() == "true") 
                // {
                //     data: 'photo',
                //     name: 'items.photo',
                //     orderable: false,
                //     searchable: false
                // },
                @endif
                @if(itemType() == "true") {
                    data: 'type',
                    name: 'items.type'
                },
                @endif {
                    data: 'measure',
                    name: 'measure',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'inve_amount',
                    name: 'inve_amount',
                    orderable: false,
                    searchable: false
                },
                @if(systemConfig()[4] != 0) {
                    data: 'OnHandCode',
                    name: 'OnHandCode',
                    orderable: false,
                    searchable: false
                },
                @endif
                @if(getOtherMeasure() == "true" || systemConfig()[27] == 1) {
                    data: 'o_measure',
                    name: 'o_measure',
                    orderable: false,
                    searchable: false
                },
                @endif
                @if(getOtherMeasure2() == "true") {
                    data: 'o_measure1',
                    name: 'o_measure1',
                    orderable: false,
                    searchable: false
                },
                @endif
                @if(getM2() != "" && getSubMeasure() != "true") {
                    data: 'Unit2',
                    name: 'Unit2',
                    orderable: false,
                    searchable: false
                },
                @endif
                @if(getM3() != "" && getSubMeasure() != "true") {
                    data: 'Unit3',
                    name: 'Unit3',
                    orderable: false,
                    searchable: false
                },
                @endif
                @if(getM4() != "") {
                    data: 'Unit4',
                    name: 'Unit4',
                    orderable: false,
                    searchable: false
                },
                @endif
                @if(getSubMeasure() == "true") {
                    data: 'Unit2',
                    name: 'Unit2',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'measure_ratio',
                    name: 'measure_ratio',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'sub_measure',
                    name: 'sub_measure',
                    orderable: false,
                    searchable: false
                },
                @endif
                @if(itemOnSaleOrder() == "true") {
                    data: 'onSaleOrder',
                    name: 'onSaleOrder',
                    orderable: false,
                    searchable: false
                },
                @endif
                @if(systemConfig()[4] != 0 && systemConfig()[9] == 0 && itemOnSaleOrder() == "true") {
                    data: 'saleBundlOrder',
                    name: 'saleBundlOrder',
                    orderable: false,
                    searchable: false
                },
                @endif
                @if(invetoryPercent() == "true") {
                    data: 'percent',
                    name: 'percent',
                    orderable: false,
                    searchable: false
                },
                @endif {
                    data: 'rate',
                    name: 'rate',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'user',
                    name: 'users.name',
                },
                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                }
            ]
        });
    }
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        @if($show_site)
            getAllRecord();
        @else
            getRecord({{$inventorySite[0]->id}});
        @endif
    });
    var my_table = 0;
    /**
     * we load approperiat datable according
     * to it's site_id
     */
    $(document).on("click", "#mytabs li", function(event) {
        var myid = event.target.id;
        // console.log('ids', myid);
        vtr.myid = myid;
        if (myid == 'default_and_zero') {
            getAllRecord('yes');
        } else if (myid != 'default') {
            getRecord(myid);
        } else {
            getAllRecord();
        }
    });
    function getRecord(myid) {
        if (my_table != 0) {
            my_table.destroy();
        }
        my_table = $('#my_table_' + myid).DataTable({
            ajax: {
                url: '{{route("inventory.index")}}',
                data: {
                    site_id: myid,
                    inv_category: vm.inv_category,
                    type: vtr.type
                }
            },
            pageLength: '{{getPageRows()}}',
            order: [
                ["{{orderByColumn()=='number'?0:3}}", "{{getRowOrder()}}"]
            ],
            responsive: '{{responsiveDataTable()}}',
            pagingType: '{{paginationType()}}',
            scrollCollapse: false,
            paging: true,
            serverSide: true,
            autoWidth: false,
            destroy: true,
            buttons: [{
                extend: 'excel',
                text: '',
                key: {
                    key: 'x',
                    altkey: true
                }
            }],
            columns: [{
                    data: 'id',
                    name: 'items.id',
                    searchable: false
                },
                @if(searchByCodeLocation()=="true")
                    {
                        data: 'ItemName',
                        name: 'items.name'
                    },
                @else
                    {
                        data: 'number',
                        name: 'items.number'
                    },
                @endif
                
                {
                    data: 'site_name',
                    name: 'site_name',
                    orderable: false,
                    searchable: false
                },
                @if(searchByCodeLocation()=="true")
                    {
                        data: 'number',
                        name: 'items.number'
                    },
                @else
                    {
                        data: 'ItemName',
                        name: 'items.name'
                    },
                @endif
                
                @if(itemCategory() == "true") {
                    data: 'categoryName',
                    name: 'inventory_categories.name'
                },
                @endif
                @if(itemBrand() == "true") {
                    data: 'brandName',
                    name: 'inventory_brand.name'
                },
                @endif
                @if(getShowMakeCartan()=="true")
                {
                    data: 'length',
                    name: 'inventories.length'
                },
                {
                    data: 'width',
                    name: 'inventories.width'
                },
                {
                    data: 'height',
                    name: 'inventories.height'
                },
                @endif
                @if(itemPicture() == "true") 
                // {
                //     data: 'photo',
                //     name: 'items.photo',
                //     orderable: false,
                //     searchable: false
                // },
                @endif
                @if(itemType() == "true") {
                    data: 'type',
                    name: 'items.type'
                },
                @endif {
                    data: 'measure',
                    name: 'measure',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'OnHand',
                    name: 'OnHand',
                    orderable: false,
                    searchable: false
                },
                @if(systemConfig()[4] != 0) {
                    data: 'OnHandCode',
                    name: 'OnHandCode',
                    orderable: false,
                    searchable: false
                },
                @endif
                @if(getOtherMeasure() == "true" || systemConfig()[27] == 1) {
                    data: 'o_measure',
                    name: 'o_measure',
                    orderable: false,
                    searchable: false
                },
                @endif
                @if(getOtherMeasure2() == "true") {
                    data: 'o_measure1',
                    name: 'o_measure1',
                    orderable: false,
                    searchable: false
                },
                @endif
                @if(getM2() != "" && getSubMeasure() != "true") {
                    data: 'Unit2',
                    name: 'Unit2',
                    orderable: false,
                    searchable: false
                },
                @endif
                @if(getM3() != "" && getSubMeasure() != "true") {
                    data: 'Unit3',
                    name: 'Unit3',
                    orderable: false,
                    searchable: false
                },
                @endif
                @if(getM4() != "") {
                    data: 'Unit4',
                    name: 'Unit4',
                    orderable: false,
                    searchable: false
                },
                @endif
                @if(getSubMeasure() == "true") {
                    data: 'Unit2',
                    name: 'Unit2',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'measure_ratio',
                    name: 'measure_ratio',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'sub_measure',
                    name: 'sub_measure',
                    orderable: false,
                    searchable: false
                },
                @endif
                @if(itemOnSaleOrder() == "true") {
                    data: 'onSaleOrder',
                    name: 'onSaleOrder',
                    orderable: false,
                    searchable: false
                },
                @endif
                @if(systemConfig()[4] != 0 && systemConfig()[9] == 0 && itemOnSaleOrder() == "true") {
                    data: 'saleBundlOrder',
                    name: 'saleBundlOrder',
                    orderable: false,
                    searchable: false
                },
                @endif
                @if(invetoryPercent() == "true") {
                    data: 'percent',
                    name: 'percent',
                    orderable: false,
                    searchable: false
                },
                @endif 
                {
                    data: 'user',
                    name: 'user',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                }          
            ]
        });
    }
    // register modal component
    new Vue({
        el: '#company_ll',
        methods: {
            setCompany: function(event) {
                window.location.reload()
            }
        }
    });
    var Modal = Vue.component('modal', {
        template: '#modal-template',
        methods: {
            ok: function() {
                this.$emit('ok')
            }
        }
    });
    contract = {!!$contract!!};
    var vmd = new Vue({
        el: '#appdetail',
        data: {
            period: 'CustomDates',
            from_date: null,
            to_date: null,
            show_modal_detail: false,
            showDiv: [],
            contract: contract,
            selected_contract: null,
            selectedItem: null,
            selectedItem1: null,
            itemlist: [],
            item_id: [],
            selectedMember: null,
            memberlist: [],
            selectedMemberClass: null,
            memberClass: []
        },
        watch: {
            selectedItem: function(newVal, oldVal) {
                let x = [];
                newVal.forEach(function(e) {
                x.push(e.id);
                });

                this.item_id = x;
                // console.log('x value');
                // console.log(x);
            }
        },
        mounted: function() {
            this.showDiv['both_inventory_detail_pdf'] = false;
            this.showDiv['in_inventory_detail_pdf'] = false;
            this.showDiv['out_inventory_detail_pdf'] = false;
            this.showDiv['project_items_in_out'] = false;
            this.showDiv['purchase_item'] = false;
            this.showDiv['inventory_general_report_code'] = false;
        },
        methods: {
            ok: function() {
                this.show_modal_detail = !this.show_modal_detail;
            },
            close: function(e) {
                this.show_modal_detail = !this.show_modal_detail;
            },
            getModalContent(myData) {
                //Your other code that launches the modal
                this.show_modal_detail = true;
                this.$nextTick(function() {
                    $(document).ready(function() {
                        var to, from;
                        to = $("#range-to-example").persianDatepicker(modelDate());
                        from = $("#range-from-example").persianDatepicker(modelDate());

                        document.getElementById('dynamic_content').innerHTML = myData;
                    });
                })
            },
            onItemSearch(search, loading) {
                loading(true);
                this.searchItem(search, loading, this);
            },
            //ajax call to get items
            searchItem(search, loading, vm) {
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'items',
                            keyword: search,
                        }
                    })
                    .then(function(response) {
                        this.itemlist = [];
                        if (response.data.length > 0) {
                            vm.itemlist = response.data;
                            // console.log('data', vm.itemlist);
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            },

            //ajax call to get items
            searchMember(search, loading) {
                var vm = this;
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'member',
                        type: 'Vendor',
                        search: search,
                    }
                })
                    .then(function (response) {
                        this.memberlist = [];
                        if (response.data.length > 0) {
                            vm.memberlist = response.data;
                            // console.log('data', vm.memberlist);
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
            },
            
            //ajax call to get items
            searchMemberClass(search, loading) {
                var vm = this;
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'anyTable',
                        'search_column': 'name',
                        'table_name': 'member_classes',
                        keyword: search,
                    }
                })
                    .then(function (response) {
                        this.memberClass = [];
                        if (response.data.length > 0) {
                            vm.memberClass = response.data;
                            // console.log('data', vm.memberlist);
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
            },

            //ajax call to get dates
            getDates() {
                setTimeout((function () {
                vmd.getDate(vmd.period);
                    // console.log(12);
                }), 2e2);
            },
            getDate(period) {
                if (period) {
                // console.log(3232, period);
                if (period != 'CustomDates') {
                    axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'getDatesByPeriod',
                        period: period,
                    }
                    })
                    .then(function(response) {
                    vmd.from_date = null;
                    vmd.to_date = null;
                    if (response.data) {
                        vmd.from_date = response.data.start;
                        vmd.to_date = response.data.end;
                        // console.log('data', response.data);
                    }
                    })
                    .catch(function(error) {
                    vmd.period = 'CustomDates';
                    vmd.from_date = null;
                    vmd.to_date = null;
                    })
                } else {
                    vmd.from_date = null;
                    vmd.to_date = null;
                }
                }
            },
        },
    })
    function report_by_type_pdf_detail(e) {
        $('#show_modal_detail').click();
        var myid = event.target.id;
        var type_id = myid;
        for (obj in vmd.showDiv) {
            vmd.showDiv[obj] = false;
        }
        vmd.showDiv[type_id] = true;
        ////pdf all detail
        if (type_id == 'both_inventory_detail_pdf') {
            var myhtml = `<input type="hidden" name="type" value="both_inventory_detail_pdf"/>`;
            $('#dd_form').attr('action', "{{route('export.PDFAll')}}");
            vmd.getModalContent(myhtml);
        }
        ////pdf in detail
        if (type_id == 'in_inventory_detail_pdf') {
            var myhtml = `<input type="hidden" name="type" value="in_inventory_detail_pdf"/>`;
            $('#dd_form').attr('action', "{{route('export.PDFAll')}}");
            vmd.getModalContent(myhtml);
        }
        ////pdf out detail
        if (type_id == 'out_inventory_detail_pdf') {
            var myhtml = `<input type="hidden" name="type" value="out_inventory_detail_pdf"/>`;
            $('#dd_form').attr('action', "{{route('export.PDFAll')}}");
            vmd.getModalContent(myhtml);
        }
        ////pdf project in out items
        if (type_id == 'project_items_in_out') {
            var myhtml = `<input type="hidden" name="type" value="project_items_in_out"/>`;
            $('#dd_form').attr('action', "{{route('export.PDFAll')}}");
            vmd.getModalContent(myhtml);
        }
        ////pdf project in out items
        if (type_id == 'purchase_item') {
            var myhtml = `<input type="hidden" name="type" value="purchase_item"/>`;
            $('#dd_form').attr('action', "{{route('export.PDFAll')}}");
            vmd.getModalContent(myhtml);
        }
        ////pdf project in out items
        if (type_id == 'inventory_general_report_code') {
            var myhtml = `<input type="hidden" name="type" value="inventory_general_report_code"/>`;
            $('#dd_form').attr('action', "{{route('export.PDFAll')}}");
            vmd.getModalContent(myhtml);
        }
    }
    new Vue({
        el: '#app3',
        data: {
            showModal: false,
            site_id: my_site_id,
        },
        methods: {
            ok: function() {
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample3: function() {
                //Your other code that launches the modal
                this.showModal = true;
                this.site_id = my_site_id;

                this.$nextTick(function() {
                    $(document).ready(function() {
                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    })
    function inventory_of_site(site_id = 0) {
        my_site_id = site_id;
        $('#show-modal3').click();
        // e.preventDefault();
    }
    new Vue({
        el: '#app4',
        data: {
            showModal: false,
            site_id: my_site_id,
        },
        methods: {
            ok: function() {
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample4: function() {
                //Your other code that launches the modal
                this.showModal = true;
                this.site_id = my_site_id;
                this.$nextTick(function() {
                    $(document).ready(function() {
                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    })
    function inventory_of_site_excell(site_id = 0) {
        my_site_id = site_id;
        $('#show-modal4').click();
        // e.preventDefault();
    }
    // start app
    var inventorySite = {!! json_encode($inventorySite) !!};
    var type = 'pdf';
    var vm = new Vue({
        el: '#app',
        data: {
            showModal: false,
            selectedItem: null,
            inventory_type: null,
            wichType: 'pdf',
            itemlist: [],
            type: type,
            inventorySite: inventorySite,
            istype: 'all',
            item_id: [],
            selectedSite: null,
            inventory_site_id: [],
            inv_category: null,
            all_onhund: null
        },
        watch: {
            selectedItem: function(newVal, oldVal) {
                let x = [];
                newVal.forEach(function(e) {
                    x.push(e.id);
                });
                this.item_id = x;
                // console.log('x value');
                // console.log(x);
            },
            selectedSite: function(newVal, oldVal) {
                let x = [];
                newVal.forEach(function(e) {
                    x.push(e.id);
                });
                this.inventory_site_id = x;
                // console.log('x value');
                // console.log(x);
            }
        },
        methods: {
            onItemSearch(search, loading) {
                loading(true);
                this.searchItem(search, loading, this);
            },
            toggleType(type = null) {
                this.wichType = type;
                if (type == 'excell') {
                    $('#d_form').attr('action', "{{route('export.ExcelAll')}}");
                } else {
                    $('#d_form').attr('action', "{{route('export.PDFAll')}}");
                }
            },
            //ajax call to get items
            searchItem(search, loading, vm) {
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'items',
                            keyword: search,
                        }
                    })
                    .then(function(response) {
                        this.itemlist = [];
                        if (response.data.length > 0) {
                            vm.itemlist = response.data;
                            // console.log('data', vm.itemlist);
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            },
            ok: function() {
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            getModalContent(myData) {
                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {
                        $(".date").persianDatepicker(modelDate());
                        document.getElementById('dynamic_content').innerHTML = myData;
                    });
                })
            }
        },
    })
    function report_by_type_pdf(e) {
        $('#show-modal').click();
        var myid = event.target.id;
        var type_id = myid;
        ////pdf
        if (type_id == 'print_pdf_all') {
            var myhtml = `<input type="hidden" name="type" value="allInventoryReport"/>`;
            $('#d_form').attr('action', "{{route('export.PDFAll')}}");
            vm.getModalContent(myhtml);
        }
        ////excell
        if (type_id == 'inventory_excell_all') {
            $('#d_form').attr('action', "{{route('export.ExcelAll')}}");
            var myhtml = `<input type="hidden" name="type" value="allInventoryReport"/>`;
            vm.getModalContent(myhtml);
        }
    }
    function toggleCollaps(el) {
        var e = $(el);
        var temp = e.parent;
        // temppp.childrin('.child').css({"display":"block"});
    }
    // for new modal

    var vm_main = new Vue({
        el: '#print-modal',
        data: {
            is_show: false,
            pdfRoute: '{!!route('export.PDFAll') !!}',
            excelRoute: '{!! route('export.ExcelAll') !!}',
            customReportData: [
                {
                    Name: '@lang("layout.Category")',
                    column_name: 'category',
                    checkedColumn: (cust_rep.category) ? 'checked' : '',
                    column_percentage:(cust_rep.category___percent)?cust_rep.category___percent:''
                },
                {
                    Name: '@lang("layout.Number")',
                    column_name: 'number',
                    checkedColumn: (cust_rep.number) ? 'checked' : '',
                    column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''
                },
                {
                    Name: '@lang("layout.SerialNum")',
                    column_name: 'serial_num',
                    checkedColumn: (cust_rep.serial_num) ? 'checked' : '',
                    column_percentage:(cust_rep.serial_num___percent)?cust_rep.serial_num___percent:''
                },
                {
                    Name: '@lang("menu.InventoryBrand")',
                    column_name: 'inventoryBrand',
                    checkedColumn: (cust_rep.inventoryBrand) ? 'checked' : '',
                    column_percentage:(cust_rep.inventoryBrand___percent)?cust_rep.inventoryBrand___percent:''
                },
                {
                    Name: '@lang("layout.Description")',
                    column_name: 'description',
                    checkedColumn: (cust_rep.description) ? 'checked' : '',
                    column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''
                },
                {
                    Name: '@lang("layout.Name")',
                    column_name: 'name',
                    checkedColumn: (cust_rep.name) ? 'checked' : '',
                    column_percentage:(cust_rep.name___percent)?cust_rep.name___percent:''
                },
                {
                    Name: '@lang("layout.InitialQuantity")',
                    column_name: 'initial_quantity',
                    checkedColumn: (cust_rep.initial_quantity) ? 'checked' : '',
                    column_percentage:(cust_rep.initial_quantity___percent)?cust_rep.initial_quantity___percent:''
                },          
                {
                    Name: '@lang("layout.QuantityIn")',
                    column_name: 'quantityIn',
                    checkedColumn: (cust_rep.quantityIn) ? 'checked' : '',
                    column_percentage:(cust_rep.quantityIn___percent)?cust_rep.quantityIn___percent:''
                },
                {
                    Name: '@lang("layout.TotalQuantityIn")',
                    column_name: 'qut_in',
                    checkedColumn: (cust_rep.qut_in) ? 'checked' : '',
                    column_percentage:(cust_rep.qut_in___percent)?cust_rep.qut_in___percent:''
                },
                {
                    Name: '@lang("layout.TotalQuantityOut")',
                    column_name: 'qut_out',
                    checkedColumn: (cust_rep.qut_out) ? 'checked' : '',
                    column_percentage:(cust_rep.qut_out___percent)?cust_rep.qut_out___percent:''
                },
                {
                    Name: '@lang("layout.OnSaleOrder")',
                    column_name: 'on_sale_order',
                    checkedColumn: (cust_rep.on_sale_order) ? 'checked' : '',
                    column_percentage:(cust_rep.on_sale_order___percent)?cust_rep.on_sale_order___percent:''
                },
                {
                    Name: '@lang("layout.OnHand")',
                    column_name: 'on_hand',
                    checkedColumn: (cust_rep.on_hand) ? 'checked' : '',
                    column_percentage:(cust_rep.on_hand___percent)?cust_rep.on_hand___percent:''
                },
                {
                    Name: '@lang("layout.Unit")',
                    column_name: 'unit',
                    checkedColumn: (cust_rep.unit) ? 'checked' : '',
                    column_percentage:(cust_rep.unit___percent)?cust_rep.unit___percent:''
                },
                {
                    Name: '@lang("layout.Percent")',
                    column_name: 'percent',
                    checkedColumn: (cust_rep.percent) ? 'checked' : '',
                    column_percentage:(cust_rep.percent___percent)?cust_rep.percent___percent:''
                },
                {
                    Name: '@lang("layout.Rate")',
                    column_name: 'rate',
                    checkedColumn: (cust_rep.rate) ? 'checked' : '',
                    column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''
                },
                {
                    Name: '@lang("layout.AverageCost")',
                    column_name: 'average_cost',
                    checkedColumn: (cust_rep.average_cost) ? 'checked' : '',
                    column_percentage:(cust_rep.average_cost___percent)?cust_rep.average_cost___percent:''
                },
                {
                    Name: '@lang("layout.TotalAssetValue")',
                    column_name: 'total_asset_value',
                    checkedColumn: (cust_rep.total_asset_value) ? 'checked' : '',
                    column_percentage:(cust_rep.total_asset_value___percent)?cust_rep.total_asset_value___percent:''
                },
                {
                    Name: '@lang("layout.Min")',
                    column_name: 'min',
                    checkedColumn: (cust_rep.min) ? 'checked' : '',
                    column_percentage:(cust_rep.min___percent)?cust_rep.min___percent:''
                },
                {
                    Name: '@lang("layout.Max")',
                    column_name: 'max',
                    checkedColumn: (cust_rep.max) ? 'checked' : '',
                    column_percentage:(cust_rep.max___percent)?cust_rep.max___percent:''
                },
                {
                    Name: '@lang("layout.Unit")2',
                    column_name: 'unit2',
                    checkedColumn: (cust_rep.unit2) ? 'checked' : '',
                    column_percentage:(cust_rep.unit2___percent)?cust_rep.unit2___percent:''
                },
                {
                    Name: '@lang("layout.Unit")3',
                    column_name: 'unit3',
                    checkedColumn: (cust_rep.unit3) ? 'checked' : '',
                    column_percentage:(cust_rep.unit3___percent)?cust_rep.unit3___percent:''
                },
                {
                    Name: '@lang("layout.Unit")4',
                    column_name: 'unit4',
                    checkedColumn: (cust_rep.unit4) ? 'checked' : '',
                    column_percentage:(cust_rep.unit4___percent)?cust_rep.unit4___percent:''
                },
                {
                    Name: '@lang("layout.Total")',
                    column_name: 'total',
                    checkedColumn: (cust_rep.total) ? 'checked' : '',
                    column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''
                },
                {
                    Name: '@lang("layout.OMeasureValue1")',
                    column_name: 'o_measure1',
                    checkedColumn: (cust_rep.o_measure1) ? 'checked' : '',
                    column_percentage:(cust_rep.o_measure1___percent)?cust_rep.o_measure1___percent:''
                },
                {
                    Name: '@lang("layout.OMeasureValue2")',
                    column_name: 'o_measure2',
                    checkedColumn: (cust_rep.o_measure2) ? 'checked' : '',
                    column_percentage:(cust_rep.o_measure2___percent)?cust_rep.o_measure2___percent:''
                }
                ,
                {
                    Name: '@lang("layout.Length")',
                    column_name: 'length',
                    checkedColumn: (cust_rep.length) ? 'checked' : '',
                    column_percentage:(cust_rep.length___percent)?cust_rep.length___percent:''
                },
                {
                    Name: '@lang("layout.Width")',
                    column_name: 'width',
                    checkedColumn: (cust_rep.width) ? 'checked' : '',
                    column_percentage:(cust_rep.width___percent)?cust_rep.width___percent:''
                },
                {
                    Name: '@lang("layout.Height")',
                    column_name: 'height',
                    checkedColumn: (cust_rep.height) ? 'checked' : '',
                    column_percentage:(cust_rep.height___percent)?cust_rep.height___percent:''
                },
                {
                    Name: '@lang("layout.PurchaseOrder")',
                    column_name: 'on_purchase_order',
                    checkedColumn: (cust_rep.on_purchase_order) ? 'checked' : '',
                    column_percentage:(cust_rep.on_purchase_order___percent)?cust_rep.on_purchase_order___percent:''
                },
                {
                    Name: '@lang("layout.StartDate")',
                    column_name: 'startDate',
                    checkedColumn: (cust_rep.startDate) ? 'checked' : '',
                    column_percentage:(cust_rep.startDate___percent)?cust_rep.startDate___percent:''
                },
                {
                    Name: '@lang("layout.EndDate")',
                    column_name: 'endDate',
                    checkedColumn: (cust_rep.endDate) ? 'checked' : '',
                    column_percentage:(cust_rep.endDate___percent)?cust_rep.endDate___percent:''
                },
                {
                    Name: '@lang("layout.LoadVehicle")',
                    column_name: 'loadVehicle',
                    checkedColumn: (cust_rep.loadVehicle) ? 'checked' : '',
                    column_percentage:(cust_rep.loadVehicle___percent)?cust_rep.loadVehicle___percent:''
                },
                {
                    Name: '@lang("layout.DischargeVehicle")',
                    column_name: 'dischargeVehicle',
                    checkedColumn: (cust_rep.dischargeVehicle) ? 'checked' : '',
                    column_percentage:(cust_rep.dischargeVehicle___percent)?cust_rep.dischargeVehicle___percent:''
                },
                {
                    Name: '@lang("layout.SaleableQuentity")',
                    column_name: 'saleableQuentity',
                    checkedColumn: (cust_rep.saleableQuentity) ? 'checked' : '',
                    column_percentage:(cust_rep.saleableQuentity___percent)?cust_rep.saleableQuentity___percent:''
                },
                {
                    Name: '@lang("layout.CustomerDeliveryQuentity")',
                    column_name: 'customerDeliveryQuentity',
                    checkedColumn: (cust_rep.customerDeliveryQuentity) ? 'checked' : '',
                    column_percentage:(cust_rep.customerDeliveryQuentity___percent)?cust_rep.customerDeliveryQuentity___percent:''
                },
                {
                    Name: '@lang("layout.TotalTanker")',
                    column_name: 'totalTanker',
                    checkedColumn: (cust_rep.totalTanker) ? 'checked' : '',
                    column_percentage:(cust_rep.totalTanker___percent)?cust_rep.totalTanker___percent:''
                },
                {
                    Name: '@lang("layout.ItemType")',
                    column_name: 'itemType',
                    checkedColumn: (cust_rep.itemType) ? 'checked' : '',
                    column_percentage:(cust_rep.itemType___percent)?cust_rep.itemType___percent:''
                },
                {
                    Name: '@lang("layout.TotalCode")',
                    column_name: 'totalCode',
                    checkedColumn: (cust_rep.totalCode) ? 'checked' : '',
                    column_percentage:(cust_rep.totalCode___percent)?cust_rep.totalCode___percent:''
                },
                {
                    Name: '@lang("layout.User")',
                    column_name: 'user',
                    checkedColumn: (cust_rep.user) ? 'checked' : '',
                    column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''
                },
                {
                    Name: '@lang("layout.Currency")',
                    column_name: 'currency2',
                    checkedColumn: (cust_rep.currency2) ? 'checked' : '',
                    column_percentage:(cust_rep.currency2___percent)?cust_rep.currency2___percent:''
                },
                {
                    Name: '@lang("layout.TotalIn")',
                    column_name: 'totalIn1',
                    checkedColumn: (cust_rep.totalIn1) ? 'checked' : '',
                    column_percentage:(cust_rep.totalIn1___percent)?cust_rep.totalIn1___percent:''
                },
                {
                    Name: '@lang("layout.TotalOut")',
                    column_name: 'TotalOut1',
                    checkedColumn: (cust_rep.TotalOut1) ? 'checked' : '',
                    column_percentage:(cust_rep.TotalOut1___percent)?cust_rep.TotalOut1___percent:''
                },
                {
                    Name: '@lang("layout.OnHand")',
                    column_name: 'OnHand1',
                    checkedColumn: (cust_rep.OnHand1) ? 'checked' : '',
                    column_percentage:(cust_rep.OnHand1___percent)?cust_rep.OnHand1___percent:''
                },
                {
                    Name: '@lang("layout.CustomerStock")',
                    column_name: 'CustomerStock',
                    checkedColumn: (cust_rep.CustomerStock) ? 'checked' : '',
                    column_percentage:(cust_rep.CustomerStock___percent)?cust_rep.CustomerStock___percent:''
                },
                {
                    Name: '@lang("layout.StockNearCustomer")',
                    column_name: 'StockNearCustomer',
                    checkedColumn: (cust_rep.StockNearCustomer) ? 'checked' : '',
                    column_percentage:(cust_rep.StockNearCustomer___percent)?cust_rep.StockNearCustomer___percent:''
                },
            ],
            cust_rep: cust_rep
        },
        methods: {
            closeModal: function() {
                this.is_show = !this.is_show
            },
        }
    });
    new Vue({
        el: '#anchore-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                vm_main.$data.is_show = true;
            }
        }
    });
    var vtr = new Vue({
            el: '#type_part',
            data: {
                type: null,
                myid: null,
            },
            methods: {
                getData() {
                    if (this.type != null && this.type != '') {
                        if (this.myid == null || this.myid == 'default') {
                            // console.log(444, this.type, this.myid);
                            getAllRecord();
                        }else if (this.myid == 'default_and_zero') {
                            // console.log(444, this.type, this.myid);
                            getAllRecord('yes');
                        }else{
                            // console.log(234, this.type, this.myid);
                            getRecord(this.myid);
                        }
                    }
                }
            }
        });
</script>
@endpush