@extends('layouts.factor-master')

@section('content')

<?php 
$report=customeReportNew('inventory_index');
$_category= !in_array('category', $report);
$_number= !in_array('number', $report);
$_inventoryBrand= !in_array('inventoryBrand', $report);
$_description= !in_array('description', $report);
$_name= !in_array('name', $report);
$_initial_quantity= !in_array('initial_quantity', $report);
$_qut_in= !in_array('qut_in', $report);
$_qut_out= !in_array('qut_out', $report);
$_on_hand= !in_array('on_hand', $report);
$_on_sale_order= !in_array('on_sale_order', $report);
$_unit= !in_array('unit', $report);
$_percent= !in_array('percent', $report);
$_rate= !in_array('rate', $report);
$_average_cost= !in_array('average_cost', $report);
$_total_asset_value= !in_array('total_asset_value', $report);
$_min= !in_array('min', $report);
$_max= !in_array('max', $report);
$_total= !in_array('total', $report);
$_unit2= !in_array('unit2', $report);
$_unit3= !in_array('unit3', $report);
$_unit4= !in_array('unit4', $report);
?>

<h4></h4>
<h4 class="table-caption" style="text-align: center;">@lang('layout.ItemsInventoryList')</h4>

<table style="width: 100%; margin-bottom: 10px;">
  <tr>
    @if($site && $site !=[])
    <td>
      <span>@lang('layout.SiteName')</span>:
      <span>{{$site}}</span>
    </td>
    @endif
  </tr>
  <tr>
    @if($from_date)
    <td>
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
    </td>
    @endif
    @if($to_date)
    <td>
      <span>@lang('layout.ToDate')</span>:
      <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
    </td>
    @endif
  </tr>
</table>
<table class="main-table">
  <thead>
    <tr class="bg">
      <td>
        <center class="center"> #</center>
      </td>
      @if($_number)
      <td>
        <center class="center"> @lang('layout.Number') </center>
      </td>
      @endif
      @if($_category)
      <td>
        <center class="center"> @lang('layout.Category') </center>
      </td>
      @endif
      @if($_name)
      <td>
        <center class="center"> @lang('layout.ItemName') </center>
      </td>
      @endif
      @if($_unit)
      <td>
        <center class="center"> @lang('layout.U/M') </center>
      </td>
      @endif
      <td width="50%">
        <center class="center"> @lang('layout.Code') ( @lang('layout.Color') )
          
        </center>
      </td>
      @if(getOtherMeasure()=="true")
      @if($_unit2)
      <td>
        <div class="center"> @lang('layout.OMeasureValue1') </div>
      </td>
      @endif
      @endif
      @if($_on_hand)
      <td>
        <center class="center"> @lang('layout.TotalOnHand') </center>
      </td>
      @endif
      @if($_average_cost)
      <td>
        <center class="center"> @lang('layout.Total') @lang('layout.AverageCost') </center>
      </td>
      @endif
    </tr>
  </thead>
  <?php
  $count = 0;
  $averageCost = 0;
  $codes = [];
  $total_quantity = [];
  $total_OMeasure = 0;
  ?>
  <tbody>
    @foreach($data AS $record)
    <?php
    $codes = $record['codes'];
    ?>
    <tr>
      <td class="center">{{++$count}}</td>
      @if($_number)
      <td class="center">{{$record['number']}}</td>
      @endif
      @if($_category)
      <td class="center">{{$record['category']}}</td>
      @endif
      @if($_name)
      <td class="center">{{$record['name']}}</td>
      @endif
      @if($_unit)
      <td class="center">{{$record['Measure']}}</td>
      @endif

      <td width="50%">
        <table class="main-table" style="width:100%">

        <tr class="bg">
              @if($_inventoryBrand)
              <td class="center" >
                <div class="center"> @lang('layout.Brand') </div>
              </td>
              @endif
              <td class="center" >
                <div class="center"> @lang('layout.Code') </div>
              </td>
              @if(getOtherMeasure()=="true")
              @if($_unit2)
              <td class="center" >
                <div class="center"> @lang('layout.OMeasureValue1') </div>
              </td>
              @endif
              @endif
              @if(getShowWing()!="false")
              <th > <div class="center"> @lang('layout.Wing') </div> </th>
              @endif
              @if($_on_hand)
              <td class="center" >
                <div class="center"> @lang('layout.Quantity') </div>
              </td>
              @endif
              @if($_average_cost)
              <td class="center" >
                <div class="center"> @lang('layout.AverageCost') </div>
              </td>
              @endif
            </tr>

          <?php
          $totalQty = 0;
          $totalCost = 0;
          $other_m_hand = 0;
          $o_measure_name = null;
          ?>
          @foreach($codes AS $row)
          <?php
          $total_OMeasure += $row['other_m_hand'];
          $other_m_hand += $row['other_m_hand'];
          $o_measure_name = $row['o_measure_name'];
          $totalQty += $row['quantity'];
          $totalCost += ($row['quantity'] * $row['costExpense']);
          $averageCost += ($row['quantity'] * $row['costExpense']);

          if (array_key_exists($record['Measure'], $total_quantity)) {
            $total_quantity[$record['Measure']] = $total_quantity[$record['Measure']] + $row['quantity'];
          } else {
            $total_quantity[$record['Measure']] = $row['quantity'];
          }

          ?>
          <tr>
            @if($_inventoryBrand)
            <td width="15%" class="center">{{$row['brand_name']}}</td>
            @endif
            <td width="18%" class="center">{{$row['code']}}</td>
            @if(getOtherMeasure()=="true")
            @if($_unit2)
            <td width="15%" class="center">{{myRound($row['other_m_hand'])}} {{$row['o_measure_name']}}</td>
            @endif
            @endif
            @if(getShowWing()!="false")
            <td width="16%" class="center">{{myRound($row['on_hand_khada'])}}</td>
            @endif
            @if($_on_hand)
            <td width="18%" class="center">{{myRound($row['quantity'])}}</td>
            @endif
            @if($_average_cost)
            <td width="18%" class="center">{{myRound($row['costExpense'])}} {{getHomeCurrency()['symbol']}}</td>
            @endif
          </tr>
          @endforeach
        </table>
      </td>
      @if(getOtherMeasure()=="true")
      @if($_unit2)
      <td class="center">{{myRound($other_m_hand)}} {{$o_measure_name}}</td>
      @endif
      @endif
      @if($_on_hand)
      <td class="center">{{myRound($totalQty)}}</td>
      @endif
      @if($_average_cost)
      <td class="center">{{myRound($totalCost)}} {{getHomeCurrency()[getCurrencyType()]}}</td>
      @endif
    </tr>
    @endforeach
  </tbody>
</table>
<hr />

@if($_total)
<table class="main-table">
  <tr class="bg">
    <td colspan="3"><div class="center">@lang('layout.TotalOnHand')</div></td>
  </tr>
  <tr>
    <td><div class="center"> #</div></td>
    <td><div class="center"> @lang('layout.U/M') </div></td>
    <td><div class="center"> @lang('layout.Quantity') </div></td>
  </tr>
  <?php
  $count=0;
  foreach($total_quantity As $key=>$quantity)
  {
    ?>
    <tr>
      <td><div class="center">{{++$count}}</div></td>
      <td><div class="center">{{$key}}</div></td>
      <td><div class="center">{{round($quantity,2)}}</div></td>

    </tr>
    <?php
  }
  ?>
</table>
@endif

@if($_total_asset_value)
<table class="main-table" style="width:100%">
  <tr class="bg">
    <td width="40%">
      <div class="center"> @lang('layout.OMeasureValue1') </div>
    </td>
    <td width="60%">
      <div class="center"> {{myRound($total_OMeasure)}}</div>
    </td>
  </tr>
  <tr class="bg">
    <td width="40%">
      <div class="center"> @lang('layout.TotalAssetValueInAverageCost') </div>
    </td>
    <td width="60%">
      <div class="center"> {{myRound($averageCost)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
    </td>
  </tr>
</table>
@endif


<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->
@endsection