@extends('layouts.app')
@section('style')
<style>
.v-select input[type=search], .v-select input[type=search]:focus {
    width: 50% !important;
}
.table > tbody > tr > td, .table > tbody > tr > th, .table > tfoot > tr > td, .table > tfoot > tr > th, .table > thead > tr > td, .table > thead > tr > th {
    padding: 8px;
    padding: 4px 2px;
}
.input-has-error {
    outline: 1px solid #ff0000 !important;
    background-color: #ff000014;
}
</style>
@stop
@section('content')
@include('inventories.modal')
<!-- BEGIN CONTENT BODY -->
<!-- END PAGE BAR -->
<div class="row">
    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditItem')</span>
                {{--<span class="caption-helper">@lang('layout.someinfo...')</span>--}}
            </div>
        </div>
        <div class="portlet-body form" id="item-service" v-cloak style="margin-bottom:20%;">
            <!-- BEGIN FORM-->
            {!! Form::model($inventory, ['method' => 'PATCH','route' => ['inventory.update',$inventory->id],'class'=>'form-horizont','id'=>'inventory-edit-form','files'=> true]) !!}
                <div class="form-body col-lg-12">
                    <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
                        <div class="row" style="padding: 0.5% 1%;">
                            <div class="col-lg-12">
                                <div class="row">
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.ItemName')</label>
                                            {{Form::text('name',null,['class' => 'form-control','placeholder' => __('layout.EnterItemName'),'v-validate' =>'"required|min:2"','data-vv-as' => __('layout.Name')])}}
                                            <span class="required">@{{ errors.first('name') }}</span>
                                            {{--<span class="help-block"> This is inline help </span>--}}
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.ItemType')</label>
                                            <select class="form-control" name="type">
                                                <option <?php if($inventory->type == 'inventoryPart'){echo 'selected="selected"';} ?> value="inventoryPart">@lang('layout.InventoryPart')</option>
                                                <option <?php if($inventory->type == 'inventoryAssembly'){echo 'selected="selected"';} ?> value="inventoryAssembly">@lang('layout.InventoryAssembly')</option>
                                                <option <?php if($inventory->type == 'workingProgress'){echo 'selected="selected"';} ?> value="workingProgress">@lang('layout.WorkingProgress')</option>
                                                <option <?php if($inventory->type == 'procurement'){echo 'selected="selected"';} ?> value="procurement">@lang('layout.Procurement')</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.ItemCode'):</label>
                                            {{Form::text('number',null,['class' => 'form-control','min' =>'0' ,'placeholder' => __('layout.ItemCode')])}}
                                        </div>
                                    </div>
                                    <!--div class="col-md-4">
                                        @if(getSerailNumber() =="true")
                                        <div class="form-group">
                                                <label class="control-label"> @lang('layout.SerialNum')</label>
                                                {{Form::text('serial_number',null,['class' => 'form-control','tabindex' =>'1','placeholder' => __('layout.SerialNum')])}}
                                            </div>
                                        @endif	
                                    </div -->
                                    @if(getGauge() =="true")
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.Gauge')</label>
                                                {{Form::text('gauge',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.Gauge')])}}
                                            </div>
                                        </div>
                                    @endif	
                                </div>
                                <div class="row">
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.U_M_Set')</label>
                                        <div class="input-group">
                                            <v-select :disabled="canUpdate=='canNot'" placeholder="@lang('layout.SelectUnitMeasure') " label="name"  :options="measureList" v-model="measureSelected" ></v-select>
                                            <input type="hidden" name="um_id" v-validate="'required'" data-vv-as="@lang('layout.U_M_Set')" :value="(measureSelected)?measureSelected.id:null">
                                            <span class="required">@{{ errors.first('um_id') }}</span>
                                            {{--{{Form::select('income_account',$income,null,['class' => 'form-control'])}}--}}
                                            <span class="btn btn-success  input-group-addon" @click="showModal = true, acount_type = 'income'" style="background-color:  rgb(80, 129, 141)"> <i class="fa fa-plus" style="color: white"></i>
                                            </span>
                                        </div>
                                        <div id="measure">
                                            <modal v-if="showModal" @close="showModal = false">
                                                <div slot="body">
                                                    <div class="row">
                                                        <div class="col-md-3">
                                                            <h4>@lang('layout.MetricType')</h4>
                                                            <span v-for="metric in metricList">
                                                                <div class="mt-radio-list">
                                                                    <label class="mt-radio"> @{{ metric.name }}
                                                                        <input name="metric" type="radio" v-bind:value="metric" v-model="selectedMetric" v-on:change="selectedMeasure = {}">
                                                                        <span></span>
                                                                    </label>
                                                                </div>
                                                            </span>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <h4>@lang('layout.Measure') </h4>
                                                            <span v-for="measure1 in selectedMetric.measure">
                                                                <div class="mt-radio-list">
                                                                    <span v-if="measure1.text=='Other'">@lang('layout.OtherMeasure') </span>
                                                                    <span v-if="measure1.text !='Other'">@{{ measure1.text }} </span>
                                                                    <label class="mt-radio">
                                                                        <input name="measureds" type="radio" v-bind:value="measure1"  v-model="selectedMeasure">
                                                                        <span></span>
                                                                    </label>
                                                                </div>
                                                            </span>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <span v-if="selectedMeasure.text == 'Other'">
                                                                <h4 class="text-center">@lang('layout.OtherMeasure') </h4>
                                                                <div>
                                                                    <div class="form-group">
                                                                        <label class="control-label col-md-5">
                                                                        @lang('layout.MeasureName')</label>
                                                                        <div class="col-md-7">
                                                                            <input type="text" class="form-control" placeholder="@lang('layout.EnterMeasureName')" v-model.trim="selectedMeasure.name">
                                                                            <span class="help-block"></span>
                                                                        </div>
                                                                    </div>
                                                                    <div class="form-group">
                                                                        <label class="control-label col-md-5">
                                                                            @lang('layout.MeasureName')
                                                                        </label>
                                                                        <div class="col-md-7">
                                                                            <input type="number" class="form-control" placeholder="@lang('layout.EnterMeasureuint')" v-model.number="selectedMeasure.unit">
                                                                            <span class="help-block">  </span>
                                                                        </div>
                                                                    </div>
                                                                    <div class="form-group ">
                                                                        <label class="control-label col-md-5">
                                                                            @lang('layout.MeasureSymbol')
                                                                        </label>
                                                                        <div class="col-md-7">
                                                                            <input type="text" class="form-control" placeholder="@lang('layout.EnterMeasureSymbol')" v-model.trim="selectedMeasure.symbol">
                                                                            <span class="help-block">  </span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <h3 slot="header">
                                                    <div class="col-md-4">
                                                        <h3>
                                                            @lang('layout.AddNewMeasure')
                                                        </h3>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div v-if="fieldErrors.length > 0">
                                                            <p class="text-danger" fieldErrors>
                                                                <spna v-text="fieldErrors"></spna>
                                                            </p>
                                                        </div>
                                                    </div>
                                                </h3>
                                                <div slot="footer">
                                                    <button type=button class="modal-default-button btn-success" v-on:click="addMeasure">
                                                        @lang('layout.OK')
                                                    </button>
                                                    <button type=button class="modal-default-button btn-danger" v-on:click="showModal = false ,measure = null , type=null">
                                                        @lang('layout.Cancel')
                                                    </button>
                                                </div>
                                            </modal>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.CostInInventory')</label>
                                        <div class="form-group">
                                            {{Form::number('cost',$inventory->cost,['class' => 'form-control','v-model'=>'cost',':class'=>'{"input-has-error":!isError}' ,'step' => 'any','min' =>'0'])}}
                                            <!-- <textarea class="form-control" readonly v-if="measureSelected" rows="1" cols="1" style="resize: none; overflow:hidden">
                                                @lang('layout.Per') @{{(measureSelected)?measureSelected.symbol:null}}
                                            </textarea> -->
                                            <input v-if="measureSelected"  type="text" readonly :value="per_item_measure" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.Default_Rate')</label>
                                            {{Form::number('rate',$inventory->rate,['class' => 'form-control','v-model'=>'rate','step' => 'any','min' =>'0','placeholder' => __('layout.Default_Rate')])}}  
                                            <!-- <textarea class="form-control" readonly v-if="measureSelected" rows="1" cols="1" style="resize: none; overflow:hidden">
                                                @lang('layout.Per') @{{(measureSelected)?measureSelected.symbol:null}}
                                            </textarea> -->
                                            <input v-if="measureSelected"  type="text" readonly :value="per_item_measure" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                        <label class="control-label">@lang('layout.Photo')</label>
                                        {!! Form::file('photo', null, array('placeholder' => 'photo','class' => 'form-control')) !!}
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.AssetAccount')</label>
                                            <v-select :disabled="canUpdate=='canNot'" placeholder="@lang('layout.SelectAssetAccount')" label="name"  :options="{{ json_encode($asset) }}" v-model="assetAccount" ></v-select>
                                            <input type="hidden" name="asset_account" :value="(assetAccount)?assetAccount.id:null">
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.IncomeAccount')</label>
                                            <v-select :disabled="canUpdate=='canNot'" placeholder="@lang('layout.SelectIncomeAccount')" label="name"  :options="{{ json_encode($income) }}" v-model="incomeAccount" ></v-select>
                                            <input type="hidden" name="income_account" :value="(incomeAccount)?incomeAccount.id:null">
                                            {{--{{Form::select('income_account',$income,null,['class' => 'form-control'])}}--}}
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.CostAccount')</label>
                                            <v-select :disabled="canUpdate=='canNot'" placeholder="@lang('layout.SelectCostAccount')" label="name"  :options="{{ json_encode($cost) }}" v-model="costAccount" ></v-select>
                                            <input type="hidden" name="cost_account" :value="(costAccount)?costAccount.id:null">
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Location')</label>
                                            {{Form::text('item_location',null,['class' => 'form-control','placeholder' => __('layout.Location')])}}
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Min')</label>
                                            {{Form::number('min',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.Min')])}}
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Max')</label>
                                            {{Form::number('max',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.Max')])}}
                                        </div>
                                    </div>
                                    <!--<div class="col-lg-2">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.OnHand')</label>
                                            <input type="number" disabled class="form-control" v-model='onHand' >
                                            {{--{{Form::number('quantity',null,['class' => 'form-control','v-model'=>'onHand','step' => 'any','min' =>'0'])}}--}}
                                        </div>
                                    </div> -->
                                    <div class="col-lg-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Category'):</label>
                                            <v-select placeholder="@lang('layout.SelectInventoryCategory')" label="name"  :options="{{ json_encode($category) }}" v-model="category" ></v-select>
                                            <input type="hidden" name="category" :value="(category)?category.id:null">
                                            {{--{{Form::select('inventory_category_id',$category,null,['class' => 'form-control','min' =>'0' ,'placeholder' => __('layout.ItemCode')])}}--}}
                                        </div>
                                    </div>
                                    <div class="col-lg-3"> 
                                        <div class="form-group">
                                            <label class="control-label">@lang('menu.InventoryBrand'):</label>
                                            <v-select placeholder="@lang('menu.InventoryBrand')" label="name" tabindex='4'  :options="brand" v-model="selectedBrand" ></v-select>
                                            <input type="hidden" name="inventory_brand_id" :value="(selectedBrand)?selectedBrand.id:null">
                                        </div>
                                    </div> 
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            {{Form::textarea('description',null,['class' => 'form-control','rows' => '1','placeholder' => __('layout.Description')])}}
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    @if(getMarginAndMarkup()=="true")
                                        <div class="col-lg-3">
                                            <label class="control-label">@lang('layout.Margin')</label>
                                            <div class="input-group">
                                                {{Form::number('margin',null,['class' => 'form-control','v-model'=>'margin','step' => 'any','min' =>'0','readonly'=>'readonly'])}}
                                                <span class="input-group-addon">%</span>
                                            </div>
                                        </div>
                                        <div class="col-lg-3">
                                            <label class="control-label">@lang('layout.Markup')</label>
                                            <div class="input-group">
                                                {{Form::number('markup',null,['class' => 'form-control','v-model'=>'markup','step' => 'any','min' =>'0','readonly'=>'readonly'])}}
                                                <span class="input-group-addon">%</span>
                                            </div>
                                        </div>
                                    @endif
                                    @if(getSerialNumberTimes() >= 1 && getSerialNumberTimes() <= 9)
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.ItemCode')1</label>
                                                {{Form::text('number1',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.ItemCode'), 'autocomplete'=>'off'])}}
                                            </div>
                                        </div>
                                    @endif
                                    @if(getSerialNumberTimes() >= 2 && getSerialNumberTimes() <= 9)
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.ItemCode')2</label>
                                                {{Form::text('number2',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.ItemCode'), 'autocomplete'=>'off'])}}
                                            </div>
                                        </div>
                                    @endif
                                    @if(getSerialNumberTimes() >= 3 && getSerialNumberTimes() <= 9)
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.ItemCode')3</label>
                                                {{Form::text('number3',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.ItemCode'), 'autocomplete'=>'off'])}}
                                            </div>
                                        </div>
                                    @endif
                                    @if(getSerialNumberTimes() >= 4 && getSerialNumberTimes() <= 9)
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.ItemCode')4</label>
                                                {{Form::text('number4',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.ItemCode'), 'autocomplete'=>'off'])}}
                                            </div>
                                        </div>
                                    @endif
                                    @if(getSerialNumberTimes() >= 5 && getSerialNumberTimes() <= 9)
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.ItemCode')5</label>
                                                {{Form::text('number5',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.ItemCode'), 'autocomplete'=>'off'])}}
                                            </div>
                                        </div>
                                    @endif
                                    @if(getSerialNumberTimes() >= 6 && getSerialNumberTimes() <= 9)
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.ItemCode')6</label>
                                                {{Form::text('number6',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.ItemCode'), 'autocomplete'=>'off'])}}
                                            </div>
                                        </div>
                                    @endif
                                    @if(getSerialNumberTimes() >= 7 && getSerialNumberTimes() <= 9)
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.ItemCode')7</label>
                                                {{Form::text('number7',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.ItemCode'), 'autocomplete'=>'off'])}}
                                            </div>
                                        </div>
                                    @endif
                                    @if(getSerialNumberTimes() >= 8 && getSerialNumberTimes() <= 9)
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.ItemCode')8</label>
                                                {{Form::text('number8',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.ItemCode'), 'autocomplete'=>'off'])}}
                                            </div>
                                        </div>
                                    @endif
                                    @if(getSerialNumberTimes() >= 9 && getSerialNumberTimes() <= 9)
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.ItemCode')9</label>
                                                {{Form::text('number9',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.ItemCode'), 'autocomplete'=>'off'])}}
                                            </div>
                                        </div>
                                    @endif
                                    @if(getShowMakeCartan()=="true")
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Length')</label>
                                                {{Form::text('length',null,['class' => 'form-control','placeholder' => __('layout.Length')])}}
                                            </div>
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Width')</label>
                                                {{Form::text('width',null,['class' => 'form-control','placeholder' => __('layout.Width')])}}
                                            </div>
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Height')</label>
                                                {{Form::text('height',null,['class' => 'form-control','placeholder' => __('layout.Height')])}}
                                            </div>
                                        </div>
                                    @endif
                                    @if(getM2()!="" && getSubMeasure()!="true")  
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Measure2')</label>
                                                <v-select placeholder="@lang('layout.SelectUnitMeasure2') "  label="name"  :options="measureList" @input="OtherMeasureChange" v-model="measureSelected2" ></v-select>
                                                <input type="hidden" name="um_id2"  :value="(measureSelected2)?measureSelected2.id:null"> 
                                            </div>
                                        </div>   
                                    @endif
                                    @if(getM3()!="" && getSubMeasure()!="true")  
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Measure3')</label>
                                                <v-select placeholder="@lang('layout.SelectUnitMeasure3') "  label="name"  :options="measureList" @input="OtherMeasureChange" v-model="measureSelected3" ></v-select>
                                                <input type="hidden" name="um_id3"  :value="(measureSelected3)?measureSelected3.id:null">      
                                            </div>
                                        </div>
                                    @endif
                                    @if(getM4()!="")
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Measure4')</label>
                                                <v-select placeholder="@lang('layout.SelectUnitMeasure4') "  label="name"  :options="measureList" @input="OtherMeasureChange" v-model="measureSelected4" ></v-select>
                                                <input type="hidden" name="um_id4"  :value="(measureSelected4)?measureSelected4.id:null">    
                                            </div>
                                        </div>
                                    @endif
                                    @if(getOtherMeasure()=="true")
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.OMeasureName') 1</label>  
                                                <input type="text" name="o_measure_name" value="{{$inventory->o_measure_name}}" placeholder="@lang('layout.OMeasureName') " class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.OMeasureValue')</label>
                                                {{Form::number('o_measure_value',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.OMeasureValue')])}}
                                            </div>
                                        </div>
                                    @endif
                                </div>
                                <div class="row">
                                    @if(getOtherMeasure()=="true")
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.OMeasureName') 2</label> 
                                                <input type="text" name="other_um_id" value="{{$inventory->other_um_id}}" placeholder="@lang('layout.OMeasureName') " class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.OMeasureValue')</label>
                                                {{Form::number('um_exchange',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.OMeasureValue')])}}
                                            </div>
                                        </div>
                                    @endif
                                    @if(getSubMeasure()=="true")
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.SubMeasure')</label>
                                                <input type="text" name="subMeasure" value="{{$sub_measure_name}}" class="form-control">
                                            </div>
                                        </div>   
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.MeasureRatio')</label>
                                                <input type="number" name="measure_ratio" value="{{$inventory->measure_ratio}}" class="form-control">        
                                            </div>
                                        </div>
                                        @endif
                                        
                                </div>
                                <div class="row">
                                    @if(getSubMeasure()!="true")
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.WeightFee')</label>
                                                <v-select placeholder="@lang('layout.WeightFee') "  label="name"  :options="measureList" @input="OtherMeasureChange" v-model="measureSelected3" ></v-select>
                                                <input type="hidden" name="um_id3"  :value="(measureSelected3)?measureSelected3.id:null">
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label">@lang('layout.TotalValue')</label>
                                {{Form::number('total',null,['class' => 'form-control','v-model'=>'result','step' => 'any','min' =>'0' ,'disabled'])}}
                            </div>
                    </div> -->
                    {{--<div class="form-group">--}}
                        {{--<label class="control-label col-md-3">tax</label>--}}
                        {{--<div class="col-md-9">--}}
                            {{--{{Form::select('tax',[],null,['class' => 'form-control'])}}--}}
                        {{--</div>--}}
                    {{--</div>--}}
                    <!--/row-->
                    <!--<div style="height: 200px; overflow:scroll;">
                        <span v-for="site in sites ">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <input type="hidden" name="site_id[]" :value="site.id" >
                                    <input type="text" :value="site.name" disabled  class = 'form-control' >
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <input name="quantity[]" type="number" class="form-control" placeholder="@lang('layout.OnHand')" v-model.number="site.qty">
                                </div>
                            </div>
                        </span>
                    </div> -->
                </div>
                <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center">
                    <a v-if="isError" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</a>
                    <a href="{{route('inventory.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    <hr>
                </div>
            {{Form::close()}}
            <!-- END FORM-->
        </div>
    </div>
</div>

@endsection
@push('scripts')


<script>

    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    Vue.component('modal', {
        template: '#vendor-template'
    })

    Vue.component('modal', {
        template: '#modal-template'

    }) 

    Vue.component('v-select', VueSelect.VueSelect)
    let vu = new Vue({
        el: '#item-service',
        data: {
            incomeAccount:null,
            canUpdate:"{{ $canUpdate }}",
            costAccount:null,
            assetAccount:null,
            measureSelected:null,
            measureSelected2:null,
            measureSelected3:null,
            measureSelected4:null,
            subMeasure:null,

            otherMeasureSelected:null,
            measure_all_company:{!! json_encode($measure_all_company) !!},
            allMeasureList:{!! json_encode($measure) !!},
            measureList:{!! json_encode($measure) !!},
            otherMeasureList:{!! json_encode($measure) !!},
            category:null,
			brand:{!! json_encode($brand) !!},
            selectedBrand:null,
            sites:{!! json_encode($site) !!},
            type: 'inventoryPart',
            measures: {!! json_encode($measure) !!},
            cost: "{{$inventory->cost}}",
            selectedUm1:"{{$inventory->um1_id}}",
            selectedUm2:"{{$inventory->um2_id}}",
            selectedUm3:"{{$inventory->um3_id}}",
            othermeasure:'',
            total: 0,
            errorMessage: '',
            showModal: false,
            fieldErrors: [],
            selectedMetric: {},
            senddata: {},
            selectedMeasure: {},
            metricList:{!!json_encode(getMeasures())!!},
            cost: "{{$inventory->cost}}",
            rate: "{{$inventory->rate}}",

        },

        computed: {
            per_item_measure:function(){
                var mesure = (!this.measureSelected)?null:this.measureSelected.symbol;
                var tex = "@lang('layout.Per')";
                return tex+" "+mesure;

                
            },
            margin: function (){
                var rate = parseFloat((this.rate)?this.rate:0);
                var cost = parseFloat((this.cost)?this.cost:0);

                if(this.rate == 0 && this.cost == 0 ){
                    return 100;
                }
                else{
                    var result  = (100*rate)/cost;
                    var markup = result-100;

                    return myRound((markup*cost)/rate);
                    }
            },
            markup: function(){

                var rate = parseFloat((this.rate)?this.rate:0);
                var cost = parseFloat((this.cost)?this.cost:0);

                if(this.rate == 0 && this.cost == 0 ){
                    return 100;
                }
                else{

                    var result  = (100*rate)/cost;
                    return myRound(result-100);
                }
            },
            isError:function()
            {
                @if(getAddItemWithZeroRate() != 'true')
                var isError=false;
                if(this.cost>0)
                {
                    isError= true;
                }
                @else
                var isError=true;
                @endif
                return isError;
            },
            description: function (createElement) {
                this.total = this.cost * this.noHand


            },
            result: function () {
                return this.cost * this.onHand;
            },
            onHand: function () {

                var total = 0
                this.sites.forEach(function (site) {
                    total += (site.qty)?site.qty:0;
                })
                return total;
            }
        },
        methods: {
            onComplete: function () {
                    // document.getElementById("account-form").submit()
//                this.$emit('on-complete')
//                alert('Yay. Done!');
},

     OtherMeasureChange:function () {
                    this.measureList        = this.allMeasureList.slice();
                    this.othermeasureList   = this.allMeasureList.slice();
                 
                    if (this.measureSelected) {
                      var temp=[];
                         for(var i=0;i<this.measureList.length;i++)
                         {
                            if(this.measureList[i].quantity_id !=this.measureSelected.quantity_id)
                            {
                              temp.push(this.measureList[i]);
                            }
                         }
                         this.othermeasureList=temp;
                    
                    }
                    
                },
addMeasure: function () {

    let senddata = _.clone(this.selectedMetric);

    senddata.measure = _.clone(this.selectedMeasure);

    var req = axios.post("{{route('measure.store')}}",senddata)
    .then(function (response) {
        vu.showModal = false;
        vu.fieldErrors = [];
        vu.selectedMetric = {};
        vu.selectedMeasure = {};

        axios.get("{{route('inventory.create')}}").then(function (response) {

            vu.measureList = response.data;
        });


    })
    .catch(function (error) {
        axios.get("{{route('inventory.create')}}").then(function (response) {

            vu.measureList = response.data;
        });

        vu.fieldErrors = error.response.data

    });

},
handleSubmit(e) {
    this.$validator.validate().then(valid => {
        if (valid) {
            // alert(e.target);
            vu.submitInventory(e.target);
        }
    });
},
submitInventory:function(){
    swal({
        title:"@lang('layout.AreYouSure?')",

        buttons: ["@lang('layout.Cancel')","@lang('layout.Submit')"],

        text: "",
        icon: "info",
        dangerMode: true,
    }).then((willDelete) => {
        if (willDelete) {
            document.getElementById("inventory-edit-form").submit()

        } else {

        }
    });
},

setData:function() {
    this.measureSelected      = _.find(this.measure_all_company, (o) => o.id == {{$inventory->um_id}});

    @if(getM2()!="" && $inventory->um1_id!=null)  
    vu.measureSelected2       = _.find(this.measureList,(o) => o.id == {{$inventory->um1_id}});
	@endif

	@if(getM3()!="" && $inventory->um2_id)  
    vu.measureSelected3       = _.find(this.measureList,(o) => o.id == {{$inventory->um2_id}});
	@endif
    
	@if(getM4()!="" && $inventory->um3_id)  
    vu.measureSelected4       = _.find(this.measureList,(o) => o.id == {{$inventory->um3_id}});
	@endif 

    @if(getSubMeasure()=="true" && $inventory->sub_measure)  
    vu.subMeasure       = _.find(this.measureList,(o) => o.id == {{$inventory->sub_measure}});
    @endif
           

    if(this.othermeasure)
    {
        this.otherMeasureSelected   = _.find(this.measureList, (o) => o.id == this.othermeasure);
    }
    console.log('test',this.othermeasure);

    this.incomeAccount          = _.find({!! json_encode($income)  !!}, (o) => o.id == {{$inventory->income}});
    this.costAccount            = _.find({!!  json_encode($cost) !!}, (o) => o.id == {{$inventory->cost_account}});
    this.assetAccount           = _.find({!!  json_encode($asset) !!}, (o) => o.id == {{$inventory->asset}});
    @if($inventory->category)
    this.category               = _.find({!!json_encode($category) !!}, (o) => o.id == {{$inventory->category}});
    @endif
	@if($inventory->inventory_brand_id)
    this.selectedBrand               = _.find({!!json_encode($brand) !!}, (o) => o.id == {{$inventory->inventory_brand_id}});
	@endif

}
}



});

vu.setData();
</script>


@endpush