@extends('layouts.app')
@section('style')

<style>
.v-select input[type=search], .v-select input[type=search]:focus {

    width: 50% !important;
}

.table > tbody > tr > td, .table > tbody > tr > th, .table > tfoot > tr > td, .table > tfoot > tr > th, .table > thead > tr > td, .table > thead > tr > th {
    padding: 8px;
    padding: 4px 2px;
}
.input-has-error {
    outline: 1px solid #ff0000 !important;
    background-color: #ff000014;
}
</style>
@stop
@section('content')
@include('inventories.cmodal')  
@include('inventories.modal')
<!-- BEGIN CONTENT BODY -->

<!-- END PAGE BAR -->
<div class="row">
    @if (count($errors) > 0)
    <div class="m-heading-1 border-red m-bordered errors-action">

        <h4 class="error-title"><strong>Whoops!</strong> There were some problems with your input</h4>
        <ul class="error-body">
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>

    </div>
    @endif
    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.AddNewItem')</span>
                {{--<span class="caption-helper">@lang('layout.someinfo...')</span>--}}
            </div>
        </div>
        <div class="portlet-body form" id="item-service" v-cloak style="margin-bottom:20%;">
            <!-- BEGIN FORM-->
            {{Form::open(['route' => 'inventory.store','method' => 'POST','id' => 'inventory-form'])}}
            <div class="form-body">
                <div class="row">
                    <input type="hidden" name="type" value="inventoryPart">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.ItemName')</label>
                            {{Form::text('name',null,['class' => 'form-control','placeholder' => __('layout.EnterItemName')])}}
                            {{--<span class="help-block"> This is inline help </span>--}}
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">@lang('layout.ItemCode'):</label>
                            {{Form::number('number',null,['class' => 'form-control','min' =>'0' ,'placeholder' => __('layout.ItemCode')])}}
                        </div>
                    </div>

                </div>
                <div class="row">
                    <div class="col-md-6" >
                        <div class="row">
                            <div class="col-md-8">
                               <div class="form-group">
                                   <label class="control-label">@lang('layout.U_M_Set')</label>
                                   <v-select placeholder="@lang('layout.SelectUnitMeasure') " label="name"  :options="measureList" v-model="measureSelected" ></v-select>
                                   <input type="hidden" name="um_id" :value="(measureSelected)?measureSelected.id:null">
                               </div>
                           </div>
                           <div class="col-md-4">
                               <div class="form-group"><!-- <label>@lang('layout.AddNewMeasure') </label> -->
                                   <button class="btn green" type=button id="show-modal"
                                   v-on:click="showModal = true" style="margin-top: 25px;"> @lang('layout.AddMeasure') <i class="fa fa-plus"> </i>
                               </button>
                               <div id="measure">
                                <modal v-if="showModal" @close="showModal = false">
                                    <div slot="body">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <h4>@lang('layout.MetricType')</h4>
                                                <span v-for="metric in metricList">
                                                    <div class="mt-radio-list">
                                                        <label class="mt-radio"> @{{ metric.name }}

                                                            <input name="metric" type="radio" v-bind:value="metric"
                                                            v-model="selectedMetric" v-on:change="selectedMeasure = {}">

                                                            <span></span>
                                                        </label>
                                                    </div>
                                                </span>
                                            </div>
                                            <div class="col-md-3">
                                                <h4>@lang('layout.Measure') </h4>

                                                <span v-for="measure1 in selectedMetric.measure">
                                                    <div class="mt-radio-list">
                                                        <label class="mt-radio"> @{{ measure1.text }}

                                                            <input name="measureds" type="radio" v-bind:value="measure1"
                                                            v-model="selectedMeasure">

                                                            <span></span>
                                                        </label>
                                                    </div>
                                                </span>

                                            </div>
                                            <div class="col-md-6">
                                                <span v-if="selectedMeasure.text == 'Other'">
                                                    <h4 class="text-center">@lang('layout.OtherMeasure') </h4>
                                                    <div>
                                                        <div class="form-group">
                                                            <label class="control-label col-md-5">
                                                            @lang('layout.MeasureName')</label>
                                                            <div class="col-md-7">
                                                                <input type="text" class="form-control"
                                                                placeholder="@lang('layout.EnterMeasureName')"
                                                                v-model.trim="selectedMeasure.name">
                                                                <span class="help-block">  </span>
                                                            </div>
                                                        </div>

                                                        <div class="form-group">
                                                            <label class="control-label col-md-5">
                                                                @lang('layout.MeasureAmount')
                                                            </label>
                                                            <div class="col-md-7">
                                                                <input type="number" class="form-control"
                                                                placeholder="@lang('layout.EnterMeasureuint')"
                                                                v-model.number="selectedMeasure.unit">
                                                                <span class="help-block">  </span>
                                                            </div>
                                                        </div>
                                                        <div class="form-group ">
                                                            <label class="control-label col-md-5">
                                                                @lang('layout.MeasureSymbol')
                                                            </label>
                                                            <div class="col-md-7">
                                                                <input type="text" class="form-control"
                                                                placeholder="@lang('layout.EnterMeasureSymbol')"
                                                                v-model.trim="selectedMeasure.symbol">
                                                                <span class="help-block">  </span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </span>
                                            </div>

                                        </div>

                                    </div>
                                    <h3 slot="header">
                                        <div class="col-md-4">
                                            <h3>
                                                @lang('layout.AddNewMeasure')
                                            </h3>
                                        </div>
                                        <div class="col-md-4">
                                            <div v-if="fieldErrors.length > 0">
                                                <p class="text-danger" fieldErrors>
                                                    <spna v-text="fieldErrors"></spna>
                                                </p>
                                            </div>
                                        </div>
                                    </h3>
                                    <div slot="footer">
                                        <button type=button class="modal-default-button" v-on:click="addMeasure">
                                            @lang('layout.OK')
                                        </button>
                                        <button type=button class="modal-default-button"
                                        v-on:click="showModal = false ,measure = null , type=null">
                                        @lang('layout.Cancel')
                                    </button>
                                </div>
                            </modal>
                        </div>
                    </div>
                </div>
            </div> 
            <div class="row">
                <div class="col-md-8">
                   <div class="form-group">
                       <label class="control-label">@lang('layout.IncomeAccount')</label>
                       <v-select placeholder="@lang('layout.SelectIncomeAccount')" label="name"  :options="{{ json_encode($income) }}" v-model="incomeAccount" ></v-select>
                       <input type="hidden" name="income_account" :value="(incomeAccount)?incomeAccount.id:null">

                       {{--{{Form::select('income_account',$income,null,['class' => 'form-control'])}}--}}
                   </div>
               </div>
               <div class="col-md-4">
                   <div class="form-group">
                    <label class="control-label"> @lang('layout.Default_Rate')</label>
                    {{Form::number('rate',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.Default_Rate')])}}
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-8">
               <div class="form-group">
                   <label class="control-label">@lang('layout.AssetAccount')</label>
                   <v-select placeholder="@lang('layout.SelectAssetAccount')" label="name"  :options="{{ json_encode($asset) }}" v-model="assetAccount" ></v-select>
                   <input type="hidden" name="asset_account" :value="(assetAccount)?assetAccount.id:null">

               </div>
           </div>
           <div class="col-md-4">
               <div class="form-group">
                  <label class="control-label">@lang('layout.Cost')</label>
                  {{Form::number('cost',null,['class' => 'form-control','v-model'=>'cost',':class'=>'{"input-has-error":!isError}','step' => 'any','min' =>'0'])}}
              </div>
          </div>
      </div> 

      <div class="row">
        <div class="col-md-8">
           <div class="form-group">
               <label class="control-label">@lang('layout.CostAccount')</label>
               <v-select placeholder="@lang('layout.SelectCostAccount')" label="name"  :options="{{ json_encode($cost) }}" v-model="costAccount" ></v-select>
               <input type="hidden" name="cost_account" :value="(costAccount)?costAccount.id:null">

           </div>
       </div>
       <div class="col-md-4">
           <div class="form-group">
              <label class="control-label">@lang('layout.TotalValue')</label>
              {{Form::number('total',null,['class' => 'form-control','v-model'=>'result','step' => 'any','min' =>'0' ,'disabled'])}}
          </div>
      </div>
  </div>  
</div>
<div class="col-md-6">
    <div class="row">
        <div class="col-md-8"> 
            <label class="control-label">@lang('layout.Category'):</label>
            <v-select placeholder="@lang('layout.SelectInventoryCategory')" label="name"  :options="categories" v-model="category" ></v-select>
            <input type="hidden" name="category" :value="(category)?category.id:null">
            {{--{{Form::select('inventory_category_id',$category,null,['class' => 'form-control','min' =>'0' ,'placeholder' => __('layout.ItemCode')])}}--}}
        </div>
        <div class="col-md-4">
            <div class="form-group">
                <!-- <label>@lang('layout.AddNewMeasure') </label> -->
                                             <!-- <button class="btn green" type=button id="show-cmodal"
                                                 @click="showcModal = true" style="margin-top: 25px;"> @lang('layout.AddMeasure') <i class="fa fa-plus"> </i>
                                             </button> -->

                                             <button class="btn green" type=button id="show-cmodal"
                                             @click="showcModal = true" style="margin-top: 25px;">@lang('layout.AddCategory')<i class="fa fa-plus"> </i>
                                         </button>
                                         <div id="measure">
                                            <modal v-if="showModal" @close="showModal = false">
                                                <div slot="body">
                                                    <div class="row">
                                                        <div class="col-md-3">
                                                            <h4>@lang('layout.MetricType')</h4>
                                                            <span v-for="metric in metricList">
                                                                <div class="mt-radio-list">
                                                                    <label class="mt-radio"> @{{ metric.name }}

                                                                        <input name="metric" type="radio" v-bind:value="metric"
                                                                        v-model="selectedMetric" v-on:change="selectedMeasure = {}">

                                                                        <span></span>
                                                                    </label>
                                                                </div>
                                                            </span>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <h4>@lang('layout.Measure') </h4>

                                                            <span v-for="measure1 in selectedMetric.measure">
                                                                <div class="mt-radio-list">
                                                                    <label class="mt-radio"> @{{ measure1.text }}

                                                                        <input name="measureds" type="radio" v-bind:value="measure1"
                                                                        v-model="selectedMeasure">

                                                                        <span></span>
                                                                    </label>
                                                                </div>
                                                            </span>

                                                        </div>
                                                        <div class="col-md-6">
                                                            <span v-if="selectedMeasure.text == 'Other'">
                                                                <h4 class="text-center">@lang('layout.OtherMeasure') </h4>
                                                                <div>
                                                                    <div class="form-group">
                                                                        <label class="control-label col-md-5">
                                                                        @lang('layout.MeasureName')</label>
                                                                        <div class="col-md-7">
                                                                            <input type="text" class="form-control"
                                                                            placeholder="@lang('layout.EnterMeasureName')"
                                                                            v-model.trim="selectedMeasure.name">
                                                                            <span class="help-block">  </span>
                                                                        </div>
                                                                    </div>

                                                                    <div class="form-group">
                                                                        <label class="control-label col-md-5">
                                                                            @lang('layout.MeasureAmount')
                                                                        </label>
                                                                        <div class="col-md-7">
                                                                            <input type="number" class="form-control"
                                                                            placeholder="@lang('layout.EnterMeasureuint')"
                                                                            v-model.number="selectedMeasure.unit">
                                                                            <span class="help-block">  </span>
                                                                        </div>
                                                                    </div>
                                                                    <div class="form-group ">
                                                                        <label class="control-label col-md-5">
                                                                            @lang('layout.MeasureSymbol')
                                                                        </label>
                                                                        <div class="col-md-7">
                                                                            <input type="text" class="form-control"
                                                                            placeholder="@lang('layout.EnterMeasureSymbol')"
                                                                            v-model.trim="selectedMeasure.symbol">
                                                                            <span class="help-block">  </span>
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                            </span>
                                                        </div>

                                                    </div>

                                                </div>
                                                <h3 slot="header">
                                                    <div class="col-md-4">
                                                        <h3>
                                                            @lang('layout.AddNewMeasure')
                                                        </h3>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div v-if="fieldErrors.length > 0">
                                                            <p class="text-danger" fieldErrors>
                                                                <spna v-text="fieldErrors"></spna>
                                                            </p>
                                                        </div>
                                                    </div>
                                                </h3>
                                                <div slot="footer">
                                                    <button type=button class="modal-default-button btn btn-success" v-on:click="addMeasure">
                                                        @lang('layout.OK')
                                                    </button>
                                                    <button type=button class="modal-default-button btn btn-danger"
                                                    v-on:click="showModal = false ,measure = null , type=null">
                                                    @lang('layout.Cancel')
                                                </button>
                                            </div>
                                        </modal>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="row">
                              <div class="col-md-8">
                               <div class="form-group">
                                   <label class="control-label">@lang('layout.OMeasureName')</label>
                                   {{Form::text('o_measure_name',null,['class' => 'form-control','placeholder' => __('layout.OMeasureName')])}}
                               </div>
                           </div>
                           <div class="col-md-4">
                               <div class="form-group">
                                  <label class="control-label">@lang('layout.OMeasureValue')</label>
                                  {{Form::number('o_measure_value',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.OMeasureValue')])}}

                              </div>
                          </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label">@lang('layout.Description')</label>
                            {{Form::textarea('description',null,['class' => 'form-control','rows' => '3','placeholder' => __('layout.Description')])}}
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                               <div class="form-group">
                                   <label class="control-label">@lang('layout.Min')</label>
                                   {{Form::number('min',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.Min')])}}
                               </div>
                           </div>
                           <div class="col-md-4">
                               <div class="form-group">
                                  <label class="control-label">@lang('layout.Max')</label>
                                  {{Form::number('max',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.Max')])}}

                              </div>
                          </div>
                          <div class="col-md-4">
                           <div class="form-group">
                              <label class="control-label">@lang('layout.OnHand')</label>
                              <input type="number" disabled class="form-control" v-model='onHand' >
                              {{--{{Form::number('quantity',null,['class' => 'form-control','v-model'=>'onHand','step' => 'any','min' =>'0'])}}--}}
                          </div>
                      </div>
                  </div>  
                  {{--<div class="form-group">--}}
                    {{--<label class="control-label col-md-3">tax</label>--}}
                    {{--<div class="col-md-9">--}}
                        {{--{{Form::select('tax',[],null,['class' => 'form-control'])}}--}}
                    {{--</div>--}}
                {{--</div>--}}
            </div>
            <!--/span-->
        </div>
        <!--/row-->
        <div style="height: 200px; overflow:scroll;">

            <span v-for="site in sites ">
                <div class="col-md-6">
                    <div class="form-group">
                        <input type="hidden" name="site_id[]" :value="site.id" >
                        <input type="text" :value="site.name" disabled  class = 'form-control' >
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <input name="quantity[]" type="number" class="form-control" placeholder="@lang('layout.OnHand')" v-model.number="site.qty">
                    </div>
                </div>
            </span>

        </div>
    </div>

    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
        <a v-if="isError" @click="submitInventory" class="btn green">@lang('layout.Submit')</a>
        <a href="{{route('inventory.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
    </div>
    {{Form::close()}}
    {!! Form::open(array('method'=>'POST','class'=>'form-horizontal')) !!}
    {{ csrf_field() }}                                        
    <cmodal :show="showcModal" @close="showcModal = false">
        <h3 slot='cheader'>@lang('layout.AddNewCategory')</h3>
        <div slot="cbody">
            <label class="cform-label" for="name">@lang('layout.CategoryName'):</label>
            {{Form::text('name',null,['class' => 'cform-control','placeholder' => __('layout.CategoryName'),'v-model'=>'nameCat'])}}

            <label class="cform-label" for="parent">@lang('layout.ParentID'):</label>
            {{Form::select('parent',$parent,Null,['class' => 'cform-control','placeholder' => __('layout.SelectParent'),'v-model'=>'parentCat'])}}

            <label class="cform-label" for="description">@lang('layout.Description'):</label>
            {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'cform-control','rows' => 6, 'cols' => 30,'v-model'=>'descriptionCat')) !!}

        </div>
        <div slot="cfooter">
            <button type="button" class="modal-default-button btn btn-success" @click="savePost">
                @lang('layout.Submit')
            </button>
        </div>
    </cmodal>
    <!-- <button id="show-modal" @click="showcModal = true">New Post</button> -->


    {!! Form::close() !!}
    <!-- END FORM-->
</div>
</div>
</div>

@endsection
@push('scripts')


<script>

    Vue.component('modal', {
        template: '#vendor-template'
    })

    Vue.component('modal', {
        template: '#modal-template'
    })
    Vue.component('cmodal', {
      template: '#cmodal-template',
      props: ['show']
  });
    Vue.component('v-select', VueSelect.VueSelect)
    let vu = new Vue({
        el: '#item-service',
        data: {
            showcModal: false,
            incomeAccount:null,
            costAccount:null,
            assetAccount:null,
            measureSelected:null,
            measureList:{!! json_encode($measure) !!},
            categories:{!! json_encode($category) !!},
            category:null,
            sites:{!! json_encode($site) !!},
            type: 'inventoryPart',
            measures: {!! json_encode($measure) !!},
            cost: 0,
            nameCat: null,
            descriptionCat: null,
            parentCat: null,
            total: 0,
            errorMessage: '',
            showModal: false,
            fieldErrors: [],
            selectedMetric: {},
            senddata: {},
            selectedMeasure: {},
            metricList: {
                Count: {

                    name: "@lang('layout.Count')",
                    unit: "each",
                    symbol: "ea",
                    description: "this is description for count type measure",
                    measure: [
                    {
                        text: "@lang('layout.Each')",
                        name: "Each",
                        unit: 1,
                        symbol: "ea",
                        description: "this is description for each  measure",
                    },
                    {
                        text: "@lang('layout.Pair')",
                        name: "Pair",
                        unit: 2,
                        symbol: "pr",
                        description: "this is description for each  measure",
                    },
                    {
                        text: "@lang('layout.Dozen')",
                        name: "Dozen",
                        unit: 12,
                        symbol: "dz",
                        description: "this is description for each  measure",
                    },
                    {
                        text: "Other",
                        name: "",
                        unit: 0,
                        symbol: "",
                        description: "",
                    },
                    ]
                },
                Length: {
                    name: "@lang('layout.Length')",
                    unit: "Centimetre",
                    symbol: "cm",
                    description: "this is description for Centimetre type measure",
                    measure: [
                    {
                        text: "@lang('layout.Centimetre')",
                        name: "Centimetre",
                        unit: 1,
                        symbol: "cm",
                        description: "this is description for Centimetre  measure",
                    },
                    {
                        text: "@lang('layout.Inch')",
                        name: "Inch",
                        unit: 2.5,
                        symbol: "in",
                        description: "this is description for Inch  measure",
                    },
                    {
                        text: "@lang('layout.Meter')",
                        name: "Meter",
                        unit: 100,
                        symbol: "m",
                        description: "this is description for Meter  measure",
                    },
                    {
                        text: "Other",
                        name: "",
                        unit: 0,
                        symbol: "",
                        description: "",
                    },

                    ]
                },
                Weight: {
                    name: "@lang('layout.Weight')",
                    unit: "Gram",
                    symbol: "g",
                    description: "this is description for Gram type measure",
                    measure: [
                    {
                        text: "@lang('layout.Gram')",
                        name: "Gram",
                        unit: 1,
                        symbol: "g",
                        description: "this is description for Gram  measure",
                    },
                    {
                        text: "@lang('layout.Kilogram')",
                        name: "Kilogram",
                        unit: 1000,
                        symbol: "kg",
                        description: "this is description for Kilogram  measure",
                    },
                    {
                        text: "@lang('layout.Ton')",
                        name: "Ton",
                        unit: 1000000,
                        symbol: "ton",
                        description: "this is description for Ton  measure",
                    },
                    {
                        text: "Other",
                        name: "",
                        unit: 0,
                        symbol: "",
                        description: "",
                    },
                    ]
                },
                Time: {
                    name: "@lang('layout.Time')",
                    unit: "second",
                    symbol: "sec",
                    description: "this is description for sec type measure",
                    measure: [
                    {
                        text: "@lang('layout.second')",
                        name: "second",
                        unit: 1,
                        symbol: "sec",
                        description: "this is description for second  measure",
                    },
                    {
                        text: "@lang('layout.Minute')",
                        name: "Minute",
                        unit: 60,
                        symbol: "min",
                        description: "this is description for Minute  measure",
                    },
                    {
                        text: "@lang('layout.Hour')",
                        name: "Hour",
                        unit: 3600,
                        symbol: "hr",
                        description: "this is description for Hour  measure",
                    },
                    {
                        text: "@lang('layout.Day')",
                        name: "Day",
                        unit: 86400,
                        symbol: "day",
                        description: "this is description for Day  measure",
                    },
                    {
                        text: "Other",
                        name: "",
                        unit: 0,
                        symbol: "",
                        description: "",
                    },
                    ]
                },
                Storage: {
                    name: "@lang('layout.Storage')",
                    unit: "byte",
                    symbol: "B",
                    description: "this is description for sec type measure",
                    measure: [
                    {
                        text: "@lang('layout.kilobyte')",
                        name: "kilobyte",
                        unit: 1000,
                        symbol: "KB",
                        description: "this is description for kilobyte  measure",
                    },
                    {
                        text: "@lang('layout.Megabyte(MB)')",
                        name: "megabyte",
                        unit: Math.pow(1000, 2),
                        symbol: "MB",
                        description: "this is description for Megabyte  measure",
                    },
                    {
                        text: "@lang('layout.Gigabyte(GB)')",
                        name: "gigabyte",
                        unit:  Math.pow(1000, 3),
                        symbol: "hr",
                        description: "this is description for Gigabyte  measure",
                    },
                    {
                        text: "Other",
                        name: "",
                        unit: 0,
                        symbol: "",
                        description: "",
                    },
                    ]
                }

            },



        },

        computed: {
         isError:function()
         {
            var isError=false;
            if(this.cost>0)
            {
                isError= true;
            }
            return isError;
        },
        description: function (createElement) {
            this.total = this.cost * this.noHand


        },
        result: function () {
            return this.cost * this.onHand;
        },
        onHand: function () {

            var total = 0
            this.sites.forEach(function (site) {
                total += (site.qty)?site.qty:0;
            })
            return total;
        }
    },
    methods: {

        onComplete: function () {
                // document.getElementById("account-form").submit()
//                this.$emit('on-complete')
//                alert('Yay. Done!');
},  savePost: function () {

    var test = {name: this.nameCat, description:this.descriptionCat, parent: this.parentCat,add: true};
    var req = axios.post("{{route('inventoryCategory.addCategory')}}",test)
    .then(function (response) {
        vu.showcModal = false;
        vu.fieldErrors = [];
        var data = {id: response.data.id,name: response.data.name};
                        // vu.categories = response.data;
                        axios.get("{{route('inventoryCategory.create')}}").then(function (response) {
                            vu.nameCat        = null,
                            vu.descriptionCat = null,
                            vu.parentCat      = null,
                            vu.categories     = response.data;
                        });
                    });




},
addMeasure: function () {

    let senddata = _.clone(this.selectedMetric);

    senddata.measure = _.clone(this.selectedMeasure);

    var req = axios.post("{{route('measure.store')}}",senddata)
    .then(function (response) {
        vu.showModal = false;
        vu.fieldErrors = [];
        vu.selectedMetric = {};
        vu.selectedMeasure = {};

        axios.get("{{route('inventory.create')}}").then(function (response) {

            vu.measureList = response.data;
        });


    })
    .catch(function (error) {
        axios.get("{{route('inventory.create')}}").then(function (response) {

            vu.measureList = response.data;
        });

        vu.fieldErrors = error.response.data

    });

},
addMeasure: function () {
    let senddata = _.clone(this.selectedMetric);
    senddata.measure = _.clone(this.selectedMeasure);

    var req = axios.post("{{route('measure.store')}}",senddata)
    .then(function (response) {
        vu.showModal = false;
        vu.fieldErrors = [];
        vu.selectedMetric = {};
        vu.selectedMeasure = {};
        axios.get("{{route('inventory.create')}}").then(function (response) {
            vu.measureList = response.data;
        });
    })
    .catch(function (error) {
        axios.get("{{route('inventory.create')}}").then(function (response) {

            vu.measureList = response.data;
        });

        vu.fieldErrors = error.response.data

    });

},
submitInventory:function(){

    swal({
        title:"@lang('layout.AreYouSure?')",
        buttons: ["@lang('layout.Cancel')","@lang('layout.Submit')"],
        text: "",
        icon: "info",
        dangerMode: true,
    }).then((willDelete) => {
        if (willDelete) {
            document.getElementById("inventory-form").submit()

        } else {

        }
    });
}
}
});

</script>


@endpush