@extends('layouts.app')
@section('style')
<style>
.v-select input[type=search], .v-select input[type=search]:focus {
    width: 50% !important;
}
.table > tbody > tr > td, .table > tbody > tr > th, .table > tfoot > tr > td, .table > tfoot > tr > th, .table > thead > tr > td, .table > thead > tr > th {
    padding: 8px;
    padding: 4px 2px;
}
.input-has-error {
    outline: 1px solid #ff0000 !important;
    background-color: #ff000014;
}
.dropdown-toggle .clear{
  display: none;
}
.required{padding-left: 0px !important;}
</style>
@stop
@section('content')
@include('inventories.cmodal')  
@include('inventories.modal') 
<!-- BEGIN CONTENT BODY -->
<!-- END PAGE BAR -->
<div class="row">
    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.AddNewItem')</span>
            </div>
        </div>
        <div class="portlet-body form" id="item-service" v-cloak style="margin-bottom:20%;">
            <!-- BEGIN FORM-->
            {{Form::open(['route' => 'inventory.store','method' => 'POST','id' => 'inventory-form','files'=> true])}}
                <div class="form-body">
                    <div class="row" style="margin-bottom: 20px; padding: 10px;">
                        <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
                            <div class="row" style="padding: 0.5% 1%;">
                                <div class="col-lg-12">
                                    <div class="row">
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.ItemName')</label>
                                                {{Form::text('name',null,['class' => 'form-control','tabindex' =>'1','placeholder' => __('layout.EnterItemName'), 'autocomplete'=>'off','v-validate' =>'"required|min:2"','data-vv-as' => __('layout.Name')])}}
                                                <span class="required">@{{ errors.first('name') }}</span>
                                                {{--<span class="help-block"> This is inline help </span>--}}
                                            </div>
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.ItemType')</label>
                                                <select class="form-control" tabindex='2' name="type">
                                                    <option selected="selected" value="inventoryPart">@lang('layout.InventoryPart')</option>
                                                    <option value="inventoryAssembly">@lang('layout.InventoryAssembly')</option>
                                                    <option value="workingProgress">@lang('layout.WorkingProgress')</option>
                                                    <option value="procurement">@lang('layout.Procurement')</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.ItemCode')</label>
                                                <input type="text" name="number" v-model="number" @input="checkNo()" placeholder = "@lang('layout.ItemCode')" tabindex='3' v-validate='"required|min:1"' data-vv-as="@lang('layout.ItemCode')" class='form-control' />
                                                <span class="required">@{{ errors.first('number') }}</span>
                                                <span v-if="number_Error ==true" class="input-has-error" style="color: red">@{{number_msg}}</span>
                                            </div>
                                        </div>
                                        <!-- div class="col-md-4">
                                            @if(getSerailNumber() =="true")
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.SerialNum')</label>
                                                    {{Form::text('serial_number',null,['class' => 'form-control','tabindex' =>'3','placeholder' => __('layout.SerialNum')])}}
                                                </div>
                                            @endif	
                                        </div -->
                                        <div class="col-lg-3">
                                            @if(getGauge() =="true")
                                            <div class="form-group">
                                                    <label class="control-label"> @lang('layout.Gauge')</label>
                                                    {{Form::text('gauge',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.Gauge')])}}
                                                </div>
                                            @endif	
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-3" >
                                            <label class="control-label">@lang('layout.U_M_Set') <span class="required">@{{ errors.first('um_id') }}</span></label>
                                            <div class="input-group">
                                                <v-select placeholder="@lang('layout.SelectUnitMeasure') " tabindex="4" label="name"  :options="measureList" @input="OtherMeasureChange" v-model="measureSelected" ></v-select>
                                                <input type="hidden" name="um_id" v-validate="'required'" data-vv-as="@lang('layout.U_M_Set')" :value="(measureSelected)?measureSelected.id:null">
                                                {{--{{Form::select('income_account',$income,null,['class' => 'form-control'])}}--}}
                                                <span class="btn btn-success  input-group-addon" @click="showModal = true, acount_type = 'income'" style="background-color:  rgb(84, 199, 211);"> <i class="fa fa-plus" style="color: white"></i>
                                                </span>
                                                
                                            </div>
                                            <div id="measure">
                                                <modal v-if="showModal" @close="showModal = false">
                                                    <div slot="body">
                                                        <div class="row">
                                                            <div class="col-md-3">
                                                                <h4>@lang('layout.MetricType')</h4>
                                                                <span v-for="metric in metricList">
                                                                    <div class="mt-radio-list">
                                                                        <label class="mt-radio"> @{{ metric.name }}
                                                                            <input name="metric" type="radio" v-bind:value="metric"
                                                                            v-model="selectedMetric" v-on:change="selectedMeasure = {}">
                                                                            <span></span>
                                                                        </label>
                                                                    </div>
                                                                </span>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <h4>@lang('layout.Measure') </h4>
                                                                <span v-for="measure1 in selectedMetric.measure">
                                                                    <div class="mt-radio-list">
                                                                        <label class="mt-radio">
                                                                        <span v-if="measure1.text=='Other'">@lang('layout.OtherMeasure') </span>
                                                                        <span v-if="measure1.text !='Other'">@{{ measure1.text }} </span>
                                                                            <input name="measureds" type="radio" v-bind:value="measure1"
                                                                            v-model="selectedMeasure">
                                                                            <span></span>
                                                                        </label>
                                                                    </div>
                                                                </span>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <span v-if="selectedMeasure.text == 'Other'">
                                                                    <h4 class="text-center">@lang('layout.OtherMeasure') </h4>
                                                                    <div>
                                                                        <div class="form-group">
                                                                            <label class="control-label col-md-5">
                                                                            @lang('layout.MeasureName')</label>
                                                                            <div class="col-md-7">
                                                                                <input type="text" class="form-control"
                                                                                placeholder="@lang('layout.EnterMeasureName')"
                                                                                v-model.trim="selectedMeasure.name">
                                                                                <span class="help-block">  </span>
                                                                            </div>
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label class="control-label col-md-5">
                                                                                @lang('layout.MeasureAmount')
                                                                            </label>
                                                                            <div class="col-md-7">
                                                                                <input type="number" class="form-control"
                                                                                placeholder="@lang('layout.EnterMeasureuint')"
                                                                                v-model.number="selectedMeasure.unit">
                                                                                <span class="help-block">  </span>
                                                                            </div>
                                                                        </div>
                                                                        <div class="form-group ">
                                                                            <label class="control-label col-md-5">
                                                                                @lang('layout.MeasureSymbol')
                                                                            </label>
                                                                            <div class="col-md-7">
                                                                                <input type="text" class="form-control"
                                                                                placeholder="@lang('layout.EnterMeasureSymbol')"
                                                                                v-model.trim="selectedMeasure.symbol">
                                                                                <span class="help-block">  </span>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <h3 slot="header">
                                                        <div class="col-md-4">
                                                            <h3>
                                                                @lang('layout.AddNewMeasure')
                                                            </h3>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div v-if="fieldErrors.length > 0">
                                                                <p class="text-danger" fieldErrors>
                                                                    <spna v-text="fieldErrors"></spna>
                                                                </p>
                                                            </div>
                                                        </div>
                                                    </h3>
                                                    <div slot="footer">
                                                        <button type=button class="modal-default-button" v-on:click="addMeasure">
                                                            @lang('layout.OK')
                                                        </button>
                                                        <button type=button class="modal-default-button" v-on:click="showModal = false ,measure = null , type=null">@lang('layout.Cancel') </button>
                                                    </div>
                                                </modal>
                                            </div>
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.CostInInventory')</label>
                                                {{Form::number('cost',null,['class' => 'form-control','v-model'=>'cost','tabindex'=>'5',':class'=>'{"input-has-error":!isError}','step' => 'any','min' =>'0','v-validate' =>'"required|decimal:10"','data-vv-as' => __('layout.CostInInventory')])}}
                                                <input v-if="measureSelected"  type="text" readonly :value="per_item_measure" class="form-control">
                                            </div>
                                            <span class="required">@{{ errors.first('cost') }}</span>
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.Default_Rate')</label>
                                                {{Form::number('rate',null,['class' => 'form-control ','step' => 'any','v-model'=>'rate','tabindex'=>'6','min' =>'0','placeholder' => __('layout.Default_Rate'),'v-validate' =>'"decimal:10"','data-vv-as' => __('layout.Default_Rate')])}}                 
                                                <input v-if="measureSelected"  type="text" readonly :value="per_item_measure" class="form-control">
                                                <span class="required">@{{ errors.first('rate') }}</span>
                                            </div>
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Photo')</label>
                                                {!! Form::file('photo', null, array('placeholder' => 'photo','class' => 'form-control')) !!}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-3">
                                            <label class="control-label">@lang('layout.InventoryAssetAccount')</label>
                                            <div class="input-group">
                                                <v-select placeholder="@lang('layout.SelectAssetAccount')" tabindex = "7" label="name"  :options="{{ json_encode($asset) }}" v-model="assetAccount" ></v-select>
                                                <input type="hidden" name="asset_account" v-validate="'required'" data-vv-as="@lang('layout.AssetAccount')" :value="(assetAccount)?assetAccount.id:null">
                                                <span class="required">@{{ errors.first('asset_account') }}</span>
                                                <span class="btn btn-success input-group-addon " @click="showcModalAccount = true, acount_type = 'otherCurrentAsset'" style="background-color:  rgb(84, 199, 211)"><i class="fa fa-plus" style="color: white"></i></span>
                                            </div>
                                        </div>
                                        <div class="col-lg-3">
                                            <label class="control-label">@lang('layout.IncomeAccount') <span class="required">@{{ errors.first('income_account') }}</span></label>
                                            <div class="input-group">
                                                <v-select placeholder="@lang('layout.SelectIncomeAccount')" tabindex = "8" label="name"  :options="{{ json_encode($income) }}" v-model="incomeAccount" ></v-select>
                                                <input type="hidden" name="income_account" v-validate="'required'" data-vv-as="@lang('layout.IncomeAccount')" :value="(incomeAccount)?incomeAccount.id:null">
                                                
                                                {{--{{Form::select('income_account',$income,null,['class' => 'form-control'])}}--}}
                                                <span class="btn btn-success  input-group-addon" @click="showcModalAccount = true, acount_type = 'income'" style="background-color:  rgb(84, 199, 211)"> <i class="fa fa-plus" style="color: white"></i>
                                                </span>
                                            </div>
                                        </div>
                                        <div class="col-lg-3">
                                            <label class="control-label">@lang('layout.CostCogsInInventory')</label>
                                            <div class="input-group">
                                                <v-select placeholder="@lang('layout.SelectCostAccount')" label="name" tabindex="9" :options="{{ json_encode($cost) }}" v-model="costAccount" ></v-select>
                                                <input type="hidden" name="cost_account" v-validate="'required'" data-vv-as="@lang('layout.CostAccount')" :value="(costAccount)?costAccount.id:null">
                                                <span class="required">@{{ errors.first('cost_account') }}</span>
                                                <span class="btn btn-success input-group-addon " @click="showcModalAccount = true, acount_type = 'costOfGoodSold'" style="background-color:  rgb(84, 199, 211)"><i class="fa fa-plus" style="color: white"></i></span>
                                            </div>
                                        </div>
                                        @if(itemBrand()=="true")
                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Location')</label>
                                                    {{Form::text('item_location',null,['class' => 'form-control','placeholder' => __('layout.Location')])}}               
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Min')</label>
                                                {{Form::number('min',null,['class' => 'form-control','step' => 'any','tabindex' => '10','min' =>'0','placeholder' => __('layout.Min')])}}
                                            </div>
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Max')</label>
                                                {{Form::number('max',null,['class' => 'form-control','step' => 'any','min' =>'0','tabindex' => '11','placeholder' => __('layout.Max')])}}
                                            </div>
                                        </div>
                                        <div class="col-lg-3"> 
                                            <label class="control-label">@lang('layout.Category')</label>
                                            <div class="input-group">
                                                <v-select placeholder="@lang('layout.SelectInventoryCategory')" label="name" tabindex='12'  :options="categories" v-model="category" ></v-select>
                                                <input type="hidden" name="category" :value="(category)?category.id:null">
                                                <span class="btn btn-success input-group-addon " @click="showcModal = true, acount_type = 'otherCurrentAsset'" style="background-color:  rgb(84, 199, 211)"><i class="fa fa-plus" style="color: white"></i></span>
                                            </div>
                                            <div id="measure">
                                                <modal v-if="showModal" @close="showModal = false">
                                                    <div slot="body">
                                                        <div class="row">
                                                            <div class="col-md-3">
                                                                <h4>@lang('layout.MetricType')</h4>
                                                                <span v-for="metric in metricList">
                                                                    <div class="mt-radio-list">
                                                                        <label class="mt-radio"> @{{ metric.name }}
                                                                            <input name="metric" type="radio" v-bind:value="metric"
                                                                            v-model="selectedMetric" v-on:change="selectedMeasure = {}">
                                                                            <span></span>
                                                                        </label>
                                                                    </div>
                                                                </span>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <h4>@lang('layout.Measure') </h4>
                                                                <span v-for="measure1 in selectedMetric.measure">
                                                                    <div class="mt-radio-list">
                                                                        <span v-if="measure1.text=='Other'">@lang('layout.OtherMeasure') </span>
                                                                        <span v-if="measure1.text !='Other'">@{{ measure1.text }} </span>
                                                                        <input name="measureds" type="radio" v-bind:value="measure1" v-model="selectedMeasure">
                                                                        <span></span>
                                                                    </div>
                                                                </span>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <span v-if="selectedMeasure.text == 'Other'">
                                                                    <h4 class="text-center">@lang('layout.OtherMeasure') </h4>
                                                                    <div>
                                                                        <div class="form-group">
                                                                            <label class="control-label col-md-5">
                                                                            @lang('layout.MeasureName')</label>
                                                                            <div class="col-md-7">
                                                                                <input type="text" class="form-control"
                                                                                placeholder="@lang('layout.EnterMeasureName')"
                                                                                v-model.trim="selectedMeasure.name">
                                                                                <span class="help-block">  </span>
                                                                            </div>
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label class="control-label col-md-5">
                                                                                @lang('layout.MeasureAmount')
                                                                            </label>
                                                                            <div class="col-md-7">
                                                                                <input type="number" class="form-control"
                                                                                placeholder="@lang('layout.EnterMeasureuint')"
                                                                                v-model.number="selectedMeasure.unit">
                                                                                <span class="help-block">  </span>
                                                                            </div>
                                                                        </div>
                                                                        <div class="form-group ">
                                                                            <label class="control-label col-md-5">
                                                                                @lang('layout.MeasureSymbol')
                                                                            </label>
                                                                            <div class="col-md-7">
                                                                                <input type="text" class="form-control"
                                                                                placeholder="@lang('layout.EnterMeasureSymbol')"
                                                                                v-model.trim="selectedMeasure.symbol">
                                                                                <span class="help-block">  </span>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <h3 slot="header">
                                                        <div class="col-md-4">
                                                            <h3>
                                                                @lang('layout.AddNewMeasure')
                                                            </h3>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div v-if="fieldErrors.length > 0">
                                                                <p class="text-danger" fieldErrors>
                                                                    <spna v-text="fieldErrors"></spna>
                                                                </p>
                                                            </div>
                                                        </div>
                                                    </h3>
                                                    <div slot="footer">
                                                        <button type=button class="modal-default-button btn btn-success" v-on:click="addMeasure">
                                                            @lang('layout.OK')
                                                        </button>
                                                        <button type=button class="modal-default-button btn btn-danger"
                                                        v-on:click="showModal = false ,measure = null , type=null">
                                                        @lang('layout.Cancel')
                                                        </button>
                                                    </div>
                                                </modal>
                                            </div>
                                        </div>                     
                                        @if(itemBrand()=="true")
                                            <div class="col-lg-3"> 
                                                <div class="form-group">
                                                    <label class="control-label">@lang('menu.InventoryBrand'):</label>
                                                    <v-select placeholder="@lang('menu.InventoryBrand')" label="name" tabindex=''  :options="brand" v-model="selectedBrand" ></v-select>
                                                    <input type="hidden" name="inventory_brand_id" :value="(selectedBrand)?selectedBrand.id:null">
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Description')</label>
                                                {{Form::textarea('description',null,['class' => 'form-control','rows' => '1','placeholder' => __('layout.Description')])}}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        @if(getMarginAndMarkup()=="true")
                                            <div class="col-lg-3">
                                                <label class="control-label">@lang('layout.Margin')</label>
                                                <div class="input-group">
                                                    {{Form::number('margin',null,['class' => 'form-control','v-model'=>'margin','step' => 'any','min' =>'0','readonly'=>'readonly'])}}
                                                    <span class="input-group-addon">%</span>
                                                </div>
                                            </div>
                                            <div class="col-lg-3">
                                                <label class="control-label">@lang('layout.Markup')</label>
                                                <div class="input-group">
                                                    {{Form::number('markup',null,['class' => 'form-control','v-model'=>'markup','step' => 'any','min' =>'0','readonly'=>'readonly'])}}
                                                    <span class="input-group-addon">%</span>
                                                </div>
                                            </div>
                                        @endif
                                        @if(getSerialNumberTimes() >= 1 && getSerialNumberTimes() <= 9)
                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.ItemCode')1</label>
                                                    {{Form::text('number1',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.ItemCode'), 'autocomplete'=>'off'])}}
                                                </div>
                                            </div>
                                        @endif
                                        @if(getSerialNumberTimes() >= 2 && getSerialNumberTimes() <= 9)
                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.ItemCode')2</label>
                                                    {{Form::text('number2',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.ItemCode'), 'autocomplete'=>'off'])}}
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="row">
                                        @if(getSerialNumberTimes() >= 3 && getSerialNumberTimes() <= 9)
                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.ItemCode')3</label>
                                                    {{Form::text('number3',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.ItemCode'), 'autocomplete'=>'off'])}}
                                                </div>
                                            </div>
                                        @endif
                                        @if(getSerialNumberTimes() >= 4 && getSerialNumberTimes() <= 9)
                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.ItemCode')4</label>
                                                    {{Form::text('number4',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.ItemCode'), 'autocomplete'=>'off'])}}
                                                </div>
                                            </div>
                                        @endif
                                        @if(getSerialNumberTimes() >= 5 && getSerialNumberTimes() <= 9)
                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.ItemCode')5</label>
                                                    {{Form::text('number5',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.ItemCode'), 'autocomplete'=>'off'])}}
                                                </div>
                                            </div>
                                        @endif
                                        @if(getSerialNumberTimes() >= 6 && getSerialNumberTimes() <= 9)
                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.ItemCode')6</label>
                                                    {{Form::text('number6',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.ItemCode'), 'autocomplete'=>'off'])}}
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="row">
                                        @if(getSerialNumberTimes() >= 7 && getSerialNumberTimes() <= 9)
                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.ItemCode')7</label>
                                                    {{Form::text('number7',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.ItemCode'), 'autocomplete'=>'off'])}}
                                                </div>
                                            </div>
                                        @endif
                                        @if(getSerialNumberTimes() >= 8 && getSerialNumberTimes() <= 9)
                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.ItemCode')8</label>
                                                    {{Form::text('number8',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.ItemCode'), 'autocomplete'=>'off'])}}
                                                </div>
                                            </div>
                                        @endif
                                        @if(getSerialNumberTimes() >= 9 && getSerialNumberTimes() <= 9)
                                            <div class="col-lg-6">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.ItemCode')9</label>
                                                    {{Form::text('number9',null,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.ItemCode'), 'autocomplete'=>'off'])}}
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="row">
                                        @if(getShowMakeCartan()=="true")
                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Length')</label>
                                                    {{Form::text('length',null,['class' => 'form-control','placeholder' => __('layout.Length')])}}
                                                </div>
                                            </div>
                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Width')</label>
                                                    {{Form::text('width',null,['class' => 'form-control','placeholder' => __('layout.Width')])}}

                                                </div>
                                            </div>
                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Height')</label>
                                                    {{Form::text('height',null,['class' => 'form-control','placeholder' => __('layout.Height')])}}
                                                </div>
                                            </div>
                                        @endif
                                        <!--Begin Item Other Measures-->
                                        @if(getM2()!="" && getSubMeasure()!="true")  
                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Measure2')</label>
                                                    <v-select placeholder="@lang('layout.SelectUnitMeasure2') "  label="name"  :options="measureList" @input="OtherMeasureChange" v-model="measureSelected2" ></v-select>
                                                    <input type="hidden" name="um_id2"  :value="(measureSelected2)?measureSelected2.id:null">   
                                                </div>
                                            </div>   
                                        @endif
                                    </div>
                                    <div class="row">
                                        @if(getM3()!="" && getSubMeasure()!="true")  
                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Measure3')</label>
                                                    <v-select placeholder="@lang('layout.SelectUnitMeasure3') "  label="name"  :options="measureList" @input="OtherMeasureChange" v-model="measureSelected3" ></v-select>
                                                    <input type="hidden" name="um_id3"  :value="(measureSelected3)?measureSelected3.id:null">    
                                                </div>
                                            </div>
                                        @endif
                                        @if(getM4()!="")
                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Measure4')</label>
                                                    <v-select placeholder="@lang('layout.SelectUnitMeasure4') "  label="name"  :options="measureList" @input="OtherMeasureChange" v-model="measureSelected4" ></v-select>
                                                    <input type="hidden" name="um_id4"  :value="(measureSelected4)?measureSelected4.id:null">   
                                                </div>
                                            </div>
                                        @endif
                                        @if(getOtherMeasure()=="true")
                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.OMeasureName') 1</label>  
                                                    <input type="text" name="o_measure_name"  class="form-control">
                                                </div>
                                            </div>
                                            @if (getCalQuantityOfOtherMeasure() != 'simpleMethod')
                                                <div class="col-lg-3">
                                                    <div class="form-group">
                                                        <label class="control-label">@lang('layout.OMeasureValue')</label>
                                                        {{Form::number('o_measure_value',null,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                                                    </div>
                                                </div>
                                            @endif
                                        @endif
                                    </div>
                                    <div class="row">
                                        @if(getOtherMeasure()=="true")
                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.OMeasureName') 2</label>         
                                                    <input type="text" name="other_um_id"  class="form-control">
                                                </div>
                                            </div>
                                            @if (getCalQuantityOfOtherMeasure() != 'simpleMethod')
                                                <div class="col-lg-3">
                                                    <div class="form-group">
                                                        <label class="control-label">@lang('layout.OMeasureValue')</label>
                                                        {{Form::number('um_exchange',null,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                                                    </div>
                                                </div>
                                            @endif
                                        @endif
                                        <!--Begin Item Sub measure And Other Belongs to Rahim Garizi-->
                                        @if(getSubMeasure()=="true")  
                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.SubMeasure')</label>
                                                    <input type="text" name="subMeasure"  class="form-control">
                                                </div>
                                            </div>   
                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.MeasureRatio')</label>
                                                    <input type="number" name="measure_ratio"  class="form-control"> 
                                                </div>
                                            </div>
                                            <div class="col-lg-3">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.WeightFee')</label>
                                                    <v-select placeholder="@lang('layout.WeightFee') "  label="name"  :options="measureList" @input="OtherMeasureChange" v-model="measureSelected3" ></v-select>
                                                    <input type="hidden" name="um_id3"  :value="(measureSelected3)?measureSelected3.id:null">    
                                                </div>
                                            </div>
                                        @endif
                                        <!--End Item Sub measure And Other Belongs to Rahim Garizi-->
                                    </div>
                                    <!--End Item Other Measures--> 
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-0">
                        <div class="row">
                            <div class="row">     
                                <!--<div class="col-md-4">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.OnHand')</label>
                                        <input type="number" disabled class="form-control" v-model='onHand' >

                                        {{--{{Form::number('quantity',null,['class' => 'form-control','v-model'=>'onHand
                                        ','step' => 'any','min' =>'0'])}}--}}
                                    </div>
                                </div> -->
                            </div>  
                            {{--<div class="form-group">--}}
                                {{--<label class="control-label col-md-3">tax</label>--}}
                                {{--<div class="col-md-9">--}}
                                    {{--{{Form::select('tax',[],null,['class' => 'form-control'])}}--}}
                                {{--</div>--}}
                            {{--</div>--}}
                        </div>
                        <!--/span-->
                    </div>
                    <!--/row-->
                    <div style="height: 200px; overflow:scroll;">
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center"> @lang('layout.Site') </th>
                                    <th class="text-center"> @lang('layout.OnHand') </th>
                                    <th class="text-center" v-show="showWhat('expire_date')=='yes'" > @lang('layout.ExpireDate') </th>
                                    @if(systemConfig()[27] == 1)
                                    <th class="text-center"> @lang('layout.Density') </th>
                                    @endif
                                    @if(showLocation()=="true")
                                    <th class="text-center"> @lang('layout.Location') </th>
                                    @endif
                                    <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description1') </th>
                                    <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Model') </th>
                                    <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Color') </th>
                                    @if(getCalQuantityOfOtherMeasure() == 'simpleMethod' || getCalQuantityOfOtherMeasure() == 'avgMethod')
                                    <th v-show="showWhat('other_measure')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue1')</th>
                                    <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue2')</th>
                                    @endif 
                                    @if(getShowCBM()=="true")
                                    <th v-show="showWhat('other_measure')=='yes'" style="min-width: 50px">@lang('layout.CBM')</th>
                                    @endif 

                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="site in sites">
                                    <td class="highlight">
                                        <input type="hidden" name="site_id[]" :value="site.id" >
                                        <input type="text" :value="site.name" disabled  class = 'form-control' >
                                    </td>
                                    <td class="highlight">
                                        <input name="quantity[]" type="number" class="form-control" placeholder="@lang('layout.OnHand')" v-model.number="site.qty">
                                    </td>
                                    <td class="highlight" v-show="showWhat('expire_date')=='yes'">
                                        <input name="expire_date[]" type="text" class="form-control date" placeholder="@lang('layout.ExpireDate')">
                                    </td>
                                    @if(systemConfig()[27] == 1)
                                    <td class="highlight">
                                        <input name="density[]" type="number" class="form-control" placeholder="@lang('layout.Density')">
                                    </td>
                                    @endif
                                    @if(showLocation()=="true")
                                    <td>
                                        <input name="location[]" type="text" class="form-control" placeholder="@lang('layout.Location')">
                                    </td>
                                    @endif
                                    <td v-show="showWhat('sale_description')=='yes'">
                                        <input type="text" placeholder="@lang('layout.Description1')" name="inventory_description[]" class="form-control">
                                    </td>
                                    <td v-show="showWhat('sale_description')=='yes'">
                                        <input type="text" placeholder="@lang('layout.Model')" name="model[]" class="form-control">
                                    </td>
                                    <td v-show="showWhat('sale_description')=='yes'">
                                        <input type="text" placeholder="@lang('layout.Color')" name="color[]" class="form-control">
                                    </td>
                                    @if (getCalQuantityOfOtherMeasure() == 'simpleMethod' || getCalQuantityOfOtherMeasure() == 'avgMethod')
                                    <td v-show="showWhat('other_measure')=='yes'">
                                        <input name="other_measure_amount1[]" type="number" class="form-control" placeholder="@lang('layout.OMeasureValue1')">
                                    </td>
                                    <td v-show="showWhat('other_measure2')=='yes'">
                                        <input name="other_measure_amount2[]" type="number" class="form-control" placeholder="@lang('layout.OMeasureValue2')">
                                    </td>
                                    @endif 

                                    @if(getShowCBM()=="true")
                                    <td>
                                        <input name="cbm[]" type="number" class="form-control" placeholder="@lang('layout.CBM')">
                                    </td>
                                    @endif

                                </tr>
                            </tbody>
                        </table>
                        <br />
                    </div>
                </div>
                <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center">
                    <a v-if="((isError) && (number_Error == false))" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</a>
                    <!--  <a v-if="isError"  class="btn btn-primary" @click="handleSubmit($event)">@lang('layout.SaveAndNew')
                        <input type="hidden" name="SaveAndNew" value="save"/>
                    </a> -->
                    <button type="button" class="btn blue" @click="saveAndNew($event)" v-if="((isError) && (number_Error == false))" >@lang('layout.SaveAndNew')</button>   
                    <a href="{{route('inventory.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    <hr>
                </div>
            {{Form::close()}}
            {!! Form::open(array('method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }}                                        
                <cmodal :show="showcModal" @close="showcModal = false">
                    <h3 slot='cheader'>@lang('layout.AddNewCategory')</h3>
                    <div slot="cbody">
                        <label class="cform-label" for="name">@lang('layout.CategoryName'):</label>
                        {{Form::text('name',null,['class' => 'cform-control','placeholder' => __('layout.CategoryName'),'v-model'=>'nameCat'])}}
                        <label class="cform-label" for="parent">@lang('layout.ParentID'):</label>
                        {{Form::select('parent',$parent,Null,['class' => 'cform-control','placeholder' => __('layout.SelectParent'),'v-model'=>'parentCat'])}}
                        <label class="cform-label" for="description">@lang('layout.Description'):</label>
                        {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'cform-control','rows' => 6, 'cols' => 30,'v-model'=>'descriptionCat')) !!}
                    </div>
                    <div slot="cfooter">
                        <button type="button" class="modal-default-button btn btn-success" @click="savePost">
                            @lang('layout.Submit')
                        </button>
                    </div>
                </cmodal>
                <!-- <button id="show-modal" @click="showcModal = true">New Post</button> -->


            {!! Form::close() !!}    
            {!! Form::open(array('method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }}                                        
                <cmodal :show="showcModalAccount" @close="showcModalAccount = false">
                    <h3 slot='cheader'>@lang('layout.CreateNewAccountStep')</h3>
                    <div slot="cbody">
                        @if(getAccountNumber()=="true")
                            <label class="cform-label" for="name">@lang('layout.AccountNumber'):</label>
                            <input type="number" name="number" class="cform-control"  v-model="numberAcc" placeholder="@lang('layout.AccountNumber')" autocomplete="off">
                            <span class="required">@{{account_errors.number}}</span>
                        @endif  
                        <label class="cform-label" for="name">@lang('layout.AccountName'):</label>
                        {{Form::text('name','null',['class' => 'cform-control','placeholder' => __('layout.AccountName'),'v-model'=>'nameAcc','autocomplete'=>'off'])}}
                        <span class="required">@{{account_errors.name}}</span>
                        {{--<label class="cform-label" for="name">@lang('layout.AccountType'):</label>
                        <select name="type" v-model="typeAcc" class="form-control">
                            <option value="income">@lang('layout.Income')</option>
                            <option value="costOfGoodSold">@lang('layout.CostOfGoodSold')</option>
                            <option value="otherCurrentAsset">@lang('layout.OtherCurrenctAsset')</option>
                        </select>--}}
                        {{--<label class="cform-label" for="parent">@lang('layout.ParentID'):</label>
                        {{Form::select('parent_id',$parent,Null,['class' => 'cform-control','placeholder' => __('layout.SelectParent'),'v-model'=>'parentAcc'])}}--}}
                        <label class="cform-label" for="description">@lang('layout.Description'):</label>
                        {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'cform-control','rows' => 4, 'cols' => 30,'v-model'=>'descriptionAcc')) !!}
                    </div>
                    <div slot="cfooter">
                        <button type="button" class="modal-default-button btn btn-success" @click="saveAccount">
                            @lang('layout.Submit')
                        </button>
                    </div>
                </cmodal>
            {!! Form::close() !!}  
            <!-- END FORM-->
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
@if(App::getLocale())
  Vue.use(VeeValidate, {
      locale: '{{App::getLocale()}}',
  });
  @else
Vue.use(VeeValidate, {
    locale: 'en',
});
@endif
Vue.use(VueInputAutowidth);
    Vue.component('modal', {
        template: '#vendor-template'
    })
    Vue.component('modal', {
        template: '#modal-template'
    })
    Vue.component('cmodal', {
      template: '#cmodal-template',
      props: ['show']
  });
    var income = {!! $income !!};
    var asset = {!! $asset !!};
    var cost_a= {!! $cost !!};
    Vue.component('v-select', VueSelect.VueSelect)
    let vu = new Vue({
        el: '#item-service',
        data: {
        showcModal: false,
        showcModalAccount: false,
            number:"{{$number}}",
            old_number:"{{$number}}",
            number_msg: '',
            number_Error: false,
            incomeAccount:null,
            costAccount:null,
            assetAccount:null,
            measureSelected:null,
            measureSelected2:null,
            measureSelected3:null,
            measureSelected4:null,
            subMeasure:null,
            othermeasureSelected:null,
            allMeasureList:{!! json_encode($measure) !!},
            measureList:{!! json_encode($measure) !!},
            othermeasureList:[],
            categories:{!! json_encode($category) !!},
            category:null,
            brand:{!! json_encode($brand) !!},
            selectedBrand:null,
            sites:{!! json_encode($site) !!},
            type: 'inventoryPart',
            measures: {!! json_encode($measure) !!},
            cost: 0,
            rate: 0,
            nameCat: null,
            descriptionCat: null,
            parentCat: null,
            //Begin Account Modal
            nameAcc: null,
            numberAcc: null,
            typeAcc: null,
            // parentAcc: null,
            descriptionAcc: null,
            acount_type:'',
            account_errors: '',
            account_success: '',
            //End Account Modal
            total: 0,
            errorMessage: '',
            showModal: false,
            fieldErrors: [],
            selectedMetric: {},
            senddata: {},
            selectedMeasure: {},
            metricList:{!!json_encode(getMeasures())!!},
        },
        computed: {
        per_item_measure:function(){
            var mesure = (!this.measureSelected)?null:this.measureSelected.symbol;
            var tex = "@lang('layout.Per')";
            return tex+" "+mesure;
        },
         isError:function()
         {
            @if(getAddItemWithZeroRate() != 'true')
            var isError=false;
            if(this.cost>0)
            {
                isError= true;
            }
            @else
            var isError=true;
            @endif
            return isError;
        },
        description: function (createElement) {
            this.total = this.cost * this.noHand
        },
        result: function () {
            return this.cost * this.onHand;
        },
        onHand: function () {
            var total = 0
            this.sites.forEach(function (site) {
                total += (site.qty)?site.qty:0;
            })
            return total;
        },
        margin: function (){ 
            var rate = parseFloat((this.rate)?this.rate:0);
            var cost = parseFloat((this.cost)?this.cost:0);
            if(this.rate == 0 && this.cost == 0 ){
                return 100;
            }
            else{
                var result  = (100*rate)/cost;
                var markup = result-100;
                return myRound((markup*cost)/rate);
            }
        },
        markup: function(){
            var rate = parseFloat((this.rate)?this.rate:0);
            var cost = parseFloat((this.cost)?this.cost:0);
            if(this.rate == 0 && this.cost == 0 ){
                return 100;
            }
            else{
                var result  = (100*rate)/cost;
                return myRound(result-100);
            }
        }
    },
    mounted:function(){
        this.defaultValue();
    },
    methods: {
      defaultValue()
      {
        if(income.length==1)
        {
          this.incomeAccount=income[0];
        }
        if(asset.length==1)
        {
          this.assetAccount=asset[0];
        }
        if(cost_a.length==1)
        {
          this.costAccount=cost_a[0];
        }
      },
      checkNo() {
            var chack = 'false';
            var number = vu.number;
            if (number != null) {
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            number: vu.number,
                            method_name: 'Search_number',
                            table_name: 'items'
                        },
                    })
                    .then(function(response) {
                        // console.log(response.data.result);
                        if (response.data.result != null) {
                            // console.log(response.data.result);
                            // vu.temp_items=response.data;
                            vu.number_msg = "@lang('layout.DuplicateData')";
                            vu.number_Error = true;
                        } else {
                            vu.number_msg = 'no';
                            vu.number_Error = false;
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    });
            }
        },
		handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
						// alert(e.target);
                        vu.submitInventory(e.target);
                    }
                });
            },
        OtherMeasureChange:function () {
                    this.measureList        = this.allMeasureList.slice();
                    this.othermeasureList   = this.allMeasureList.slice();       
                    if (this.measureSelected) {
                      var temp=[];
                         for(var i=0;i<this.measureList.length;i++)
                         {
                            if(this.measureList[i].quantity_id !=this.measureSelected.quantity_id)
                            {
                              temp.push(this.measureList[i]);
                            }
                         }
                         this.othermeasureList=temp;
                    }
                },
        onComplete: function () {
                // document.getElementById("account-form").submit()
//                this.$emit('on-complete')
//                alert('Yay. Done!');
},  
savePost: function () {
    var test = {name: this.nameCat, description:this.descriptionCat, parent: this.parentCat,add: true};
    var req = axios.post("{{route('inventoryCategory.addCategory')}}",test)
    .then(function (response) {
        if (response) {
            vu.category = response.data.category;
        }
        vu.showcModal = false;
        vu.fieldErrors = [];
        var data = {id: response.data.id,name: response.data.name};
            // vu.categories = response.data; 
            axios.get("{{route('inventoryCategory.create')}}").then(function (response) {
                vu.nameCat        = null,
                vu.descriptionCat = null,
                vu.parentCat      = null,
                vu.categories     = response.data;
            });
        });
},
saveAccount: function () {
    if(this.numberAcc != null)
    {
    var test = {name: this.nameAcc, description:this.descriptionAcc, parent_id: this.parentAcc,type: this.acount_type,number:this.numberAcc,add: true};
    }
    else{
        var test = {name: this.nameAcc, description:this.descriptionAcc, parent_id: this.parentAcc,type: this.acount_type,add: true};
    }
    var req = axios.post("{{route('account.addAccount')}}",test)
    .then(function (response) {
        if (response) {
            if(response.data.account.type == "income"){
                vu.incomeAccount = response.data.account;
            } if(response.data.account.type == "costOfGoodSold"){
                vu.costAccount = response.data.account;
            } if(response.data.account.type == "otherCurrentAsset"){
                vu.assetAccount = response.data.account;
            }
            vu.account_success = response.data.message;
            if(vu.account_success)
            {
            toastr.success(vu.account_success)
            }
                vu.showcModalAccount = false;
                vu.nameAcc           = null,
                vu.numberAcc           = null,
                vu.descriptionAcc    = null,
                // vu.parentAcc      = null,
                vu.typeAcc           = null;
                vu.acount_type       = '';   
        }
        })
        .catch(function (error) {
            vu.account_errors = error.response.data.errors;
    });
},
addMeasure: function () {
    let senddata = _.clone(this.selectedMetric);
    senddata.measure = _.clone(this.selectedMeasure);
    var req = axios.post("{{route('measure.store')}}",senddata)
    .then(function (response) {
        if (response) {
            if (response.data) {
                // var measure_id = response.data.me.id;
                vu.measureSelected = response.data.me;
                // console.log(444, response, measure_id);
            }
        }
        vu.showModal = false;
        vu.fieldErrors = [];
        vu.selectedMetric = {};
        vu.selectedMeasure = {};
        axios.get("{{route('inventory.create')}}").then(function (response) {
            vu.measureList = response.data;
        });
    })
    .catch(function (error) {
        axios.get("{{route('inventory.create')}}").then(function (response) {
            vu.measureList = response.data;
        });
        vu.fieldErrors = error.response.data
    });
},
submitInventory:function(){
    swal({
        title:"@lang('layout.AreYouSure?')",
        buttons: ["@lang('layout.Cancel')","@lang('layout.Submit')"],
        text: "",
        icon: "info",
        dangerMode: true,
    }).then((willDelete) => {
        if (willDelete) {
            document.getElementById("inventory-form").submit()
        } else {
        }
    });
},
  saveAndNew()
      {
           this.$validator.validate()
          .then(valid =>{
              if(valid)
              {              
                var url="{{route('inventory.store')}}";
                form_id='inventory-form';
                var data= $('#'+form_id).serialize();
                toggleBlock(true);
                axios.post(url,data)
                .then(function(response){
                         toggleBlock(0);
                         if(response.data.result==1)
                         {
                            $('#'+form_id).trigger('reset');             
                            toastr.success('',response.data.message); 
                            vu.number=Number(vu.old_number)+1;
                            vu.old_number=Number(vu.old_number)+1;
                            vu.incomeAccount=null;
                            vu.assetAccount=null;
                            vu.costAccount=null;
                            vu.measureSelected=null;
                            vu.othermeasureSelected=null;
                            vu.category=null;
                            vu.defaultValue();
                             axios.get("{{route('inventory.create')}}").then(function (response) {
                                vu.measureList = response.data;
                            });
                         }
                         else
                         {
                            var message="{{__('message.Warning')}}";
                            //$('#error-sound')[0].play();
                            toastr.warning('',message);
                         }
                })
                .catch(function(error){
                  toggleBlock(0);
                    console.log(error);
                    var message="{{__('message.Warning')}}";
                    //$('#error-sound')[0].play();
                    toastr.warning('',message);
                });
              }
          })
      },
}
});
</script>
@endpush