@extends('layouts.factor-master')

@section('content')

<?php
?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.InventoryDetails')</h3>
<table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>
<br>
  <table class="main-table">

    <thead>
      <tr class="bg">
        <td  class="center"  ><div > #</div></td>
        <td  class="center"  ><div > @lang('layout.Type')</div></td>
        <td  class="center"  ><div > @lang('layout.Number')</div></td>
        <td  class="center"  ><div > @lang('layout.Member')</div></td>
        <td  class="center"  ><div > @lang('layout.Date')</div></td>
        <td  class="center"  ><div > @lang('layout.ItemName') </div></td>
        <td  class="center"  ><div > @lang('layout.SiteName')</div></td>
        <td  class="center"  ><div > @lang('layout.Measure') </div></td>
        <td  class="center"  ><div > @lang('layout.QutIn')</div></td>
        @if(getShowPurchaseRate() != "false")
         <td  class="center"  ><div > @lang('layout.Cost')</div></td>
        @endif
        <td  class="center"  ><div > @lang('layout.QutOut')</div></td>
        @if(getShowSaleRate() != "false") 
          <td  class="center"  ><div > @lang('layout.SalePrice')</div></td>
        @endif
        @if(getShowPurchaseRate() != "false")
          <td  class="center"  ><div > @lang('layout.Total')</div></td>
        @endif
        <td  class="center"   width="15%"><div > @lang('layout.Description')</div></td>
      </tr>
    </thead>
   
    <?php
    $count = 0;
    $in=0;
    $out=0;
    $totalPrice=0;

    ?>
    @foreach($data AS $record)
      <?php
        $totalPrice+=$record->Total;
        if($record->cat == 'in')
        {
          $in +=$record->Quantity;
        }
        if($record->cat == 'out')
        {
         $out +=$record->Quantity;
        }
        ?>
   
    <tr>
      <td class="center">{{++$count}}</td>
      <td class="center">{{__('type.'.ucfirst($record->Type))}}</td>
      <td class="center">{{$record->Number}}</td>
      <td class="center">{{$record->member}}</td>
      <td class="center">{{convertDate($record->Date)}}</td>
      <td class="center">{{$record->Name}}</td>
      <td class="center">{{$record->SiteName}}</td>
      <td class="center">{{$record->Measure}}</td>

      <td class="center">
        @if($record->cat=='in')
        {{$record->Quantity}}
        @endif
      </td>
      @if(getShowPurchaseRate() != "false") 
        <td class="center">{{myRound($record->Cost)}}</td>
      @endif
      <td class="center">
        @if($record->cat=='out')
        {{$record->Quantity}}
        @endif
      </td>
      @if(getShowSaleRate() != "false") 
        <td class="center">{{myRound($record->sales_price)}}</td>
      @endif
      @if(getShowPurchaseRate() != "false")
        <td class="center">{{myRound($record->Total)}}</td>
      @endif
      <td class="center">{{$record->Description}}</td>
    </tr>
    @endforeach
</table>


  
@if(getShowPurchaseRate() != "false")
<span>@lang('layout.TotalPrice')</span>:
<span>{{$totalPrice}} {{getHomeCurrency()[getCurrencyType()]}}</span>
@endif

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection