@extends('layouts.factor-master')

@section('content')

<?php
$report=customeReport('inventory');
$_description=in_array('description', $report);
$_name=in_array('name', $report);
$_initial_quantity=in_array('initial_quantity', $report);
$_qut_in=in_array('qut_in', $report);
$_qut_out=in_array('qut_out', $report);
$_on_hand=in_array('on_hand', $report);
$_on_sale_order=in_array('on_sale_order', $report);
$_unit=in_array('unit', $report);
$_percent=in_array('percent', $report);
$_rate=in_array('rate', $report);
$_average_cost=in_array('average_cost', $report);
$_total_asset_value=in_array('total_asset_value', $report);
$_min=in_array('min', $report);
$_max=in_array('max', $report);
?>


 <h3 class="table-caption" style="text-align: center;">@lang('layout.ItemsInventoryList')</h3>
 <table  class="main-table">
  <tr>
   @if($info && $info !=[])
   <td colspan="2">
    <span>@lang('layout.SiteName')</span>:
    <span>{{$info->name}}</span>
  </td>
  @endif
</tr>
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>

<br>
<table class="main-table">
  <thead>
    <tr class="bg">
    <td><div class="center"> #</div></td>
    
    @if($_name)<td><div class="center"> @lang('layout.Name') </div></td>@endif
    @if(itemType()=="true")<td><div class="center"> @lang('layout.ItemType') </div></td>@endif
    @if($_qut_in)<td><div class="center"> @lang('layout.TotalQuantityIn')</div></td>@endif
    @if($_qut_out)<td><div class="center"> @lang('layout.TotalQuantityOut')</div></td>@endif

    <td><div class="center">@lang('layout.OnHand') @lang('layout.ToDay') </div></td>
    @if($_on_hand)<td><div class="center"> @lang('layout.OnHand')</div></td>@endif
    @if($_unit)<td><div class="center"> @lang('layout.Measure')</div></td>@endif



  </tr>
  </thead>
  <?php
  $count = 0;
  $qut_in=0;
  $qut_out=0;
  $total_qut=[];
  $total_qut_out=[];
  ?>
  @foreach($dataInDate AS $record)
  <?php
  $qut_in+=$record['quantityIn'];
  $qut_out+=$record['quantityOut'];

  if(array_key_exists($record['um'], $total_qut))
  {
    $total_qut[$record['um']]['in']=$total_qut[$record['um']]['in']+$record['quantityIn'];
    $total_qut[$record['um']]['out']=$total_qut[$record['um']]['out']+$record['quantityOut'];
  }
  else
  {
    $total_qut[$record['um']]['in']=$record['quantityIn'];
    $total_qut[$record['um']]['out']=$record['quantityOut'];
  }

  if(array_key_exists($record['um'], $total_qut_out))
  {
    $total_qut_out[$record['um']]=$total_qut_out[$record['um']]+$record['quantityOut'];
  }
  else
  {
    $total_qut_out[$record['um']]=$record['quantityOut'];
  }

  ?>
  <tr> 
    <td class="center">{{++$count}}</td>
    @if($_name) <td class="center">{{$record['name']}}</td> @endif
    @if(itemType()=="true")<td class="center">{{__('layout.'.ucfirst($record['type']))}}</td>@endif
    @if($_qut_in)<td class="center">{{myRound($record['quantityIn'])}}</td>@endif
    @if($_qut_out) <td class="center">{{myRound($record['quantityOut'])}}</td>@endif
    <td class="center">{{myRound($record['quantity'])}}</td>
    @if($_on_hand) <td class="center">{{myRound($record['onhandall'])}}</td>@endif
    @if($_unit)<td class="center">{{$record['um']}}</td> @endif
  </tr>
  @endforeach
</table>

<table class="main-table">
  <tr class="bg">
    <td colspan="5"><center>@lang('layout.Quantity')</center></td>
  </tr>
  <tr>
    <td><div class="center"> #</div></td>
    <td><div class="center"> @lang('layout.Measure') </div></td>
    <td><div class="center"> @lang('layout.TotalIn') </div></td>
    <td><div class="center"> @lang('layout.TotalOut') </div></td>
    <td><div class="center"> @lang('layout.TotalOnHand') </div></td>
  </tr>
  <?php
  $count=0;
  foreach($total_qut As $key=>$quantity)
  {
    ?>
    <tr>
      <td><div class="center">{{++$count}}</div></td>
      <td><div class="center">{{$key}}</div></td>
      <td><div class="center">{{myRound($quantity['in'])}}</div></td>
      <td><div class="center">{{myRound($quantity['out'])}}</div></td>
      <td><div class="center">{{myRound($quantity['in'] - $quantity['out'])}}</div></td>
    </tr>
    <?php
  }
  ?>
</table>

  <table class="main-table" cellpadding="5px">

    <thead>
      <tr class="bg">
        <td class="center"><b> @lang('layout.TotalIn')</b></td>
        <td class="center"><b> @lang('layout.TotalOut')</b></td>
        <td class="center"><b> @lang('layout.TotalOnHand')</b></td>
    </tr>
    </thead>
    <tbody>
    <tr>
      <td class="center">{{myRound($qut_in)}} </td>
      <td class="center">{{myRound($qut_out)}} </td>
      <td class="center">{{myRound($qut_in - $qut_out)}} </td>
    
    </tr>
    </tbody>
  </table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection