@extends('layouts.app')
@section('content')
    <!-- END PAGE HEADER-->
        <!-- new modal for print -->

        <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'currencyList'"
                      @closed="closeModal">

            <div slot=body>
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->
            <div class="row" v-cloak>
                    <div class="tabbable tabbable-tabdrop">
                    <div class="row">
                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.Date')</label>
                                    <div class="input-group">
                                        <input class="form-control date" id="range-from-example" name="from_date"
                                                autocomplete="off">

                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="range-to-example" name="to_date">

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                        
                </div>
            </div>
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->

            </div>
        </report-modal>
    </div>

    <!-- /new modal for print -->
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.CurrencyList') </span>
                </div>
                <!-- <div class="tools"></div> -->
                <div class="btn-group pull-right">
                    @if(!$homeCurrency)
                        @permission('homeCurrency-create')
                        <button data-toggle="modal" data-target="#home-currency" class="btn btn-success">
                            @lang('layout.HomeCurency')<i class="fa fa-check-circle"></i>
                        </button>
                        @endpermission

                    @else
                        @permission('exchangeRate-create')
                               <button data-toggle="modal" data-target="#exchange-rate" class="btn btn-success" style="margin: 3px">
                                    <i class="fa fa-money"></i> @lang('layout.ExchangeRate')
                               </button>
                               <button data-toggle="modal" data-target="#exchange-rate-other" class="btn btn-success" style="margin: 3px">
                                    <i class="fa fa-money"></i> @lang('layout.ExchangeRateWithOtherBase')
                               </button>
                                <a data-toggle="modal" data-target="#help" class="btn btn-primary" style="margin: 3px">
                                    <i class="fa fa-question-circle"></i> @lang('layout.Guide')
                                </a>
                                <span id="anchore-modal">
                                    <a href="#" @click.prevent="showModal" id="" class="btn  btn-success" style="margin: 3px">
                                        <i class="fa fa-print"></i>
                                    </a>
                                </span>
                        @endpermission
                    @endif

                </div>
            </div>








            







            <div class="tabbable tabbable-tabdrop">

                <ul class="nav nav-tabs">
                    <li class="active">
                        <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.CurrencyList')</a>
                    </li>
                    @if(systemConfig()[29] == 1)
                    <li class="">
                        <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Opening')</a>
                    </li>
                     <li class="">
                        <a href="#tab3" data-toggle="tab" id="tab_invoice_payment">@lang('layout.Closing')</a>
                    </li> 
                    @endif
                </ul>
                <div class="tab-content"> 
                    <div class="tab-pane active" id="tab1">
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.CurrencyList')</span>
                                </div>
                            </div>
                            <div class="portlet-body">  
                                <table class="table table-striped table-bordered table-hover" id="currency">
                                    <thead>
                                        <tr>
                                            {{-- <th>@lang('layout.ID')</th>--}}
                                             <th>@lang('layout.Currency')</th>
                                             <th>@lang('layout.StaticRate')</th>
                                             <th>@lang('layout.ExchangeRate')</th>
                                             @if(getCompanyTag() != 1)
                                                 <th>@lang('layout.ExchangeRateHQ')</th>
                                             @endif
                                             <th>@lang('layout.Name')</th>
                                             <th>@lang('layout.Date')</th>
                                             <th>@lang('layout.Date')</th>
                                             <th>@lang('layout.Hour')</th>
                                         </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>

                    @if(systemConfig()[29] == 1)
                    <div class="tab-pane" id="tab2">
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.Opening')</span>
                                </div>
                            </div>
                            <div class="portlet-body">  
                                <table class="table table-striped table-bordered table-hover" id="opening">
                                    <thead>
                                        <tr>
                                            {{-- <th>@lang('layout.ID')</th>--}}
                                             <th>@lang('layout.Currency')</th>
                                             <th>@lang('layout.StaticRate')</th>
                                             <th>@lang('layout.ExchangeRate')</th>
                                             
                                             <th>@lang('layout.Name')</th>
                                             <th>@lang('layout.Date')</th>
                                         </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="tab3">
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.Closing')</span>
                                </div>
                            </div>
                            <div class="portlet-body">  
                                <table class="table table-striped table-bordered table-hover" id="closing">
                                    <thead>
                                        <tr>
                                            {{-- <th>@lang('layout.ID')</th>--}}
                                             <th>@lang('layout.Currency')</th>
                                             <th>@lang('layout.StaticRate')</th>
                                             <th>@lang('layout.ExchangeRate')</th>
                                             
                                             <th>@lang('layout.Name')</th>
                                             <th>@lang('layout.Date')</th>
                                         </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                    @endif
                   
                </div>
            </div>
 







        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END CONTENT BODY -->

    @include('modal.modal')
    
    @if(!$homeCurrency)

        <div id="modal-section">
            <form-modal :route="route" :method="'post'" :modal-id="'home-currency'">
                <div slot="body">
                    <div class="col-sm-12">
                        <label for="home" class="form-label">
                            @lang('layout.SelectHomeCurrency')
                        </label>
                        <select name="home" id="home" class="form-control">
                            <option disabled>@lang('layout.SelectHomeCurrency')</option>
                            @foreach($currencies as $currency)
                                <option value="{{$currency->id}}">{{$currency->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </form-modal>
        </div>
    @else

        <div id="rate">
            <form-modal :route="routeExchange" :method="'post'" :modal-id="'exchange-rate'">
                <div slot="header">

                    <div class="row">
                        <div class="{{auth()->user()->company()->first()->tag == 1 ? 'col-sm-12': 'col-sm-6'}}">
                            <h5 class="text-primary" style="margin: 20px"><i class="fa fa-money"></i>
                                <b>@lang('layout.HomeCurency') : {{$homeCurrency->name}}</b></h5>
                        </div>
                        @if(getCompanyTag() != 1)
                            <div class="col-sm-6">
                                <h5 class="text-default">
                                    <i class="fa fa-money"></i> &nbsp;
                                    <b>@lang('layout.HQHomeCurrency')
                                        : @if($hqHomeCurrency) {{$hqHomeCurrency->name}} @endif</b>
                                </h5>
                            </div>
                        @endif
                    </div>
                </div>
                <div slot="body">
                    @foreach($currencies as $currency)
                        <div class="col-sm-12 @if(auth()->user()->company()->first()->tag != 1) col-md-6 @endif">
                            <div class="form-group">
                                <label for="{{'rate-'.$currency->id}}">{{$currency->name}}</label>
                                <div class="input-group">
                                    <span class="input-group-addon" style="background-color: #1d252b !important;">
                                        @if(systemConfig()[30] == 1)
                                        <i style="color: white;">@lang('layout.StaticRate') {{($homeCurrency->currency_id == $currency->id)?1:$currency->static_rate}} </i>
                                        @endif
                                    </span> 

                                    <input type="number" class="form-control" name="{{'rate'.$currency->id }}"
                                       id="{{'rate-'.$currency->id}}" placeholder="@lang('layout.ExchangeRate')"
                                       @if($homeCurrency->currency_id == $currency->id)
                                       value="1"
                                       readonly
                                        @endif >
                                </div>
                            </div>
                        </div>
                        @if(getCompanyTag() != 1  && getHomeCurrency()['code'] != getMainBranchHomeCurrency()['code'])
                            <div class="col-sm-12 col-md-6">
                                <div class="form-group">
                                    <label for="{{'hq-'.$currency->id}}">{{$currency->name}}</label>
                                    <input type="number" name="{{'hq_rate'.$currency->id}}" id="{{'hq-'.$currency->id}}"
                                           class="form-control"
                                           placeholder="@lang('layout.ExchangeRateHQ')"
                                           @if($hqHomeCurrency->currency_id == $currency->id)
                                           value="1"
                                           readonly
                                            @endif
                                    >
                                </div>
                            </div>

                        @endif
                    @endforeach
                </div>

            </form-modal>
        </div>
        @include('modal.modal_other_home')
        <div id="rate_base">
            <form-modal-other :route="routeExchange" :method="'post'" :modal-id="'exchange-rate-other'">
                <div slot="header">

                    <div class="row">
                        <div class="col-sm-12">
                            <h5 class="text-primary" style="margin: 20px"><i class="fa fa-money"></i>
                                <b>@lang('layout.HomeCurency') : {{$homeCurrency->name}}</b></h5>
                        </div>
                        <div class="col-md-12">
                            <label class="control-label">@lang('layout.HomeCurency')</label>
                            <v-select label="name" :options="currencies" v-model="selected_currency"></v-select>
                        </div>
                    </div>
                </div>
                <div slot="body">
                        <div v-for="curr in currencies" class="col-sm-12 col-md-12">
                            <div class="form-group">
                                <label :for="'rate-'+curr.id">@{{curr.name}}</label>
                                <div class="input-group">
                                    @if(systemConfig()[30] == 1)
                                    <span class="input-group-addon" style="background-color: #1d252b !important;">
                                        <i v-if="curr" style="color: white;">@lang('layout.StaticRate') @{{(curr.currency_id == selected_currency.currency_id)?1:curr.static_rate}}</i>
                                    </span> 

                                    <input type="number" class="form-control" :name="'model2_rate'+curr.id" :id="'rate-'+curr.id" placeholder="@lang('layout.ExchangeRate')" step="any"
                                    :value="(curr.currency_id == selected_currency.currency_id)?1:''" :required="{{$homeCurrency->currency_id}} == curr.currency_id || selected_currency.currency_id == curr.currency_id" 
                                    :readonly="curr.currency_id == selected_currency.currency_id" >
                                    <input type="hidden" :name="'id'+curr.id" :value="curr.id" >
                                    <input type="hidden" :name="'static_rate'+curr.id" :value="(curr.currency_id == selected_currency.currency_id)?1:curr.static_rate">
                                    
                                    @else

                                    <input type="number" class="form-control" :name="'model2_rate'+curr.id" :id="'rate-'+curr.id" placeholder="@lang('layout.ExchangeRate')" step="any"
                                    :value="(curr.currency_id == selected_currency.currency_id)?1:''" :required="{{$homeCurrency->currency_id}} == curr.currency_id || selected_currency.currency_id == curr.currency_id" 
                                    :readonly="{{$homeCurrency->currency_id}} == curr.currency_id && {{$homeCurrency->currency_id}} == selected_currency.currency_id" >
                                    <input type="hidden" :name="'id'+curr.id" :value="curr.id" >

                                    @endif

                                    <span class="input-group-addon">
                                        <i v-if="curr.currency_id == selected_currency.currency_id" style="color: white;">@lang('layout.SelectedCurrency')</i>
                                    </span> 
                                    
                                </div>
                                
                            </div>
                        </div>
                        <input type="hidden" name="selected_home_currency" :value="!selected_currency?null:selected_currency.currency_id">
                        <input type="hidden" name="home_currency" value="{{$homeCurrency->currency_id}}">
                </div>

            </form-modal-other>
        </div>

        

    @endif

    <div id="help" class="modal fade" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">
                        &times;
                    </button>
                    <h4>@lang('layout.Guide')<i class="fa fa-question-circle"></i></h4>
                </div>
                <div class="modal-body">
                    @lang('layout.ExchangeRateHelp')
                </div>
                <div class="modal-footer">
                    <button class="btn btn-success" data-dismiss="modal">@lang('layout.Ok')</button>
                </div>
            </div>
        </div>
    </div>

@stop
@include('print.modal')
@push('scripts')

    <script>
        
        
            
        jQuery(document).ready(function () {
            $(function () {
                let x = $('#currency').DataTable({
                    processing: true,
                    serverSide: true,
                    
                    ajax: {
                    url: '{{route("home.currency.index")}}',
                    data: {type: 'currency'}
                },

                    columns: [
                      /*  {data: 'id', name: 'id'},*/
                        {data: 'name', name: 'currencies.name'},
                        @if(systemConfig()[30] == 1)
                        {data: 'static_rate', name: 'currencies.static_rate'},
                        @endif
                        {data: 'exchange_rate', name: 'currency_rate_details.exchange_rate'},
                            @if(getCompanyTag() != 1)
                        {
                            data: 'hq_rate', name: 'currency_rate_details.hq_rate'
                        },
                            @endif
                        {
                            data: 'uname', name: 'users.name'
                        }, 
                        {data: 'date_m', name: 'currency_rate_details.created_at'},
                        {data: 'date', name: 'currency_rate_details.created_at'},
                        {data: 'hour', name: 'hour'}
                    ],
                });
                // let data = x.columns(5).data();
                // console.log(x.rows(columns[{data: 'exchange_rate'}]).nodes().length)
                // alert('the table has' + data);
            });
        });



        @if(systemConfig()[29] == 1)
        jQuery(document).ready(function () {
            $(function () {
                let x = $('#opening').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                    url: '{{route("home.currency.index")}}',
                    data: {type: 'opening'}
                },
                    columns: [
                      /*  {data: 'id', name: 'id'},*/
                        {data: 'name', name: 'currencies.name'},
                        @if(systemConfig()[30] == 1)
                        {data: 'Static_rate', name: 'currencies.Static_rate'},
                        @endif
                        {data: 'rate', name: 'opening_rate.rate'},
                        
                        {
                            data: 'uname', name: 'users.name'
                        }, 
                        {data: 'date', name: 'opening_rate.date'},
                    ],
                });
                // let data = x.columns(5).data();
                // console.log(x.rows(columns[{data: 'exchange_rate'}]).nodes().length)
                // alert('the table has' + data);
            });
        });




        jQuery(document).ready(function () {
            $(function () {
                let x = $('#closing').DataTable({
                    processing: true,
                    serverSide: true,

                    ajax: {
                    url: '{{route("home.currency.index")}}',
                    data: {type: 'closing'}
                    },

                    columns: [
                      /*  {data: 'id', name: 'id'},*/
                        {data: 'name', name: 'currencies.name'},
                        @if(systemConfig()[30] == 1)
                        {data: 'Static_rate', name: 'currencies.Static_rate'},
                        @endif
                        {data: 'rate', name: 'close_rate.rate'},
                      
                        {
                            data: 'uname', name: 'users.name'
                        }, 
                        {data: 'date', name: 'close_rate.date'},
                    ],
                });
                // let data = x.columns(5).data();
                // console.log(x.rows(columns[{data: 'exchange_rate'}]).nodes().length)
                // alert('the table has' + data);
            });
        });

        @endif




        @if(!$homeCurrency)
        new Vue({
            el: '#modal-section',
            data: {
                route: '{!! route('home.currency.store') !!}'
            },
        });

        @else
        new Vue({
            el: '#rate',
            data: {
                routeExchange: '{!! route('exchange.rate.store') !!}'
            }
        });

        Vue.component('v-select', VueSelect.VueSelect);
        
        new Vue({
            el: '#rate_base',
            data: {
                routeExchange: '{!! route('exchange.rate.store') !!}',
                selected_currency: {!! json_encode($homeCurrency) !!},
                currencies: {!! json_encode($currencies) !!},
            }
        });

        
        @endif

            // start app
            var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}'

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
        // /for new modal

    </script>
    <!-- END INTERNAL SCRIPT -->
@endpush
