@extends('layouts.app')
@section('content')

    <!-- END PAGE HEADER-->

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.EditHomeCurrency') </span>
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body">
                <div class="row">
                    <div class="col-sm-12 col-md-3">
                        <form action="{{route('home.currency.update')}}" method="post">
                            <div class="form-group">
                                {{csrf_field()}}
                                <label for="homeCurrency">@lang('layout.HomeCurrency')</label>
                                <select name="home" id="homeCurrency" class="form-control" required>
                                    <option >@lang('layout.Select')</option>
                                    @foreach($currencies as $currency)
                                        <option value="{{$currency->id}}"
                                                @if($currency->id == $homeCurrency['id'])
                                                selected
                                                @endif >
                                            {{$currency->name.'-'.$currency->code}}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-success">
                                    <i class="fa fa-submit"></i> @lang('layout.Submit')
                                </button>
                            </div>
                        </form>

                    </div>
                </div>

            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END CONTENT BODY -->




@stop

@push('scripts')

    <script>

    </script>
    <!-- END INTERNAL SCRIPT -->
@endpush
